/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.List;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Table;
import org.alfresco.util.schemacomp.validator.DbValidator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DbObjectXMLTransformer {
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private ContentHandler xmlOut;

    public DbObjectXMLTransformer(ContentHandler contentHandler) {
        this.xmlOut = contentHandler;
    }

    public void output(DbObject dbObject) {
        try {
            this.attemptOutput(dbObject);
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to output " + dbObject, e);
        }
    }

    private void attemptOutput(DbObject dbObject) throws SAXException {
        AttributesImpl attribs = new AttributesImpl();
        if (dbObject instanceof Schema) {
            attribs.addAttribute("", "", "xmlns", "CDATA", "http://www.alfresco.org/repo/db-schema");
            attribs.addAttribute("", "", "xmlns:xsi", "CDATA", "http://www.w3.org/2001/XMLSchema-instance");
            attribs.addAttribute("", "", "xsi:schemaLocation", "CDATA", "http://www.alfresco.org/repo/db-schema db-schema.xsd");
        }
        attribs.addAttribute("", "", "name", "CDATA", dbObject.getName());
        this.addAttributes(dbObject, attribs);
        String tagName = dbObject.getClass().getSimpleName().toLowerCase();
        this.xmlOut.startElement("", "", tagName, attribs);
        this.transformValidators(dbObject.getValidators());
        this.transformDbObject(dbObject);
        this.xmlOut.endElement("", "", tagName);
    }

    private void transformValidators(List<DbValidator> validators) throws SAXException {
        if (validators.size() > 0) {
            this.simpleStartTag("validators");
            for (DbValidator dbv : validators) {
                AttributesImpl attribs = new AttributesImpl();
                attribs.addAttribute("", "", "class", "CDATA", dbv.getClass().getName());
                this.xmlOut.startElement("", "", "validator", attribs);
                if (dbv.getPropertyNames().size() > 0) {
                    this.simpleStartTag("properties");
                    for (String propName : dbv.getPropertyNames()) {
                        AttributesImpl propAttrs = new AttributesImpl();
                        propAttrs.addAttribute("", "", "name", "CDATA", propName);
                        this.xmlOut.startElement("", "", "property", propAttrs);
                        String propValue = dbv.getProperty(propName);
                        char[] chars = propValue.toCharArray();
                        this.xmlOut.characters(chars, 0, chars.length);
                        this.simpleEndTag("property");
                    }
                    this.simpleEndTag("properties");
                }
                this.simpleEndTag("validator");
            }
            this.simpleEndTag("validators");
        }
    }

    private void addAttributes(DbObject dbObject, AttributesImpl attribs) {
        if (dbObject instanceof Schema) {
            Schema schema = (Schema)dbObject;
            attribs.addAttribute("", "", "dbprefix", "CDATA", schema.getDbPrefix());
            attribs.addAttribute("", "", "version", "CDATA", Integer.toString(schema.getVersion()));
            attribs.addAttribute("", "", "tablecolumnorder", "CDATA", Boolean.toString(schema.isCheckTableColumnOrder()));
        } else if (dbObject instanceof Index) {
            Index index = (Index)dbObject;
            attribs.addAttribute("", "", "unique", "CDATA", Boolean.toString(index.isUnique()));
        } else if (dbObject instanceof Column) {
            Column column = (Column)dbObject;
            attribs.addAttribute("", "", "order", "CDATA", Integer.toString(column.getOrder()));
        }
    }

    private void transformDbObject(DbObject dbObject) throws SAXException {
        if (dbObject instanceof Schema) {
            this.transformSchema((Schema)dbObject);
        } else if (dbObject instanceof Table) {
            this.transformTable((Table)dbObject);
        } else if (dbObject instanceof Column) {
            this.transformColumn((Column)dbObject);
        } else if (dbObject instanceof ForeignKey) {
            this.transformForeignKey((ForeignKey)dbObject);
        } else if (dbObject instanceof Index) {
            this.transformIndex((Index)dbObject);
        } else if (dbObject instanceof PrimaryKey) {
            this.transformPrimaryKey((PrimaryKey)dbObject);
        }
    }

    private void transformSchema(Schema schema) throws SAXException {
        this.simpleStartTag("objects");
        for (DbObject dbo : schema) {
            this.output(dbo);
        }
        this.simpleEndTag("objects");
    }

    private void transformTable(Table table) throws SAXException {
        this.simpleStartTag("columns");
        for (Column column : table.getColumns()) {
            this.output(column);
        }
        this.simpleEndTag("columns");
        if (table.hasPrimaryKey()) {
            this.output(table.getPrimaryKey());
        }
        this.simpleStartTag("foreignkeys");
        for (ForeignKey fk : table.getForeignKeys()) {
            this.output(fk);
        }
        this.simpleEndTag("foreignkeys");
        this.simpleStartTag("indexes");
        for (Index index : table.getIndexes()) {
            this.output(index);
        }
        this.simpleEndTag("indexes");
    }

    private void transformColumn(Column column) throws SAXException {
        this.simpleElement("type", column.getType());
        this.simpleElement("nullable", Boolean.toString(column.isNullable()));
        this.simpleElement("autoincrement", Boolean.toString(column.isAutoIncrement()));
    }

    private void transformForeignKey(ForeignKey fk) throws SAXException {
        this.simpleElement("localcolumn", fk.getLocalColumn());
        this.simpleElement("targettable", fk.getTargetTable());
        this.simpleElement("targetcolumn", fk.getTargetColumn());
    }

    private void transformIndex(Index index) throws SAXException {
        this.columnNameList(index.getColumnNames(), null);
    }

    private void transformPrimaryKey(PrimaryKey pk) throws SAXException {
        this.columnNameList(pk.getColumnNames(), pk.getColumnOrders());
    }

    private void simpleElement(String tag, String content) throws SAXException {
        this.simpleStartTag(tag);
        char[] chars = content.toCharArray();
        this.xmlOut.characters(chars, 0, chars.length);
        this.simpleEndTag(tag);
    }

    private void simpleStartTag(String tag) throws SAXException {
        this.xmlOut.startElement("", "", tag, EMPTY_ATTRIBUTES);
    }

    private void simpleEndTag(String tag) throws SAXException {
        this.xmlOut.endElement("", "", tag);
    }

    private void columnNameList(List<String> columnNames, List<Integer> columnOrders) throws SAXException {
        this.simpleStartTag("columnnames");
        int i = 0;
        while (i < columnNames.size()) {
            String columnName = columnNames.get(i);
            AttributesImpl attribs = new AttributesImpl();
            if (columnOrders != null) {
                int columnOrder = columnOrders.get(i);
                attribs.addAttribute("", "", "order", "CDATA", Integer.toString(columnOrder));
            }
            this.xmlOut.startElement("", "", "columnname", attribs);
            char[] chars = columnName.toCharArray();
            this.xmlOut.characters(chars, 0, chars.length);
            this.simpleEndTag("columnname");
            ++i;
        }
        this.simpleEndTag("columnnames");
    }
}

