/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.service.cmr.security.PersonService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;

public class IdentityServiceRemoteUserMapper
implements RemoteUserMapper,
ActivateableBean {
    private static final Log LOGGER = LogFactory.getLog(IdentityServiceRemoteUserMapper.class);
    static final String USERNAME_CLAIM = "preferred_username";
    private boolean isEnabled;
    private boolean isValidationFailureSilent;
    private PersonService personService;
    private BearerTokenResolver bearerTokenResolver;
    private IdentityServiceFacade identityServiceFacade;

    public void setActive(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setValidationFailureSilent(boolean silent) {
        this.isValidationFailureSilent = silent;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setBearerTokenResolver(BearerTokenResolver bearerTokenResolver) {
        this.bearerTokenResolver = bearerTokenResolver;
    }

    public void setIdentityServiceFacade(IdentityServiceFacade identityServiceFacade) {
        this.identityServiceFacade = identityServiceFacade;
    }

    @Override
    public String getRemoteUser(HttpServletRequest request) {
        LOGGER.trace((Object)"Retrieving username from http request...");
        if (!this.isEnabled) {
            LOGGER.debug((Object)"IdentityServiceRemoteUserMapper is disabled, returning null.");
            return null;
        }
        try {
            String headerUserId = this.extractUserFromHeader(request);
            if (headerUserId != null) {
                String normalizedUserId = this.normalizeUserId(headerUserId);
                LOGGER.trace((Object)("Returning userId: " + AuthenticationUtil.maskUsername((String)normalizedUserId)));
                return normalizedUserId;
            }
        }
        catch (IdentityServiceFacade.IdentityServiceFacadeException e) {
            if (!this.isValidationFailureSilent) {
                throw new AuthenticationException("Failed to extract username from token: " + e.getMessage(), (Throwable)e);
            }
            LOGGER.error((Object)("Failed to authenticate user using IdentityServiceRemoteUserMapper: " + e.getMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("Failed to authenticate user using IdentityServiceRemoteUserMapper: " + e.getMessage()), (Throwable)e);
        }
        LOGGER.trace((Object)"Could not identify a userId. Returning null.");
        return null;
    }

    @Override
    public boolean isActive() {
        return this.isEnabled;
    }

    private String extractUserFromHeader(HttpServletRequest request) {
        String bearerToken;
        LOGGER.debug((Object)"Trying bearer token...");
        try {
            bearerToken = this.bearerTokenResolver.resolve(request);
        }
        catch (OAuth2AuthenticationException e) {
            LOGGER.debug((Object)"Failed to resolve Bearer token.", (Throwable)e);
            return null;
        }
        Optional<String> possibleUsername = Optional.ofNullable(bearerToken).map(this.identityServiceFacade::decodeToken).map(t -> t.getClaim(USERNAME_CLAIM)).filter(String.class::isInstance).map(String.class::cast);
        if (possibleUsername.isEmpty()) {
            LOGGER.debug((Object)"User could not be authenticated by IdentityServiceRemoteUserMapper.");
            return null;
        }
        String username = possibleUsername.get();
        LOGGER.trace((Object)("Extracted username: " + AuthenticationUtil.maskUsername((String)username)));
        return username;
    }

    private String normalizeUserId(final String userId) {
        if (userId == null) {
            return null;
        }
        String normalized = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return IdentityServiceRemoteUserMapper.this.personService.getUserIdentifier(userId);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Normalized user name for '" + AuthenticationUtil.maskUsername((String)userId) + "': " + AuthenticationUtil.maskUsername((String)normalized)));
        }
        return normalized == null ? userId : normalized;
    }
}

