/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.DefaultJWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JOSEProcessorConfiguration;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerEndpointMetadata;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.SpringBasedIdentityServiceFacade;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.converter.RsaKeyConverters;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class IdentityServiceFacadeFactoryBean
implements FactoryBean<IdentityServiceFacade> {
    private static final Log LOGGER = LogFactory.getLog(IdentityServiceFacadeFactoryBean.class);
    private boolean enabled;
    private SpringBasedIdentityServiceFacadeFactory factory;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setIdentityServiceConfig(IdentityServiceConfig identityServiceConfig) {
        this.factory = new SpringBasedIdentityServiceFacadeFactory(() -> HttpClientProvider.access$1(new HttpClientProvider(identityServiceConfig)), new ClientRegistrationProvider(identityServiceConfig)::createClientRegistration, new JwtDecoderProvider(identityServiceConfig)::createJwtDecoder);
    }

    public IdentityServiceFacade getObject() throws Exception {
        if (!this.enabled) {
            return null;
        }
        return new LazyInstantiatingIdentityServiceFacade(() -> SpringBasedIdentityServiceFacadeFactory.access$0(this.factory));
    }

    public Class<?> getObjectType() {
        return IdentityServiceFacade.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private static IdentityServiceFacade.IdentityServiceFacadeException authorizationServerCantBeUsedException(RuntimeException cause) {
        return new IdentityServiceFacade.IdentityServiceFacadeException("Unable to use the Authorization Server.", cause);
    }

    private static boolean isDefined(String value) {
        return value != null && !value.isBlank();
    }

    private static class ClientRegistrationProvider {
        private final IdentityServiceConfig config;

        private ClientRegistrationProvider(IdentityServiceConfig config) {
            this.config = Objects.requireNonNull(config);
        }

        public ClientRegistration createClientRegistration(RestOperations rest) {
            return this.possibleMetadataURIs().stream().map(u -> this.extractMetadata(rest, (URI)u)).filter(Optional::isPresent).map(Optional::get).findFirst().map(this::createBuilder).map(this::configureClientAuthentication).map(ClientRegistration.Builder::build).orElseThrow(() -> new IllegalStateException("Failed to create ClientRegistration."));
        }

        private ClientRegistration.Builder createBuilder(OIDCProviderMetadata metadata) {
            String authUri = Optional.of(metadata).map(AuthorizationServerEndpointMetadata::getAuthorizationEndpointURI).map(URI::toASCIIString).orElse(null);
            String issuerUri = Optional.of(metadata).map(AuthorizationServerMetadata::getIssuer).map(Identifier::getValue).orElseGet(this.config::getIssuerUrl);
            return ClientRegistration.withRegistrationId((String)"ids").authorizationUri(authUri).tokenUri(metadata.getTokenEndpointURI().toASCIIString()).jwkSetUri(metadata.getJWKSetURI().toASCIIString()).issuerUri(issuerUri).authorizationGrantType(AuthorizationGrantType.PASSWORD);
        }

        private ClientRegistration.Builder configureClientAuthentication(ClientRegistration.Builder builder) {
            builder.clientId(this.config.getResource());
            if (this.config.isPublicClient()) {
                return builder.clientSecret(null).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST);
            }
            return builder.clientSecret(this.config.getClientSecret()).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        }

        private Optional<OIDCProviderMetadata> extractMetadata(RestOperations rest, URI metadataUri) {
            String response;
            try {
                ResponseEntity r = rest.exchange(RequestEntity.get((URI)metadataUri).build(), String.class);
                if (r.getStatusCode() != HttpStatus.OK || !r.hasBody()) {
                    LOGGER.warn((Object)("Unexpected response from " + metadataUri + ". Status code: " + r.getStatusCode() + ", has body: " + r.hasBody() + "."));
                    return Optional.empty();
                }
                response = (String)r.getBody();
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Failed to get response from " + metadataUri + ". " + e.getMessage()), (Throwable)e);
                return Optional.empty();
            }
            try {
                return Optional.of(OIDCProviderMetadata.parse((String)response));
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Failed to parse metadata. " + e.getMessage()), (Throwable)e);
                return Optional.empty();
            }
        }

        private Collection<URI> possibleMetadataURIs() {
            return List.of(UriComponentsBuilder.fromUriString((String)this.config.getIssuerUrl()).pathSegment(new String[]{".well-known", "openid-configuration"}).build().toUri());
        }
    }

    private static class HttpClientProvider {
        private final IdentityServiceConfig config;

        private HttpClientProvider(IdentityServiceConfig config) {
            this.config = Objects.requireNonNull(config);
        }

        private HttpClient createHttpClient() {
            try {
                HttpClientBuilder clientBuilder = HttpClients.custom();
                this.applyConnectionConfiguration(clientBuilder);
                this.applySSLConfiguration(clientBuilder);
                return clientBuilder.build();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create ClientHttpRequestFactory. " + e.getMessage(), e);
            }
        }

        private void applyConnectionConfiguration(HttpClientBuilder builder) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.config.getClientConnectionTimeout()).setSocketTimeout(this.config.getClientSocketTimeout()).build();
            builder.setDefaultRequestConfig(requestConfig).setMaxConnTotal(this.config.getConnectionPoolSize());
        }

        private void applySSLConfiguration(HttpClientBuilder builder) throws Exception {
            SSLContextBuilder sslContextBuilder = null;
            if (this.config.isDisableTrustManager()) {
                sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE);
            } else if (IdentityServiceFacadeFactoryBean.isDefined(this.config.getTruststore())) {
                char[] truststorePassword = this.asCharArray(this.config.getTruststorePassword(), null);
                sslContextBuilder = SSLContexts.custom().loadTrustMaterial(new File(this.config.getTruststore()), truststorePassword);
            }
            if (IdentityServiceFacadeFactoryBean.isDefined(this.config.getClientKeystore())) {
                if (sslContextBuilder == null) {
                    sslContextBuilder = SSLContexts.custom();
                }
                char[] keystorePassword = this.asCharArray(this.config.getClientKeystorePassword(), null);
                char[] keyPassword = this.asCharArray(this.config.getClientKeyPassword(), keystorePassword);
                sslContextBuilder.loadKeyMaterial(new File(this.config.getClientKeystore()), keystorePassword, keyPassword);
            }
            if (sslContextBuilder != null) {
                builder.setSSLContext(sslContextBuilder.build());
            }
            if (this.config.isDisableTrustManager() || this.config.isAllowAnyHostname()) {
                builder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
        }

        private char[] asCharArray(String value, char[] nullValue) {
            return Optional.ofNullable(value).filter(Predicate.not(String::isBlank)).map(String::toCharArray).orElse(nullValue);
        }

        static /* synthetic */ HttpClient access$1(HttpClientProvider httpClientProvider) {
            return httpClientProvider.createHttpClient();
        }
    }

    static class JwtDecoderProvider {
        private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;
        private final IdentityServiceConfig config;

        JwtDecoderProvider(IdentityServiceConfig config) {
            this.config = Objects.requireNonNull(config);
        }

        public JwtDecoder createJwtDecoder(RestOperations rest, ClientRegistration.ProviderDetails providerDetails) {
            try {
                NimbusJwtDecoder decoder = this.buildJwtDecoder(rest, providerDetails);
                decoder.setJwtValidator(this.createJwtTokenValidator(providerDetails));
                decoder.setClaimSetConverter((Converter)new ClaimTypeConverter(OidcIdTokenDecoderFactory.createDefaultClaimTypeConverters()));
                return decoder;
            }
            catch (RuntimeException e) {
                LOGGER.warn((Object)"Failed to create JwtDecoder.", (Throwable)e);
                throw IdentityServiceFacadeFactoryBean.authorizationServerCantBeUsedException(e);
            }
        }

        private NimbusJwtDecoder buildJwtDecoder(RestOperations rest, ClientRegistration.ProviderDetails providerDetails) {
            if (IdentityServiceFacadeFactoryBean.isDefined(this.config.getRealmKey())) {
                RSAPublicKey publicKey = this.parsePublicKey(this.config.getRealmKey());
                return NimbusJwtDecoder.withPublicKey((RSAPublicKey)publicKey).signatureAlgorithm(SIGNATURE_ALGORITHM).build();
            }
            String jwkSetUri = this.requireValidJwkSetUri(providerDetails);
            return NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(SIGNATURE_ALGORITHM).restOperations(rest).jwtProcessorCustomizer(this::reconfigureJWKSCache).build();
        }

        private void reconfigureJWKSCache(ConfigurableJWTProcessor<SecurityContext> jwtProcessor) {
            Optional<RemoteJWKSet> jwkSource = Optional.ofNullable(jwtProcessor).map(JOSEProcessorConfiguration::getJWSKeySelector).filter(JWSVerificationKeySelector.class::isInstance).map(o -> (JWSVerificationKeySelector)o).map(JWSVerificationKeySelector::getJWKSource).filter(RemoteJWKSet.class::isInstance).map(o -> (RemoteJWKSet)o);
            if (jwkSource.isEmpty()) {
                LOGGER.warn((Object)"Not able to reconfigure the JWK Cache. Unexpected JWKSource.");
                return;
            }
            Optional<URL> jwkSetUrl = jwkSource.map(RemoteJWKSet::getJWKSetURL);
            if (jwkSetUrl.isEmpty()) {
                LOGGER.warn((Object)"Not able to reconfigure the JWK Cache. Unknown JWKSetURL.");
                return;
            }
            Optional<ResourceRetriever> resourceRetriever = jwkSource.map(RemoteJWKSet::getResourceRetriever);
            if (resourceRetriever.isEmpty()) {
                LOGGER.warn((Object)"Not able to reconfigure the JWK Cache. Unknown ResourceRetriever.");
                return;
            }
            DefaultJWKSetCache cache = new DefaultJWKSetCache((long)this.config.getPublicKeyCacheTtl(), -1L, TimeUnit.SECONDS);
            RemoteJWKSet cachingJWKSource = new RemoteJWKSet(jwkSetUrl.get(), resourceRetriever.get(), (JWKSetCache)cache);
            jwtProcessor.setJWSKeySelector((JWSKeySelector)new JWSVerificationKeySelector(JWSAlgorithm.parse((String)SIGNATURE_ALGORITHM.getName()), (JWKSource)cachingJWKSource));
        }

        private OAuth2TokenValidator<Jwt> createJwtTokenValidator(ClientRegistration.ProviderDetails providerDetails) {
            OAuth2TokenValidator[] oAuth2TokenValidatorArray = new OAuth2TokenValidator[4];
            oAuth2TokenValidatorArray[0] = new JwtTimestampValidator(Duration.of(0L, ChronoUnit.MILLIS));
            oAuth2TokenValidatorArray[1] = new JwtIssuerValidator(providerDetails.getIssuerUri());
            oAuth2TokenValidatorArray[2] = new JwtClaimValidator("typ", "Bearer"::equals);
            oAuth2TokenValidatorArray[3] = new JwtClaimValidator("sub", Objects::nonNull);
            return new DelegatingOAuth2TokenValidator(oAuth2TokenValidatorArray);
        }

        private RSAPublicKey parsePublicKey(String pem) {
            try {
                return this.tryToParsePublicKey(pem);
            }
            catch (Exception e) {
                if (this.isPemFormatException(e)) {
                    return this.tryToParsePublicKey("-----BEGIN PUBLIC KEY-----\n" + pem + "\n-----END PUBLIC KEY-----");
                }
                throw e;
            }
        }

        private RSAPublicKey tryToParsePublicKey(String pem) {
            ByteArrayInputStream pemStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));
            return (RSAPublicKey)RsaKeyConverters.x509().convert((Object)pemStream);
        }

        private boolean isPemFormatException(Exception e) {
            return e.getMessage() != null && e.getMessage().contains("-----BEGIN PUBLIC KEY-----");
        }

        private String requireValidJwkSetUri(ClientRegistration.ProviderDetails providerDetails) {
            String uri = providerDetails.getJwkSetUri();
            if (!IdentityServiceFacadeFactoryBean.isDefined(uri)) {
                OAuth2Error oauth2Error = new OAuth2Error("missing_signature_verifier", "Failed to find a Signature Verifier for: '" + providerDetails.getIssuerUri() + "'. Check to ensure you have configured the JwkSet URI.", null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            return uri;
        }
    }

    static class JwtIssuerValidator
    implements OAuth2TokenValidator<Jwt> {
        private final String requiredIssuer;

        public JwtIssuerValidator(String issuer) {
            this.requiredIssuer = Objects.requireNonNull(issuer, "issuer cannot be null");
        }

        public OAuth2TokenValidatorResult validate(Jwt token) {
            Objects.requireNonNull(token, "token cannot be null");
            Object issuer = token.getClaim("iss");
            if (issuer != null && this.requiredIssuer.equals(issuer.toString())) {
                return OAuth2TokenValidatorResult.success();
            }
            OAuth2Error error = new OAuth2Error("invalid_token", String.format("The iss claim is not valid. Expected `%s` but got `%s`.", this.requiredIssuer, issuer), "https://tools.ietf.org/html/rfc6750#section-3.1");
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
        }
    }

    static class LazyInstantiatingIdentityServiceFacade
    implements IdentityServiceFacade {
        private final AtomicReference<IdentityServiceFacade> targetFacade = new AtomicReference();
        private final Supplier<IdentityServiceFacade> targetFacadeCreator;

        LazyInstantiatingIdentityServiceFacade(Supplier<IdentityServiceFacade> targetFacadeCreator) {
            this.targetFacadeCreator = Objects.requireNonNull(targetFacadeCreator);
        }

        @Override
        public IdentityServiceFacade.AccessTokenAuthorization authorize(IdentityServiceFacade.AuthorizationGrant grant) throws IdentityServiceFacade.AuthorizationException {
            return this.getTargetFacade().authorize(grant);
        }

        @Override
        public IdentityServiceFacade.DecodedAccessToken decodeToken(String token) throws IdentityServiceFacade.TokenDecodingException {
            return this.getTargetFacade().decodeToken(token);
        }

        private IdentityServiceFacade getTargetFacade() {
            return Optional.ofNullable(this.targetFacade.get()).orElseGet(() -> this.targetFacade.updateAndGet(prev -> Optional.ofNullable(prev).orElseGet(this::createTargetFacade)));
        }

        private IdentityServiceFacade createTargetFacade() {
            try {
                return this.targetFacadeCreator.get();
            }
            catch (IdentityServiceFacade.IdentityServiceFacadeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                LOGGER.warn((Object)"Failed to instantiate IdentityServiceFacade.", (Throwable)e);
                throw IdentityServiceFacadeFactoryBean.authorizationServerCantBeUsedException(e);
            }
        }
    }

    private static class SpringBasedIdentityServiceFacadeFactory {
        private final Supplier<HttpClient> httpClientProvider;
        private final Function<RestOperations, ClientRegistration> clientRegistrationProvider;
        private final BiFunction<RestOperations, ClientRegistration.ProviderDetails, JwtDecoder> jwtDecoderProvider;

        SpringBasedIdentityServiceFacadeFactory(Supplier<HttpClient> httpClientProvider, Function<RestOperations, ClientRegistration> clientRegistrationProvider, BiFunction<RestOperations, ClientRegistration.ProviderDetails, JwtDecoder> jwtDecoderProvider) {
            this.httpClientProvider = Objects.requireNonNull(httpClientProvider);
            this.clientRegistrationProvider = Objects.requireNonNull(clientRegistrationProvider);
            this.jwtDecoderProvider = Objects.requireNonNull(jwtDecoderProvider);
        }

        private IdentityServiceFacade createIdentityServiceFacade() {
            HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory(this.httpClientProvider.get());
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
            ClientRegistration clientRegistration = this.clientRegistrationProvider.apply((RestOperations)restTemplate);
            JwtDecoder jwtDecoder = this.jwtDecoderProvider.apply((RestOperations)restTemplate, clientRegistration.getProviderDetails());
            return new SpringBasedIdentityServiceFacade((RestOperations)this.createOAuth2RestTemplate((ClientHttpRequestFactory)httpRequestFactory), clientRegistration, jwtDecoder);
        }

        private RestTemplate createOAuth2RestTemplate(ClientHttpRequestFactory requestFactory) {
            RestTemplate restTemplate = new RestTemplate(Arrays.asList(new FormHttpMessageConverter(), new OAuth2AccessTokenResponseHttpMessageConverter()));
            restTemplate.setRequestFactory(requestFactory);
            restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
            return restTemplate;
        }

        static /* synthetic */ IdentityServiceFacade access$0(SpringBasedIdentityServiceFacadeFactory springBasedIdentityServiceFacadeFactory) {
            return springBasedIdentityServiceFacadeFactory.createIdentityServiceFacade();
        }
    }
}

