/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.ArrayDeque;
import java.util.Deque;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.PeerAssociationResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event.v1.model.Resource;
import org.alfresco.repo.event2.EventInfo;
import org.alfresco.repo.event2.EventJSONSchema;
import org.alfresco.repo.event2.NodeResourceHelper;
import org.alfresco.repo.event2.PeerAssociationEventSupportedPolicies;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.namespace.QName;

public class PeerAssociationEventConsolidator
implements PeerAssociationEventSupportedPolicies {
    private final Deque<EventType> eventTypes = new ArrayDeque<EventType>();
    protected final AssociationRef associationRef;
    private PeerAssociationResource resource;
    private final NodeResourceHelper helper;

    public PeerAssociationEventConsolidator(AssociationRef associationRef, NodeResourceHelper helper) {
        this.associationRef = associationRef;
        this.helper = helper;
    }

    public RepoEvent<DataAttributes<PeerAssociationResource>> getRepoEvent(EventInfo eventInfo) {
        EventType eventType = this.getDerivedEvent();
        DataAttributes<PeerAssociationResource> eventData = this.buildEventData(eventInfo, this.resource);
        return RepoEvent.builder().setId(eventInfo.getId()).setSource(eventInfo.getSource()).setTime(eventInfo.getTimestamp()).setType(eventType.getType()).setData(eventData).setDataschema(EventJSONSchema.getSchemaV1(eventType)).build();
    }

    protected DataAttributes<PeerAssociationResource> buildEventData(EventInfo eventInfo, PeerAssociationResource resource) {
        return EventData.builder().setEventGroupId(eventInfo.getTxnId()).setResource((Resource)resource).build();
    }

    @Override
    public void onCreateAssociation(AssociationRef associationRef) {
        this.eventTypes.add(EventType.PEER_ASSOC_CREATED);
        this.resource = this.buildPeerAssociationResource(associationRef);
    }

    @Override
    public void beforeDeleteAssociation(AssociationRef associationRef) {
        this.eventTypes.add(EventType.PEER_ASSOC_DELETED);
        this.resource = this.buildPeerAssociationResource(associationRef);
    }

    private PeerAssociationResource buildPeerAssociationResource(AssociationRef associationRef) {
        String sourceId = associationRef.getSourceRef().getId();
        String targetId = associationRef.getTargetRef().getId();
        String assocType = this.helper.getQNamePrefixString(associationRef.getTypeQName());
        return new PeerAssociationResource(sourceId, targetId, assocType);
    }

    private EventType getDerivedEvent() {
        if (this.isTemporaryPeerAssociation()) {
            return EventType.PEER_ASSOC_DELETED;
        }
        if (this.eventTypes.contains(EventType.PEER_ASSOC_CREATED)) {
            return EventType.PEER_ASSOC_CREATED;
        }
        if (this.eventTypes.getLast() == EventType.PEER_ASSOC_DELETED) {
            return EventType.PEER_ASSOC_DELETED;
        }
        return this.eventTypes.getFirst();
    }

    public boolean isTemporaryPeerAssociation() {
        return this.eventTypes.contains(EventType.PEER_ASSOC_CREATED) && this.eventTypes.getLast() == EventType.PEER_ASSOC_DELETED;
    }

    public QName getAssocType() {
        return this.associationRef.getTypeQName();
    }

    public Deque<EventType> getEventTypes() {
        return this.eventTypes;
    }
}

