/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.template.ApplyTemplateMethod;
import org.alfresco.repo.virtual.template.FilingParameters;
import org.alfresco.repo.virtual.template.FilingRule;
import org.alfresco.repo.virtual.template.TemplateFilingRule;
import org.alfresco.repo.virtual.template.VirtualFolderDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Test;

public class TemplateFilingRuleTest
extends VirtualizationIntegrationTest {
    @Test
    public void testFilingSubPath_specialCharacters() throws Exception {
        NodeRef vfNodeRef = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "Template 6 With Spaces", "C/org/alfresco/repo/virtual/template/testTemplate5.json");
        NodeRef sfpNodeRef = this.nodeService.getChildByName(vfNodeRef, ContentModel.ASSOC_CONTAINS, "SpecialFilingPath5");
        Reference sfpReference = Reference.fromNodeRef((NodeRef)sfpNodeRef);
        ApplyTemplateMethod applyTemplateMethod = new ApplyTemplateMethod(this.environment);
        VirtualFolderDefinition structure = (VirtualFolderDefinition)sfpReference.execute((ProtocolMethod)applyTemplateMethod);
        FilingRule filingRule = structure.getFilingRule();
        Assert.assertTrue((boolean)(filingRule instanceof TemplateFilingRule));
        NodeRef fn = filingRule.filingNodeRefFor(new FilingParameters(sfpReference));
        Assert.assertNull((Object)fn);
        this.createFolder(vfNodeRef, "Space Sub Folder");
        fn = filingRule.filingNodeRefFor(new FilingParameters(sfpReference));
        Assert.assertNotNull((Object)fn);
    }

    @Test
    public void testFilingPath_specialCharacters() throws Exception {
        NodeRef vfNodeRef = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "Template 6 With Spaces", "C/org/alfresco/repo/virtual/template/testTemplate5.json");
        NodeRef sfpNodeRef = this.nodeService.getChildByName(vfNodeRef, ContentModel.ASSOC_CONTAINS, "SpecialFilingPath4");
        Reference sfpReference = Reference.fromNodeRef((NodeRef)sfpNodeRef);
        ApplyTemplateMethod applyTemplateMethod = new ApplyTemplateMethod(this.environment);
        VirtualFolderDefinition structure = (VirtualFolderDefinition)sfpReference.execute((ProtocolMethod)applyTemplateMethod);
        FilingRule filingRule = structure.getFilingRule();
        Assert.assertTrue((boolean)(filingRule instanceof TemplateFilingRule));
        NodeRef fn = filingRule.filingNodeRefFor(new FilingParameters(sfpReference));
        Assert.assertNotNull((Object)fn);
    }
}

