/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.usage;

import java.util.concurrent.TimeUnit;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.usage.RepoUsageComponent;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.admin.RepoUsageStatus;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.FixMethodOrder;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;
import org.springframework.context.ApplicationContext;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@Category(value={OwnJVMTestsCategory.class, LuceneTests.class})
public class RepoUsageComponentTest
extends TestCase {
    private ApplicationContext ctx;
    private static final Log logger = LogFactory.getLog(RepoUsageComponentTest.class);
    private TransactionService transactionService;
    private RepoUsageComponent repoUsageComponent;
    private JobLockService jobLockService;
    private UserTransaction txn;
    private RepoUsage restrictionsBefore;

    protected void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        if (AlfrescoTransactionSupport.isActualTransactionActive()) {
            RepoUsageComponentTest.fail((String)"Test started with transaction in progress");
        }
        this.transactionService = (TransactionService)this.ctx.getBean("transactionComponent");
        this.repoUsageComponent = (RepoUsageComponent)this.ctx.getBean("repoUsageComponent");
        this.jobLockService = (JobLockService)this.ctx.getBean("jobLockService");
        AuthenticationUtil.setRunAsUserSystem();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.restrictionsBefore = this.repoUsageComponent.getRestrictions();
    }

    protected void tearDown() throws Exception {
        try {
            this.repoUsageComponent.setRestrictions(this.restrictionsBefore);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        if (this.txn != null) {
            try {
                this.txn.commit();
            }
            catch (Throwable e) {
                try {
                    this.txn.rollback();
                }
                catch (Throwable throwable) {}
                throw new RuntimeException("Failed to commit test transaction", e);
            }
        }
    }

    public void test1Setup() {
    }

    private RepoUsage getUsage() {
        RetryingTransactionHelper.RetryingTransactionCallback<RepoUsage> getCallback = new RetryingTransactionHelper.RetryingTransactionCallback<RepoUsage>(){

            public RepoUsage execute() throws Throwable {
                return RepoUsageComponentTest.this.repoUsageComponent.getUsage();
            }
        };
        return (RepoUsage)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getCallback, true);
    }

    private boolean updateUsage(final RepoUsage.UsageType usageType) {
        RetryingTransactionHelper.RetryingTransactionCallback<Boolean> getCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            public Boolean execute() throws Throwable {
                return RepoUsageComponentTest.this.repoUsageComponent.updateUsage(usageType);
            }
        };
        return (Boolean)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getCallback, false);
    }

    public void test2NoTxn() throws Throwable {
        this.txn.commit();
        this.txn = null;
        try {
            this.repoUsageComponent.getUsage();
            RepoUsageComponentTest.fail((String)"Txn required for calls to RepoAdminComponent.");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void test3GetUsage() {
        this.getUsage();
    }

    public void test4FullUse() throws Exception {
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage restrictions = new RepoUsage(Long.valueOf(System.currentTimeMillis()), this.getUsage().getUsers(), this.getUsage().getDocuments(), RepoUsage.LicenseMode.TEAM, Long.valueOf(System.currentTimeMillis() + 86400000L), false);
        this.repoUsageComponent.setRestrictions(restrictions);
        RepoUsage restrictionsCheck = this.repoUsageComponent.getRestrictions();
        RepoUsageComponentTest.assertEquals((String)"Restrictions should return without change.", (Object)restrictions, (Object)restrictionsCheck);
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage usage = this.getUsage();
        RepoUsageComponentTest.assertNotNull((String)"Usage is null", (Object)usage);
        RepoUsageComponentTest.assertNotNull((String)"Invalid user count", (Object)usage.getUsers());
        RepoUsageComponentTest.assertNotNull((String)"Invalid document count", (Object)usage.getDocuments());
        RepoUsageComponentTest.assertEquals((String)"License mode not set", (Object)restrictions.getLicenseMode(), (Object)usage.getLicenseMode());
        RepoUsageComponentTest.assertEquals((String)"License expiry not set", (Object)restrictions.getLicenseExpiryDate(), (Object)usage.getLicenseExpiryDate());
        RepoUsageComponentTest.assertEquals((String)"Read-only state not set", (boolean)restrictions.isReadOnly(), (boolean)usage.isReadOnly());
        RepoUsageStatus status = this.repoUsageComponent.getUsageStatus();
        logger.debug((Object)status);
    }

    public void test5LicenseUse() throws Exception {
        Long licenseUserLimit = 5L;
        Long licenseDocumentLimit = 100000L;
        RepoUsage.LicenseMode licenseMode = RepoUsage.LicenseMode.TEAM;
        Long licenseExpiry = System.currentTimeMillis() + 86400000L;
        RepoUsage restrictions = new RepoUsage(Long.valueOf(System.currentTimeMillis()), licenseUserLimit, licenseDocumentLimit, licenseMode, licenseExpiry, !this.transactionService.getAllowWrite());
        this.repoUsageComponent.setRestrictions(restrictions);
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        this.getUsage();
    }

    public void testLicenceHoursBeforeExpiration() throws Exception {
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage restrictions = new RepoUsage(Long.valueOf(System.currentTimeMillis()), Long.valueOf(5000L), Long.valueOf(100000L), RepoUsage.LicenseMode.TEAM, Long.valueOf(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(6L)), false);
        this.repoUsageComponent.setRestrictions(restrictions);
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage usage = this.getUsage();
        RepoUsageComponentTest.assertFalse((String)"Usage is in read-only mode", (boolean)usage.isReadOnly());
        RepoUsageComponentTest.assertTrue((String)"System is in read-only mode", (boolean)this.transactionService.getAllowWrite());
        RepoUsageStatus status = this.repoUsageComponent.getUsageStatus();
        RepoUsageComponentTest.assertEquals((String)"System is not at Warning All Level", (Object)status.getLevel(), (Object)RepoUsageStatus.RepoUsageLevel.WARN_ALL);
    }

    public void testLicenceMinutesAfterExpiration() throws Exception {
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage restrictions = new RepoUsage(Long.valueOf(System.currentTimeMillis()), Long.valueOf(5000L), Long.valueOf(100000L), RepoUsage.LicenseMode.TEAM, Long.valueOf(System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(1L)), false);
        this.repoUsageComponent.setRestrictions(restrictions);
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage usage = this.getUsage();
        RepoUsageComponentTest.assertTrue((String)"Usage is not in read-only mode", (boolean)usage.isReadOnly());
        RepoUsageComponentTest.assertFalse((String)"System is not in read-only mode", (boolean)this.transactionService.getAllowWrite());
        RepoUsageStatus status = this.repoUsageComponent.getUsageStatus();
        RepoUsageComponentTest.assertEquals((String)"System is not at Locked Level", (Object)status.getLevel(), (Object)RepoUsageStatus.RepoUsageLevel.LOCKED_DOWN);
    }

    public void testLicenceMonthsBeforeExpiration() throws Exception {
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage restrictions = new RepoUsage(Long.valueOf(System.currentTimeMillis()), Long.valueOf(5000L), Long.valueOf(100000L), RepoUsage.LicenseMode.TEAM, Long.valueOf(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(60L)), false);
        this.repoUsageComponent.setRestrictions(restrictions);
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage usage = this.getUsage();
        RepoUsageComponentTest.assertFalse((String)"Usage is in read-only mode", (boolean)usage.isReadOnly());
        RepoUsageComponentTest.assertTrue((String)"System is in read-only mode", (boolean)this.transactionService.getAllowWrite());
        RepoUsageStatus status = this.repoUsageComponent.getUsageStatus();
        RepoUsageComponentTest.assertEquals((String)"System is not at OK Level", (Object)status.getLevel(), (Object)RepoUsageStatus.RepoUsageLevel.OK);
    }

    public void testLicenceDaysAfterExpiration() throws Exception {
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage restrictions = new RepoUsage(Long.valueOf(System.currentTimeMillis()), Long.valueOf(5000L), Long.valueOf(100000L), RepoUsage.LicenseMode.TEAM, Long.valueOf(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(5L)), false);
        this.repoUsageComponent.setRestrictions(restrictions);
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage usage = this.getUsage();
        RepoUsageComponentTest.assertTrue((String)"Usage is not in read-only mode", (boolean)usage.isReadOnly());
        RepoUsageComponentTest.assertFalse((String)"System is not in read-only mode", (boolean)this.transactionService.getAllowWrite());
        RepoUsageStatus status = this.repoUsageComponent.getUsageStatus();
        RepoUsageComponentTest.assertEquals((String)"System is not at Locked Level", (Object)status.getLevel(), (Object)RepoUsageStatus.RepoUsageLevel.LOCKED_DOWN);
    }
}

