/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.impl.AccessPermissionImpl;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.usage.UsageService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.FixMethodOrder;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;
import org.springframework.context.ApplicationContext;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@Category(value={OwnJVMTestsCategory.class, LuceneTests.class})
public class MultiTDemoTest
extends TestCase {
    private static Log logger = LogFactory.getLog(MultiTDemoTest.class);
    private ApplicationContext ctx;
    private NodeService nodeService;
    private NodeArchiveService nodeArchiveService;
    private NamespaceService namespaceService;
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private SiteService siteService;
    private SearchService searchService;
    private ContentService contentService;
    private PermissionService permissionService;
    private OwnableService ownableService;
    private TenantAdminService tenantAdminService;
    private TenantService tenantService;
    private AuthorityService authorityService;
    private CategoryService categoryService;
    private CheckOutCheckInService cociService;
    private RepoAdminService repoAdminService;
    private DictionaryService dictionaryService;
    private UsageService usageService;
    private TransactionService transactionService;
    private FileFolderService fileFolderService;
    private Repository repositoryHelper;
    public static int NUM_TENANTS = 2;
    public static final String TEST_RUN = String.valueOf(System.currentTimeMillis());
    public static final String TEST_TENANT_DOMAIN = String.valueOf(TEST_RUN) + ".my.test";
    public static final String TEST_TENANT_DOMAIN2 = String.valueOf(TEST_TENANT_DOMAIN) + "2";
    public static List<String> tenants = new ArrayList<String>(NUM_TENANTS);
    public static final String ROOT_DIR = "./tenantstores";
    public static final String DEFAULT_ADMIN_PW = "admin";
    public static final String DEFAULT_GUEST_UN = "guest";
    public static final String DEFAULT_GUEST_PW = "thiscanbeanything";
    public static final String TEST_USER1 = "alice";
    public static final String TEST_USER2 = "bob";
    public static final String TEST_USER3 = "eve";
    public static final String TEST_USER4 = "fred";
    private static Set<StoreRef> DEFAULT_STORES;
    private static final int DEFAULT_STORE_COUNT;
    public static StoreRef SPACES_STORE;

    static {
        int i = 1;
        while (i <= NUM_TENANTS) {
            tenants.add(String.valueOf(TEST_TENANT_DOMAIN) + i);
            ++i;
        }
        DEFAULT_STORES = new HashSet<StoreRef>(Arrays.asList(new StoreRef("workspace://lightWeightVersionStore"), new StoreRef("system://system"), new StoreRef("workspace://version2Store"), new StoreRef("user://alfrescoUserStore"), new StoreRef("workspace://SpacesStore"), new StoreRef("archive://SpacesStore")));
        DEFAULT_STORE_COUNT = DEFAULT_STORES.size();
        SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{ApplicationContextHelper.CONFIG_LOCATIONS[0], "classpath:tenant/mt-*context.xml"});
        this.nodeService = (NodeService)this.ctx.getBean("NodeService");
        this.nodeArchiveService = (NodeArchiveService)this.ctx.getBean("nodeArchiveService");
        this.namespaceService = (NamespaceService)this.ctx.getBean("NamespaceService");
        this.authenticationService = (MutableAuthenticationService)this.ctx.getBean("AuthenticationService");
        this.tenantAdminService = (TenantAdminService)this.ctx.getBean("tenantAdminService");
        this.tenantService = (TenantService)this.ctx.getBean("tenantService");
        this.personService = (PersonService)this.ctx.getBean("PersonService");
        this.searchService = (SearchService)this.ctx.getBean("SearchService");
        this.contentService = (ContentService)this.ctx.getBean("ContentService");
        this.permissionService = (PermissionService)this.ctx.getBean("PermissionService");
        this.ownableService = (OwnableService)this.ctx.getBean("OwnableService");
        this.authorityService = (AuthorityService)this.ctx.getBean("AuthorityService");
        this.categoryService = (CategoryService)this.ctx.getBean("CategoryService");
        this.cociService = (CheckOutCheckInService)this.ctx.getBean("CheckoutCheckinService");
        this.repoAdminService = (RepoAdminService)this.ctx.getBean("RepoAdminService");
        this.dictionaryService = (DictionaryService)this.ctx.getBean("DictionaryService");
        this.usageService = (UsageService)this.ctx.getBean("usageService");
        this.transactionService = (TransactionService)this.ctx.getBean("TransactionService");
        this.fileFolderService = (FileFolderService)this.ctx.getBean("FileFolderService");
        this.ownableService = (OwnableService)this.ctx.getBean("OwnableService");
        this.repositoryHelper = (Repository)this.ctx.getBean("repositoryHelper");
        this.siteService = (SiteService)this.ctx.getBean("SiteService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.createTenants();
        this.createUsers();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void createTenants() {
        for (String tenantDomain : tenants) {
            this.createTenant(tenantDomain);
        }
    }

    private void createTenant(final String tenantDomain) {
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!MultiTDemoTest.this.tenantAdminService.existsTenant(tenantDomain)) {
                    MultiTDemoTest.this.tenantAdminService.createTenant(tenantDomain, ("admin " + tenantDomain).toCharArray(), null);
                    logger.info((Object)("Created tenant " + tenantDomain));
                }
                return null;
            }
        }, (String)"");
    }

    private void deleteTenant(final String tenantDomain) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        if (MultiTDemoTest.this.tenantAdminService.existsTenant(tenantDomain)) {
                            BehaviourFilter behaviourFilter = (BehaviourFilter)MultiTDemoTest.this.ctx.getBean("policyBehaviourFilter");
                            behaviourFilter.disableBehaviour(ContentModel.TYPE_PERSON);
                            behaviourFilter.disableBehaviour(ContentModel.ASPECT_UNDELETABLE);
                            MultiTDemoTest.this.tenantAdminService.deleteTenant(tenantDomain);
                            logger.info((Object)("Deleted tenant " + tenantDomain));
                        }
                        return null;
                    }
                }, (String)"");
                return null;
            }
        });
    }

    private void createUsers() {
        for (final String tenantDomain : tenants) {
            String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    MultiTDemoTest.this.createUser(MultiTDemoTest.TEST_USER1, tenantDomain, "alice " + tenantDomain);
                    MultiTDemoTest.this.createUser(MultiTDemoTest.TEST_USER2, tenantDomain, "bob " + tenantDomain);
                    if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                        MultiTDemoTest.this.createUser(MultiTDemoTest.TEST_USER3, tenantDomain, "eve " + tenantDomain);
                    }
                    return null;
                }
            }, (String)tenantAdminName, (String)tenantDomain);
        }
    }

    public void test01CreateTenants() throws Throwable {
        String[] tenantDomains;
        logger.info((Object)"Create tenants");
        String tenantDomain1 = String.valueOf(TEST_RUN) + ".one.createTenant";
        String tenantDomain2 = String.valueOf(TEST_RUN) + ".two.createTenant";
        String[] stringArray = tenantDomains = new String[]{tenantDomain1, tenantDomain2};
        int n = tenantDomains.length;
        int n2 = 0;
        while (n2 < n) {
            String tenantDomain = stringArray[n2];
            this.createTenant(tenantDomain);
            ++n2;
        }
        List persons = this.personService.getPeople(null, true, null, new PagingRequest(0, Integer.MAX_VALUE, null)).getPage();
        for (PersonService.PersonInfo person : persons) {
            String userName = person.getUserName();
            String[] stringArray2 = tenantDomains;
            int n3 = tenantDomains.length;
            int n4 = 0;
            while (n4 < n3) {
                String tenantDomain = stringArray2[n4];
                MultiTDemoTest.assertFalse((String)("Unexpected (tenant) user: " + userName), (boolean)userName.endsWith(tenantDomain));
                ++n4;
            }
        }
    }

    private void deleteTestAuthoritiesForTenant(final String[] uniqueGroupNames, final String userName) {
        String tenantDomain = this.tenantService.getUserDomain(userName);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                NodeRef personNodeRef = MultiTDemoTest.this.personService.getPerson(userName);
                NodeRef homeSpaceRef = (NodeRef)MultiTDemoTest.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_HOMEFOLDER);
                MultiTDemoTest.assertNotNull((Object)homeSpaceRef);
                int i = 0;
                while (i < uniqueGroupNames.length) {
                    MultiTDemoTest.this.authorityService.deleteAuthority("GROUP_" + uniqueGroupNames[i]);
                    ++i;
                }
                return null;
            }
        }, (String)userName, (String)tenantDomain);
    }

    private void createTestAuthoritiesForTenant(final String[] uniqueGroupNames, final String userName) {
        String tenantDomain = this.tenantService.getUserDomain(userName);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                MultiTDemoTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        NodeRef personNodeRef = MultiTDemoTest.this.personService.getPerson(userName);
                        NodeRef homeSpaceRef = (NodeRef)MultiTDemoTest.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_HOMEFOLDER);
                        MultiTDemoTest.assertNotNull((Object)homeSpaceRef);
                        int i = 0;
                        while (i < uniqueGroupNames.length) {
                            MultiTDemoTest.this.authorityService.createAuthority(AuthorityType.GROUP, uniqueGroupNames[i]);
                            MultiTDemoTest.this.permissionService.setPermission(homeSpaceRef, "GROUP_" + uniqueGroupNames[i], "Consumer", true);
                            ++i;
                        }
                        return null;
                    }
                }, false);
                return null;
            }
        }, (String)userName, (String)tenantDomain);
    }

    private void checkTestAuthoritiesPresence(final String[] uniqueGroupNames, final String userName, final boolean shouldPresent) {
        String tenantDomain = this.tenantService.getUserDomain(userName);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                NodeRef personNodeRef = MultiTDemoTest.this.personService.getPerson(userName);
                NodeRef homeSpaceRef = (NodeRef)MultiTDemoTest.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_HOMEFOLDER);
                Set perms = MultiTDemoTest.this.permissionService.getAllSetPermissions(homeSpaceRef);
                Set auths = MultiTDemoTest.this.authorityService.getAllAuthorities(AuthorityType.GROUP);
                int i = 0;
                while (i < uniqueGroupNames.length) {
                    AccessPermissionImpl toCheck = new AccessPermissionImpl("Consumer", AccessStatus.ALLOWED, "GROUP_" + uniqueGroupNames[i], 0);
                    if (shouldPresent) {
                        MultiTDemoTest.assertTrue((boolean)auths.contains("GROUP_" + uniqueGroupNames[i]));
                        MultiTDemoTest.assertTrue((boolean)perms.contains(toCheck));
                    } else {
                        MultiTDemoTest.assertTrue((!auths.contains("GROUP_" + uniqueGroupNames[i]) ? 1 : 0) != 0);
                        MultiTDemoTest.assertTrue((!perms.contains(toCheck) ? 1 : 0) != 0);
                    }
                    ++i;
                }
                return null;
            }
        }, (String)userName, (String)tenantDomain);
    }

    private void createGroup(String shortName, String parentShortName) {
        String groupName = this.authorityService.getName(AuthorityType.GROUP, shortName);
        if (!this.authorityService.authorityExists(groupName)) {
            String parentGroupName = null;
            if (parentShortName != null && !this.authorityService.authorityExists(parentGroupName = this.authorityService.getName(AuthorityType.GROUP, parentShortName))) {
                logger.warn((Object)("Parent group does not exist: " + parentShortName));
                return;
            }
            this.authorityService.createAuthority(AuthorityType.GROUP, shortName);
            if (parentGroupName != null) {
                this.addToGroup(parentShortName, groupName);
            }
        } else {
            logger.warn((Object)("Group already exists: " + shortName));
        }
    }

    private void addToGroup(String parentGroupShortName, String authorityName) {
        String parentGroupName = this.authorityService.getName(AuthorityType.GROUP, parentGroupShortName);
        this.authorityService.addAuthority(parentGroupName, authorityName);
    }

    private NodeRef createUser(String baseUserName, String tenantDomain, String password) {
        String userName = this.tenantService.getDomainUser(baseUserName, tenantDomain);
        NodeRef personNodeRef = null;
        if (!this.authenticationService.authenticationExists(userName)) {
            NodeRef baseHomeFolder = this.getUserHomesNodeRef(SPACES_STORE);
            NodeRef homeFolder = this.createHomeSpaceFolderNode(baseHomeFolder, baseUserName, userName);
            this.authenticationService.createAuthentication(userName, password.toCharArray());
            HashMap<QName, String> personProperties = new HashMap<QName, String>();
            personProperties.put(ContentModel.PROP_USERNAME, userName);
            personProperties.put(ContentModel.PROP_HOMEFOLDER, (String)homeFolder);
            personProperties.put(ContentModel.PROP_FIRSTNAME, baseUserName);
            personProperties.put(ContentModel.PROP_LASTNAME, String.valueOf(baseUserName) + "-" + tenantDomain);
            personProperties.put(ContentModel.PROP_EMAIL, userName);
            personNodeRef = this.personService.createPerson(personProperties);
            this.permissionService.setPermission(personNodeRef, userName, this.permissionService.getAllPermission(), true);
            NodeRef checkHomeSpaceRef = (NodeRef)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_HOMEFOLDER);
            MultiTDemoTest.assertNotNull((Object)checkHomeSpaceRef);
            logger.info((Object)("Created user " + userName));
        } else {
            personNodeRef = this.personService.getPerson(userName);
            logger.info((Object)("Found existing user " + userName));
        }
        return personNodeRef;
    }

    private void loginLogoutUser(String username, String password) {
        this.authenticationService.authenticate(username, password.toCharArray());
        username = this.authenticationService.getCurrentUserName();
        NodeRef personRef = this.personService.getPerson(username);
        NodeRef homeSpaceRef = (NodeRef)this.nodeService.getProperty(personRef, ContentModel.PROP_HOMEFOLDER);
        if (!this.nodeService.exists(homeSpaceRef)) {
            throw new InvalidNodeRefException(homeSpaceRef);
        }
        this.authenticationService.clearCurrentSecurityContext();
    }

    private NodeRef getUserHomesNodeRef(StoreRef storeRef) {
        return this.findFolderNodeRef(storeRef, "/app:company_home/app:user_homes");
    }

    private NodeRef getWebClientExtensionNodeRef(StoreRef storeRef) {
        return this.findFolderNodeRef(storeRef, "/app:company_home/app:dictionary/app:webclient_extension");
    }

    private NodeRef findFolderNodeRef(StoreRef storeRef, String folderXPath) {
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, folderXPath, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef folderNodeRef = null;
        if (nodeRefs.size() != 1) {
            throw new AlfrescoRuntimeException("Cannot find folder location: " + folderXPath);
        }
        folderNodeRef = (NodeRef)nodeRefs.get(0);
        return folderNodeRef;
    }

    private NodeRef createFolderNode(NodeRef parentFolderNodeRef, String nameValue) {
        if (nameValue != null) {
            HashMap<QName, String> folderProps = new HashMap<QName, String>();
            folderProps.put(ContentModel.PROP_NAME, nameValue);
            return this.nodeService.createNode(parentFolderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nameValue), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
        }
        return null;
    }

    private NodeRef createCategory(StoreRef storeRef, NodeRef parentCategoryRef, String name, String description) {
        NodeRef ref = parentCategoryRef == null ? this.categoryService.createRootCategory(storeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE, name) : this.categoryService.createCategory(parentCategoryRef, name);
        HashMap<QName, String> titledProps = new HashMap<QName, String>(1, 1.0f);
        titledProps.put(ContentModel.PROP_DESCRIPTION, description);
        this.nodeService.addAspect(ref, ContentModel.ASPECT_TITLED, titledProps);
        return ref;
    }

    private NodeRef createHomeSpaceFolderNode(NodeRef folderNodeRef, String spaceName, String userName) {
        if (spaceName != null) {
            HashMap<QName, String> folderProps = new HashMap<QName, String>();
            folderProps.put(ContentModel.PROP_NAME, spaceName);
            NodeRef nodeRef = this.nodeService.createNode(folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)spaceName), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
            HashMap<QName, String> uiFacetsProps = new HashMap<QName, String>(3);
            uiFacetsProps.put(ApplicationModel.PROP_ICON, "space-icon-default");
            uiFacetsProps.put(ContentModel.PROP_TITLE, spaceName);
            this.nodeService.addAspect(nodeRef, ApplicationModel.ASPECT_UIFACETS, uiFacetsProps);
            this.setupHomeSpacePermissions(nodeRef, userName);
            return nodeRef;
        }
        return null;
    }

    private void setupHomeSpacePermissions(NodeRef homeSpaceRef, String userName) {
        this.permissionService.setPermission(homeSpaceRef, userName, this.permissionService.getAllPermission(), true);
        String permission = "Consumer";
        if (permission != null && permission.length() != 0) {
            this.permissionService.setPermission(homeSpaceRef, this.permissionService.getAllAuthorities(), permission, true);
        }
        this.ownableService.setOwner(homeSpaceRef, userName);
        this.permissionService.setPermission(homeSpaceRef, this.permissionService.getOwnerAuthority(), this.permissionService.getAllPermission(), true);
        this.permissionService.setInheritParentPermissions(homeSpaceRef, false);
    }

    private NodeRef getHomeSpaceFolderNode(String userName) {
        return (NodeRef)this.nodeService.getProperty(this.personService.getPerson(userName), ContentModel.PROP_HOMEFOLDER);
    }

    private NodeRef addContent(NodeRef spaceRef, String name, String textData, String mimeType) {
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, name);
        ChildAssociationRef association = this.nodeService.createNode(spaceRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, name);
        titledProps.put(ContentModel.PROP_DESCRIPTION, name);
        this.nodeService.addAspect(content, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimeType);
        writer.setEncoding("UTF-8");
        writer.putContent(textData);
        return content;
    }

    private NodeRef addContent(NodeRef spaceRef, String name, InputStream is, String mimeType) {
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, name);
        ChildAssociationRef association = this.nodeService.createNode(spaceRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, name);
        titledProps.put(ContentModel.PROP_DESCRIPTION, name);
        this.nodeService.addAspect(content, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimeType);
        writer.setEncoding("UTF-8");
        writer.putContent(is);
        return content;
    }

    private SiteInfo createSite(String siteId) {
        SiteInfo siteInfo = this.siteService.createSite(null, siteId, "title - " + siteId, "description - " + siteId, SiteVisibility.PRIVATE);
        NodeRef result = this.siteService.getContainer(siteId, "documentLibrary");
        if (result == null) {
            result = this.siteService.createContainer(siteId, "documentLibrary", ContentModel.TYPE_FOLDER, null);
        }
        return siteInfo;
    }

    public void test02NonSharedGroupDeletion() {
        String tenantDomain1 = String.valueOf(TEST_RUN) + ".groupdel1";
        String tenantDomain2 = String.valueOf(TEST_RUN) + ".groupdel2";
        try {
            String[] tenantUniqueGroupNames = new String[10];
            String[] superadminUniqueGroupNames = new String[10];
            int i = 0;
            while (i < tenantUniqueGroupNames.length) {
                tenantUniqueGroupNames[i] = String.valueOf(TEST_RUN) + "test_group" + i;
                superadminUniqueGroupNames[i] = String.valueOf(TEST_RUN) + "test_group_sa" + i;
                ++i;
            }
            this.clearUsage(AuthenticationUtil.getAdminUserName());
            this.createTenant(tenantDomain1);
            this.createTenant(tenantDomain2);
            String tenantAdminName1 = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain1);
            String tenantAdminName2 = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain2);
            this.clearUsage(tenantDomain1);
            this.createTestAuthoritiesForTenant(tenantUniqueGroupNames, tenantAdminName1);
            this.clearUsage(tenantDomain1);
            this.checkTestAuthoritiesPresence(tenantUniqueGroupNames, tenantAdminName1, true);
            this.clearUsage(tenantDomain2);
            this.checkTestAuthoritiesPresence(tenantUniqueGroupNames, tenantAdminName2, false);
            this.checkTestAuthoritiesPresence(tenantUniqueGroupNames, DEFAULT_ADMIN_PW, false);
            this.createTestAuthoritiesForTenant(superadminUniqueGroupNames, DEFAULT_ADMIN_PW);
            this.clearUsage(tenantDomain1);
            this.checkTestAuthoritiesPresence(superadminUniqueGroupNames, tenantAdminName1, false);
            this.clearUsage(tenantDomain2);
            this.checkTestAuthoritiesPresence(superadminUniqueGroupNames, tenantAdminName2, false);
            this.checkTestAuthoritiesPresence(superadminUniqueGroupNames, DEFAULT_ADMIN_PW, true);
            this.clearUsage(tenantDomain1);
            this.deleteTestAuthoritiesForTenant(tenantUniqueGroupNames, tenantAdminName1);
            this.checkTestAuthoritiesPresence(tenantUniqueGroupNames, tenantAdminName1, false);
            this.deleteTestAuthoritiesForTenant(superadminUniqueGroupNames, DEFAULT_ADMIN_PW);
            this.checkTestAuthoritiesPresence(superadminUniqueGroupNames, DEFAULT_ADMIN_PW, false);
        }
        finally {
            this.deleteTenant(tenantDomain1);
            this.deleteTenant(tenantDomain2);
        }
    }

    public void test03SharedGroupDeletion() {
        String tenantDomain1 = String.valueOf(TEST_RUN) + ".groupdel3";
        String tenantDomain2 = String.valueOf(TEST_RUN) + ".groupdel4";
        try {
            String[] commonTenantUniqueGroupNames = new String[10];
            int i = 0;
            while (i < commonTenantUniqueGroupNames.length) {
                commonTenantUniqueGroupNames[i] = String.valueOf(TEST_RUN) + "test_group" + i;
                ++i;
            }
            this.clearUsage(AuthenticationUtil.getAdminUserName());
            this.createTenant(tenantDomain1);
            this.createTenant(tenantDomain2);
            String tenantAdminName1 = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain1);
            String tenantAdminName2 = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain2);
            this.clearUsage(tenantDomain1);
            this.createTestAuthoritiesForTenant(commonTenantUniqueGroupNames, tenantAdminName1);
            this.clearUsage(tenantDomain2);
            this.createTestAuthoritiesForTenant(commonTenantUniqueGroupNames, tenantAdminName2);
            this.createTestAuthoritiesForTenant(commonTenantUniqueGroupNames, DEFAULT_ADMIN_PW);
            this.clearUsage(tenantDomain1);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, tenantAdminName1, true);
            this.clearUsage(tenantDomain2);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, tenantAdminName2, true);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, DEFAULT_ADMIN_PW, true);
            this.clearUsage(tenantDomain1);
            this.deleteTestAuthoritiesForTenant(commonTenantUniqueGroupNames, tenantAdminName1);
            this.clearUsage(tenantDomain1);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, tenantAdminName1, false);
            this.clearUsage(tenantDomain2);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, tenantAdminName2, true);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, DEFAULT_ADMIN_PW, true);
            this.clearUsage(tenantDomain1);
            this.createTestAuthoritiesForTenant(commonTenantUniqueGroupNames, tenantAdminName1);
            this.clearUsage(tenantDomain2);
            this.deleteTestAuthoritiesForTenant(commonTenantUniqueGroupNames, tenantAdminName2);
            this.clearUsage(tenantDomain1);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, tenantAdminName1, true);
            this.clearUsage(tenantDomain2);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, tenantAdminName2, false);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, DEFAULT_ADMIN_PW, true);
            this.clearUsage(tenantDomain2);
            this.createTestAuthoritiesForTenant(commonTenantUniqueGroupNames, tenantAdminName2);
            this.deleteTestAuthoritiesForTenant(commonTenantUniqueGroupNames, DEFAULT_ADMIN_PW);
            this.clearUsage(tenantDomain1);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, tenantAdminName1, true);
            this.clearUsage(tenantDomain2);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, tenantAdminName2, true);
            this.checkTestAuthoritiesPresence(commonTenantUniqueGroupNames, DEFAULT_ADMIN_PW, false);
        }
        finally {
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
            this.deleteTenant(tenantDomain1);
            this.deleteTenant(tenantDomain2);
        }
    }

    public void test04_ETHREEOH_2015() {
        final String tenantDomain1 = String.valueOf(TEST_RUN) + ".one.ethreeoh2015";
        String tenantDomain2 = String.valueOf(TEST_RUN) + ".two.ethreeoh2015";
        this.clearUsage(AuthenticationUtil.getAdminUserName());
        this.createTenant(tenantDomain1);
        String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain1);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                MultiTDemoTest.this.createUser(MultiTDemoTest.TEST_USER1, tenantDomain1, "alice " + tenantDomain1);
                return null;
            }
        }, (String)tenantAdminName, (String)tenantDomain1);
        this.createTenant(tenantDomain2);
    }

    private void clearUsage(String userName) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final NodeRef personNodeRef = this.personService.getPerson(userName);
        this.nodeService.setProperty(personNodeRef, ContentModel.PROP_SIZE_CURRENT, (Serializable)new Long(-1L));
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                MultiTDemoTest.this.usageService.deleteDeltas(personNodeRef);
                return null;
            }
        }, false);
    }

    public void test05ValidateUsers() throws Throwable {
        logger.info((Object)"Validate demo users");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                List persons = MultiTDemoTest.this.personService.getPeople(null, true, null, new PagingRequest(0, Integer.MAX_VALUE, null)).getPage();
                for (PersonService.PersonInfo person : persons) {
                    String userName = person.getUserName();
                    for (String tenantDomain : tenants) {
                        MultiTDemoTest.assertFalse((String)("Unexpected (tenant) user: " + userName), (boolean)userName.endsWith(tenantDomain));
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        try {
            for (final String tenantDomain : tenants) {
                String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
                TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        List persons = MultiTDemoTest.this.personService.getPeople(null, null, null, new PagingRequest(0, Integer.MAX_VALUE, null)).getPage();
                        for (PersonService.PersonInfo person : persons) {
                            NodeRef personRef = person.getNodeRef();
                            String userName = (String)((Object)MultiTDemoTest.this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
                            MultiTDemoTest.assertTrue((boolean)userName.endsWith(tenantDomain));
                            logger.info((Object)("Validate users: get all people - found user: " + userName));
                            NodeRef homeSpaceRef = (NodeRef)MultiTDemoTest.this.nodeService.getProperty(personRef, ContentModel.PROP_HOMEFOLDER);
                            MultiTDemoTest.assertNotNull((Object)homeSpaceRef);
                        }
                        if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                            MultiTDemoTest.assertEquals((int)5, (int)persons.size());
                        } else {
                            MultiTDemoTest.assertEquals((int)4, (int)persons.size());
                        }
                        return null;
                    }
                }, (String)tenantAdminName, (String)tenantDomain);
            }
        }
        catch (Throwable t) {
            StringWriter stackTrace = new StringWriter();
            t.printStackTrace(new PrintWriter(stackTrace));
            System.err.println(stackTrace.toString());
            throw t;
        }
    }

    public void test06LoginTenantUsers() throws Throwable {
        logger.info((Object)"Login tenant users");
        try {
            AuthenticationUtil.clearCurrentSecurityContext();
            for (String tenantDomain : tenants) {
                this.loginLogoutUser(this.tenantService.getDomainUser(TEST_USER1, tenantDomain), "alice " + tenantDomain);
                this.loginLogoutUser(this.tenantService.getDomainUser(TEST_USER2, tenantDomain), "bob " + tenantDomain);
                if (!tenantDomain.equals(TEST_TENANT_DOMAIN2)) continue;
                this.loginLogoutUser(this.tenantService.getDomainUser(TEST_USER3, tenantDomain), "eve " + tenantDomain);
            }
        }
        catch (Throwable t) {
            StringWriter stackTrace = new StringWriter();
            t.printStackTrace(new PrintWriter(stackTrace));
            System.err.println(stackTrace.toString());
            throw t;
        }
    }

    public void test07LoginTenantGuests() throws Throwable {
        logger.info((Object)"Login tenant guests");
        try {
            AuthenticationUtil.clearCurrentSecurityContext();
            for (String tenantDomain : tenants) {
                this.loginLogoutUser(this.tenantService.getDomainUser(DEFAULT_GUEST_UN, tenantDomain), DEFAULT_GUEST_UN);
            }
        }
        catch (Throwable t) {
            StringWriter stackTrace = new StringWriter();
            t.printStackTrace(new PrintWriter(stackTrace));
            System.err.println(stackTrace.toString());
            throw t;
        }
    }

    public void test08LoginTenantAdmin() throws Throwable {
        logger.info((Object)"Login tenant admins");
        try {
            AuthenticationUtil.clearCurrentSecurityContext();
            for (String tenantDomain : tenants) {
                this.loginLogoutUser(this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain), "admin " + tenantDomain);
            }
        }
        catch (Throwable t) {
            StringWriter stackTrace = new StringWriter();
            t.printStackTrace(new PrintWriter(stackTrace));
            System.err.println(stackTrace.toString());
            throw t;
        }
    }

    public void test09CreateGroups() {
        String tenantAdminName;
        logger.info((Object)"Create demo groups");
        MultiTDemoTest.assertTrue((tenants.size() > 0 ? 1 : 0) != 0);
        final int rootGrpsOrigCnt = (Integer)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Integer>(){

            public Integer doWork() throws Exception {
                return MultiTDemoTest.this.authorityService.getAllRootAuthorities(AuthorityType.GROUP).size();
            }
        }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenants.get(0)), (String)tenants.get(0));
        for (final String tenantDomain : tenants) {
            tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    MultiTDemoTest.this.createGroup("GrpA", null);
                    MultiTDemoTest.this.createGroup("SubGrpA", "GrpA");
                    MultiTDemoTest.this.createGroup("GrpB", null);
                    MultiTDemoTest.this.createGroup("GrpC", null);
                    if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                        MultiTDemoTest.this.createGroup("SubGrpC", "GrpC");
                    }
                    MultiTDemoTest.this.createGroup("GrpD", null);
                    MultiTDemoTest.this.addToGroup("GrpD", tenantAdminName);
                    return null;
                }
            }, (String)tenantAdminName, (String)tenantDomain);
        }
        for (final String tenantDomain : tenants) {
            tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    Set rootGrps = MultiTDemoTest.this.authorityService.getAllRootAuthorities(AuthorityType.GROUP);
                    MultiTDemoTest.assertEquals((int)(rootGrpsOrigCnt + 4), (int)rootGrps.size());
                    Set auths = MultiTDemoTest.this.authorityService.getContainedAuthorities(null, "GROUP_GrpA", true);
                    MultiTDemoTest.assertEquals((int)1, (int)auths.size());
                    auths = MultiTDemoTest.this.authorityService.getContainedAuthorities(null, "GROUP_GrpB", true);
                    MultiTDemoTest.assertEquals((int)0, (int)auths.size());
                    auths = MultiTDemoTest.this.authorityService.getContainedAuthorities(null, "GROUP_GrpC", true);
                    if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                        MultiTDemoTest.assertEquals((int)1, (int)auths.size());
                    } else {
                        MultiTDemoTest.assertEquals((int)0, (int)auths.size());
                    }
                    auths = MultiTDemoTest.this.authorityService.getContainedAuthorities(null, "GROUP_GrpD", true);
                    MultiTDemoTest.assertEquals((int)1, (int)auths.size());
                    MultiTDemoTest.assertTrue((boolean)auths.toArray()[0].equals(tenantAdminName));
                    return null;
                }
            }, (String)tenantAdminName, (String)tenantDomain);
        }
    }

    @Category(value={RedundantTests.class})
    public void test10CreateCategories() {
        logger.info((Object)"Create demo categories");
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                logger.info((Object)"Create demo categories - super tenant");
                MultiTDemoTest.this.createCategoriesImpl("");
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName(), (String)"");
        for (final String tenantDomain : tenants) {
            String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    logger.info((Object)("Create demo categories - " + tenantDomain));
                    MultiTDemoTest.this.createCategoriesImpl(tenantDomain);
                    return null;
                }
            }, (String)tenantAdminName, (String)tenantDomain);
        }
    }

    private void createCategoriesImpl(String tenantDomain) {
        if (tenantDomain.equals("")) {
            Collection childAssocs = this.categoryService.getRootCategories(SPACES_STORE, ContentModel.ASPECT_GEN_CLASSIFIABLE);
            for (ChildAssociationRef childAssoc : childAssocs) {
                if (!this.nodeService.getProperty(childAssoc.getChildRef(), ContentModel.PROP_NAME).equals("CatA")) continue;
                return;
            }
        }
        String query = "PATH:\"/cm:categoryRoot/cm:generalclassifiable/*\"";
        ResultSet resultSet = this.searchService.query(SPACES_STORE, "lucene", query);
        int cnt = resultSet.length();
        NodeRef catA = this.createCategory(SPACES_STORE, null, "CatA", "CatA-" + tenantDomain);
        this.createCategory(SPACES_STORE, catA, "SubCatA", "SubCatA-" + tenantDomain);
        NodeRef catB = this.createCategory(SPACES_STORE, null, "CatB", "CatB-" + tenantDomain);
        this.createCategory(SPACES_STORE, catB, "SubCatB", "SubCatB-" + tenantDomain);
        cnt += 2;
        if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
            NodeRef catC = this.createCategory(SPACES_STORE, null, "CatC", "CatC-" + tenantDomain);
            this.createCategory(SPACES_STORE, catC, "SubCatC", "SubCatC-" + tenantDomain);
            ++cnt;
        }
        resultSet.close();
        resultSet = this.searchService.query(SPACES_STORE, "lucene", query);
        MultiTDemoTest.assertEquals((int)cnt, (int)resultSet.length());
        resultSet.close();
        String queryMembers = "PATH:\"/cm:categoryRoot/cm:generalclassifiable//cm:catA/member\"";
        resultSet = this.searchService.query(SPACES_STORE, "lucene", queryMembers);
        MultiTDemoTest.assertEquals((int)0, (int)resultSet.length());
        resultSet.close();
        NodeRef homeSpaceRef = this.getHomeSpaceFolderNode(AuthenticationUtil.getRunAsUser());
        NodeRef contentRef = this.addContent(homeSpaceRef, "tqbfjotld.txt", "The quick brown fox jumps over the lazy dog (tenant " + tenantDomain + ")", "text/plain");
        MultiTDemoTest.assertFalse((boolean)this.nodeService.hasAspect(contentRef, ContentModel.ASPECT_GEN_CLASSIFIABLE));
        List categories = (ArrayList<NodeRef>)this.nodeService.getProperty(contentRef, ContentModel.PROP_CATEGORIES);
        MultiTDemoTest.assertNull((Object)categories);
        categories = new ArrayList<NodeRef>(1);
        categories.add(catA);
        HashMap<QName, Serializable> catProps = new HashMap<QName, Serializable>();
        catProps.put(ContentModel.PROP_CATEGORIES, (Serializable)((Object)categories));
        this.nodeService.addAspect(contentRef, ContentModel.ASPECT_GEN_CLASSIFIABLE, catProps);
        MultiTDemoTest.assertTrue((boolean)this.nodeService.hasAspect(contentRef, ContentModel.ASPECT_GEN_CLASSIFIABLE));
        categories = (List)((Object)this.nodeService.getProperty(contentRef, ContentModel.PROP_CATEGORIES));
        MultiTDemoTest.assertEquals((int)1, (int)categories.size());
        queryMembers = "PATH:\"/cm:categoryRoot/cm:generalclassifiable//cm:CatA/member\"";
        resultSet = this.searchService.query(SPACES_STORE, "lucene", queryMembers);
        MultiTDemoTest.assertEquals((int)1, (int)resultSet.length());
        resultSet.close();
    }

    public void test11CreateFolders() {
        logger.info((Object)"Create demo folders");
        ArrayList<String> users = new ArrayList<String>(3);
        users.add(TEST_USER1);
        users.add(TEST_USER2);
        users.add(TEST_USER3);
        for (final String tenantDomain : tenants) {
            for (String baseUserName : users) {
                if (baseUserName.equals(TEST_USER3) && !tenantDomain.equals(TEST_TENANT_DOMAIN2)) continue;
                final String tenantUserName = this.tenantService.getDomainUser(baseUserName, tenantDomain);
                TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        NodeRef homeSpaceRef = MultiTDemoTest.this.getHomeSpaceFolderNode(tenantUserName);
                        NodeRef folderRef = MultiTDemoTest.this.createFolderNode(homeSpaceRef, "myfolder1");
                        MultiTDemoTest.this.createFolderNode(folderRef, "mysubfolder1");
                        folderRef = MultiTDemoTest.this.createFolderNode(homeSpaceRef, "myfolder2");
                        MultiTDemoTest.this.createFolderNode(folderRef, "mysubfolder2");
                        if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                            folderRef = MultiTDemoTest.this.createFolderNode(homeSpaceRef, "myfolder3");
                            MultiTDemoTest.this.createFolderNode(folderRef, "mysubfolder3");
                        }
                        return null;
                    }
                }, (String)tenantUserName, (String)tenantDomain);
            }
        }
    }

    public void test12CreateVersionableUserContent() {
        logger.info((Object)"Create demo content");
        ArrayList<String> users = new ArrayList<String>(3);
        users.add(TEST_USER1);
        users.add(TEST_USER2);
        users.add(TEST_USER3);
        for (final String tenantDomain : tenants) {
            for (String baseUserName : users) {
                if (baseUserName.equals(TEST_USER3) && !tenantDomain.equals(TEST_TENANT_DOMAIN2)) continue;
                final String tenantUserName = this.tenantService.getDomainUser(baseUserName, tenantDomain);
                TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        NodeRef homeSpaceRef = MultiTDemoTest.this.getHomeSpaceFolderNode(tenantUserName);
                        NodeRef contentRef = MultiTDemoTest.this.addContent(homeSpaceRef, String.valueOf(tenantUserName) + " quick brown fox.txt", "The quick brown fox jumps over the lazy dog (tenant " + tenantDomain + ")", "text/plain");
                        MultiTDemoTest.this.nodeService.addAspect(contentRef, ContentModel.ASPECT_VERSIONABLE, null);
                        if (tenantDomain.equals(TEST_TENANT_DOMAIN2)) {
                            contentRef = MultiTDemoTest.this.addContent(homeSpaceRef, String.valueOf(tenantUserName) + " quick brown fox ANO.txt", "The quick brown fox jumps over the lazy dog ANO (tenant " + tenantDomain + ")", "text/plain");
                            MultiTDemoTest.this.nodeService.addAspect(contentRef, ContentModel.ASPECT_VERSIONABLE, null);
                        }
                        return null;
                    }
                }, (String)tenantUserName, (String)tenantDomain);
            }
        }
    }

    public void test13GetStores() {
        logger.info((Object)"Get tenant stores");
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                for (StoreRef storeRef : MultiTDemoTest.this.nodeService.getStores()) {
                    System.out.println("StoreRef: " + storeRef);
                }
                MultiTDemoTest.assertTrue((String)("System: " + MultiTDemoTest.this.nodeService.getStores().size() + ", " + (tenants.size() + 1)), (MultiTDemoTest.this.nodeService.getStores().size() >= DEFAULT_STORE_COUNT * (tenants.size() + 1) ? 1 : 0) != 0);
                return null;
            }
        }, (String)"");
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                MultiTDemoTest.assertTrue((String)("Super admin: " + MultiTDemoTest.this.nodeService.getStores().size()), (MultiTDemoTest.this.nodeService.getStores().size() >= DEFAULT_STORE_COUNT ? 1 : 0) != 0);
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName(), (String)"");
        for (final String tenantDomain : tenants) {
            String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    HashSet stores = new HashSet(MultiTDemoTest.this.nodeService.getStores());
                    MultiTDemoTest.assertEquals((String)("Tenant: " + tenantDomain), (Object)DEFAULT_STORES, stores);
                    return null;
                }
            }, (String)tenantAdminName, (String)tenantDomain);
        }
    }

    public void test14GetProperty() {
        logger.info((Object)"Test get property");
        for (final String tenantDomain : tenants) {
            String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    NodeRef personNodeRef = MultiTDemoTest.this.createUser(MultiTDemoTest.TEST_USER4, tenantDomain, "fred " + tenantDomain);
                    NodeRef homeFolderNodeRef = (NodeRef)MultiTDemoTest.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_HOMEFOLDER);
                    MultiTDemoTest.assertFalse((boolean)homeFolderNodeRef.toString().contains(tenantDomain));
                    Map props = MultiTDemoTest.this.nodeService.getProperties(personNodeRef);
                    MultiTDemoTest.assertFalse((boolean)((Serializable)props.get(ContentModel.PROP_HOMEFOLDER)).toString().contains(tenantDomain));
                    String storeId = (String)((Object)MultiTDemoTest.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_STORE_IDENTIFIER));
                    MultiTDemoTest.assertFalse((boolean)storeId.contains(tenantDomain));
                    MultiTDemoTest.assertFalse((boolean)((Serializable)props.get(ContentModel.PROP_STORE_IDENTIFIER)).toString().contains(tenantDomain));
                    return null;
                }
            }, (String)tenantAdminName, (String)tenantDomain);
        }
    }

    @Category(value={RedundantTests.class})
    public void test15COCIandSearch() {
        logger.info((Object)"Test checkout/checkin and search");
        for (String tenantDomain : tenants) {
            final String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    String origText = "You have been invited to";
                    String query = "+PATH:\"/app:company_home/app:dictionary/app:email_templates/app:invite_email_templates/*\" +TEXT:\"" + origText + "\"";
                    ResultSet resultSet = MultiTDemoTest.this.searchService.query(SPACES_STORE, "lucene", query);
                    MultiTDemoTest.assertEquals((int)1, (int)resultSet.length());
                    NodeRef nodeRef = resultSet.getNodeRef(0);
                    resultSet.close();
                    NodeRef workingCopyNodeRef = MultiTDemoTest.this.cociService.checkout(nodeRef);
                    ContentWriter writer = MultiTDemoTest.this.contentService.getWriter(workingCopyNodeRef, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/plain");
                    writer.setEncoding("UTF-8");
                    String updateText = "Updated by " + tenantAdminName;
                    writer.putContent(updateText);
                    MultiTDemoTest.this.cociService.checkin(workingCopyNodeRef, null);
                    query = "+PATH:\"/app:company_home/app:dictionary/app:email_templates/app:invite_email_templates/*\" +TEXT:\"" + origText + "\"";
                    resultSet = MultiTDemoTest.this.searchService.query(SPACES_STORE, "lucene", query);
                    MultiTDemoTest.assertEquals((int)0, (int)resultSet.length());
                    resultSet.close();
                    query = "+PATH:\"/app:company_home/app:dictionary/app:email_templates/app:invite_email_templates/*\" +TEXT:\"" + updateText + "\"";
                    resultSet = MultiTDemoTest.this.searchService.query(SPACES_STORE, "lucene", query);
                    MultiTDemoTest.assertEquals((int)1, (int)resultSet.length());
                    resultSet.close();
                    return null;
                }
            }, (String)tenantAdminName, (String)tenantDomain);
        }
    }

    public void test16DeleteArchiveAndRestoreContent() {
        logger.info((Object)"test delete/archive & restore content");
        AuthenticationUtil.clearCurrentSecurityContext();
        final String superAdmin = AuthenticationUtil.getAdminUserName();
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                MultiTDemoTest.this.deleteArchiveAndRestoreContent(superAdmin, "");
                return null;
            }
        }, (String)superAdmin);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                MultiTDemoTest.this.createUser("superAnoUser", "", "superAnoUser");
                return null;
            }
        }, (String)superAdmin);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                MultiTDemoTest.this.deleteArchiveAndRestoreContent("superAnoUser", "");
                return null;
            }
        }, (String)"superAnoUser");
        for (final String tenantDomain : tenants) {
            final String tenantUserName = this.tenantService.getDomainUser(TEST_USER1, tenantDomain);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    MultiTDemoTest.this.deleteArchiveAndRestoreContent(tenantUserName, tenantDomain);
                    return null;
                }
            }, (String)tenantUserName, (String)tenantDomain);
        }
    }

    private void deleteArchiveAndRestoreContent(String userName, String tenantDomain) {
        NodeRef homeSpaceRef = this.getHomeSpaceFolderNode(userName);
        NodeRef contentRef = this.addContent(homeSpaceRef, String.valueOf(userName) + " " + System.currentTimeMillis() + " tqbfjotld.txt", "The quick brown fox jumps over the lazy dog (tenant " + tenantDomain + ")", "text/plain");
        MultiTDemoTest.assertEquals((String)userName, (String)this.ownableService.getOwner(contentRef));
        this.permissionService.hasPermission(contentRef, "DeleteNode");
        NodeRef storeArchiveNode = this.nodeService.getStoreArchiveNode(contentRef.getStoreRef());
        this.nodeService.deleteNode(contentRef);
        StoreRef archiveStoreRef = storeArchiveNode.getStoreRef();
        NodeRef archivedContentRef = new NodeRef(archiveStoreRef, contentRef.getId());
        MultiTDemoTest.assertEquals((String)userName, (String)this.ownableService.getOwner(archivedContentRef));
        this.permissionService.hasPermission(archivedContentRef, "DeleteNode");
        RestoreNodeReport report = this.nodeArchiveService.restoreArchivedNode(archivedContentRef);
        MultiTDemoTest.assertNotNull((Object)report);
        NodeRef restoredNodeRef = report.getRestoredNodeRef();
        MultiTDemoTest.assertNotNull((Object)restoredNodeRef);
        archivedContentRef = new NodeRef(archiveStoreRef, restoredNodeRef.getId());
        this.nodeService.deleteNode(restoredNodeRef);
        this.nodeArchiveService.purgeArchivedNode(archivedContentRef);
    }

    public void test17CustomModels() {
        logger.info((Object)"test custom models");
        final int defaultModelCnt = this.dictionaryService.getAllModels().size();
        for (String tenantDomain : tenants) {
            String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    MultiTDemoTest.assertEquals((int)0, (int)MultiTDemoTest.this.repoAdminService.getModels().size());
                    MultiTDemoTest.assertEquals((int)defaultModelCnt, (int)MultiTDemoTest.this.dictionaryService.getAllModels().size());
                    MultiTDemoTest.assertNull((Object)MultiTDemoTest.this.dictionaryService.getClass(QName.createQName((String)"{my.new.model}sop")));
                    InputStream modelStream = this.getClass().getClassLoader().getResourceAsStream("tenant/exampleModel.xml");
                    MultiTDemoTest.this.repoAdminService.deployModel(modelStream, "exampleModel.xml");
                    MultiTDemoTest.assertEquals((int)1, (int)MultiTDemoTest.this.repoAdminService.getModels().size());
                    MultiTDemoTest.assertEquals((int)(defaultModelCnt + 1), (int)MultiTDemoTest.this.dictionaryService.getAllModels().size());
                    ClassDefinition myType = MultiTDemoTest.this.dictionaryService.getClass(QName.createQName((String)"{my.new.model}sop"));
                    MultiTDemoTest.assertNotNull((Object)myType);
                    MultiTDemoTest.assertEquals((Object)QName.createQName((String)"{my.new.model}mynewmodel"), (Object)myType.getModel().getName());
                    MultiTDemoTest.this.repoAdminService.deactivateModel("exampleModel.xml");
                    MultiTDemoTest.assertEquals((int)1, (int)MultiTDemoTest.this.repoAdminService.getModels().size());
                    MultiTDemoTest.assertEquals((int)defaultModelCnt, (int)MultiTDemoTest.this.dictionaryService.getAllModels().size());
                    MultiTDemoTest.assertNull((Object)MultiTDemoTest.this.dictionaryService.getClass(QName.createQName((String)"{my.new.model}sop")));
                    MultiTDemoTest.this.repoAdminService.activateModel("exampleModel.xml");
                    MultiTDemoTest.assertEquals((int)1, (int)MultiTDemoTest.this.repoAdminService.getModels().size());
                    MultiTDemoTest.assertEquals((int)(defaultModelCnt + 1), (int)MultiTDemoTest.this.dictionaryService.getAllModels().size());
                    myType = MultiTDemoTest.this.dictionaryService.getClass(QName.createQName((String)"{my.new.model}sop"));
                    MultiTDemoTest.assertNotNull((Object)myType);
                    MultiTDemoTest.assertEquals((Object)QName.createQName((String)"{my.new.model}mynewmodel"), (Object)myType.getModel().getName());
                    return null;
                }
            }, (String)tenantAdminName, (String)tenantDomain);
        }
    }

    public void test18AddCustomWebClient() {
        logger.info((Object)"test add custom web client config");
        for (String tenantDomain : tenants) {
            String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    NodeRef webClientExtFolder = MultiTDemoTest.this.getWebClientExtensionNodeRef(SPACES_STORE);
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("tenant/webclient.properties");
                    MultiTDemoTest.this.addContent(webClientExtFolder, "webclient.properties", is, "text/plain");
                    is = this.getClass().getClassLoader().getResourceAsStream("tenant/web-client-config-custom.xml");
                    MultiTDemoTest.this.addContent(webClientExtFolder, "web-client-config-custom.xml", is, "text/xml");
                    return null;
                }
            }, (String)tenantAdminName, (String)tenantDomain);
        }
    }

    public void test19FileFolder() {
        logger.info((Object)"test file/folder list");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        for (String tenantDomain : tenants) {
            String tenantUserName = this.tenantService.getDomainUser(TEST_USER1, tenantDomain);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    ArrayList<String> pathElements = new ArrayList<String>(2);
                    pathElements.add("Data Dictionary");
                    pathElements.add("Presentation Templates");
                    NodeRef chRef = MultiTDemoTest.this.repositoryHelper.getCompanyHome();
                    NodeRef ddRef = MultiTDemoTest.this.fileFolderService.resolveNamePath(chRef, pathElements).getNodeRef();
                    MultiTDemoTest.assertTrue((MultiTDemoTest.this.fileFolderService.list(ddRef).size() > 0 ? 1 : 0) != 0);
                    return null;
                }
            }, (String)tenantUserName, (String)tenantDomain);
        }
    }

    public void test20_ALF_12732() {
        String tenantDomain1 = String.valueOf(TEST_RUN) + ".one.alf12732";
        this.createTenant(tenantDomain1);
        String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain1);
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)tenantAdminName);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    MultiTDemoTest.this.createSite("site1");
                    NodeRef docLib1Ref = MultiTDemoTest.this.siteService.getContainer("site1", "documentLibrary");
                    NodeRef contentRef = MultiTDemoTest.this.addContent(docLib1Ref, "tqbfjotld.txt", "The quick brown fox jumps over the lazy dog", "text/plain");
                    MultiTDemoTest.this.createSite("site2");
                    NodeRef docLib2Ref = MultiTDemoTest.this.siteService.getContainer("site2", "documentLibrary");
                    MultiTDemoTest.this.nodeService.moveNode(contentRef, docLib2Ref, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"tqbfjotld.txt"));
                    MultiTDemoTest.this.siteService.cleanSitePermissions(contentRef, null);
                    return null;
                }
            }, (String)tenantAdminName, (String)tenantDomain1);
        }
        finally {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }

    public void test21_ALF_14354() {
        String tenantDomain1 = String.valueOf(TEST_RUN) + ".one.alf14354";
        String tenantDomain2 = String.valueOf(TEST_RUN) + ".two.alf14354";
        this.createTenant(tenantDomain1);
        this.createTenant(tenantDomain2);
        String tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain1);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                NodeRef rootNodeRef = MultiTDemoTest.this.repositoryHelper.getRootHome();
                MultiTDemoTest.assertTrue((boolean)MultiTDemoTest.this.nodeService.exists(rootNodeRef));
                return null;
            }
        }, (String)tenantAdminName, (String)tenantDomain1);
        tenantAdminName = this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain2);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                NodeRef rootNodeRef = MultiTDemoTest.this.repositoryHelper.getRootHome();
                MultiTDemoTest.assertTrue((boolean)MultiTDemoTest.this.nodeService.exists(rootNodeRef));
                return null;
            }
        }, (String)tenantAdminName, (String)tenantDomain2);
    }

    private int searchForDataDictionary(String tenantAdminName, final String query) {
        return (Integer)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Integer>(){

            public Integer doWork() throws Exception {
                ResultSet resultSet = MultiTDemoTest.this.searchService.query(SPACES_STORE, "lucene", query, null);
                return resultSet.length();
            }
        }, (String)tenantAdminName);
    }

    public void test22DeleteAllTenants() {
        logger.info((Object)"test delete tenants");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        List allTenants = this.tenantAdminService.getAllTenants();
        for (Tenant tenant : allTenants) {
            this.deleteTenant(tenant.getTenantDomain());
        }
    }
}

