/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.remote.server;

import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.springframework.remoting.rmi.RmiRegistryFactoryBean;

public class AlfrescoRmiRegistryFactoryBean
extends RmiRegistryFactoryBean {
    private static final String ERR_MSG_NOT_ENABLED = "The RMI registry factory is disabled.";
    private boolean enabled = true;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.enabled) {
            super.afterPropertiesSet();
        }
    }

    protected Registry getRegistry(String registryHost, int registryPort, RMIClientSocketFactory clientSocketFactory, RMIServerSocketFactory serverSocketFactory) throws RemoteException {
        if (this.enabled) {
            return super.getRegistry(registryHost, registryPort, clientSocketFactory, serverSocketFactory);
        }
        throw new RemoteException(ERR_MSG_NOT_ENABLED);
    }

    protected Registry getRegistry(int registryPort, RMIClientSocketFactory clientSocketFactory, RMIServerSocketFactory serverSocketFactory) throws RemoteException {
        if (this.enabled) {
            return super.getRegistry(registryPort, clientSocketFactory, serverSocketFactory);
        }
        throw new RemoteException(ERR_MSG_NOT_ENABLED);
    }

    protected Registry getRegistry(int registryPort) throws RemoteException {
        if (this.enabled) {
            return super.getRegistry(registryPort);
        }
        throw new RemoteException(ERR_MSG_NOT_ENABLED);
    }
}

