/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.events;

import org.alfresco.repo.events.AbstractEventsService;
import org.alfresco.repo.events.ExceptionEventsService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.sync.events.types.ExceptionGeneratedEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gytheio.messaging.MessageProducer;
import org.gytheio.messaging.MessagingException;

public class ExceptionEventsServiceImpl
extends AbstractEventsService
implements ExceptionEventsService {
    private static Log logger = LogFactory.getLog(ExceptionEventsServiceImpl.class);
    private MessageProducer messageProducer;
    private boolean enabled;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setMessageProducer(MessageProducer messageProducer) {
        this.messageProducer = messageProducer;
    }

    @Override
    public void init() {
    }

    @Override
    public void exceptionGenerated(String txnId, Throwable t) {
        if (this.enabled) {
            try {
                long timestamp = System.currentTimeMillis();
                String networkId = TenantUtil.getCurrentDomain();
                String username = AuthenticationUtil.getFullyAuthenticatedUser();
                ExceptionGeneratedEvent event = new ExceptionGeneratedEvent(this.nextSequenceNumber(), txnId, timestamp, networkId, t, username);
                this.messageProducer.send((Object)event);
            }
            catch (MessagingException e) {
                logger.error((Object)e);
            }
        }
    }
}

