/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema.script;

import java.io.File;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.schema.script.ScriptBundleExecutor;
import org.alfresco.repo.domain.schema.script.ScriptExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptBundleExecutorImpl
implements ScriptBundleExecutor {
    private ScriptExecutor scriptExecutor;
    protected Log log = LogFactory.getLog(ScriptBundleExecutorImpl.class);

    public ScriptBundleExecutorImpl(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    @Override
    public void exec(boolean logOnly, String dir, String ... scripts) {
        String[] stringArray = scripts;
        int n = scripts.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File file = new File(dir, name);
            try {
                this.scriptExecutor.executeScriptUrl(file.getPath());
            }
            catch (Exception e) {
                String msg = "Unable to run SQL script: dir=" + dir + ", name=" + name;
                if (logOnly) {
                    this.log.error((Object)msg, (Throwable)e);
                    break;
                }
                throw new AlfrescoRuntimeException(msg, (Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    public void exec(String dir, String ... scripts) {
        this.exec(true, dir, scripts);
    }

    @Override
    public void execWithPostScript(String dir, String postScript, String ... scripts) {
        try {
            this.exec(true, dir, scripts);
        }
        catch (Throwable throwable) {
            this.exec(true, dir, postScript);
            throw throwable;
        }
        this.exec(true, dir, postScript);
    }
}

