/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.InputStream;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.springframework.extensions.surf.util.I18NUtil;

public class FixTemplatePatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.fixWebscriptTemplate.result";
    private static final String MSG_SKIP = "patch.fixWebscriptTemplate.skip";
    private Repository repository;
    protected ContentService contentService;
    private String target;
    private String source;

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    protected String applyInternal() throws Exception {
        List refs = this.searchService.selectNodes(this.repository.getRootHome(), this.target, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (refs.size() < 1) {
            return I18NUtil.getMessage((String)MSG_SKIP);
        }
        this.updateContent((NodeRef)refs.get(0));
        return I18NUtil.getMessage((String)MSG_SUCCESS);
    }

    private void updateContent(NodeRef nodeRef) {
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.source);
        if (is != null) {
            ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
            contentWriter.setMimetype("text/plain");
            contentWriter.setEncoding("UTF-8");
            contentWriter.putContent(is);
        }
    }
}

