/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.ImporterActionExecuter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImporterActionExecuterTest {
    public static ApplicationContextInit ctx = new ApplicationContextInit();
    private static final String FILE_NAME = "import-archive-test/SuspiciousPathsArchive.zip";
    private static ContentService contentService;
    private static ImporterActionExecuter importerActionExecuter;
    private static NodeService nodeService;
    private static ServiceRegistry serviceRegistry;
    private static StoreRef storeRef;

    @BeforeClass
    public static void setup() throws Exception {
        serviceRegistry = (ServiceRegistry)ctx.getApplicationContext().getBean("ServiceRegistry", ServiceRegistry.class);
        contentService = serviceRegistry.getContentService();
        nodeService = serviceRegistry.getNodeService();
        importerActionExecuter = (ImporterActionExecuter)ctx.getApplicationContext().getBean("import", ImporterActionExecuter.class);
        AuthenticationUtil.setRunAsUserSystem();
        storeRef = (StoreRef)serviceRegistry.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<StoreRef>(){

            public StoreRef execute() {
                StoreRef storeRef = nodeService.createStore("workspace", "Test_" + System.nanoTime());
                return storeRef;
            }
        });
    }

    @AfterClass
    public static void tearDown() {
        try {
            serviceRegistry.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() {
                    if (storeRef != null) {
                        nodeService.deleteStore(storeRef);
                    }
                    return null;
                }
            });
        }
        finally {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }

    @Test
    public void testImportArchiveWithSuspiciousPaths() throws IOException {
        RetryingTransactionHelper retryingTransactionHelper = serviceRegistry.getRetryingTransactionHelper();
        retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                NodeRef rootNodeRef = nodeService.getRootNode(storeRef);
                NodeRef zipFileNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/ImporterActionExecuterTest", (String)"testAssocQName1"), ContentModel.TYPE_CONTENT).getChildRef();
                NodeRef targetFolderNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/ImporterActionExecuterTest", (String)"testAssocQName2"), ContentModel.TYPE_FOLDER).getChildRef();
                ImporterActionExecuterTest.this.putContent(zipFileNodeRef, ImporterActionExecuterTest.FILE_NAME);
                Action action = ImporterActionExecuterTest.this.createAction(zipFileNodeRef, "ImporterActionExecuterTestActionDefinition", targetFolderNodeRef);
                try {
                    try {
                        importerActionExecuter.execute(action, zipFileNodeRef);
                        Assert.fail((String)"An AlfrescoRuntimeException should have occured.");
                    }
                    catch (AlfrescoRuntimeException e) {
                        Assert.assertTrue((boolean)e.getMessage().contains("Archive contains suspicious paths. Please review it's contents and make sure it doesn't contain entries with absolute paths or paths containing references to the parent folder (i.e. \"..\")"));
                        nodeService.deleteNode(targetFolderNodeRef);
                        nodeService.deleteNode(zipFileNodeRef);
                    }
                }
                finally {
                    nodeService.deleteNode(targetFolderNodeRef);
                    nodeService.deleteNode(zipFileNodeRef);
                }
                return null;
            }
        });
    }

    @Test
    public void testImportHasTitledAspectForFolders() throws IOException {
        RetryingTransactionHelper retryingTransactionHelper = serviceRegistry.getRetryingTransactionHelper();
        retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                NodeRef rootNodeRef = nodeService.getRootNode(storeRef);
                NodeRef zipFileNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT).getChildRef();
                NodeRef targetFolderNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER).getChildRef();
                ImporterActionExecuterTest.this.putContent(zipFileNodeRef, "import-archive-test/folderCmTitledAspectArchive.zip");
                Action action = ImporterActionExecuterTest.this.createAction(zipFileNodeRef, "ImporterActionExecuterTestActionDefinition", targetFolderNodeRef);
                try {
                    importerActionExecuter.execute(action, zipFileNodeRef);
                    NodeRef importedFolder = nodeService.getChildByName(targetFolderNodeRef, ContentModel.ASSOC_CONTAINS, "folderCmTitledAspectArchive");
                    Assert.assertNotNull((String)"import action failed", (Object)importedFolder);
                    boolean hasAspectTitled = nodeService.hasAspect(importedFolder, ContentModel.ASPECT_TITLED);
                    Assert.assertTrue((String)"folder didn't get the cm:titled aspect applied", (boolean)hasAspectTitled);
                    String title = (String)((Object)nodeService.getProperty(importedFolder, ContentModel.PROP_TITLE));
                    Assert.assertNull((String)"The title should not have cm:title set", (Object)title);
                }
                finally {
                    nodeService.deleteNode(targetFolderNodeRef);
                    nodeService.deleteNode(zipFileNodeRef);
                }
                return null;
            }
        });
    }

    @Test
    public void testImportThatExceedsCompressionRatioFails() throws IOException {
        RetryingTransactionHelper retryingTransactionHelper = serviceRegistry.getRetryingTransactionHelper();
        retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                NodeRef rootNodeRef = nodeService.getRootNode(storeRef);
                NodeRef zipFileNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT).getChildRef();
                NodeRef targetFolderNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER).getChildRef();
                ImporterActionExecuterTest.this.putContent(zipFileNodeRef, "import-archive-test/exceedsRatio.zip");
                Action action = ImporterActionExecuterTest.this.createAction(zipFileNodeRef, "ImporterActionExecuterTestActionDefinition", targetFolderNodeRef);
                try {
                    try {
                        importerActionExecuter.setRatioThreshold(3L);
                        importerActionExecuter.execute(action, zipFileNodeRef);
                        Assert.fail((String)"Import action should have detected that zip file exceeds compression ration threshold");
                    }
                    catch (AlfrescoRuntimeException e) {
                        Assert.assertTrue((boolean)e.getMessage().contains("Unexpected compression ratio detected"));
                        nodeService.deleteNode(targetFolderNodeRef);
                        nodeService.deleteNode(zipFileNodeRef);
                    }
                }
                finally {
                    nodeService.deleteNode(targetFolderNodeRef);
                    nodeService.deleteNode(zipFileNodeRef);
                }
                return null;
            }
        });
    }

    @Test
    public void testImportThatExceedsUncompressedBytesLimitFails() throws IOException {
        RetryingTransactionHelper retryingTransactionHelper = serviceRegistry.getRetryingTransactionHelper();
        retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                NodeRef rootNodeRef = nodeService.getRootNode(storeRef);
                NodeRef zipFileNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT).getChildRef();
                NodeRef targetFolderNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER).getChildRef();
                ImporterActionExecuterTest.this.putContent(zipFileNodeRef, "import-archive-test/exceedsUncompressedBytesLimit.zip");
                Action action = ImporterActionExecuterTest.this.createAction(zipFileNodeRef, "ImporterActionExecuterTestActionDefinition", targetFolderNodeRef);
                try {
                    try {
                        importerActionExecuter.setUncompressedBytesLimit("1000");
                        importerActionExecuter.execute(action, zipFileNodeRef);
                        Assert.fail((String)"Import action should have detected that uncompressed bytes exceed limit");
                    }
                    catch (AlfrescoRuntimeException e) {
                        Assert.assertTrue((boolean)e.getMessage().contains("Uncompressed bytes limit exceeded"));
                        nodeService.deleteNode(targetFolderNodeRef);
                        nodeService.deleteNode(zipFileNodeRef);
                    }
                }
                finally {
                    nodeService.deleteNode(targetFolderNodeRef);
                    nodeService.deleteNode(zipFileNodeRef);
                }
                return null;
            }
        });
    }

    private void putContent(NodeRef zipFileNodeRef, String resource) {
        URL url = AbstractContentTransformerTest.class.getClassLoader().getResource(resource);
        File file = new File(url.getFile());
        ContentWriter writer = contentService.getWriter(zipFileNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("application/zip");
        writer.putContent(file);
    }

    private Action createAction(NodeRef nodeRef, String actionDefinitionName, NodeRef targetNodeRef) {
        ActionImpl action = new ActionImpl(nodeRef, GUID.generate(), actionDefinitionName);
        action.setParameterValue("destination", (Serializable)targetNodeRef);
        action.setParameterValue("encoding", (Serializable)((Object)"UTF-8"));
        return action;
    }
}

