/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.remote.server;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.UUID;
import org.alfresco.util.remote.server.AbstractRemoteInputStreamServer;
import org.alfresco.util.remote.server.RemoteInputStreamServer;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;
import org.springframework.remoting.rmi.RmiServiceExporter;

public class RmiRemoteInputStreamServer
extends AbstractRemoteInputStreamServer {
    private RmiServiceExporter rmiServiceExporter;

    public RmiRemoteInputStreamServer(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public String start(String host, int port) throws RemoteException {
        String name = String.valueOf(this.inputStream.getClass().getName()) + UUID.randomUUID();
        this.rmiServiceExporter = new RmiServiceExporter();
        this.rmiServiceExporter.setServiceName(name);
        this.rmiServiceExporter.setRegistryPort(port);
        this.rmiServiceExporter.setRegistryHost(host);
        this.rmiServiceExporter.setServiceInterface(RemoteInputStreamServer.class);
        this.rmiServiceExporter.setService((Object)this);
        this.rmiServiceExporter.afterPropertiesSet();
        return name;
    }

    @Override
    public void close() throws IOException {
        try {
            this.inputStream.close();
        }
        finally {
            if (this.rmiServiceExporter != null) {
                try {
                    this.rmiServiceExporter.destroy();
                }
                catch (Throwable e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
    }

    public static RemoteInputStreamServer obtain(String host, int port, String name) throws RemoteException {
        RmiProxyFactoryBean rmiProxyFactoryBean = new RmiProxyFactoryBean();
        rmiProxyFactoryBean.setServiceUrl("rmi://" + host + ":" + port + "/" + name);
        rmiProxyFactoryBean.setServiceInterface(RemoteInputStreamServer.class);
        rmiProxyFactoryBean.setRefreshStubOnConnectFailure(true);
        try {
            rmiProxyFactoryBean.afterPropertiesSet();
        }
        catch (Exception exception) {
            throw new RemoteException("Error create rmi proxy");
        }
        return (RemoteInputStreamServer)rmiProxyFactoryBean.getObject();
    }
}

