/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.schedule;

import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.schedule.AbstractScheduledLockedJob;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ScheduledJobLockExecuter {
    private static final long LOCK_TTL = 30000L;
    private static Log logger = LogFactory.getLog((String)ScheduledJobLockExecuter.class.getName());
    private static ThreadLocal<Pair<Long, String>> lockThreadLocal = new ThreadLocal();
    private final JobLockService jobLockService;
    private final QName lockQName;
    private final AbstractScheduledLockedJob job;

    public ScheduledJobLockExecuter(JobLockService jobLockService, String name, AbstractScheduledLockedJob job) {
        this.jobLockService = jobLockService;
        this.lockQName = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)name);
        this.job = job;
    }

    public void execute(JobExecutionContext jobContext) throws JobExecutionException {
        try {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("   Job %s started.", this.lockQName.getLocalName()));
                }
                this.refreshLock();
                this.job.executeJob(jobContext);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("   Job %s completed.", this.lockQName.getLocalName()));
                }
            }
            catch (LockAcquisitionException lockAcquisitionException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("   Job %s already underway.", this.lockQName.getLocalName()));
                }
                this.releaseLock();
            }
            catch (VmShutdownListener.VmShutdownException vmShutdownException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("   Job %s aborted.", this.lockQName.getLocalName()));
                }
                this.releaseLock();
            }
        }
        finally {
            this.releaseLock();
        }
    }

    private void refreshLock() {
        Pair lockPair = lockThreadLocal.get();
        if (lockPair == null) {
            String lockToken = this.jobLockService.getLock(this.lockQName, 30000L);
            Long lastLock = new Long(System.currentTimeMillis());
            lockPair = new Pair((Object)lastLock, (Object)lockToken);
            lockThreadLocal.set((Pair<Long, String>)lockPair);
        } else {
            long now = System.currentTimeMillis();
            long lastLock = (Long)lockPair.getFirst();
            String lockToken = (String)lockPair.getSecond();
            if (now - lastLock > 15000L) {
                this.jobLockService.refreshLock(lockToken, this.lockQName, 30000L);
                lastLock = System.currentTimeMillis();
                lockPair = new Pair((Object)lastLock, (Object)lockToken);
                lockThreadLocal.set((Pair<Long, String>)lockPair);
            }
        }
    }

    private void releaseLock() {
        Pair<Long, String> lockPair = lockThreadLocal.get();
        if (lockPair != null) {
            try {
                this.jobLockService.releaseLock((String)lockPair.getSecond(), this.lockQName);
            }
            finally {
                lockThreadLocal.set(null);
            }
        }
    }
}

