/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jscript;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowTransition;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.mozilla.javascript.Scriptable;

public class JscriptWorkflowNode
implements Serializable {
    static final long serialVersionUID = 6785972019256246499L;
    private final String name;
    private final String title;
    private final String description;
    private final boolean isTaskNode;
    private final ArrayList<JscriptWorkflowTransition> transitions;
    private final Scriptable scope;
    private final ServiceRegistry serviceRegistry;

    public JscriptWorkflowNode(String name, String title, String description, boolean isTaskNode, ArrayList<JscriptWorkflowTransition> transitions, Scriptable scope, ServiceRegistry serviceRegistry) {
        this.name = name;
        this.title = title;
        this.description = description;
        this.isTaskNode = isTaskNode;
        this.transitions = transitions;
        this.scope = scope;
        this.serviceRegistry = serviceRegistry;
    }

    public JscriptWorkflowNode(WorkflowNode workflowNode, Scriptable scope, ServiceRegistry serviceRegistry) {
        WorkflowTransition[] cmrWorkflowTransitions;
        this.name = workflowNode.name;
        this.title = workflowNode.title;
        this.description = workflowNode.description;
        this.isTaskNode = workflowNode.isTaskNode;
        this.transitions = new ArrayList();
        WorkflowTransition[] workflowTransitionArray = cmrWorkflowTransitions = workflowNode.transitions;
        int n = cmrWorkflowTransitions.length;
        int n2 = 0;
        while (n2 < n) {
            WorkflowTransition cmrWorkflowTransition = workflowTransitionArray[n2];
            this.transitions.add(new JscriptWorkflowTransition(cmrWorkflowTransition));
            ++n2;
        }
        this.scope = scope;
        this.serviceRegistry = serviceRegistry;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isTaskNode() {
        return this.isTaskNode;
    }

    public Scriptable getTransitions() {
        Scriptable transitionsScriptable = (Scriptable)new ValueConverter().convertValueForScript(this.serviceRegistry, this.scope, null, this.transitions);
        return transitionsScriptable;
    }

    public String toString() {
        String transitionsList = "{";
        for (JscriptWorkflowTransition transition : this.transitions) {
            transitionsList = String.valueOf(transitionsList) + ", '" + transition + "'";
        }
        transitionsList = String.valueOf(transitionsList) + "}";
        return "WorkflowNode[title=" + this.title + ",transitions=" + transitionsList + "]";
    }
}

