/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowPackageComponent;
import org.alfresco.repo.workflow.WorkflowPackageImpl$AjcClosure1;
import org.alfresco.repo.workflow.WorkflowPackageImpl$AjcClosure3;
import org.alfresco.repo.workflow.WorkflowPackageImpl$AjcClosure5;
import org.alfresco.repo.workflow.WorkflowPackageImpl$AjcClosure7;
import org.alfresco.repo.workflow.traitextender.WorkflowPackageExtension;
import org.alfresco.repo.workflow.traitextender.WorkflowPackageTrait;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.traitextender.AJProxyTrait;
import org.alfresco.traitextender.Extend;
import org.alfresco.traitextender.ExtendedTrait;
import org.alfresco.traitextender.Extensible;
import org.alfresco.traitextender.RouteExtensions;
import org.alfresco.traitextender.Trait;
import org.alfresco.util.GUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class WorkflowPackageImpl
implements WorkflowPackageComponent,
Extensible {
    private static final String PACKAGE_FOLDER = "packages";
    private static final String ERR_PACKAGE_ALREADY_ASSOCIATED = "workflow.package.already.associated.error";
    private ImporterBootstrap bootstrap;
    private SearchService searchService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private PermissionService permissionService;
    private NodeRef systemWorkflowContainer = null;
    private TenantService tenantService;
    private MessageService messageService;
    private BehaviourFilter policyBehaviourFilter;
    private final ExtendedTrait<WorkflowPackageTrait> workflowPackageTrait = new ExtendedTrait<WorkflowPackageTrait>(AJProxyTrait.create(this, WorkflowPackageTrait.class));
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;

    public void setImporterBootstrap(ImporterBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    @Override
    @Extend(traitAPI=WorkflowPackageTrait.class, extensionAPI=WorkflowPackageExtension.class)
    public NodeRef createPackage(NodeRef container) {
        NodeRef nodeRef = container;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)nodeRef);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new WorkflowPackageImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = WorkflowPackageImpl.class.getDeclaredMethod("createPackage", NodeRef.class).getAnnotation(Extend.class);
        }
        return (NodeRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private NodeRef makePackageContainer() {
        NodeRef packages = this.findOrCreatePackagesFolder();
        String packageId = "pkg_" + GUID.generate();
        QName packageName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)packageId);
        try {
            this.policyBehaviourFilter.disableBehaviour(packages, ContentModel.ASPECT_AUDITABLE);
            ChildAssociationRef packageAssoc = this.nodeService.createNode(packages, ContentModel.ASSOC_CONTAINS, packageName, WorkflowModel.TYPE_PACKAGE);
            NodeRef packageContainer = packageAssoc.getChildRef();
            this.permissionService.setPermission(packageContainer, "GROUP_EVERYONE", "All", true);
            NodeRef nodeRef = packageContainer;
            return nodeRef;
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(packages, ContentModel.ASPECT_AUDITABLE);
        }
    }

    private NodeRef findOrCreatePackagesFolder() {
        NodeRef system = this.getSystemWorkflowContainer();
        List packageFolders = this.searchService.selectNodes(system, "./cm:packages", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (packageFolders.size() > 0) {
            return (NodeRef)packageFolders.get(0);
        }
        QName packageFolderName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)PACKAGE_FOLDER);
        ChildAssociationRef packageFolderAssoc = this.nodeService.createNode(system, ContentModel.ASSOC_CHILDREN, packageFolderName, ContentModel.TYPE_SYSTEM_FOLDER);
        return packageFolderAssoc.getChildRef();
    }

    @Override
    @Extend(traitAPI=WorkflowPackageTrait.class, extensionAPI=WorkflowPackageExtension.class)
    public void deletePackage(NodeRef container) {
        NodeRef nodeRef = container;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)nodeRef);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new WorkflowPackageImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = WorkflowPackageImpl.class.getDeclaredMethod("deletePackage", NodeRef.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=WorkflowPackageTrait.class, extensionAPI=WorkflowPackageExtension.class)
    public List<String> getWorkflowIdsForContent(NodeRef packageItem) {
        NodeRef nodeRef = packageItem;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)nodeRef);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new WorkflowPackageImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = WorkflowPackageImpl.class.getDeclaredMethod("getWorkflowIdsForContent", NodeRef.class).getAnnotation(Extend.class);
        }
        return (List)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private NodeRef getSystemWorkflowContainer() {
        if (this.tenantService.isEnabled()) {
            NodeRef systemContainer = this.findSystemContainer();
            NodeRef tenantSystemWorkflowContainer = this.findSystemWorkflowContainer(systemContainer);
            if (tenantSystemWorkflowContainer == null) {
                throw new WorkflowException("Unable to find system workflow folder - does not exist.");
            }
            return tenantSystemWorkflowContainer;
        }
        if (this.systemWorkflowContainer == null) {
            NodeRef systemContainer = this.findSystemContainer();
            this.systemWorkflowContainer = this.findSystemWorkflowContainer(systemContainer);
            if (this.systemWorkflowContainer == null) {
                throw new WorkflowException("Unable to find system workflow folder - does not exist.");
            }
        }
        return this.systemWorkflowContainer;
    }

    private NodeRef findSystemWorkflowContainer(NodeRef systemContainer) {
        String path = this.bootstrap.getConfiguration().getProperty("system.workflow_container.childname");
        if (path == null) {
            throw new WorkflowException("Unable to locate workflow system container - path not specified");
        }
        List nodeRefs = this.searchService.selectNodes(systemContainer, path, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef result = null;
        if (nodeRefs != null && nodeRefs.size() > 0) {
            result = (NodeRef)nodeRefs.get(0);
        }
        if (!this.tenantService.isEnabled()) {
            if (result == null) {
                result = this.systemWorkflowContainer;
            } else {
                this.systemWorkflowContainer = result;
            }
        }
        return result;
    }

    private NodeRef findSystemContainer() {
        String path = this.bootstrap.getConfiguration().getProperty("system.system_container.childname");
        if (path == null) {
            throw new WorkflowException("Unable to locate system container - path not specified");
        }
        NodeRef root = this.nodeService.getRootNode(this.bootstrap.getStoreRef());
        List nodeRefs = this.searchService.selectNodes(root, path, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs == null || nodeRefs.size() == 0) {
            throw new WorkflowException("Unable to locate system container - path not found");
        }
        return (NodeRef)nodeRefs.get(0);
    }

    public NodeRef createSystemWorkflowContainer() {
        NodeRef systemContainer = this.findSystemContainer();
        NodeRef systemWfContainer = this.findSystemWorkflowContainer(systemContainer);
        if (systemWfContainer == null) {
            String name = this.bootstrap.getConfiguration().getProperty("system.workflow_container.childname");
            QName qname = QName.createQName((String)name, (NamespacePrefixResolver)this.namespaceService);
            ChildAssociationRef childRef = this.nodeService.createNode(systemContainer, ContentModel.ASSOC_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
            systemWfContainer = childRef.getChildRef();
        }
        return systemWfContainer;
    }

    @Override
    @Extend(traitAPI=WorkflowPackageTrait.class, extensionAPI=WorkflowPackageExtension.class)
    public boolean setWorkflowForPackage(WorkflowInstance instance) {
        WorkflowInstance workflowInstance = instance;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)workflowInstance);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, workflowInstance, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new WorkflowPackageImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = WorkflowPackageImpl.class.getDeclaredMethod("setWorkflowForPackage", WorkflowInstance.class).getAnnotation(Extend.class);
        }
        return Conversions.booleanValue((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    @Override
    public <T extends Trait> ExtendedTrait<T> getTrait(Class<? extends T> traitAPI) {
        return this.workflowPackageTrait;
    }

    static {
        WorkflowPackageImpl.ajc$preClinit();
    }

    static final /* synthetic */ NodeRef createPackage_aroundBody0(WorkflowPackageImpl ajc$this, NodeRef container, JoinPoint joinPoint) {
        boolean isSystemPackage = false;
        if (container == null) {
            container = ajc$this.makePackageContainer();
            isSystemPackage = true;
        }
        if (ajc$this.nodeService.hasAspect(container, WorkflowModel.ASPECT_WORKFLOW_PACKAGE)) {
            String msg = "Container '" + container + "' is already a workflow package.";
            throw new WorkflowException(msg);
        }
        ajc$this.nodeService.addAspect(container, WorkflowModel.ASPECT_WORKFLOW_PACKAGE, null);
        ajc$this.nodeService.setProperty(container, WorkflowModel.PROP_IS_SYSTEM_PACKAGE, (Serializable)Boolean.valueOf(isSystemPackage));
        return container;
    }

    static final /* synthetic */ void deletePackage_aroundBody2(WorkflowPackageImpl ajc$this, NodeRef container, JoinPoint joinPoint) {
        if (container != null && ajc$this.nodeService.exists(container) && ajc$this.nodeService.hasAspect(container, WorkflowModel.ASPECT_WORKFLOW_PACKAGE)) {
            Boolean isSystemPackage = (Boolean)ajc$this.nodeService.getProperty(container, WorkflowModel.PROP_IS_SYSTEM_PACKAGE);
            if (isSystemPackage != null && isSystemPackage.booleanValue()) {
                ajc$this.nodeService.deleteNode(container);
            } else {
                ajc$this.nodeService.removeAspect(container, WorkflowModel.ASPECT_WORKFLOW_PACKAGE);
            }
        }
    }

    static final /* synthetic */ List getWorkflowIdsForContent_aroundBody4(WorkflowPackageImpl ajc$this, NodeRef packageItem, JoinPoint joinPoint) {
        ParameterCheck.mandatory((String)"packageItem", (Object)packageItem);
        ArrayList<String> workflowIds = new ArrayList<String>();
        if (ajc$this.nodeService.exists(packageItem)) {
            List parentAssocs = ajc$this.nodeService.getParentAssocs(packageItem);
            for (ChildAssociationRef parentAssoc : parentAssocs) {
                String workflowInstance;
                NodeRef parentRef = parentAssoc.getParentRef();
                if (!ajc$this.nodeService.hasAspect(parentRef, WorkflowModel.ASPECT_WORKFLOW_PACKAGE) || ajc$this.nodeService.hasAspect(parentRef, ContentModel.ASPECT_ARCHIVED) || (workflowInstance = (String)((Object)ajc$this.nodeService.getProperty(parentRef, WorkflowModel.PROP_WORKFLOW_INSTANCE_ID))) == null || workflowInstance.length() <= 0) continue;
                workflowIds.add(workflowInstance);
            }
        }
        return workflowIds;
    }

    static final /* synthetic */ boolean setWorkflowForPackage_aroundBody6(WorkflowPackageImpl ajc$this, WorkflowInstance instance, JoinPoint joinPoint) {
        NodeRef packageNode = instance.getWorkflowPackage();
        if (packageNode == null) {
            return false;
        }
        Serializable pckgInstanceId = ajc$this.nodeService.getProperty(packageNode, WorkflowModel.PROP_WORKFLOW_INSTANCE_ID);
        if (pckgInstanceId != null) {
            if (pckgInstanceId.equals(instance.getId())) {
                return false;
            }
            String msg = ajc$this.messageService.getMessage(ERR_PACKAGE_ALREADY_ASSOCIATED, new Object[]{packageNode, instance.getId(), pckgInstanceId});
            throw new WorkflowException(msg);
        }
        if (!ajc$this.nodeService.hasAspect(packageNode, WorkflowModel.ASPECT_WORKFLOW_PACKAGE)) {
            ajc$this.createPackage(packageNode);
        }
        String definitionId = instance.getDefinition().getId();
        String definitionName = instance.getDefinition().getName();
        String instanceId = instance.getId();
        ajc$this.nodeService.setProperty(packageNode, WorkflowModel.PROP_WORKFLOW_DEFINITION_ID, (Serializable)((Object)definitionId));
        ajc$this.nodeService.setProperty(packageNode, WorkflowModel.PROP_WORKFLOW_DEFINITION_NAME, (Serializable)((Object)definitionName));
        ajc$this.nodeService.setProperty(packageNode, WorkflowModel.PROP_WORKFLOW_INSTANCE_ID, (Serializable)((Object)instanceId));
        return true;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkflowPackageImpl.java", WorkflowPackageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createPackage", "org.alfresco.repo.workflow.WorkflowPackageImpl", "org.alfresco.service.cmr.repository.NodeRef", "container", "", "org.alfresco.service.cmr.repository.NodeRef"), 151);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePackage", "org.alfresco.repo.workflow.WorkflowPackageImpl", "org.alfresco.service.cmr.repository.NodeRef", "container", "", "void"), 229);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkflowIdsForContent", "org.alfresco.repo.workflow.WorkflowPackageImpl", "org.alfresco.service.cmr.repository.NodeRef", "packageItem", "", "java.util.List"), 251);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWorkflowForPackage", "org.alfresco.repo.workflow.WorkflowPackageImpl", "org.alfresco.service.cmr.workflow.WorkflowInstance", "instance", "", "boolean"), 380);
    }
}

