/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.repo.processor.BaseProcessor;
import org.alfresco.repo.template.ClassPathRepoTemplateLoader;
import org.alfresco.repo.template.TemplateProcessorMethod;
import org.alfresco.repo.template.TemplateSource;
import org.alfresco.repo.template.XSLTProcessorMethodInvoker;
import org.alfresco.repo.template.XSLTemplateModel;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateProcessor;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.XMLUtil;
import org.apache.bsf.BSFManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XSLTProcessor
extends BaseProcessor
implements TemplateProcessor {
    private static final Log log = LogFactory.getLog(XSLTProcessor.class);
    private static final String LOCALE_SEPARATOR = "_";
    private static final String MSG_ERROR_NO_TEMPLATE = "error_no_template";
    private static final String MSG_UNABLE_TO_READ_TEMPLATE = "template.xslt.read_error";
    private static final String MSG_UNABLE_TO_PARSE_TEMPLATE = "template.xslt.parse_error";
    public static final QName ROOT_NAMESPACE = QName.createQName(null, (String)"root_namespace");
    private String defaultEncoding = "UTF-8";
    private TemplateLoader templateLoader;

    @Override
    public void register() {
        super.register();
        this.templateLoader = new ClassPathRepoTemplateLoader(this.services.getNodeService(), this.services.getContentService(), this.defaultEncoding);
    }

    @Override
    public void process(String template, Object model, Writer out) {
        TemplateSource templateSource;
        try {
            templateSource = (TemplateSource)this.templateLoader.findTemplateSource(template);
        }
        catch (IOException ex) {
            throw new TemplateException(MSG_UNABLE_TO_READ_TEMPLATE, new Object[]{ex.getMessage()}, ex);
        }
        this.process(templateSource, model, out);
    }

    @Override
    public void processString(final String template, Object model, Writer out) {
        TemplateSource stringTemplateSource = new TemplateSource(){

            @Override
            public long lastModified() {
                return System.currentTimeMillis();
            }

            @Override
            public InputStream getResource(String name) {
                return null;
            }

            @Override
            public Reader getReader(String encoding) throws IOException {
                return new StringReader(template);
            }

            @Override
            public void close() throws IOException {
            }
        };
        this.process(stringTemplateSource, model, out);
    }

    private void process(TemplateSource templateSource, Object model, Writer out) {
        Document xslTemplate;
        if (model == null || !XSLTemplateModel.class.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("\"model\" must be an XSLTemplateModel object: " + model);
        }
        XSLTemplateModel xsltModel = (XSLTemplateModel)model;
        System.setProperty("org.apache.xalan.extensions.bsf.BSFManager", BSFManager.class.getName());
        try {
            try {
                xslTemplate = XMLUtil.parse(templateSource.getReader(this.defaultEncoding));
            }
            catch (IOException ex) {
                throw new TemplateException(MSG_UNABLE_TO_READ_TEMPLATE, new Object[]{ex.getMessage()}, ex);
            }
            catch (SAXException sax) {
                throw new TemplateException(MSG_UNABLE_TO_PARSE_TEMPLATE, new Object[]{sax.getMessage()}, sax);
            }
        }
        finally {
            try {
                templateSource.close();
            }
            catch (IOException ex) {
                log.warn((Object)"Error while trying to close template stream", (Throwable)ex);
            }
        }
        List<String> scriptIds = this.addScripts(xsltModel, xslTemplate);
        this.addParameters(xsltModel, xslTemplate);
        final LinkedList errors = new LinkedList();
        ErrorListener errorListener = new ErrorListener(){

            @Override
            public void error(TransformerException te) throws TransformerException {
                log.debug((Object)("error " + te.getMessageAndLocation()));
                errors.add(te);
            }

            @Override
            public void fatalError(TransformerException te) throws TransformerException {
                log.debug((Object)("fatalError " + te.getMessageAndLocation()));
                throw te;
            }

            @Override
            public void warning(TransformerException te) throws TransformerException {
                log.debug((Object)("warning " + te.getMessageAndLocation()));
                errors.add(te);
            }
        };
        final TemplateSource resourceSource = templateSource;
        URIResolver uriResolver = new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("request to resolve href " + href + " using base " + base));
                }
                InputStream in = null;
                try {
                    in = resourceSource.getResource(href);
                    if (in == null) {
                        throw new TransformerException("unable to resolve href " + href);
                    }
                    Document d = XMLUtil.parse(in);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("loaded " + XMLUtil.toString(d)));
                    }
                    return new DOMSource(d);
                }
                catch (TransformerException ex) {
                    throw ex;
                }
                catch (Exception e) {
                    throw new TransformerException("unable to load " + href, e);
                }
            }
        };
        Source xmlSource = this.getXMLSource(xsltModel);
        Transformer t = null;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setErrorListener(errorListener);
            tf.setURIResolver(uriResolver);
            if (log.isDebugEnabled()) {
                log.debug((Object)("xslTemplate: \n" + XMLUtil.toString(xslTemplate)));
            }
            t = tf.newTransformer(new DOMSource(xslTemplate));
            if (errors.size() != 0) {
                StringBuilder msg = new StringBuilder("errors encountered creating tranformer ... \n");
                for (TransformerException te : errors) {
                    msg.append(te.getMessageAndLocation()).append("\n");
                }
                throw new TemplateException(msg.toString());
            }
            t.setErrorListener(errorListener);
            t.setURIResolver(uriResolver);
            t.setParameter("versionParam", "2.0");
        }
        catch (TransformerConfigurationException tce) {
            log.error((Object)tce);
            throw new TemplateException(tce.getMessage(), tce);
        }
        try {
            try {
                t.transform(xmlSource, new StreamResult(out));
            }
            catch (TransformerException te) {
                log.error((Object)te.getMessageAndLocation());
                throw new TemplateException(te.getMessageAndLocation(), te);
            }
            catch (Exception e) {
                log.error((Object)("unexpected error " + e));
                throw new TemplateException(e.getMessage(), e);
            }
        }
        finally {
            if (!scriptIds.isEmpty()) {
                XSLTProcessorMethodInvoker.removeMethods(scriptIds);
            }
        }
        if (errors.size() != 0) {
            StringBuilder msg = new StringBuilder("errors encountered during transformation ... \n");
            for (TransformerException te : errors) {
                msg.append(te.getMessageAndLocation()).append("\n");
            }
            throw new TemplateException(msg.toString());
        }
    }

    protected List<String> addScripts(XSLTemplateModel xsltModel, Document xslTemplate) {
        HashMap methods = new HashMap();
        for (Map.Entry<QName, Object> entry : xsltModel.entrySet()) {
            if (!(entry.getValue() instanceof TemplateProcessorMethod)) continue;
            String prefix = QName.splitPrefixedQName((String)entry.getKey().toPrefixString())[0];
            QName qn = QName.createQName((String)entry.getKey().getNamespaceURI(), (String)prefix);
            if (!methods.containsKey(qn)) {
                methods.put(qn, new LinkedList());
            }
            ((List)methods.get(qn)).add(entry);
        }
        Element docEl = xslTemplate.getDocumentElement();
        docEl.setAttribute("xmlns:xalan", "http://xml.apache.org/xalan");
        HashSet<String> excludePrefixes = new HashSet<String>();
        if (docEl.hasAttribute("exclude-result-prefixes")) {
            excludePrefixes.addAll(Arrays.asList(docEl.getAttribute("exclude-result-prefixes").split(" ")));
        }
        excludePrefixes.add("xalan");
        LinkedList<String> result = new LinkedList<String>();
        for (QName ns : methods.keySet()) {
            String prefix = ns.getLocalName();
            docEl.setAttribute("xmlns:" + prefix, ns.getNamespaceURI());
            excludePrefixes.add(prefix);
            Element compEl = xslTemplate.createElementNS("http://xml.apache.org/xalan", "xalan:component");
            compEl.setAttribute("prefix", prefix);
            docEl.appendChild(compEl);
            String functionNames = null;
            Element scriptEl = xslTemplate.createElementNS("http://xml.apache.org/xalan", "xalan:script");
            scriptEl.setAttribute("lang", "javascript");
            StringBuilder js = new StringBuilder("var _xsltp_invoke = java.lang.Class.forName('" + XSLTProcessorMethodInvoker.class.getName() + "').newInstance();\n" + "function _xsltp_to_java_array(js_array) {\n" + "var java_array = java.lang.reflect.Array.newInstance(java.lang.Object, js_array.length);\n" + "for (var i = 0; i < js_array.length; i++) { java_array[i] = js_array[i]; }\n" + "return java_array; }\n");
            for (Map.Entry entry : (List)methods.get(ns)) {
                functionNames = functionNames == null ? ((QName)entry.getKey()).getLocalName() : String.valueOf(functionNames) + " " + ((QName)entry.getKey()).getLocalName();
                String id = String.valueOf(((QName)entry.getKey()).getLocalName()) + entry.getValue().hashCode();
                js.append("function " + ((QName)entry.getKey()).getLocalName() + "() { return _xsltp_invoke.invokeMethod('" + id + "', _xsltp_to_java_array(arguments)); }\n");
                XSLTProcessorMethodInvoker.addMethod(id, (TemplateProcessorMethod)entry.getValue());
                result.add(id);
            }
            log.debug((Object)("generated JavaScript bindings:\n" + js));
            scriptEl.appendChild(xslTemplate.createTextNode(js.toString()));
            compEl.setAttribute("functions", functionNames);
            compEl.appendChild(scriptEl);
        }
        docEl.setAttribute("exclude-result-prefixes", StringUtils.join((Object[])excludePrefixes.toArray(new String[excludePrefixes.size()]), (String)" "));
        return result;
    }

    protected void addParameters(XSLTemplateModel xsltModel, Document xslTemplate) {
        Element docEl = xslTemplate.getDocumentElement();
        String XSL_NS = docEl.getNamespaceURI();
        String XSL_NS_PREFIX = docEl.getPrefix();
        for (Map.Entry<QName, Object> e : xsltModel.entrySet()) {
            if (ROOT_NAMESPACE.equals((Object)e.getKey())) continue;
            Element el = xslTemplate.createElementNS(XSL_NS, String.valueOf(XSL_NS_PREFIX) + ":variable");
            el.setAttribute("name", e.getKey().toPrefixString());
            Object o = e.getValue();
            if (!(o instanceof String) && !(o instanceof Number) && !(o instanceof Boolean)) continue;
            el.appendChild(xslTemplate.createTextNode(o.toString()));
            docEl.insertBefore(el, null);
        }
    }

    protected Source getXMLSource(Map<QName, Object> model) {
        if (!model.containsKey(ROOT_NAMESPACE)) {
            return null;
        }
        Object o = model.get(ROOT_NAMESPACE);
        if (!(o instanceof Document)) {
            throw new IllegalArgumentException("expected root namespace object to be a  " + Document.class.getName() + ".  found a " + o.getClass().getName());
        }
        return new DOMSource((Document)o);
    }

    @Override
    public void process(String template, Object model, Writer out, Locale locale) {
        if (template.indexOf("://") != -1) {
            this.process(template, model, out);
        } else {
            TemplateSource templateSource = null;
            int lastDot = template.lastIndexOf(46);
            String prefix = lastDot == -1 ? template : template.substring(0, lastDot);
            String suffix = lastDot == -1 ? "" : template.substring(lastDot);
            String localeName = LOCALE_SEPARATOR + locale.toString();
            StringBuffer buf = new StringBuffer(template.length() + localeName.length());
            buf.append(prefix);
            while (true) {
                int lastUnderscore;
                buf.setLength(prefix.length());
                String path = buf.append(localeName).append(suffix).toString();
                try {
                    templateSource = (TemplateSource)this.templateLoader.findTemplateSource(path);
                }
                catch (IOException ex) {
                    throw new TemplateException(MSG_UNABLE_TO_READ_TEMPLATE, new Object[]{ex.getMessage()}, ex);
                }
                if (templateSource != null || (lastUnderscore = localeName.lastIndexOf(95)) == -1) break;
                localeName = localeName.substring(0, lastUnderscore);
            }
            if (templateSource == null) {
                throw new TemplateException(MSG_ERROR_NO_TEMPLATE, new Object[]{template});
            }
            this.process(templateSource, model, out);
        }
    }
}

