/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import javax.servlet.http.HttpServletRequest;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.security.authentication.identityservice.AlfrescoBearerTokenRequestAuthenticator;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceHttpFacade;
import org.alfresco.service.cmr.security.PersonService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.representations.AccessToken;

public class IdentityServiceRemoteUserMapper
implements RemoteUserMapper,
ActivateableBean {
    private static Log logger = LogFactory.getLog(IdentityServiceRemoteUserMapper.class);
    private boolean isEnabled;
    private boolean isValidationFailureSilent;
    private PersonService personService;
    private KeycloakDeployment keycloakDeployment;

    public void setActive(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setValidationFailureSilent(boolean silent) {
        this.isValidationFailureSilent = silent;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setIdentityServiceDeployment(KeycloakDeployment deployment) {
        this.keycloakDeployment = deployment;
    }

    @Override
    public String getRemoteUser(HttpServletRequest request) {
        block8: {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Retrieving username from http request...");
            }
            if (this.isEnabled) break block8;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"IdentityServiceRemoteUserMapper is disabled, returning null.");
            }
            return null;
        }
        try {
            String headerUserId = this.extractUserFromHeader(request);
            if (headerUserId != null) {
                String normalizedUserId = this.normalizeUserId(headerUserId);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Returning userId: " + AuthenticationUtil.maskUsername((String)normalizedUserId)));
                }
                return normalizedUserId;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to authenticate user using IdentityServiceRemoteUserMapper: " + e.getMessage()), (Throwable)e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Could not identify a userId. Returning null.");
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return this.isEnabled;
    }

    private String extractUserFromHeader(HttpServletRequest request) {
        String userName = null;
        IdentityServiceHttpFacade facade = new IdentityServiceHttpFacade(request);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Trying bearer token...");
        }
        AlfrescoBearerTokenRequestAuthenticator tokenAuthenticator = new AlfrescoBearerTokenRequestAuthenticator(this.keycloakDeployment);
        AuthOutcome tokenOutcome = tokenAuthenticator.authenticate((HttpFacade)facade);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bearer token outcome: " + tokenOutcome));
        }
        if (tokenOutcome == AuthOutcome.FAILED && !this.isValidationFailureSilent) {
            throw new AuthenticationException("Token validation failed: " + tokenAuthenticator.getValidationFailureDescription());
        }
        if (tokenOutcome == AuthOutcome.AUTHENTICATED) {
            userName = this.extractUserFromToken(tokenAuthenticator.getToken());
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"User could not be authenticated by IdentityServiceRemoteUserMapper.");
        }
        return userName;
    }

    private String extractUserFromToken(AccessToken jwt) {
        String userName = jwt.getPreferredUsername();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Extracted username: " + AuthenticationUtil.maskUsername((String)userName)));
        }
        return userName;
    }

    private String normalizeUserId(final String userId) {
        if (userId == null) {
            return null;
        }
        String normalized = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return IdentityServiceRemoteUserMapper.this.personService.getUserIdentifier(userId);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Normalized user name for '" + AuthenticationUtil.maskUsername((String)userId) + "': " + AuthenticationUtil.maskUsername((String)normalized)));
        }
        return normalized == null ? userId : normalized;
    }
}

