/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.springframework.beans.factory.InitializingBean;

public class IdentityServiceConfig
extends AdapterConfig
implements InitializingBean {
    private static Log logger = LogFactory.getLog(IdentityServiceConfig.class);
    private static final String CREDENTIALS_SECRET = "identity-service.credentials.secret";
    private static final String CREDENTIALS_PROVIDER = "identity-service.credentials.provider";
    private Properties globalProperties;
    private int clientConnectionTimeout;
    private int clientSocketTimeout;

    public void setGlobalProperties(Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    public int getClientConnectionTimeout() {
        return this.clientConnectionTimeout;
    }

    public void setClientConnectionTimeout(int clientConnectionTimeout) {
        this.clientConnectionTimeout = clientConnectionTimeout;
    }

    public int getClientSocketTimeout() {
        return this.clientSocketTimeout;
    }

    public void setClientSocketTimeout(int clientSocketTimeout) {
        this.clientSocketTimeout = clientSocketTimeout;
    }

    public void afterPropertiesSet() throws Exception {
        String provider;
        TreeMap<String, String> credentials = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String secret = this.globalProperties.getProperty(CREDENTIALS_SECRET);
        if (secret != null && !secret.isEmpty()) {
            credentials.put("secret", secret);
        }
        if ((provider = this.globalProperties.getProperty(CREDENTIALS_PROVIDER)) != null && !provider.isEmpty()) {
            credentials.put("provider", provider);
        }
        if (!credentials.isEmpty()) {
            this.setCredentials(credentials);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created credentials map from config: " + credentials));
            }
        }
    }
}

