/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.Map;
import org.alfresco.transform.client.model.config.CoreFunction;
import org.alfresco.transform.client.registry.TransformServiceRegistry;

public class SwitchingTransformServiceRegistry
implements TransformServiceRegistry {
    private final TransformServiceRegistry primary;
    private final TransformServiceRegistry secondary;

    public SwitchingTransformServiceRegistry(TransformServiceRegistry primary, TransformServiceRegistry secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    public long findMaxSize(String sourceMimetype, String targetMimetype, Map<String, String> options, String renditionName) {
        long maxSize;
        long primaryMaxSize = this.primary.findMaxSize(sourceMimetype, targetMimetype, options, renditionName);
        if (primaryMaxSize == -1L) {
            maxSize = -1L;
        } else {
            long secondaryMaxSize = this.secondary.findMaxSize(sourceMimetype, targetMimetype, options, renditionName);
            maxSize = primaryMaxSize == 0L ? secondaryMaxSize : (secondaryMaxSize == 0L ? primaryMaxSize : (secondaryMaxSize == -1L ? Long.valueOf(-1L) : Long.valueOf(Math.max(primaryMaxSize, secondaryMaxSize))));
        }
        return maxSize;
    }

    public String findTransformerName(String sourceMimetype, long sourceSizeInBytes, String targetMimetype, Map<String, String> actualOptions, String renditionName) {
        String name = this.primary.findTransformerName(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, renditionName);
        if (name == null) {
            name = this.secondary.findTransformerName(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, renditionName);
        }
        return name;
    }

    public boolean isSupported(CoreFunction function, String transformerName) {
        return this.primary.isSupported(function, transformerName) && this.secondary.isSupported(function, transformerName);
    }
}

