/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinition2Impl;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2;
import org.alfresco.transform.client.registry.TransformServiceRegistry;
import org.alfresco.util.ConfigFileFinder;
import org.alfresco.util.ConfigScheduler;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.ShutdownIndicator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronExpression;
import org.springframework.beans.factory.InitializingBean;

public class RenditionDefinitionRegistry2Impl
implements RenditionDefinitionRegistry2,
InitializingBean {
    private static final Log log = LogFactory.getLog(RenditionDefinitionRegistry2Impl.class);
    private TransformServiceRegistry transformServiceRegistry;
    private String renditionConfigDir;
    private String timeoutDefault;
    private ObjectMapper jsonObjectMapper;
    private CronExpression cronExpression;
    private CronExpression initialAndOnErrorCronExpression;
    private boolean firstTime = true;
    private ConfigScheduler<Data> configScheduler = new ConfigScheduler(this){

        public boolean readConfig() throws IOException {
            if (RenditionDefinitionRegistry2Impl.this.configFileFinder != null) {
                RenditionDefinitionRegistry2Impl.this.configFileFinder.setFileCount(0);
            }
            return RenditionDefinitionRegistry2Impl.this.readConfig();
        }

        public Object createData() {
            return RenditionDefinitionRegistry2Impl.this.createData();
        }
    };
    private ConfigFileFinder configFileFinder;

    void reloadRegistry() {
        this.configScheduler.readConfigAndReplace(false);
    }

    public void setTransformServiceRegistry(TransformServiceRegistry transformServiceRegistry) {
        this.transformServiceRegistry = transformServiceRegistry;
    }

    public void setRenditionConfigDir(String renditionConfigDir) {
        this.renditionConfigDir = renditionConfigDir;
    }

    public void setTimeoutDefault(String timeoutDefault) {
        this.timeoutDefault = timeoutDefault;
    }

    public void setJsonObjectMapper(ObjectMapper jsonObjectMapper) {
        this.jsonObjectMapper = jsonObjectMapper;
    }

    public CronExpression getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(CronExpression cronExpression) {
        this.cronExpression = cronExpression;
    }

    public CronExpression getInitialAndOnErrorCronExpression() {
        return this.initialAndOnErrorCronExpression;
    }

    public void setInitialAndOnErrorCronExpression(CronExpression initialAndOnErrorCronExpression) {
        this.initialAndOnErrorCronExpression = initialAndOnErrorCronExpression;
    }

    public void setShutdownIndicator(ShutdownIndicator shutdownIndicator) {
        this.configScheduler.setShutdownIndicator(shutdownIndicator);
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"transformServiceRegistry", (Object)this.transformServiceRegistry);
        PropertyCheck.mandatory((Object)this, (String)"timeoutDefault", (Object)this.timeoutDefault);
        PropertyCheck.mandatory((Object)this, (String)"jsonObjectMapper", (Object)this.jsonObjectMapper);
        if (this.cronExpression != null) {
            PropertyCheck.mandatory((Object)this, (String)"initialAndOnErrorCronExpression", (Object)this.initialAndOnErrorCronExpression);
        }
        this.configFileFinder = new ConfigFileFinder(this.jsonObjectMapper){

            protected void readJson(JsonNode jsonNode, String readFromMessage, String baseUrl) throws IOException {
                try {
                    JsonNode renditions = jsonNode.get("renditions");
                    if (renditions != null && renditions.isArray()) {
                        for (JsonNode rendition : renditions) {
                            RenditionDef def = (RenditionDef)RenditionDefinitionRegistry2Impl.this.jsonObjectMapper.convertValue((Object)rendition, RenditionDef.class);
                            HashMap<String, String> map = new HashMap<String, String>();
                            if (def.options != null) {
                                def.options.forEach(o -> {
                                    String string = map.put(((RenditionOpt)o).name, ((RenditionOpt)o).value);
                                });
                            }
                            if (!map.containsKey("timeout")) {
                                map.put("timeout", RenditionDefinitionRegistry2Impl.this.timeoutDefault);
                            }
                            RenditionDefinition2 original = RenditionDefinitionRegistry2Impl.this.getRenditionDefinition(def.renditionName);
                            new RenditionDefinition2Impl(def.renditionName, def.targetMediaType, map, true, RenditionDefinitionRegistry2Impl.this);
                            if (original == null) continue;
                            log.debug((Object)(String.valueOf(readFromMessage) + " replaced the rendition " + def.renditionName));
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Error reading " + readFromMessage + " " + e.getMessage()));
                }
            }
        };
        this.configScheduler.run(true, log, this.cronExpression, this.initialAndOnErrorCronExpression);
    }

    public Data createData() {
        Data currentData = null;
        if (this.firstTime) {
            this.firstTime = false;
        } else {
            currentData = this.getData();
        }
        return new Data(currentData);
    }

    public Data getData() {
        return (Data)this.configScheduler.getData();
    }

    public boolean readConfig() {
        boolean successReadingConfig = this.configFileFinder.readFiles("alfresco/renditions", log);
        if (this.renditionConfigDir != null && !this.renditionConfigDir.isBlank()) {
            successReadingConfig &= this.configFileFinder.readFiles(this.renditionConfigDir, log);
        }
        return successReadingConfig;
    }

    public boolean isEnabled() {
        return true;
    }

    public RenditionDefinition2 getDefinition(String renditionName) {
        return this.getRenditionDefinition(renditionName);
    }

    public void register(RenditionDefinition2 renditionDefinition) {
        String renditionName = renditionDefinition.getRenditionName();
        Data data = this.getData();
        data.renditionDefinitions.put(renditionName, renditionDefinition);
        if (renditionDefinition instanceof RenditionDefinition2Impl && !((RenditionDefinition2Impl)renditionDefinition).isDynamicallyLoaded()) {
            log.debug((Object)("Adding static rendition " + renditionName + " into the registry"));
            Data data2 = data;
            data2.staticCount = data2.staticCount + 1;
        }
        data.setFileCount(this.configFileFinder == null ? 0 : this.configFileFinder.getFileCount());
    }

    public void unregister(String renditionName) {
        Data data = this.getData();
        if (data.renditionDefinitions.remove(renditionName) == null) {
            throw new IllegalArgumentException("RenditionDefinition " + renditionName + " was not registered.");
        }
    }

    @Override
    public Set<String> getRenditionNames() {
        return this.getData().renditionDefinitions.keySet().stream().filter(name -> !name.startsWith("transform:")).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getRenditionNamesFrom(String sourceMimetype, long size) {
        Set<Pair<String, Long>> renditionNamesWithMaxSize;
        Data data = this.getData();
        Map<String, Set<Pair<String, Long>>> map = data.renditionsFor;
        synchronized (map) {
            renditionNamesWithMaxSize = data.renditionsFor.get(sourceMimetype);
            if (renditionNamesWithMaxSize == null) {
                renditionNamesWithMaxSize = this.getRenditionNamesWithMaxSize(sourceMimetype);
                data.renditionsFor.put(sourceMimetype, renditionNamesWithMaxSize);
            }
        }
        if (renditionNamesWithMaxSize.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> renditionNames = new HashSet<String>();
        for (Pair<String, Long> pair : renditionNamesWithMaxSize) {
            Long maxSize = (Long)pair.getSecond();
            if (maxSize == 0L || maxSize != -1L && maxSize < size) continue;
            String renditionName = (String)pair.getFirst();
            renditionNames.add(renditionName);
        }
        return renditionNames;
    }

    private Set<Pair<String, Long>> getRenditionNamesWithMaxSize(String sourceMimetype) {
        HashSet<Pair<String, Long>> renditions = new HashSet<Pair<String, Long>>();
        Data data = this.getData();
        for (Map.Entry<String, RenditionDefinition2> entry : data.renditionDefinitions.entrySet()) {
            Map<String, String> options;
            String targetMimetype;
            Long maxSize;
            RenditionDefinition2 renditionDefinition2 = entry.getValue();
            String renditionName = renditionDefinition2.getRenditionName();
            if (renditionName.startsWith("transform:") || (maxSize = Long.valueOf(this.transformServiceRegistry.findMaxSize(sourceMimetype, targetMimetype = renditionDefinition2.getTargetMimetype(), options = renditionDefinition2.getTransformOptions(), renditionName))) == null) continue;
            String renditionNameMaxSizePair = entry.getKey();
            Pair pair = new Pair((Object)renditionNameMaxSizePair, (Object)maxSize);
            renditions.add((Pair<String, Long>)pair);
        }
        return renditions;
    }

    @Override
    public RenditionDefinition2 getRenditionDefinition(String renditionName) {
        Data data = this.getData();
        return data.renditionDefinitions.get(renditionName);
    }

    static class Data {
        Map<String, RenditionDefinition2> renditionDefinitions = new HashMap<String, RenditionDefinition2>();
        Map<String, Set<Pair<String, Long>>> renditionsFor = new HashMap<String, Set<Pair<String, Long>>>();
        private int fileCount;
        private int staticCount;

        public Data(Data currentData) {
            if (currentData != null) {
                currentData.renditionDefinitions.forEach((renditionName, renditionDefinition) -> {
                    if (renditionDefinition instanceof RenditionDefinition2Impl && !((RenditionDefinition2Impl)renditionDefinition).isDynamicallyLoaded()) {
                        log.debug((Object)("Adding static rendition " + renditionName + " back into the registry"));
                        this.renditionDefinitions.put((String)renditionName, (RenditionDefinition2)renditionDefinition);
                        ++this.staticCount;
                    }
                });
            }
        }

        public String toString() {
            int renditionCount = this.renditionDefinitions.size();
            return "(renditions: " + renditionCount + " files: " + this.fileCount + " static: " + this.staticCount + ")";
        }

        public void setFileCount(int fileCount) {
            this.fileCount = fileCount;
        }
    }

    static class RenditionDef {
        private String renditionName;
        private String targetMediaType;
        private Set<RenditionOpt> options;

        RenditionDef() {
        }

        public void setRenditionName(String renditionName) {
            this.renditionName = renditionName;
        }

        public void setTargetMediaType(String targetMediaType) {
            this.targetMediaType = targetMediaType;
        }

        public void setOptions(Set<RenditionOpt> options) {
            this.options = options;
        }
    }

    static class RenditionOpt {
        private String name;
        private String value;

        RenditionOpt() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

