/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.exporter.NodeContentData;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.ExporterException;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ACPExportPackageHandler
implements ExportPackageHandler {
    public static final String ACP_EXTENSION = "acp";
    protected MimetypeService mimetypeService;
    protected NodeService nodeService;
    protected OutputStream outputStream;
    protected File dataFile;
    protected File contentDir;
    protected File tempDataFile;
    protected OutputStream tempDataFileStream;
    protected ZipArchiveOutputStream zipStream;
    protected int iFileCnt = 0;
    protected boolean exportAsFolders;

    public ACPExportPackageHandler(File destDir, File zipFile, File dataFile, File contentDir, boolean overwrite, MimetypeService mimetypeService) {
        try {
            String zipFilePath = zipFile.getPath();
            if (!zipFilePath.endsWith(".acp")) {
                zipFilePath = String.valueOf(zipFilePath) + (zipFilePath.charAt(zipFilePath.length() - 1) == '.' ? ACP_EXTENSION : ".acp");
            }
            File absZipFile = new File(destDir, zipFilePath);
            this.log("Exporting to package zip file " + absZipFile.getAbsolutePath());
            if (absZipFile.exists()) {
                if (!overwrite) {
                    throw new ExporterException("Package zip file " + absZipFile.getAbsolutePath() + " already exists.");
                }
                this.log("Warning: Overwriting existing package zip file " + absZipFile.getAbsolutePath());
            }
            this.outputStream = new FileOutputStream(absZipFile);
            this.dataFile = dataFile;
            this.contentDir = contentDir;
            this.mimetypeService = mimetypeService;
        }
        catch (FileNotFoundException e) {
            throw new ExporterException("Failed to create zip file", e);
        }
    }

    public ACPExportPackageHandler(OutputStream outputStream, File dataFile, File contentDir, MimetypeService mimetypeService) {
        this.outputStream = outputStream;
        this.dataFile = dataFile;
        this.contentDir = contentDir;
        this.mimetypeService = mimetypeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setExportAsFolders(boolean exportAsFolders) {
        this.exportAsFolders = exportAsFolders;
    }

    @Override
    public void startExport() {
        this.zipStream = new ZipArchiveOutputStream(this.outputStream);
        this.zipStream.setEncoding("UTF-8");
        this.zipStream.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
        this.zipStream.setUseLanguageEncodingFlag(true);
        this.zipStream.setFallbackToUTF8(true);
        this.zipStream.setUseZip64(Zip64Mode.Always);
    }

    @Override
    public OutputStream createDataStream() {
        this.tempDataFile = TempFileProvider.createTempFile((String)"exportDataStream", (String)".xml");
        try {
            this.tempDataFileStream = new FileOutputStream(this.tempDataFile);
            return this.tempDataFileStream;
        }
        catch (FileNotFoundException e) {
            throw new ExporterException("Failed to create data file stream", e);
        }
    }

    @Override
    public ContentData exportContent(InputStream content, ContentData contentData) {
        File file;
        if (content == null) {
            return contentData;
        }
        String contentDirPath = this.contentDir.getPath();
        if (contentDirPath.charAt(contentDirPath.length() - 1) != '.' && contentDirPath.lastIndexOf(46) != -1) {
            contentDirPath = contentDirPath.substring(0, contentDirPath.lastIndexOf("."));
        }
        if (this.exportAsFolders && this.nodeService != null && contentData instanceof NodeContentData) {
            NodeContentData nodeContentData = (NodeContentData)contentData;
            file = new File(String.valueOf(contentDirPath) + this.toDisplayPath(this.nodeService.getPath(nodeContentData.getNodeRef())));
        } else {
            String mimetype;
            String extension = "bin";
            if (this.mimetypeService != null && (mimetype = contentData.getMimetype()) != null && mimetype.length() > 0) {
                try {
                    extension = this.mimetypeService.getExtension(mimetype);
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
            }
            file = new File(contentDirPath, "content" + this.iFileCnt++ + "." + extension);
        }
        try {
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(file.getPath());
            this.zipStream.putArchiveEntry((ArchiveEntry)zipEntry);
            this.copyStream((OutputStream)this.zipStream, content);
        }
        catch (IOException e) {
            throw new ExporterException("Failed to zip export stream", e);
        }
        return new ContentData(file.getPath(), contentData.getMimetype(), contentData.getSize(), contentData.getEncoding());
    }

    @Override
    public void endExport() {
        String dataFilePath = this.dataFile.getPath();
        if (!dataFilePath.endsWith(".xml")) {
            dataFilePath = String.valueOf(dataFilePath) + (dataFilePath.charAt(dataFilePath.length() - 1) == '.' ? "xml" : ".xml");
        }
        ZipArchiveEntry zipEntry = new ZipArchiveEntry(dataFilePath);
        try {
            this.tempDataFileStream.close();
            this.zipStream.putArchiveEntry((ArchiveEntry)zipEntry);
            FileInputStream dataFileStream = new FileInputStream(this.tempDataFile);
            this.copyStream((OutputStream)this.zipStream, dataFileStream);
            this.zipStream.closeArchiveEntry();
            ((InputStream)dataFileStream).close();
        }
        catch (IOException e) {
            throw new ExporterException("Failed to zip data stream file", e);
        }
        try {
            this.zipStream.close();
        }
        catch (IOException e) {
            throw new ExporterException("Failed to close zip package stream", e);
        }
    }

    protected void log(String message) {
    }

    private void copyStream(OutputStream output, InputStream in) throws IOException {
        byte[] buffer = new byte[20480];
        int read = in.read(buffer, 0, 20480);
        while (read != -1) {
            output.write(buffer, 0, read);
            read = in.read(buffer, 0, 20480);
        }
    }

    private String toDisplayPath(Path path) {
        StringBuffer displayPath = new StringBuffer();
        if (path.size() == 1) {
            displayPath.append("/");
        } else {
            int i = 1;
            while (i < path.size()) {
                Path.Element element = path.get(i);
                if (element instanceof Path.ChildAssocElement) {
                    ChildAssociationRef assocRef = ((Path.ChildAssocElement)element).getRef();
                    NodeRef node = assocRef.getChildRef();
                    displayPath.append("/");
                    displayPath.append(this.nodeService.getProperty(node, ContentModel.PROP_NAME));
                }
                ++i;
            }
        }
        return displayPath.toString();
    }
}

