/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.ArrayDeque;
import java.util.Deque;
import org.alfresco.repo.event.v1.model.ChildAssociationResource;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event.v1.model.Resource;
import org.alfresco.repo.event2.ChildAssociationEventSupportedPolicies;
import org.alfresco.repo.event2.EventInfo;
import org.alfresco.repo.event2.EventJSONSchema;
import org.alfresco.repo.event2.NodeResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.namespace.QName;

public class ChildAssociationEventConsolidator
implements ChildAssociationEventSupportedPolicies {
    private final Deque<EventType> eventTypes = new ArrayDeque<EventType>();
    protected final ChildAssociationRef childAssociationRef;
    private ChildAssociationResource resource;
    private final NodeResourceHelper helper;

    public ChildAssociationEventConsolidator(ChildAssociationRef childAssociationRef, NodeResourceHelper helper) {
        this.childAssociationRef = childAssociationRef;
        this.helper = helper;
        this.resource = this.buildChildAssociationResource(this.childAssociationRef);
    }

    public RepoEvent<DataAttributes<ChildAssociationResource>> getRepoEvent(EventInfo eventInfo) {
        EventType eventType = this.getDerivedEvent();
        DataAttributes<ChildAssociationResource> eventData = this.buildEventData(eventInfo, this.resource);
        return RepoEvent.builder().setId(eventInfo.getId()).setSource(eventInfo.getSource()).setTime(eventInfo.getTimestamp()).setType(eventType.getType()).setData(eventData).setDataschema(EventJSONSchema.getSchemaV1(eventType)).build();
    }

    protected DataAttributes<ChildAssociationResource> buildEventData(EventInfo eventInfo, ChildAssociationResource resource) {
        return EventData.builder().setEventGroupId(eventInfo.getTxnId()).setResource((Resource)resource).build();
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssociationRef, boolean isNewNode) {
        this.eventTypes.add(EventType.CHILD_ASSOC_CREATED);
        this.resource = this.buildChildAssociationResource(childAssociationRef);
    }

    @Override
    public void beforeDeleteChildAssociation(ChildAssociationRef childAssociationRef) {
        this.eventTypes.add(EventType.CHILD_ASSOC_DELETED);
        this.resource = this.buildChildAssociationResource(childAssociationRef);
    }

    private ChildAssociationResource buildChildAssociationResource(ChildAssociationRef childAssociationRef) {
        String parentId = childAssociationRef.getParentRef().getId();
        String childId = childAssociationRef.getChildRef().getId();
        String assocQName = this.helper.getQNamePrefixString(childAssociationRef.getQName());
        String assocType = this.helper.getQNamePrefixString(childAssociationRef.getTypeQName());
        return new ChildAssociationResource(parentId, childId, assocType, assocQName);
    }

    private EventType getDerivedEvent() {
        if (this.isTemporaryChildAssociation()) {
            return EventType.CHILD_ASSOC_DELETED;
        }
        if (this.eventTypes.contains(EventType.CHILD_ASSOC_CREATED)) {
            return EventType.CHILD_ASSOC_CREATED;
        }
        if (this.eventTypes.getLast() == EventType.CHILD_ASSOC_DELETED) {
            return EventType.CHILD_ASSOC_DELETED;
        }
        return this.eventTypes.getFirst();
    }

    public boolean isTemporaryChildAssociation() {
        return this.eventTypes.contains(EventType.CHILD_ASSOC_CREATED) && this.eventTypes.getLast() == EventType.CHILD_ASSOC_DELETED;
    }

    public QName getChildAssocType() {
        return this.childAssociationRef.getTypeQName();
    }

    public Deque<EventType> getEventTypes() {
        return this.eventTypes;
    }
}

