/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.MySQLClusterNDBDialect;
import org.alfresco.repo.domain.dialect.MySQLInnoDBDialect;
import org.alfresco.repo.domain.dialect.PostgreSQLDialect;
import org.alfresco.repo.domain.schema.script.DeleteNotExistsExecutor;
import org.alfresco.repo.domain.schema.script.MySQLDeleteNotExistsExecutor;
import org.alfresco.repo.domain.schema.script.ScriptExecutor;
import org.alfresco.util.DialectUtil;
import org.alfresco.util.LogUtil;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ScriptExecutorImpl
implements ScriptExecutor {
    private static final String PROPERTY_DEFAULT_BATCH_SIZE = "system.upgrade.default.batchsize";
    private static final String MSG_EXECUTING_GENERATED_SCRIPT = "schema.update.msg.executing_generated_script";
    private static final String MSG_EXECUTING_COPIED_SCRIPT = "schema.update.msg.executing_copied_script";
    private static final String MSG_EXECUTING_STATEMENT = "schema.update.msg.executing_statement";
    private static final String MSG_OPTIONAL_STATEMENT_FAILED = "schema.update.msg.optional_statement_failed";
    private static final String ERR_STATEMENT_FAILED = "schema.update.err.statement_failed";
    private static final String ERR_SCRIPT_NOT_FOUND = "schema.update.err.script_not_found";
    private static final String ERR_STATEMENT_INCLUDE_BEFORE_SQL = "schema.update.err.statement_include_before_sql";
    private static final String ERR_STATEMENT_VAR_ASSIGNMENT_BEFORE_SQL = "schema.update.err.statement_var_assignment_before_sql";
    private static final String ERR_STATEMENT_VAR_ASSIGNMENT_FORMAT = "schema.update.err.statement_var_assignment_format";
    private static final String ERR_STATEMENT_VAR_ASSIGNMENT_NULL = "schema.update.err.statement_var_assignment_null";
    private static final String ERR_STATEMENT_TERMINATOR = "schema.update.err.statement_terminator";
    private static final String ERR_DELIMITER_SET_BEFORE_SQL = "schema.update.err.delimiter_set_before_sql";
    private static final String ERR_DELIMITER_INVALID = "schema.update.err.delimiter_invalid";
    private static final int DEFAULT_MAX_STRING_LENGTH = 1024;
    private static final int DEFAULT_MAX_STRING_LENGTH_NDB = 400;
    private static volatile int maxStringLength = 1024;
    private Dialect dialect;
    private ResourcePatternResolver rpr = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());
    private static Log logger = LogFactory.getLog(ScriptExecutorImpl.class);
    private Properties globalProperties;
    private ThreadLocal<StringBuilder> executedStatementsThreadLocal = new ThreadLocal();
    private DataSource dataSource;

    public static final int getMaxStringLength() {
        return maxStringLength;
    }

    public static final String trimStringForTextFields(String value) {
        if (value != null && value.length() > maxStringLength) {
            return value.substring(0, maxStringLength);
        }
        return value;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public ScriptExecutorImpl() {
        this.globalProperties = new Properties();
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setGlobalProperties(Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    @Override
    public void executeScriptUrl(String scriptUrl) throws Exception {
        connection.setAutoCommit(true);
        try (Connection connection = this.dataSource.getConnection();){
            this.executeScriptUrl(connection, scriptUrl);
        }
    }

    private void executeScriptUrl(Connection connection, String scriptUrl) throws Exception {
        Dialect dialect = this.dialect;
        String dialectStr = dialect.getClass().getSimpleName();
        InputStream scriptInputStream = this.getScriptInputStream(dialect.getClass(), scriptUrl);
        if (scriptInputStream == null) {
            throw AlfrescoRuntimeException.create((String)ERR_SCRIPT_NOT_FOUND, (Object[])new Object[]{scriptUrl});
        }
        File tempFile = null;
        try {
            tempFile = TempFileProvider.createTempFile((String)("AlfrescoSchema-" + dialectStr + "-Update-"), (String)".sql");
            FileContentWriter writer = new FileContentWriter(tempFile);
            writer.putContent(scriptInputStream);
        }
        catch (Throwable throwable) {
            try {
                scriptInputStream.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            scriptInputStream.close();
        }
        catch (Throwable throwable) {}
        String dialectScriptUrl = scriptUrl.replaceAll("\\$\\{db\\.script\\.dialect\\}", dialect.getClass().getName());
        this.executeScriptFile(connection, tempFile, dialectScriptUrl);
    }

    private InputStream getScriptInputStream(Class dialectClazz, String scriptUrl) throws Exception {
        Resource resource = DialectUtil.getDialectResource(this.rpr, dialectClazz, scriptUrl);
        if (resource == null) {
            return null;
        }
        return resource.getInputStream();
    }

    private void executeScriptFile(Connection connection, File scriptFile, String scriptUrl) throws Exception {
        Dialect dialect = this.dialect;
        StringBuilder executedStatements = this.executedStatementsThreadLocal.get();
        if (executedStatements == null) {
            executedStatements = new StringBuilder(8094);
            this.executedStatementsThreadLocal.set(executedStatements);
        }
        if (scriptUrl == null) {
            LogUtil.info((Log)logger, (String)MSG_EXECUTING_GENERATED_SCRIPT, (Object[])new Object[]{scriptFile});
        } else {
            LogUtil.info((Log)logger, (String)MSG_EXECUTING_COPIED_SCRIPT, (Object[])new Object[]{scriptFile, scriptUrl});
        }
        FileInputStream scriptInputStream = new FileInputStream(scriptFile);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)scriptInputStream, "UTF-8"));
        try {
            int line = 0;
            StringBuilder sb = new StringBuilder(1024);
            String fetchVarName = null;
            String fetchColumnName = null;
            String defaultFetchValue = null;
            String batchTableName = null;
            boolean doBatch = false;
            int batchUpperLimit = 0;
            int batchSize = 1;
            HashMap<String, Object> varAssignments = new HashMap<String, Object>(13);
            String delimiter = ";";
            if (dialect instanceof PostgreSQLDialect) {
                varAssignments.put("true", "true");
                varAssignments.put("false", "false");
                varAssignments.put("TRUE", "TRUE");
                varAssignments.put("FALSE", "FALSE");
            } else {
                varAssignments.put("true", "1");
                varAssignments.put("false", "0");
                varAssignments.put("TRUE", "1");
                varAssignments.put("FALSE", "0");
            }
            long now = System.currentTimeMillis();
            varAssignments.put("now", new Long(now).toString());
            varAssignments.put("NOW", new Long(now).toString());
            while (true) {
                String sqlOriginal = reader.readLine();
                ++line;
                if (sqlOriginal != null) {
                    int endIndex;
                    String sql = sqlOriginal.trim();
                    if (sql.startsWith("--INCLUDE:")) {
                        if (sb.length() > 0) {
                            throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_INCLUDE_BEFORE_SQL, (Object[])new Object[]{line - 1, scriptUrl});
                        }
                        String includedScriptUrl = sql.substring(10, sql.length());
                        this.executeScriptUrl(connection, includedScriptUrl);
                    } else {
                        if (sql.startsWith("--ASSIGN:")) {
                            if (sb.length() > 0) {
                                throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_VAR_ASSIGNMENT_BEFORE_SQL, (Object[])new Object[]{line - 1, scriptUrl});
                            }
                            String assignStr = sql.substring(9, sql.length());
                            String[] fetchMapping = assignStr.split("!");
                            String[] assigns = fetchMapping[0].split("=");
                            if (assigns.length != 2 || assigns[0].length() == 0 || assigns[1].length() == 0) {
                                throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_VAR_ASSIGNMENT_FORMAT, (Object[])new Object[]{line - 1, scriptUrl});
                            }
                            fetchVarName = assigns[0];
                            fetchColumnName = assigns[1];
                            if (fetchMapping.length <= 1 || fetchMapping[1].length() <= 0) continue;
                            defaultFetchValue = fetchMapping[1];
                            continue;
                        }
                        if (sql.startsWith("--FOREACH")) {
                            int sepIndex;
                            String[] args = sql.split("[ \\t]+");
                            if (args.length != 3 || (sepIndex = args[1].indexOf(46)) == -1) continue;
                            doBatch = true;
                            batchTableName = args[1].substring(0, sepIndex);
                            String stmt = "SELECT MAX(" + args[1].substring(sepIndex + 1) + ") AS upper_limit FROM " + batchTableName;
                            Object fetchedVal = this.executeStatement(connection, stmt, "upper_limit", false, line, scriptFile);
                            if (!(fetchedVal instanceof Number)) continue;
                            batchUpperLimit = ((Number)fetchedVal).intValue();
                            String batchSizeString = this.globalProperties.getProperty(args[2]);
                            if (batchSizeString == null) {
                                batchSizeString = this.globalProperties.getProperty(PROPERTY_DEFAULT_BATCH_SIZE);
                            }
                            batchSize = batchSizeString == null ? 10000 : Integer.parseInt(batchSizeString);
                            continue;
                        }
                        if (sql.startsWith("--DELETE_NOT_EXISTS")) {
                            DeleteNotExistsExecutor deleteNotExists = this.createDeleteNotExistsExecutor(dialect, connection, sql, line, scriptFile);
                            deleteNotExists.execute();
                            sb.setLength(0);
                            fetchVarName = null;
                            fetchColumnName = null;
                            defaultFetchValue = null;
                            batchTableName = null;
                            doBatch = false;
                            batchUpperLimit = 0;
                            batchSize = 1;
                            continue;
                        }
                        if (sql.startsWith("--BEGIN TXN")) {
                            connection.setAutoCommit(false);
                            continue;
                        }
                        if (sql.startsWith("--END TXN")) {
                            connection.commit();
                            connection.setAutoCommit(true);
                            continue;
                        }
                        if (sql.startsWith("--SET-DELIMITER:")) {
                            if (sb.length() > 0) {
                                throw AlfrescoRuntimeException.create((String)ERR_DELIMITER_SET_BEFORE_SQL, (Object[])new Object[]{line - 1, scriptUrl});
                            }
                            String newDelim = sql.substring(16).trim();
                            if (newDelim.length() == 0) {
                                throw AlfrescoRuntimeException.create((String)ERR_DELIMITER_INVALID, (Object[])new Object[]{line - 1, scriptUrl});
                            }
                            delimiter = newDelim;
                        }
                    }
                    if (sql.length() == 0 || sql.startsWith("--") || sql.startsWith("//") || sql.startsWith("/*")) {
                        if (sb.length() <= 0) continue;
                        throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_TERMINATOR, (Object[])new Object[]{delimiter, line - 1, scriptUrl});
                    }
                    boolean execute = false;
                    boolean optional = false;
                    if (sql.endsWith(delimiter)) {
                        sql = sql.substring(0, sql.length() - 1);
                        execute = true;
                        optional = false;
                    } else if ((sql.endsWith("(optional)") || sql.endsWith("(OPTIONAL)")) && (endIndex = sql.lastIndexOf(delimiter)) > -1) {
                        sql = sql.substring(0, endIndex);
                        execute = true;
                        optional = true;
                    }
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    int whitespaceCount = sqlOriginal.indexOf(sql);
                    int i = 0;
                    while (i < whitespaceCount) {
                        sb.append(" ");
                        ++i;
                    }
                    sb.append(sql);
                    if (!execute) continue;
                    String unsubstituted = sb.toString();
                    int lowerBound = 0;
                    while (lowerBound <= batchUpperLimit) {
                        sql = unsubstituted;
                        if (doBatch) {
                            logger.info((Object)("Processing from " + lowerBound + " to " + (lowerBound + batchSize) + " rows of " + batchUpperLimit + " rows from table " + batchTableName + "."));
                            varAssignments.put("LOWERBOUND", String.valueOf(lowerBound));
                            varAssignments.put("UPPERBOUND", String.valueOf(lowerBound + batchSize - 1));
                        }
                        for (Map.Entry entry : varAssignments.entrySet()) {
                            String var = (String)entry.getKey();
                            Object val = entry.getValue();
                            sql = sql.replaceAll("\\$\\{" + var + "\\}", val.toString());
                        }
                        sql = this.dialect != null && this.dialect instanceof PostgreSQLDialect ? sql.replaceAll("\\$\\{TRUE\\}", "TRUE") : sql.replaceAll("\\$\\{TRUE\\}", "1");
                        if (this.dialect != null && this.dialect instanceof MySQLInnoDBDialect) {
                            sql = sql.replaceAll("(?i)TYPE=InnoDB", "ENGINE=InnoDB");
                        }
                        if (this.dialect != null && this.dialect instanceof MySQLClusterNDBDialect) {
                            sql = sql.replaceAll("(?i)TYPE=InnoDB", "ENGINE=NDB");
                            sql = sql.replaceAll("(?i)ENGINE=InnoDB", "ENGINE=NDB");
                            sql = sql.replaceAll("(?i) BIT ", " BOOLEAN ");
                            sql = sql.replaceAll("(?i) BIT,", " BOOLEAN,");
                            sql = sql.replaceAll("(?i) string_value text", " string_value VARCHAR(400)");
                            sql = sql.replaceAll("(?i) VARCHAR(4000)", "TEXT(4000)");
                        }
                        Object fetchedVal = this.executeStatement(connection, sql, fetchColumnName, optional, line, scriptFile);
                        if (fetchVarName != null && fetchColumnName != null) {
                            if (fetchedVal == null) {
                                fetchedVal = defaultFetchValue;
                            }
                            if (fetchedVal == null) {
                                throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_VAR_ASSIGNMENT_NULL, (Object[])new Object[]{fetchVarName, fetchVarName, line - 1, scriptUrl});
                            }
                            varAssignments.put(fetchVarName, fetchedVal);
                        }
                        lowerBound += batchSize;
                    }
                    sb.setLength(0);
                    fetchVarName = null;
                    fetchColumnName = null;
                    defaultFetchValue = null;
                    batchTableName = null;
                    doBatch = false;
                    batchUpperLimit = 0;
                    batchSize = 1;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (Throwable throwable2) {}
            try {
                ((InputStream)scriptInputStream).close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (Throwable throwable) {}
        try {
            ((InputStream)scriptInputStream).close();
        }
        catch (Throwable throwable) {}
    }

    private DeleteNotExistsExecutor createDeleteNotExistsExecutor(Dialect dialect, Connection connection, String sql, int line, File scriptFile) {
        if (dialect instanceof MySQLInnoDBDialect) {
            return new MySQLDeleteNotExistsExecutor(connection, sql, line, scriptFile, this.globalProperties, this.dataSource);
        }
        return new DeleteNotExistsExecutor(connection, sql, line, scriptFile, this.globalProperties);
    }

    private Object executeStatement(Connection connection, String sql, String fetchColumnName, boolean optional, int line, File file) throws Exception {
        Object ret;
        block15: {
            StringBuilder executedStatements = this.executedStatementsThreadLocal.get();
            if (executedStatements == null) {
                throw new IllegalArgumentException("The executedStatementsThreadLocal must be populated");
            }
            Statement stmt = connection.createStatement();
            ret = null;
            try {
                try {
                    ResultSet rs;
                    if (logger.isDebugEnabled()) {
                        LogUtil.debug((Log)logger, (String)MSG_EXECUTING_STATEMENT, (Object[])new Object[]{sql});
                    }
                    boolean haveResults = stmt.execute(sql);
                    executedStatements.append(sql).append(";\n\n");
                    if (haveResults && fetchColumnName != null && (rs = stmt.getResultSet()).next()) {
                        ret = rs.getObject(fetchColumnName);
                    }
                }
                catch (SQLException e) {
                    if (!optional) {
                        LogUtil.error((Log)logger, (String)ERR_STATEMENT_FAILED, (Object[])new Object[]{sql, e.getMessage(), file.getAbsolutePath(), line});
                        throw e;
                    }
                    LogUtil.debug((Log)logger, (String)MSG_OPTIONAL_STATEMENT_FAILED, (Object[])new Object[]{sql, e.getMessage(), file.getAbsolutePath(), line});
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                stmt.close();
            }
            catch (Throwable throwable) {}
        }
        return ret;
    }
}

