/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.bulkimport.AnalysedDirectory;
import org.alfresco.repo.bulkimport.DirectoryAnalyser;
import org.alfresco.repo.bulkimport.ImportableItem;
import org.alfresco.repo.bulkimport.impl.AbstractFilesystemTracker;
import org.alfresco.service.cmr.repository.NodeRef;

public class StripingFilesystemTracker
extends AbstractFilesystemTracker {
    private ImportableItem rootFolder;
    private int currentLevel = 0;
    private int batchSize;
    private Map<Integer, List<ImportableItem>> directoriesToProcess = new HashMap<Integer, List<ImportableItem>>(10);
    private List<ImportableItem> toProcess = new ArrayList<ImportableItem>();

    public StripingFilesystemTracker(DirectoryAnalyser directoryAnalyser, NodeRef target, File sourceFolder, int batchSize) {
        this.directoryAnalyser = directoryAnalyser;
        this.batchSize = batchSize;
        this.rootFolder = new ImportableItem();
        this.rootFolder.getHeadRevision().setContentFile(sourceFolder.toPath());
        this.rootFolder.setNodeRef(target);
        this.addDirectoryToProcess(this.rootFolder, this.currentLevel);
    }

    protected void addDirectoriesToProcess(Collection<ImportableItem> dirsToAdd, int level) {
        List<ImportableItem> dirs = this.getDirectoriesToProcess(level);
        dirs.addAll(dirsToAdd);
    }

    protected void addDirectoryToProcess(ImportableItem dir, int level) {
        List<ImportableItem> dirs = this.getDirectoriesToProcess(level);
        dirs.add(dir);
    }

    protected List<ImportableItem> getDirectoriesToProcess(int level) {
        List<ImportableItem> dirs = this.directoriesToProcess.get(new Integer(level));
        if (dirs == null) {
            dirs = new ArrayList<ImportableItem>();
            this.directoriesToProcess.put(new Integer(level), dirs);
        }
        return dirs;
    }

    @Override
    public int count() {
        return this.numDirectoriesToProcess() * 100;
    }

    protected void incrementLevel() {
        ++this.currentLevel;
    }

    @Override
    public void itemImported(NodeRef nodeRef, ImportableItem importableItem) {
    }

    protected void addItemsToProcess(Collection<ImportableItem> items) {
        this.toProcess.addAll(items);
    }

    protected ImportableItem getDirectoryToProcess() {
        List<ImportableItem> dirs = this.getDirectoriesToProcess(this.currentLevel);
        if (dirs.size() > 0) {
            return dirs.remove(0);
        }
        return null;
    }

    public boolean moreLevels() {
        return this.getDirectoriesToProcess(this.currentLevel).size() > 0;
    }

    public int numDirectoriesToProcess() {
        return this.getDirectoriesToProcess(this.currentLevel).size();
    }

    protected List<ImportableItem> getImportableItems(int count) {
        while (this.toProcess.size() < count) {
            ImportableItem directory = this.getDirectoryToProcess();
            if (directory == null) break;
            AnalysedDirectory analysedDirectory = this.getImportableItemsInDirectory(directory);
            this.addItemsToProcess(analysedDirectory.getImportableDirectories());
            this.addItemsToProcess(analysedDirectory.getImportableItems());
            this.getDirectoriesToProcess(this.currentLevel + 1).addAll(analysedDirectory.getImportableDirectories());
        }
        int size = this.toProcess.size() >= count ? count : this.toProcess.size();
        ArrayList<ImportableItem> result = new ArrayList<ImportableItem>(size);
        int i = size;
        while (i > 0) {
            ImportableItem importableItem = this.toProcess.remove(0);
            if (importableItem != null) {
                result.add(importableItem);
                --i;
                continue;
            }
            AbstractFilesystemTracker.logger.warn((Object)"Unexpected empty toProcess queue");
        }
        if (result.size() == 0) {
            this.incrementLevel();
        }
        return result;
    }

    @Override
    public BatchProcessWorkProvider<ImportableItem> getWorkProvider() {
        BatchProcessWorkProvider<ImportableItem> provider = new BatchProcessWorkProvider<ImportableItem>(){

            @Override
            public int getTotalEstimatedWorkSize() {
                return StripingFilesystemTracker.this.count();
            }

            @Override
            public long getTotalEstimatedWorkSizeLong() {
                return StripingFilesystemTracker.this.count();
            }

            @Override
            public Collection<ImportableItem> getNextWork() {
                return StripingFilesystemTracker.this.getImportableItems(StripingFilesystemTracker.this.batchSize * 1000);
            }
        };
        return provider;
    }
}

