/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock.mem;

import java.util.Date;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.lock.mem.LockStore;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.ConcurrencyFailureException;

public abstract class AbstractLockStoreTxTest<T extends LockStore> {
    protected T lockStore;
    protected static ApplicationContext ctx;
    protected static TransactionService transactionService;

    protected abstract T createLockStore();

    @BeforeClass
    public static void setUpSpringContext() {
        ctx = ApplicationContextHelper.getApplicationContext();
        transactionService = (TransactionService)ctx.getBean("TransactionService");
    }

    @Before
    public void setUpLockStore() {
        this.lockStore = this.createLockStore();
    }

    @Test
    public void testRepeatableRead_01() throws Exception {
    }

    @Test
    public void testRepeatableReadsInTransaction() throws NotSupportedException, SystemException {
        final TransactionService txService = (TransactionService)ctx.getBean("TransactionService");
        UserTransaction txA = txService.getUserTransaction();
        final NodeRef nodeRef = new NodeRef("workspace://SpacesStore/UUID-1");
        final NodeRef nodeRef2 = new NodeRef("workspace://SpacesStore/UUID-2");
        Date now = new Date();
        Date expires = new Date(now.getTime() + 180000L);
        LockState lockState1 = LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)"jbloggs", (Date)expires, (Lifetime)Lifetime.EPHEMERAL, null);
        Thread txB = new Thread("TxB"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractLockStoreTxTest main = AbstractLockStoreTxTest.this;
                UserTransaction tx = txService.getUserTransaction();
                try {
                    try {
                        tx.begin();
                        try {
                            LockState lockState = AbstractLockStoreTxTest.this.lockStore.get(nodeRef);
                            Assert.assertEquals((Object)"jbloggs", (Object)lockState.getOwner());
                            Assert.assertEquals((Object)Lifetime.EPHEMERAL, (Object)lockState.getLifetime());
                            AbstractLockStoreTxTest.this.passControl(this, main);
                            lockState = AbstractLockStoreTxTest.this.lockStore.get(nodeRef);
                            Assert.assertEquals((Object)"jbloggs", (Object)lockState.getOwner());
                            AbstractLockStoreTxTest.this.passControl(this, main);
                            AbstractLockStoreTxTest.this.lockStore.set(nodeRef2, LockState.createLock((NodeRef)nodeRef2, (LockType)LockType.WRITE_LOCK, (String)"csmith", null, (Lifetime)Lifetime.EPHEMERAL, null));
                        }
                        finally {
                            tx.rollback();
                        }
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Error in transaction B", e);
                    }
                }
                catch (Throwable throwable) {
                    AbstractLockStoreTxTest abstractLockStoreTxTest = main;
                    synchronized (abstractLockStoreTxTest) {
                        main.notifyAll();
                    }
                    throw throwable;
                }
                AbstractLockStoreTxTest abstractLockStoreTxTest = main;
                synchronized (abstractLockStoreTxTest) {
                    main.notifyAll();
                }
            }
        };
        txA.begin();
        try {
            this.lockStore.set(nodeRef, lockState1);
            txB.setDaemon(true);
            txB.start();
            this.passControl(this, txB);
            AuthenticationUtil.setFullyAuthenticatedUser((String)"jbloggs");
            LockState lockState2 = LockState.createWithOwner((LockState)lockState1, (String)"another");
            this.lockStore.set(nodeRef, lockState2);
            this.passControl(this, txB);
            AuthenticationUtil.setFullyAuthenticatedUser((String)"another");
            LockState lockState3 = LockState.createWithOwner((LockState)lockState2, (String)"bsmith");
            this.lockStore.set(nodeRef, lockState3);
            Assert.assertEquals((Object)"bsmith", (Object)this.lockStore.get(nodeRef).getOwner());
            Assert.assertNull((String)"nodeRef2 LockState", (Object)this.lockStore.get(nodeRef2));
            this.passControl(this, txB);
            Assert.assertNull((String)"nodeRef2 LockState", (Object)this.lockStore.get(nodeRef2));
        }
        finally {
            txA.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passControl(Object from, Object to) {
        Object object = to;
        synchronized (object) {
            to.notifyAll();
        }
        object = from;
        synchronized (object) {
            try {
                from.wait(10000L);
            }
            catch (InterruptedException error) {
                throw new RuntimeException(error);
            }
        }
    }

    @Test
    public void testCannotSetLockWhenChangedByAnotherTx() throws NotSupportedException, SystemException {
        final TransactionService txService = (TransactionService)ctx.getBean("TransactionService");
        UserTransaction txA = txService.getUserTransaction();
        final NodeRef nodeRef = new NodeRef("workspace://SpacesStore/UUID-1");
        Date now = new Date();
        Date expires = new Date(now.getTime() + 180000L);
        LockState lockState1 = LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)"jbloggs", (Date)expires, (Lifetime)Lifetime.EPHEMERAL, null);
        Thread txB = new Thread("TxB"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractLockStoreTxTest main = AbstractLockStoreTxTest.this;
                UserTransaction tx = txService.getUserTransaction();
                try {
                    try {
                        tx.begin();
                        try {
                            LockState lockState = AbstractLockStoreTxTest.this.lockStore.get(nodeRef);
                            Assert.assertEquals((Object)"jbloggs", (Object)lockState.getOwner());
                            Assert.assertEquals((Object)Lifetime.EPHEMERAL, (Object)lockState.getLifetime());
                            AbstractLockStoreTxTest.this.passControl(this, main);
                            try {
                                AuthenticationUtil.setFullyAuthenticatedUser((String)"jbloggs");
                                AbstractLockStoreTxTest.this.lockStore.set(nodeRef, LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)"csmith", null, (Lifetime)Lifetime.EPHEMERAL, null));
                                Assert.fail((String)"Exception should have been thrown but was not.");
                            }
                            catch (ConcurrencyFailureException concurrencyFailureException) {}
                        }
                        finally {
                            tx.rollback();
                        }
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Error in transaction B", e);
                    }
                }
                catch (Throwable throwable) {
                    AbstractLockStoreTxTest abstractLockStoreTxTest = main;
                    synchronized (abstractLockStoreTxTest) {
                        main.notifyAll();
                    }
                    throw throwable;
                }
                AbstractLockStoreTxTest abstractLockStoreTxTest = main;
                synchronized (abstractLockStoreTxTest) {
                    main.notifyAll();
                }
            }
        };
        txA.begin();
        try {
            this.lockStore.set(nodeRef, lockState1);
            txB.setDaemon(true);
            txB.start();
            this.passControl(this, txB);
            AuthenticationUtil.setFullyAuthenticatedUser((String)"jbloggs");
            LockState lockState2 = LockState.createWithOwner((LockState)lockState1, (String)"another");
            this.lockStore.set(nodeRef, lockState2);
            this.passControl(this, txB);
            Assert.assertEquals((Object)lockState2, (Object)this.lockStore.get(nodeRef));
        }
        finally {
            txA.rollback();
        }
    }

    @Test
    public void testCanChangeLockIfLatestValueIsHeldEvenIfAlreadyChangedByAnotherTx() throws NotSupportedException, SystemException {
        final TransactionService txService = (TransactionService)ctx.getBean("TransactionService");
        UserTransaction txA = txService.getUserTransaction();
        final NodeRef nodeRef = new NodeRef("workspace://SpacesStore/UUID-1");
        final Date now = new Date();
        Date expired = new Date(now.getTime() - 180000L);
        LockState lockState1 = LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)"jbloggs", (Date)expired, (Lifetime)Lifetime.EPHEMERAL, null);
        final LockState lockState2 = LockState.createWithOwner((LockState)lockState1, (String)"another");
        Thread txB = new Thread("TxB"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractLockStoreTxTest main = AbstractLockStoreTxTest.this;
                UserTransaction tx = txService.getUserTransaction();
                try {
                    try {
                        tx.begin();
                        try {
                            AuthenticationUtil.setFullyAuthenticatedUser((String)"new-user");
                            LockState readLockState = AbstractLockStoreTxTest.this.lockStore.get(nodeRef);
                            Assert.assertEquals((Object)lockState2, (Object)readLockState);
                            Date expiresFuture = new Date(now.getTime() + 180000L);
                            LockState newUserLockState = LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)"new-user", (Date)expiresFuture, (Lifetime)Lifetime.EPHEMERAL, null);
                            AbstractLockStoreTxTest.this.lockStore.set(nodeRef, newUserLockState);
                            Assert.assertEquals((Object)newUserLockState, (Object)AbstractLockStoreTxTest.this.lockStore.get(nodeRef));
                        }
                        finally {
                            tx.rollback();
                        }
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Error in transaction B", e);
                    }
                }
                catch (Throwable throwable) {
                    AbstractLockStoreTxTest abstractLockStoreTxTest = main;
                    synchronized (abstractLockStoreTxTest) {
                        main.notifyAll();
                    }
                    throw throwable;
                }
                AbstractLockStoreTxTest abstractLockStoreTxTest = main;
                synchronized (abstractLockStoreTxTest) {
                    main.notifyAll();
                }
            }
        };
        txA.begin();
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)"jbloggs");
            this.lockStore.set(nodeRef, lockState1);
            Assert.assertEquals((Object)lockState1, (Object)this.lockStore.get(nodeRef));
            this.lockStore.set(nodeRef, lockState2);
            Assert.assertEquals((Object)lockState2, (Object)this.lockStore.get(nodeRef));
            txB.setDaemon(true);
            txB.start();
            this.passControl(this, txB);
            Assert.assertEquals((Object)lockState2, (Object)this.lockStore.get(nodeRef));
        }
        finally {
            txA.rollback();
        }
    }

    @Test
    public void testNotOnlyCurrentLockOwnerCanChangeInfo() throws NotSupportedException, SystemException {
        TransactionService txService = (TransactionService)ctx.getBean("TransactionService");
        UserTransaction txA = txService.getUserTransaction();
        NodeRef nodeRef = new NodeRef("workspace://SpacesStore/UUID-1");
        Date now = new Date();
        Date expires = new Date(now.getTime() + 180000L);
        LockState lockState1 = LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)"jbloggs", (Date)expires, (Lifetime)Lifetime.EPHEMERAL, null);
        txA.begin();
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)"jbloggs");
            this.lockStore.set(nodeRef, lockState1);
            LockState lockState2 = LockState.createWithOwner((LockState)lockState1, (String)"csmith");
            this.lockStore.set(nodeRef, lockState2);
            Assert.assertEquals((Object)lockState2, (Object)this.lockStore.get(nodeRef));
            LockState lockState3 = LockState.createWithOwner((LockState)lockState1, (String)"dsmithers");
            this.lockStore.set(nodeRef, lockState3);
            Assert.assertEquals((Object)lockState3, (Object)this.lockStore.get(nodeRef));
        }
        finally {
            txA.rollback();
        }
    }

    @Test
    public void testOtherUserCanChangeLockInfoOnceExpired() throws NotSupportedException, SystemException {
        TransactionService txService = (TransactionService)ctx.getBean("TransactionService");
        UserTransaction txA = txService.getUserTransaction();
        NodeRef nodeRef = new NodeRef("workspace://SpacesStore/UUID-1");
        Date now = new Date();
        Date expired = new Date(now.getTime() - 900L);
        LockState lockState1 = LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)"jbloggs", (Date)expired, (Lifetime)Lifetime.EPHEMERAL, null);
        txA.begin();
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)"jbloggs");
            this.lockStore.set(nodeRef, lockState1);
            AuthenticationUtil.setFullyAuthenticatedUser((String)"csmith");
            Date expiresFuture = new Date(now.getTime() + 180000L);
            LockState lockState2 = LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)"csmith", (Date)expiresFuture, (Lifetime)Lifetime.EPHEMERAL, null);
            this.lockStore.set(nodeRef, lockState2);
            Assert.assertEquals((Object)lockState2, (Object)this.lockStore.get(nodeRef));
            AuthenticationUtil.setFullyAuthenticatedUser((String)"dsmithers");
            LockState lockState3 = LockState.createWithOwner((LockState)lockState2, (String)"dsmithers");
            this.lockStore.set(nodeRef, lockState3);
            Assert.assertEquals((Object)lockState3, (Object)this.lockStore.get(nodeRef));
        }
        finally {
            txA.rollback();
        }
    }
}

