/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.alfresco.encryption.AlfrescoKeyStore;
import org.alfresco.encryption.AlfrescoKeyStoreImpl;
import org.alfresco.encryption.DefaultEncryptor;
import org.alfresco.encryption.EncryptionKeysRegistry;
import org.alfresco.encryption.InvalidKeystoreException;
import org.alfresco.encryption.KeyMap;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreChecker;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.MissingKeyException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.apache.commons.codec.binary.Base64;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class KeyStoreTests {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private KeyStoreChecker keyStoreChecker;
    private EncryptionKeysRegistry encryptionKeysRegistry;
    private UserTransaction txn = null;
    private KeyResourceLoader keyResourceLoader;
    private List<String> toDelete;
    private DefaultEncryptor backupEncryptor;

    @Before
    public void setup() throws SystemException, NotSupportedException {
        this.transactionService = (TransactionService)ctx.getBean("transactionService");
        this.keyStoreChecker = (KeyStoreChecker)ctx.getBean("keyStoreChecker");
        this.encryptionKeysRegistry = (EncryptionKeysRegistry)ctx.getBean("encryptionKeysRegistry");
        this.keyResourceLoader = (KeyResourceLoader)ctx.getBean("springKeyResourceLoader");
        this.backupEncryptor = (DefaultEncryptor)ctx.getBean("backupEncryptor");
        this.toDelete = new ArrayList<String>(10);
        AuthenticationUtil.setRunAsUserSystem();
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
    }

    @After
    public void teardown() throws IllegalStateException, SecurityException, SystemException {
        if (this.txn != null) {
            this.txn.rollback();
        }
        for (String guid : this.toDelete) {
            File file = new File(guid);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    public String generateEncodedKey() {
        try {
            return Base64.encodeBase64String((byte[])this.generateKeyData());
        }
        catch (Throwable e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
            return null;
        }
    }

    public byte[] generateKeyData() throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(System.currentTimeMillis());
        byte[] bytes = new byte[24];
        random.nextBytes(bytes);
        return bytes;
    }

    protected String generateKeystoreName() {
        String guid = GUID.generate();
        this.toDelete.add(guid);
        return guid;
    }

    protected Key generateSecretKey(String keyAlgorithm) {
        try {
            DESedeKeySpec keySpec = new DESedeKeySpec(this.generateKeyData());
            SecretKeyFactory kf = SecretKeyFactory.getInstance(keyAlgorithm);
            SecretKey secretKey = kf.generateSecret(keySpec);
            return secretKey;
        }
        catch (Throwable e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
            return null;
        }
    }

    protected TestAlfrescoKeyStore getKeyStore(String name, String type, final Map<String, String> passwords, final Map<String, String> encodedKeyData, String keyStoreLocation, String backupKeyStoreLocation) {
        KeyResourceLoader testKeyResourceLoader = new KeyResourceLoader(){

            public InputStream getKeyStore(String keyStoreLocation) throws FileNotFoundException {
                return KeyStoreTests.this.keyResourceLoader.getKeyStore(keyStoreLocation);
            }

            public Properties loadKeyMetaData(String keyMetaDataFileLocation) throws IOException, FileNotFoundException {
                Properties p = new Properties();
                p.put("keystore.password", "password");
                StringBuilder aliases = new StringBuilder();
                for (String keyAlias : passwords.keySet()) {
                    p.put(String.valueOf(keyAlias) + ".password", passwords.get(keyAlias));
                    if (encodedKeyData != null && encodedKeyData.get(keyAlias) != null) {
                        p.put(String.valueOf(keyAlias) + ".keyData", encodedKeyData.get(keyAlias));
                    }
                    p.put(String.valueOf(keyAlias) + ".algorithm", "DESede");
                    aliases.append(keyAlias);
                    aliases.append(",");
                }
                if (aliases.length() > 0) {
                    aliases.delete(aliases.length() - 1, aliases.length());
                }
                p.put("aliases", aliases.toString());
                return p;
            }
        };
        KeyStoreParameters keyStoreParameters = new KeyStoreParameters(name, type, null, "", keyStoreLocation);
        KeyStoreParameters backupKeyStoreParameters = new KeyStoreParameters(String.valueOf(name) + ".backup", type, null, "", backupKeyStoreLocation);
        TestAlfrescoKeyStore keyStore = new TestAlfrescoKeyStore();
        keyStore.setKeyStoreParameters(keyStoreParameters);
        keyStore.setBackupKeyStoreParameters(backupKeyStoreParameters);
        keyStore.setKeyResourceLoader(testKeyResourceLoader);
        keyStore.setValidateKeyChanges(true);
        keyStore.setEncryptionKeysRegistry(this.encryptionKeysRegistry);
        return keyStore;
    }

    @Test
    public void test1() {
        TestAlfrescoKeyStore missingMainKeyStore = this.getKeyStore("main", "JCEKS", Collections.singletonMap("metadata", "metadata"), Collections.singletonMap("metadata", this.generateEncodedKey()), this.generateKeystoreName(), this.generateKeystoreName());
        missingMainKeyStore.setKeysToValidate(new HashSet<String>(Collections.singletonList("metadata")));
        this.encryptionKeysRegistry.unregisterKey("metadata");
        this.keyStoreChecker.setMainKeyStore((AlfrescoKeyStore)missingMainKeyStore);
        try {
            this.keyStoreChecker.validateKeyStores();
        }
        catch (InvalidKeystoreException e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
        catch (MissingKeyException e) {
            Assert.fail((String)("Unexpected exception : " + e.getMessage()));
        }
        Assert.assertTrue((String)"", (boolean)this.encryptionKeysRegistry.getRegisteredKeys(missingMainKeyStore.getKeyAliases()).contains("metadata"));
        Assert.assertTrue((String)"", (boolean)missingMainKeyStore.exists());
        Assert.assertTrue((String)"", (missingMainKeyStore.getKey("metadata") != null ? 1 : 0) != 0);
    }

    @Test
    public void test2() {
        TestAlfrescoKeyStore missingMainKeyStore = this.getKeyStore("main", "JCEKS", Collections.singletonMap("metadata", "metadata"), null, this.generateKeystoreName(), this.generateKeystoreName());
        missingMainKeyStore.setKeysToValidate(new HashSet<String>(Collections.singletonList("metadata")));
        Assert.assertTrue((String)"", (boolean)this.encryptionKeysRegistry.isKeyRegistered("metadata"));
        this.keyStoreChecker.setMainKeyStore((AlfrescoKeyStore)missingMainKeyStore);
        try {
            this.keyStoreChecker.validateKeyStores();
            Assert.fail((String)"Should have caught missing main keystore");
        }
        catch (InvalidKeystoreException e) {
            Assert.fail((String)("Unexpected exception : " + e.getMessage()));
        }
        catch (MissingKeyException missingKeyException) {}
    }

    @Test
    public void test3() {
        TestAlfrescoKeyStore mainKeyStore = this.getKeyStore("main", "JCEKS", Collections.singletonMap("metadata", "metadata"), null, this.generateKeystoreName(), this.generateKeystoreName());
        mainKeyStore.setKeysToValidate(new HashSet<String>(Collections.singletonList("metadata")));
        this.createAndPopulateKeyStore(mainKeyStore);
        this.encryptionKeysRegistry.unregisterKey("metadata");
        this.keyStoreChecker.setMainKeyStore((AlfrescoKeyStore)mainKeyStore);
        try {
            this.keyStoreChecker.validateKeyStores();
        }
        catch (InvalidKeystoreException e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
        catch (MissingKeyException e) {
            Assert.fail((String)("Unexpected exception : " + e.getMessage()));
        }
        Assert.assertTrue((String)"", (boolean)this.encryptionKeysRegistry.isKeyRegistered("metadata"));
    }

    @Test
    public void test4() {
        this.encryptionKeysRegistry.unregisterKey("metadata");
        TestAlfrescoKeyStore keyStore = this.getKeyStore("main", "JCEKS", Collections.singletonMap("metadata", "metadata"), null, this.generateKeystoreName(), this.generateKeystoreName());
        keyStore.setKeysToValidate(new HashSet<String>(Collections.singletonList("metadata")));
        this.createAndPopulateKeyStore(keyStore);
        this.keyStoreChecker.setMainKeyStore((AlfrescoKeyStore)keyStore);
        try {
            this.keyStoreChecker.validateKeyStores();
        }
        catch (InvalidKeystoreException e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
        catch (MissingKeyException e) {
            Assert.fail((String)("Unexpected exception : " + e.getMessage()));
        }
        Assert.assertTrue((String)"", (boolean)this.encryptionKeysRegistry.isKeyRegistered("metadata"));
        keyStore.changeKey("metadata", this.generateSecretKey("DESede"));
        try {
            this.keyStoreChecker.validateKeyStores();
            Assert.fail((String)"Expected key store checker to detect changed metadata key");
        }
        catch (InvalidKeystoreException invalidKeystoreException) {
        }
        catch (MissingKeyException e) {
            Assert.fail((String)("Unexpected exception : " + e.getMessage()));
        }
    }

    @Test
    public void test5() {
        this.encryptionKeysRegistry.unregisterKey("metadata");
        TestAlfrescoKeyStore keyStore = this.getKeyStore("main", "JCEKS", Collections.singletonMap("metadata", "metadata"), null, this.generateKeystoreName(), this.generateKeystoreName());
        keyStore.setKeysToValidate(new HashSet<String>(Collections.singletonList("metadata")));
        this.createAndPopulateKeyStore(keyStore);
        try {
            this.keyStoreChecker.setMainKeyStore((AlfrescoKeyStore)keyStore);
            this.keyStoreChecker.validateKeyStores();
        }
        catch (InvalidKeystoreException e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
        catch (MissingKeyException e) {
            Assert.fail((String)("Unexpected exception : " + e.getMessage()));
        }
        keyStore.backup();
        Assert.assertTrue((String)"", (boolean)this.encryptionKeysRegistry.isKeyRegistered("metadata"));
        keyStore.changeKey("metadata", this.generateSecretKey("DESede"));
        try {
            this.keyStoreChecker.validateKeyStores();
        }
        catch (InvalidKeystoreException e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
        catch (MissingKeyException e) {
            Assert.fail((String)("Unexpected exception : " + e.getMessage()));
        }
        Assert.assertTrue((String)"", (EncryptionKeysRegistry.KEY_STATUS.OK == this.encryptionKeysRegistry.checkKey("metadata", keyStore.getKey("metadata")) ? 1 : 0) != 0);
    }

    private void createAndPopulateKeyStore(TestAlfrescoKeyStore keyStore) {
        KeyMap keyMap = new KeyMap();
        keyMap.setKey("metadata", this.generateSecretKey("DESede"));
        keyStore.create(keyMap, null);
    }

    private static class TestAlfrescoKeyStore
    extends AlfrescoKeyStoreImpl {
        private TestAlfrescoKeyStore() {
        }

        public void create(KeyMap keys, KeyMap backupKeys) {
            this.keys = keys != null ? keys : new KeyMap();
            this.backupKeys = backupKeys != null ? backupKeys : new KeyMap();
            super.create();
        }

        void changeKey(String keyAlias, Key key) {
            this.keys.setKey("metadata", key);
        }
    }
}

