/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.download.DownloadModel;
import org.alfresco.repo.node.db.traitextender.NodeServiceExtension;
import org.alfresco.repo.node.db.traitextender.NodeServiceTrait;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.ActualEnvironmentException;
import org.alfresco.repo.virtual.VirtualContentModel;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.bundle.GetPathMethod;
import org.alfresco.repo.virtual.bundle.VirtualSpringBeanExtension;
import org.alfresco.repo.virtual.config.NodeRefExpression;
import org.alfresco.repo.virtual.ref.GetActualNodeRefMethod;
import org.alfresco.repo.virtual.ref.GetAspectsMethod;
import org.alfresco.repo.virtual.ref.GetParentReferenceMethod;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.repo.virtual.template.FilingData;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidChildAssociationRefException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreExistsException;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualNodeServiceExtension
extends VirtualSpringBeanExtension<NodeServiceExtension, NodeServiceTrait>
implements NodeServiceExtension {
    private static Log logger = LogFactory.getLog(VirtualNodeServiceExtension.class);
    private VirtualStore smartStore;
    private ActualEnvironment environment;
    private NodeRefExpression downloadAssociationsFolder;

    public VirtualNodeServiceExtension() {
        super(NodeServiceTrait.class);
    }

    public void setEnvironment(ActualEnvironment environment) {
        this.environment = environment;
    }

    public void setSmartStore(VirtualStore smartStore) {
        this.smartStore = smartStore;
    }

    public boolean hasAspect(NodeRef nodeRef, QName aspectQName) {
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            boolean isNodeProtocol = reference.getProtocol().equals(Protocols.NODE.protocol);
            if (VirtualContentModel.ASPECT_VIRTUAL.equals((Object)aspectQName) || ContentModel.ASPECT_TITLED.equals((Object)aspectQName)) {
                return !isNodeProtocol;
            }
            if (VirtualContentModel.ASPECT_VIRTUAL_DOCUMENT.equals((Object)aspectQName)) {
                return isNodeProtocol;
            }
            NodeRef actualNodeRef = reference.execute(new GetActualNodeRefMethod(this.environment));
            return ((NodeServiceTrait)this.getTrait()).hasAspect(actualNodeRef, aspectQName);
        }
        return ((NodeServiceTrait)this.getTrait()).hasAspect(nodeRef, aspectQName);
    }

    public QName getType(NodeRef nodeRef) {
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            QName type = this.smartStore.getType(reference);
            return type;
        }
        return ((NodeServiceTrait)this.getTrait()).getType(nodeRef);
    }

    private Map<QName, Serializable> getVirtualProperties(Reference reference) {
        return this.smartStore.getProperties(reference);
    }

    public Map<QName, Serializable> getProperties(NodeRef nodeRef) {
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            return this.getVirtualProperties(reference);
        }
        return ((NodeServiceTrait)this.getTrait()).getProperties(nodeRef);
    }

    public Map<NodeRef, Map<QName, Serializable>> getPropertiesForNodeRefs(List<NodeRef> nodeRefs) {
        HashMap<NodeRef, Map<QName, Serializable>> result = new HashMap<NodeRef, Map<QName, Serializable>>();
        for (NodeRef nodeRef : nodeRefs) {
            Reference reference = Reference.fromNodeRef(nodeRef);
            if (reference == null) continue;
            result.put(nodeRef, this.getVirtualProperties(reference));
        }
        return result;
    }

    public Serializable getProperty(NodeRef nodeRef, QName qname) {
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            return this.getVirtualProperties(reference).get(qname);
        }
        return ((NodeServiceTrait)this.getTrait()).getProperty(nodeRef, qname);
    }

    public Set<QName> getAspects(NodeRef nodeRef) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            GetAspectsMethod method = new GetAspectsMethod(theTrait, this.environment);
            return reference.execute(method);
        }
        return theTrait.getAspects(nodeRef);
    }

    public Map<NodeRef, Set<QName>> getAspects(List<NodeRef> nodeRefs) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        HashMap<NodeRef, Set<QName>> aspectsMap = new HashMap<NodeRef, Set<QName>>();
        for (NodeRef nodeRef : nodeRefs) {
            Reference reference = Reference.fromNodeRef(nodeRef);
            if (reference != null) {
                GetAspectsMethod method = new GetAspectsMethod(theTrait, this.environment);
                aspectsMap.put(nodeRef, reference.execute(method));
                continue;
            }
            aspectsMap.put(nodeRef, theTrait.getAspects(nodeRef));
        }
        return aspectsMap;
    }

    public Path getPath(NodeRef nodeRef) {
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            return reference.execute(new GetPathMethod(this.smartStore, this.environment));
        }
        return ((NodeServiceTrait)this.getTrait()).getPath(nodeRef);
    }

    public List<Path> getPaths(NodeRef nodeRef, boolean primaryOnly) {
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            NodeRef actualNodeRef = reference.execute(new GetActualNodeRefMethod(this.environment));
            return ((NodeServiceTrait)this.getTrait()).getPaths(actualNodeRef, primaryOnly);
        }
        return ((NodeServiceTrait)this.getTrait()).getPaths(nodeRef, primaryOnly);
    }

    public boolean exists(NodeRef nodeRef) {
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            return true;
        }
        return ((NodeServiceTrait)this.getTrait()).exists(nodeRef);
    }

    public List<NodeRef> exists(List<NodeRef> nodeRefs) {
        ArrayList<NodeRef> existingRefs = new ArrayList<NodeRef>();
        ArrayList<NodeRef> nonExistingRefs = new ArrayList<NodeRef>();
        for (NodeRef nodeRef : nodeRefs) {
            Reference reference = Reference.fromNodeRef(nodeRef);
            if (reference != null) {
                existingRefs.add(nodeRef);
                continue;
            }
            nonExistingRefs.add(nodeRef);
        }
        List allExistingRefs = ((NodeServiceTrait)this.getTrait()).exists(nonExistingRefs);
        existingRefs.addAll(allExistingRefs);
        return existingRefs;
    }

    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
        Reference parentReference = Reference.fromNodeRef(parentRef);
        if (parentReference != null) {
            return this.createNode(parentRef, assocTypeQName, assocQName, nodeTypeQName, Collections.emptyMap());
        }
        QName materialAssocQName = this.materializeAssocQName(assocQName);
        return ((NodeServiceTrait)this.getTrait()).createNode(parentRef, assocTypeQName, materialAssocQName, nodeTypeQName);
    }

    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName, Map<QName, Serializable> properties) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        if (Reference.fromNodeRef(parentRef) != null && !this.isVirtualContextFolder(parentRef, this.environment)) {
            if (this.environment.isSubClass(nodeTypeQName, ContentModel.TYPE_FOLDER)) {
                throw new VirtualizationException("The creation of folders within virtual folders is disabled.");
            }
            try {
                Reference parentReference = Reference.fromNodeRef(parentRef);
                FilingData filingData = this.smartStore.createFilingData(parentReference, assocTypeQName, assocQName, nodeTypeQName, properties);
                NodeRef childParentNodeRef = filingData.getFilingNodeRef();
                if (childParentNodeRef != null) {
                    String fileName;
                    String changedFileName;
                    Map<QName, Serializable> filingDataProperties = filingData.getProperties();
                    QName changedAssocQName = assocQName;
                    if (filingDataProperties.containsKey(ContentModel.PROP_NAME) && !(changedFileName = this.handleExistingFile(childParentNodeRef, fileName = (String)((Object)filingDataProperties.get(ContentModel.PROP_NAME)))).equals(fileName)) {
                        filingDataProperties.put(ContentModel.PROP_NAME, (Serializable)((Object)changedFileName));
                        QName filingDataAssocQName = filingData.getAssocQName();
                        changedAssocQName = QName.createQName((String)filingDataAssocQName.getNamespaceURI(), (String)QName.createValidLocalName((String)changedFileName));
                    }
                    ChildAssociationRef actualChildAssocRef = theTrait.createNode(childParentNodeRef, filingData.getAssocTypeQName(), changedAssocQName == null ? filingData.getAssocQName() : changedAssocQName, filingData.getNodeTypeQName(), filingDataProperties);
                    Reference nodeProtocolChildRef = NodeProtocol.newReference(actualChildAssocRef.getChildRef(), parentReference);
                    QName vChildAssocQName = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/smartfolder/1.0", (String)actualChildAssocRef.getQName().getLocalName());
                    ChildAssociationRef childAssocRef = new ChildAssociationRef(actualChildAssocRef.getTypeQName(), parentRef, vChildAssocQName, nodeProtocolChildRef.toNodeRef());
                    Set<QName> aspects = filingData.getAspects();
                    for (QName aspect : aspects) {
                        theTrait.addAspect(actualChildAssocRef.getChildRef(), aspect, filingDataProperties);
                    }
                    return childAssocRef;
                }
                throw new InvalidNodeRefException("Can not create node using parent ", parentRef);
            }
            catch (VirtualizationException e) {
                throw new InvalidNodeRefException("Could not create node in virtual context.", parentRef, (Throwable)e);
            }
        }
        QName materialAssocQName = this.materializeAssocQName(assocQName);
        if (this.isVirtualContextFolder(parentRef, this.environment)) {
            parentRef = this.smartStore.materializeIfPossible(parentRef);
        }
        return theTrait.createNode(parentRef, assocTypeQName, materialAssocQName, nodeTypeQName, properties);
    }

    private QName materializeAssocQName(QName assocQName) {
        try {
            String lName = assocQName.getLocalName();
            NodeRef nrAssocQName = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, lName);
            if (Reference.fromNodeRef(nrAssocQName) != null) {
                nrAssocQName = this.smartStore.materializeIfPossible(nrAssocQName);
                QName materialAssocQName = QName.createQName((String)assocQName.getNamespaceURI(), (String)nrAssocQName.getId());
                return materialAssocQName;
            }
            return assocQName;
        }
        catch (VirtualizationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Defaulting on materializeAssocQName due to error.", (Throwable)e);
            }
            return assocQName;
        }
    }

    private String handleExistingFile(NodeRef parentNodeRef, String fileName) {
        NodeServiceTrait actualNodeService = (NodeServiceTrait)this.getTrait();
        NodeRef existingFile = actualNodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, fileName);
        if (existingFile != null) {
            int counter = 1;
            String tmpFilename = "";
            while (existingFile != null) {
                int beforeCounter = fileName.lastIndexOf("-");
                int dotIndex = fileName.lastIndexOf(".");
                if (dotIndex == 0) {
                    tmpFilename = String.valueOf(counter) + fileName;
                } else if (dotIndex > 0) {
                    if (beforeCounter > 0 && beforeCounter < dotIndex) {
                        boolean doesOriginalFileExist;
                        String originalFileName = String.valueOf(fileName.substring(0, beforeCounter)) + fileName.substring(dotIndex);
                        boolean bl = doesOriginalFileExist = actualNodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, originalFileName) != null;
                        if (doesOriginalFileExist) {
                            String counterStr = fileName.substring(beforeCounter + 1, dotIndex);
                            try {
                                int parseInt = DefaultTypeConverter.INSTANCE.intValue((Object)counterStr);
                                counter = parseInt + 1;
                                fileName = String.valueOf(fileName.substring(0, beforeCounter)) + fileName.substring(dotIndex);
                                dotIndex = fileName.lastIndexOf(".");
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                    tmpFilename = String.valueOf(fileName.substring(0, dotIndex)) + "-" + counter + fileName.substring(dotIndex);
                } else {
                    tmpFilename = String.valueOf(fileName) + "-" + counter;
                }
                existingFile = actualNodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, tmpFilename);
                ++counter;
            }
            fileName = tmpFilename;
        }
        return fileName;
    }

    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef) {
        if (Reference.fromNodeRef(nodeRef) != null) {
            return this.getParentAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL);
        }
        return ((NodeServiceTrait)this.getTrait()).getParentAssocs(nodeRef);
    }

    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            Reference parent = reference.execute(new GetParentReferenceMethod());
            if (parent == null) {
                return theTrait.getParentAssocs(reference.execute(new GetActualNodeRefMethod(this.environment)), typeQNamePattern, qnamePattern);
            }
            if (typeQNamePattern.isMatch(ContentModel.ASSOC_CONTAINS)) {
                Reference parentsParent = parent.execute(new GetParentReferenceMethod());
                NodeRef parentNodeRef = parent.toNodeRef();
                if (parentsParent == null) {
                    parentNodeRef = parent.execute(new GetActualNodeRefMethod(this.environment));
                }
                NodeRef referenceNodeRef = reference.toNodeRef();
                Map<QName, Serializable> properties = this.smartStore.getProperties(reference);
                Serializable name = properties.get(ContentModel.PROP_NAME);
                QName assocChildName = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/smartfolder/1.0", (String)name.toString());
                if (qnamePattern.isMatch(assocChildName)) {
                    ChildAssociationRef assoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parentNodeRef, assocChildName, referenceNodeRef);
                    return Arrays.asList(assoc);
                }
                return Collections.emptyList();
            }
            return Collections.emptyList();
        }
        return theTrait.getParentAssocs(nodeRef, typeQNamePattern, qnamePattern);
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        boolean canVirtualize = this.canVirtualizeAssocNodeRef(nodeRef);
        if (canVirtualize) {
            Reference reference = this.smartStore.virtualize(nodeRef);
            List<ChildAssociationRef> virtualAssociations = this.smartStore.getChildAssocs(reference, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, Integer.MAX_VALUE, false);
            LinkedList<ChildAssociationRef> associations = new LinkedList<ChildAssociationRef>(virtualAssociations);
            if (this.smartStore.canMaterialize(reference)) {
                NodeRef materialReference = this.smartStore.materialize(reference);
                List actualAssociations = theTrait.getChildAssocs(materialReference, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, Integer.MAX_VALUE, false);
                associations.addAll(actualAssociations);
            }
            return associations;
        }
        return theTrait.getChildAssocs(nodeRef);
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        boolean canVirtualize = this.canVirtualizeAssocNodeRef(nodeRef);
        if (canVirtualize) {
            Reference reference = this.smartStore.virtualize(nodeRef);
            List<ChildAssociationRef> virtualAssociations = this.smartStore.getChildAssocs(reference, typeQNamePattern, qnamePattern, Integer.MAX_VALUE, false);
            LinkedList<ChildAssociationRef> associations = new LinkedList<ChildAssociationRef>(virtualAssociations);
            if (this.smartStore.canMaterialize(reference)) {
                NodeRef materialReference = this.smartStore.materialize(reference);
                List actualAssociations = theTrait.getChildAssocs(materialReference, typeQNamePattern, qnamePattern);
                associations.addAll(actualAssociations);
            }
            return associations;
        }
        return theTrait.getChildAssocs(nodeRef, typeQNamePattern, qnamePattern);
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern, int maxResults, boolean preload) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        boolean canVirtualize = this.canVirtualizeAssocNodeRef(nodeRef);
        if (canVirtualize) {
            Reference reference = this.smartStore.virtualize(nodeRef);
            List<ChildAssociationRef> virtualAssociations = this.smartStore.getChildAssocs(reference, typeQNamePattern, qnamePattern, maxResults, preload);
            LinkedList<ChildAssociationRef> associations = new LinkedList<ChildAssociationRef>(virtualAssociations);
            if (associations.size() < maxResults && this.smartStore.canMaterialize(reference)) {
                NodeRef materialReference = this.smartStore.materialize(reference);
                List actualAssociations = theTrait.getChildAssocs(materialReference, typeQNamePattern, qnamePattern, maxResults - associations.size(), preload);
                associations.addAll(actualAssociations);
            }
            return associations;
        }
        return theTrait.getChildAssocs(nodeRef, typeQNamePattern, qnamePattern, maxResults, preload);
    }

    private boolean canVirtualizeAssocNodeRef(NodeRef nodeRef) {
        boolean canVirtualize = nodeRef.getId().contains("solr") ? false : this.smartStore.canVirtualize(nodeRef);
        return canVirtualize;
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern, boolean preload) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        boolean canVirtualize = this.canVirtualizeAssocNodeRef(nodeRef);
        if (canVirtualize) {
            Reference reference = this.smartStore.virtualize(nodeRef);
            List<ChildAssociationRef> virtualAssociations = this.smartStore.getChildAssocs(reference, typeQNamePattern, qnamePattern, Integer.MAX_VALUE, preload);
            LinkedList<ChildAssociationRef> associations = new LinkedList<ChildAssociationRef>(virtualAssociations);
            if (this.smartStore.canMaterialize(reference)) {
                NodeRef materialReference = this.smartStore.materialize(reference);
                List actualAssociations = theTrait.getChildAssocs(materialReference, typeQNamePattern, qnamePattern, preload);
                associations.addAll(actualAssociations);
            }
            return associations;
        }
        return theTrait.getChildAssocs(nodeRef, typeQNamePattern, qnamePattern, preload);
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, Set<QName> childNodeTypeQNames) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        boolean canVirtualize = this.canVirtualizeAssocNodeRef(nodeRef);
        if (canVirtualize) {
            Reference reference = this.smartStore.virtualize(nodeRef);
            List<ChildAssociationRef> virtualAssociations = this.smartStore.getChildAssocs(reference, childNodeTypeQNames);
            LinkedList<ChildAssociationRef> associations = new LinkedList<ChildAssociationRef>(virtualAssociations);
            if (this.smartStore.canMaterialize(reference)) {
                NodeRef materialReference = this.smartStore.materialize(reference);
                List actualAssociations = theTrait.getChildAssocs(materialReference, childNodeTypeQNames);
                associations.addAll(actualAssociations);
            }
            return associations;
        }
        return theTrait.getChildAssocs(nodeRef, childNodeTypeQNames);
    }

    public List<ChildAssociationRef> getChildAssocsByPropertyValue(NodeRef nodeRef, QName propertyQName, Serializable value) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        boolean canVirtualize = this.canVirtualizeAssocNodeRef(nodeRef);
        if (canVirtualize) {
            Reference reference = this.smartStore.virtualize(nodeRef);
            List<ChildAssociationRef> virtualAssociations = this.smartStore.getChildAssocsByPropertyValue(reference, propertyQName, value);
            LinkedList<ChildAssociationRef> associations = new LinkedList<ChildAssociationRef>(virtualAssociations);
            if (this.smartStore.canMaterialize(reference)) {
                NodeRef materialReference = this.smartStore.materialize(reference);
                List actualAssociations = theTrait.getChildAssocsByPropertyValue(materialReference, propertyQName, value);
                associations.addAll(actualAssociations);
            }
            return associations;
        }
        return theTrait.getChildAssocsByPropertyValue(nodeRef, propertyQName, value);
    }

    public NodeRef getChildByName(NodeRef nodeRef, QName assocTypeQName, String childName) {
        if (this.smartStore.canVirtualize(nodeRef)) {
            Reference virtualNode = this.smartStore.virtualize(nodeRef);
            Reference theChild = this.smartStore.getChildByName(virtualNode, assocTypeQName, childName);
            if (theChild != null) {
                NodeRef childNodeRef = theChild.toNodeRef();
                return childNodeRef;
            }
            if (this.smartStore.isVirtual(nodeRef)) {
                return null;
            }
        }
        nodeRef = this.materializeIfPossible(nodeRef);
        return ((NodeServiceTrait)this.getTrait()).getChildByName(nodeRef, assocTypeQName, childName);
    }

    public ChildAssociationRef getPrimaryParent(NodeRef nodeRef) {
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            Reference parent = reference.execute(new GetParentReferenceMethod());
            if (parent == null) {
                return ((NodeServiceTrait)this.getTrait()).getPrimaryParent(reference.execute(new GetActualNodeRefMethod(this.environment)));
            }
            Reference parentsParent = parent.execute(new GetParentReferenceMethod());
            NodeRef parentNodeRef = parent.toNodeRef();
            if (parentsParent == null) {
                parentNodeRef = parent.execute(new GetActualNodeRefMethod(this.environment));
            }
            NodeRef referenceNodeRef = reference.toNodeRef();
            Map<QName, Serializable> refProperties = this.smartStore.getProperties(reference);
            Serializable childName = refProperties.get(ContentModel.PROP_NAME);
            QName childAssocQName = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/smartfolder/1.0", (String)childName.toString());
            ChildAssociationRef assoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parentNodeRef, childAssocQName, referenceNodeRef, true, -1);
            return assoc;
        }
        return ((NodeServiceTrait)this.getTrait()).getPrimaryParent(nodeRef);
    }

    public void setDownloadAssociationsFolder(NodeRefExpression downloadAssocaiationsFolder) {
        this.downloadAssociationsFolder = downloadAssocaiationsFolder;
    }

    private void cleanUpDownloadTargetAssocs(NodeRef sourceNodeRef) {
        NodeRef tempFolderNodeRef = this.downloadAssociationsFolder.resolve();
        if (tempFolderNodeRef == null) {
            return;
        }
        String tempFileName = sourceNodeRef.getId();
        NodeRef tempFileNodeRef = this.environment.getChildByName(tempFolderNodeRef, ContentModel.ASSOC_CONTAINS, tempFileName);
        if (tempFileNodeRef == null) {
            return;
        }
        this.environment.delete(tempFileNodeRef);
    }

    private List<AssociationRef> getDownloadTargetAssocs(NodeRef sourceNodeRef) {
        try {
            ArrayList<AssociationRef> result = new ArrayList<AssociationRef>();
            NodeRef tempFolderNodeRef = this.downloadAssociationsFolder.resolve();
            if (tempFolderNodeRef == null) {
                return result;
            }
            String tempFileName = sourceNodeRef.getId();
            NodeRef tempFileNodeRef = this.environment.getChildByName(tempFolderNodeRef, ContentModel.ASSOC_CONTAINS, tempFileName);
            if (tempFileNodeRef == null) {
                return result;
            }
            List readLines = IOUtils.readLines((InputStream)this.environment.openContentStream(tempFileNodeRef), (Charset)StandardCharsets.UTF_8);
            for (String line : readLines) {
                NodeRef targetRef = new NodeRef(line);
                AssociationRef assocRef = new AssociationRef(sourceNodeRef, DownloadModel.ASSOC_REQUESTED_NODES, targetRef);
                result.add(assocRef);
            }
            return result;
        }
        catch (IOException e) {
            throw new VirtualizationException(e);
        }
    }

    private void createDownloadAssociation(NodeRef sourceNodeRef, NodeRef targetRef) {
        String tempFileName;
        NodeRef tempFolderNodeRef = this.downloadAssociationsFolder.resolve(true);
        NodeRef tempFileNodeRef = this.environment.getChildByName(tempFolderNodeRef, ContentModel.ASSOC_CONTAINS, tempFileName = sourceNodeRef.getId());
        if (tempFileNodeRef == null) {
            FileInfo newTempFileInfo = this.environment.create(tempFolderNodeRef, tempFileName, ContentModel.TYPE_CONTENT);
            tempFileNodeRef = newTempFileInfo.getNodeRef();
            ContentWriter writer = this.environment.getWriter(tempFileNodeRef, ContentModel.PROP_CONTENT, true);
            writer.setMimetype("text/plain");
            writer.putContent(targetRef.toString());
        } else {
            ContentWriter writer = this.environment.getWriter(tempFileNodeRef, ContentModel.PROP_CONTENT, true);
            try {
                List readLines = IOUtils.readLines((InputStream)this.environment.openContentStream(tempFileNodeRef), (Charset)StandardCharsets.UTF_8);
                String targetRefString = targetRef.toString();
                if (!readLines.contains(targetRefString)) {
                    readLines.add(targetRefString);
                }
                String text = "";
                for (String line : readLines) {
                    text = text.isEmpty() ? line : String.valueOf(text) + IOUtils.LINE_SEPARATOR + line;
                }
                writer.putContent(text);
            }
            catch (IOException e) {
                throw new ActualEnvironmentException(e);
            }
        }
    }

    public List<AssociationRef> getTargetAssocs(NodeRef sourceRef, QNamePattern qnamePattern) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        List targetAssocs = null;
        Reference reference = Reference.fromNodeRef(sourceRef);
        if (reference != null) {
            if (this.smartStore.canMaterialize(reference)) {
                NodeRef materializedReferece = this.smartStore.materialize(reference);
                targetAssocs = theTrait.getTargetAssocs(materializedReferece, qnamePattern);
            } else {
                targetAssocs = new LinkedList<AssociationRef>();
            }
        } else {
            targetAssocs = theTrait.getTargetAssocs(sourceRef, qnamePattern);
        }
        LinkedList<AssociationRef> virtualizedIfNeededTargetAssocs = null;
        Reference sourceReference = Reference.fromNodeRef(sourceRef);
        if (sourceReference != null) {
            virtualizedIfNeededTargetAssocs = new LinkedList();
            for (AssociationRef associationRef : targetAssocs) {
                NodeRef targetNodeRef = associationRef.getTargetRef();
                Reference targetReference = NodeProtocol.newReference(targetNodeRef, sourceReference.execute(new GetParentReferenceMethod()));
                AssociationRef virtualAssocRef = new AssociationRef(associationRef.getId(), sourceRef, associationRef.getTypeQName(), targetReference.toNodeRef(targetNodeRef.getStoreRef()));
                virtualizedIfNeededTargetAssocs.add(virtualAssocRef);
            }
        } else {
            virtualizedIfNeededTargetAssocs = targetAssocs;
            if (DownloadModel.TYPE_DOWNLOAD.equals((Object)this.environment.getType(sourceRef)) && qnamePattern.isMatch(DownloadModel.ASSOC_REQUESTED_NODES)) {
                List<AssociationRef> virtualTargetAssocs = this.getDownloadTargetAssocs(sourceRef);
                virtualizedIfNeededTargetAssocs.addAll(virtualTargetAssocs);
            }
        }
        return virtualizedIfNeededTargetAssocs;
    }

    public List<AssociationRef> getSourceAssocs(NodeRef targetRef, QNamePattern qnamePattern) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(targetRef);
        if (reference != null) {
            ArrayList<AssociationRef> materialAssocs = new ArrayList<AssociationRef>();
            if (this.smartStore.canMaterialize(reference)) {
                List sourceAssocs = theTrait.getSourceAssocs(this.smartStore.materialize(reference), qnamePattern);
                for (AssociationRef associationRef : sourceAssocs) {
                    NodeRef sourceRef = associationRef.getSourceRef();
                    Reference sourceReference = NodeProtocol.newReference(sourceRef, reference.execute(new GetParentReferenceMethod()));
                    AssociationRef virtualAssocRef = new AssociationRef(associationRef.getId(), sourceReference.toNodeRef(), associationRef.getTypeQName(), targetRef);
                    materialAssocs.add(virtualAssocRef);
                }
            }
            return materialAssocs;
        }
        return theTrait.getSourceAssocs(targetRef, qnamePattern);
    }

    public ChildAssociationRef moveNode(NodeRef nodeToMoveRef, NodeRef newParentRef, QName assocTypeQName, QName assocQName) {
        if (Reference.fromNodeRef(nodeToMoveRef) != null || Reference.fromNodeRef(newParentRef) != null) {
            throw new UnsupportedOperationException("Unsuported operation for virtual source or destination");
        }
        return ((NodeServiceTrait)this.getTrait()).moveNode(nodeToMoveRef, newParentRef, assocTypeQName, assocQName);
    }

    public void addProperties(NodeRef nodeRef, Map<QName, Serializable> properties) {
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            NodeRef actualNodeRef = reference.execute(new GetActualNodeRefMethod(null));
            ((NodeServiceTrait)this.getTrait()).addProperties(actualNodeRef, properties);
        } else {
            ((NodeServiceTrait)this.getTrait()).addProperties(nodeRef, properties);
        }
    }

    public AssociationRef createAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) {
        Reference targetReference = Reference.fromNodeRef(targetRef);
        if (targetReference != null && ((NodeServiceTrait)this.getTrait()).getType(this.materializeIfPossible(sourceRef)).equals((Object)DownloadModel.TYPE_DOWNLOAD)) {
            this.createDownloadAssociation(sourceRef, targetRef);
            AssociationRef assocRef = new AssociationRef(sourceRef, assocTypeQName, targetRef);
            return assocRef;
        }
        return ((NodeServiceTrait)this.getTrait()).createAssociation(this.materializeIfPossible(sourceRef), this.materializeIfPossible(targetRef), assocTypeQName);
    }

    private List<NodeRef> materializeIfPossible(Collection<NodeRef> nodeRefs) {
        LinkedList<NodeRef> nodeRefList = new LinkedList<NodeRef>();
        for (NodeRef nodeRef : nodeRefs) {
            nodeRefList.add(this.materializeIfPossible(nodeRef));
        }
        return nodeRefList;
    }

    private NodeRef materializeIfPossible(NodeRef nodeRef) {
        Reference ref = Reference.fromNodeRef(nodeRef);
        if (ref != null && this.smartStore.canMaterialize(ref)) {
            return this.smartStore.materialize(ref);
        }
        return nodeRef;
    }

    public List<StoreRef> getStores() {
        return ((NodeServiceTrait)this.getTrait()).getStores();
    }

    public StoreRef createStore(String protocol, String identifier) throws StoreExistsException {
        return ((NodeServiceTrait)this.getTrait()).createStore(protocol, identifier);
    }

    public void deleteStore(StoreRef storeRef) {
        ((NodeServiceTrait)this.getTrait()).deleteStore(storeRef);
    }

    public boolean exists(StoreRef storeRef) {
        return ((NodeServiceTrait)this.getTrait()).exists(storeRef);
    }

    public NodeRef.Status getNodeStatus(NodeRef nodeRef) {
        return ((NodeServiceTrait)this.getTrait()).getNodeStatus(this.materializeIfPossible(nodeRef));
    }

    public NodeRef getNodeRef(Long nodeId) {
        return ((NodeServiceTrait)this.getTrait()).getNodeRef(nodeId);
    }

    public List<NodeRef> getNodeRefs(List<Long> nodeIds) {
        return ((NodeServiceTrait)this.getTrait()).getNodeRefs(nodeIds);
    }

    public NodeRef getRootNode(StoreRef storeRef) throws InvalidStoreRefException {
        return ((NodeServiceTrait)this.getTrait()).getRootNode(storeRef);
    }

    public Set<NodeRef> getAllRootNodes(StoreRef storeRef) {
        return ((NodeServiceTrait)this.getTrait()).getAllRootNodes(storeRef);
    }

    public void setChildAssociationIndex(ChildAssociationRef childAssocRef, int index) throws InvalidChildAssociationRefException {
        ((NodeServiceTrait)this.getTrait()).setChildAssociationIndex(childAssocRef, index);
    }

    public void setType(NodeRef nodeRef, QName typeQName) throws InvalidNodeRefException {
        ((NodeServiceTrait)this.getTrait()).setType(this.materializeIfPossible(nodeRef), typeQName);
    }

    public void addAspect(NodeRef nodeRef, QName aspectTypeQName, Map<QName, Serializable> aspectProperties) throws InvalidNodeRefException, InvalidAspectException {
        ((NodeServiceTrait)this.getTrait()).addAspect(this.materializeIfPossible(nodeRef), aspectTypeQName, aspectProperties);
    }

    public void removeAspect(NodeRef nodeRef, QName aspectTypeQName) throws InvalidNodeRefException, InvalidAspectException {
        ((NodeServiceTrait)this.getTrait()).removeAspect(this.materializeIfPossible(nodeRef), aspectTypeQName);
    }

    public void deleteNode(NodeRef nodeRef) throws InvalidNodeRefException {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        NodeRef materialNode = this.smartStore.materializeIfPossible(nodeRef);
        boolean isDownload = DownloadModel.TYPE_DOWNLOAD.equals((Object)theTrait.getType(materialNode));
        theTrait.deleteNode(materialNode);
        if (isDownload) {
            this.cleanUpDownloadTargetAssocs(nodeRef);
        }
    }

    public ChildAssociationRef addChild(NodeRef parentRef, NodeRef childRef, QName assocTypeQName, QName qname) throws InvalidNodeRefException {
        return ((NodeServiceTrait)this.getTrait()).addChild(this.materializeIfPossible(parentRef), this.materializeIfPossible(childRef), assocTypeQName, qname);
    }

    public List<ChildAssociationRef> addChild(Collection<NodeRef> parentRefs, NodeRef childRef, QName assocTypeQName, QName qname) throws InvalidNodeRefException {
        return ((NodeServiceTrait)this.getTrait()).addChild(this.materializeIfPossible(parentRefs), this.materializeIfPossible(childRef), assocTypeQName, qname);
    }

    public void removeChild(NodeRef parentRef, NodeRef childRef) throws InvalidNodeRefException {
        ((NodeServiceTrait)this.getTrait()).removeChild(this.materializeIfPossible(parentRef), this.materializeIfPossible(childRef));
    }

    public boolean removeChildAssociation(ChildAssociationRef childAssocRef) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        NodeRef childRef = childAssocRef.getChildRef();
        if (Reference.fromNodeRef(childRef) != null) {
            List<ChildAssociationRef> assocsToRemove = this.revertVirtualAssociation(childAssocRef, theTrait, childRef);
            boolean removed = false;
            if (!assocsToRemove.isEmpty()) {
                for (ChildAssociationRef assoc : assocsToRemove) {
                    boolean bl = removed = removed || theTrait.removeChildAssociation(assoc);
                }
            }
            return removed;
        }
        return theTrait.removeChildAssociation(childAssocRef);
    }

    private List<ChildAssociationRef> revertVirtualAssociation(ChildAssociationRef childAssocRef, NodeServiceTrait theTrait, NodeRef childRef) {
        childRef = this.smartStore.materialize(Reference.fromNodeRef(childRef));
        ChildAssociationRef parent = theTrait.getPrimaryParent(childRef);
        final QName assocName = childAssocRef.getQName();
        List assocsToRemove = theTrait.getChildAssocs(parent.getParentRef(), (QNamePattern)childAssocRef.getTypeQName(), new QNamePattern(){

            public boolean isMatch(QName qname) {
                return assocName.getLocalName().equals(qname.getLocalName());
            }
        });
        return assocsToRemove;
    }

    public boolean removeSeconaryChildAssociation(ChildAssociationRef childAssocRef) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        NodeRef childRef = childAssocRef.getChildRef();
        if (Reference.fromNodeRef(childRef) != null) {
            List<ChildAssociationRef> assocsToRemove = this.revertVirtualAssociation(childAssocRef, theTrait, childRef);
            boolean removed = false;
            if (!assocsToRemove.isEmpty()) {
                for (ChildAssociationRef assoc : assocsToRemove) {
                    boolean bl = removed = removed || theTrait.removeSeconaryChildAssociation(assoc);
                }
            }
            return removed;
        }
        return theTrait.removeSeconaryChildAssociation(childAssocRef);
    }

    public boolean removeSecondaryChildAssociation(ChildAssociationRef childAssocRef) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        NodeRef childRef = childAssocRef.getChildRef();
        if (Reference.fromNodeRef(childRef) != null) {
            List<ChildAssociationRef> assocsToRemove = this.revertVirtualAssociation(childAssocRef, theTrait, childRef);
            boolean removed = false;
            if (!assocsToRemove.isEmpty()) {
                for (ChildAssociationRef assoc : assocsToRemove) {
                    boolean bl = removed = removed || theTrait.removeSecondaryChildAssociation(assoc);
                }
            }
            return removed;
        }
        return theTrait.removeSecondaryChildAssociation(childAssocRef);
    }

    public Long getNodeAclId(NodeRef nodeRef) throws InvalidNodeRefException {
        return ((NodeServiceTrait)this.getTrait()).getNodeAclId(this.materializeIfPossible(nodeRef));
    }

    public void setProperties(NodeRef nodeRef, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        ((NodeServiceTrait)this.getTrait()).setProperties(this.materializeIfPossible(nodeRef), properties);
    }

    public void setProperty(NodeRef nodeRef, QName qname, Serializable value) throws InvalidNodeRefException {
        ((NodeServiceTrait)this.getTrait()).setProperty(this.materializeIfPossible(nodeRef), qname, value);
    }

    public void removeProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        ((NodeServiceTrait)this.getTrait()).removeProperty(this.materializeIfPossible(nodeRef), qname);
    }

    public List<ChildAssociationRef> getChildrenByName(NodeRef nodeRef, QName assocTypeQName, Collection<String> childNames) {
        return ((NodeServiceTrait)this.getTrait()).getChildrenByName(this.materializeIfPossible(nodeRef), assocTypeQName, childNames);
    }

    public Collection<ChildAssociationRef> getChildAssocsWithoutParentAssocsOfType(NodeRef nodeRef, QName assocTypeQName) {
        NodeServiceTrait theTrait = (NodeServiceTrait)this.getTrait();
        boolean canVirtualize = this.canVirtualizeAssocNodeRef(nodeRef);
        if (canVirtualize) {
            Reference reference = this.smartStore.virtualize(nodeRef);
            Collection<ChildAssociationRef> virtualAssociations = this.smartStore.getChildAssocsWithoutParentAssocsOfType(reference, assocTypeQName);
            LinkedList<ChildAssociationRef> associations = new LinkedList<ChildAssociationRef>(virtualAssociations);
            if (this.smartStore.canMaterialize(reference)) {
                NodeRef materialReference = this.smartStore.materialize(reference);
                Collection actualAssociations = theTrait.getChildAssocsWithoutParentAssocsOfType(materialReference, assocTypeQName);
                associations.addAll(actualAssociations);
            }
            return associations;
        }
        return theTrait.getChildAssocsWithoutParentAssocsOfType(nodeRef, assocTypeQName);
    }

    public List<String> findAssocsNotLinkedByTwoOtherAssocs(NodeRef nodeRef) {
        return ((NodeServiceTrait)this.getTrait()).findAssocsNotLinkedByTwoOtherAssocs(nodeRef);
    }

    public void removeAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) throws InvalidNodeRefException {
        ((NodeServiceTrait)this.getTrait()).removeAssociation(this.materializeIfPossible(sourceRef), this.materializeIfPossible(targetRef), assocTypeQName);
    }

    public void setAssociations(NodeRef sourceRef, QName assocTypeQName, List<NodeRef> targetRefs) {
        ((NodeServiceTrait)this.getTrait()).setAssociations(this.materializeIfPossible(sourceRef), assocTypeQName, this.materializeIfPossible(targetRefs));
    }

    public AssociationRef getAssoc(Long id) {
        return ((NodeServiceTrait)this.getTrait()).getAssoc(id);
    }

    public NodeRef getStoreArchiveNode(StoreRef storeRef) {
        return ((NodeServiceTrait)this.getTrait()).getStoreArchiveNode(storeRef);
    }

    public NodeRef restoreNode(NodeRef archivedNodeRef, NodeRef destinationParentNodeRef, QName assocTypeQName, QName assocQName) {
        return ((NodeServiceTrait)this.getTrait()).restoreNode(this.materializeIfPossible(archivedNodeRef), this.materializeIfPossible(destinationParentNodeRef), assocTypeQName, assocQName);
    }

    public List<NodeRef> findNodes(NodeService.FindNodeParameters params) {
        return ((NodeServiceTrait)this.getTrait()).findNodes(params);
    }

    public int countChildAssocs(NodeRef nodeRef, boolean isPrimary) throws InvalidNodeRefException {
        return ((NodeServiceTrait)this.getTrait()).countChildAssocs(nodeRef, isPrimary);
    }

    public List<AssociationRef> getTargetAssocsByPropertyValue(NodeRef sourceRef, QNamePattern qnamePattern, QName propertyQName, Serializable propertyValue) {
        return ((NodeServiceTrait)this.getTrait()).getTargetAssocsByPropertyValue(sourceRef, qnamePattern, propertyQName, propertyValue);
    }
}

