/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.util.concurrent.TimeUnit;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.adapters.config.AdapterHttpClientConfig;
import org.springframework.beans.factory.FactoryBean;

public class IdentityServiceDeploymentFactoryBean
implements FactoryBean<KeycloakDeployment> {
    private static Log logger = LogFactory.getLog(IdentityServiceDeploymentFactoryBean.class);
    private IdentityServiceConfig identityServiceConfig;

    public void setIdentityServiceConfig(IdentityServiceConfig config) {
        this.identityServiceConfig = config;
    }

    public KeycloakDeployment getObject() throws Exception {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((AdapterConfig)this.identityServiceConfig);
        if (deployment.getClient() != null) {
            int connectionTimeout = this.identityServiceConfig.getClientConnectionTimeout();
            int socketTimeout = this.identityServiceConfig.getClientSocketTimeout();
            HttpClient client = new HttpClientBuilder().establishConnectionTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS).socketTimeout((long)socketTimeout, TimeUnit.MILLISECONDS).build((AdapterHttpClientConfig)this.identityServiceConfig);
            deployment.setClient(client);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created HttpClient for Keycloak deployment with connection timeout: " + connectionTimeout + " ms, socket timeout: " + socketTimeout + " ms."));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"HttpClient for Keycloak deployment was not set.");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Keycloak JWKS URL: " + deployment.getJwksUrl()));
            logger.info((Object)("Keycloak Realm: " + deployment.getRealm()));
            logger.info((Object)("Keycloak Client ID: " + deployment.getResourceName()));
        }
        return deployment;
    }

    public Class<KeycloakDeployment> getObjectType() {
        return KeycloakDeployment.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

