/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.LocalTransform;
import org.alfresco.repo.content.transform.LocalTransformServiceRegistry;
import org.alfresco.repo.content.transform.UnsupportedTransformationException;
import org.alfresco.repo.rendition2.LocalTransformClient;
import org.alfresco.repo.rendition2.SynchronousTransformClient;
import org.alfresco.repo.rendition2.TransformDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.transform.client.model.config.CoreFunction;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class LocalSynchronousTransformClient
implements SynchronousTransformClient,
InitializingBean {
    private static final String TRANSFORM = "Local synchronous transform ";
    private static Log logger = LogFactory.getLog(LocalTransformClient.class);
    private LocalTransformServiceRegistry localTransformServiceRegistry;
    private ContentService contentService;
    private boolean directAccessUrlEnabled;

    public void setLocalTransformServiceRegistry(LocalTransformServiceRegistry localTransformServiceRegistry) {
        this.localTransformServiceRegistry = localTransformServiceRegistry;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDirectAccessUrlEnabled(boolean directAccessUrlEnabled) {
        this.directAccessUrlEnabled = directAccessUrlEnabled;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"localTransformServiceRegistry", (Object)((Object)this.localTransformServiceRegistry));
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
        PropertyCheck.mandatory((Object)this, (String)"transformDirectAccessUrlEnabled", (Object)this.directAccessUrlEnabled);
    }

    @Override
    public boolean isSupported(String sourceMimetype, long sourceSizeInBytes, String contentUrl, String targetMimetype, Map<String, String> actualOptions, String transformName, NodeRef sourceNodeRef) {
        String renditionName = TransformDefinition.convertToRenditionName(transformName);
        LocalTransform transform = this.localTransformServiceRegistry.getLocalTransform(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, renditionName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(TRANSFORM + renditionName + " from " + sourceMimetype + (transform == null ? " is unsupported" : " is supported")));
        }
        return transform != null;
    }

    @Override
    public void transform(ContentReader reader, ContentWriter writer, Map<String, String> actualOptions, String transformName, NodeRef sourceNodeRef) {
        String renditionName = TransformDefinition.convertToRenditionName(transformName);
        try {
            if (reader == null) {
                throw new IllegalArgumentException("The content reader must be set");
            }
            if (!reader.exists()) {
                throw new IllegalArgumentException("sourceNodeRef " + sourceNodeRef + " has no content.");
            }
            String sourceMimetype = reader.getMimetype();
            long sourceSizeInBytes = reader.getSize();
            if (sourceMimetype == null) {
                throw new IllegalArgumentException("The content reader mimetype must be set");
            }
            String targetMimetype = writer.getMimetype();
            if (targetMimetype == null) {
                throw new IllegalArgumentException("The content writer mimetype must be set");
            }
            LocalTransform transform = this.localTransformServiceRegistry.getLocalTransform(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, renditionName);
            if (transform == null) {
                throw new UnsupportedTransformationException("Transformation of " + sourceMimetype + (sourceSizeInBytes > 0L ? " size " + sourceSizeInBytes : "") + " to " + targetMimetype + " unsupported");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Local synchronous transform requested " + renditionName));
            }
            actualOptions = this.addDirectAccessUrlToOptionsIfPossible(actualOptions, sourceNodeRef, transform);
            transform.transform(reader, writer, actualOptions, renditionName, sourceNodeRef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Local synchronous transform created " + renditionName));
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Local synchronous transform failed " + renditionName), (Throwable)e);
            }
            throw e;
        }
    }

    private Map<String, String> addDirectAccessUrlToOptionsIfPossible(Map<String, String> actualOptions, NodeRef sourceNodeRef, LocalTransform transform) {
        if (this.directAccessUrlEnabled && this.localTransformServiceRegistry.isSupported(CoreFunction.DIRECT_ACCESS_URL, transform) && this.contentService.isContentDirectUrlEnabled(sourceNodeRef, ContentModel.PROP_CONTENT)) {
            DirectAccessUrl directAccessUrl = this.contentService.requestContentDirectUrl(sourceNodeRef, ContentModel.PROP_CONTENT, true);
            actualOptions = new HashMap<String, String>(actualOptions);
            actualOptions.put("directAccessUrl", directAccessUrl.getContentUrl());
        }
        return actualOptions;
    }

    @Override
    public String getName() {
        return "Local";
    }
}

