/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server.impl.subetha;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.alfresco.service.cmr.email.EmailMessageException;
import org.alfresco.service.cmr.email.EmailMessagePart;
import org.alfresco.util.remote.RemotableInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class SubethaEmailMessagePart
implements EmailMessagePart {
    private static final String ERR_UNSUPPORTED_ENCODING = "email.server.err.usupported_encoding";
    private static final String ERR_FAILED_TO_READ_CONTENT_STREAM = "email.server.err.failed_to_read_content_stream";
    private static final String ERR_INCORRECT_MESSAGE_PART = "email.server.err.incorrect_message_part";
    private static final long serialVersionUID = -8530238872199733096L;
    static final Log log = LogFactory.getLog(SubethaEmailMessagePart.class);
    private static final Pattern encodingExtractor = Pattern.compile("charset\\s*=[\\s\"]*([^\";\\s]*)");
    private String encoding;
    private String fileName;
    private int fileSize = -1;
    private String contentType;
    private InputStream contentInputStream;
    private String rmiRegistryHost;
    private int rmiRegistryPort;

    protected SubethaEmailMessagePart() {
    }

    public SubethaEmailMessagePart(Part messagePart) {
        ParameterCheck.mandatory((String)"messagePart", (Object)messagePart);
        try {
            this.fileSize = messagePart.getSize();
            this.fileName = messagePart.getFileName();
            this.contentType = messagePart.getContentType();
            Matcher matcher = encodingExtractor.matcher(this.contentType);
            if (matcher.find()) {
                this.encoding = matcher.group(1);
                if (!Charset.isSupported(this.encoding)) {
                    throw new EmailMessageException(ERR_UNSUPPORTED_ENCODING, this.encoding);
                }
            }
            try {
                this.contentInputStream = messagePart.getInputStream();
            }
            catch (Exception ex) {
                throw new EmailMessageException(ERR_FAILED_TO_READ_CONTENT_STREAM, ex.getMessage());
            }
        }
        catch (MessagingException e) {
            throw new EmailMessageException(ERR_INCORRECT_MESSAGE_PART, e.getMessage());
        }
    }

    public SubethaEmailMessagePart(Part messagePart, String fileName) {
        this(messagePart);
        this.fileName = fileName;
    }

    @Override
    public InputStream getContent() {
        return this.contentInputStream;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getSize() {
        return this.fileSize;
    }

    public void setRmiRegistry(String rmiRegistryHost, int rmiRegistryPort) {
        this.rmiRegistryHost = rmiRegistryHost;
        this.rmiRegistryPort = rmiRegistryPort;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.contentInputStream = new RemotableInputStream(this.rmiRegistryHost, this.rmiRegistryPort, this.contentInputStream);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

