/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.net.ConnectException;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceAuthenticationComponent;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.util.HttpResponseException;
import org.keycloak.representations.AccessTokenResponse;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class IdentityServiceAuthenticationComponentTest
extends BaseSpringTest {
    private final IdentityServiceAuthenticationComponent authComponent = new IdentityServiceAuthenticationComponent();
    @Autowired
    private AuthenticationContext authenticationContext;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UserRegistrySynchronizer userRegistrySynchronizer;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private PersonService personService;
    private AuthzClient mockAuthzClient;

    @Before
    public void setUp() {
        this.authComponent.setAuthenticationContext(this.authenticationContext);
        this.authComponent.setTransactionService(this.transactionService);
        this.authComponent.setUserRegistrySynchronizer(this.userRegistrySynchronizer);
        this.authComponent.setNodeService(this.nodeService);
        this.authComponent.setPersonService(this.personService);
        this.mockAuthzClient = (AuthzClient)Mockito.mock(AuthzClient.class);
        this.authComponent.setAuthenticatorAuthzClient(this.mockAuthzClient);
    }

    @After
    public void tearDown() {
        this.authenticationContext.clearCurrentSecurityContext();
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticationFail() {
        Mockito.when((Object)this.mockAuthzClient.obtainAccessToken("username", "password")).thenThrow(new Throwable[]{new HttpResponseException("Unauthorized", 401, "Unauthorized", null)});
        this.authComponent.authenticateImpl("username", "password".toCharArray());
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticationFail_connectionException() {
        Mockito.when((Object)this.mockAuthzClient.obtainAccessToken("username", "password")).thenThrow(new Throwable[]{new RuntimeException("Couldn't connect to server", new ConnectException("ConnectionRefused"))});
        try {
            this.authComponent.authenticateImpl("username", "password".toCharArray());
        }
        catch (RuntimeException ex) {
            Throwable cause = ExceptionStackUtil.getCause((Throwable)ex, (Class[])new Class[]{ConnectException.class});
            IdentityServiceAuthenticationComponentTest.assertNotNull((Object)cause);
            throw ex;
        }
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticationFail_otherException() {
        Mockito.when((Object)this.mockAuthzClient.obtainAccessToken("username", "password")).thenThrow(new Throwable[]{new RuntimeException("Some other errors!")});
        this.authComponent.authenticateImpl("username", "password".toCharArray());
    }

    @Test
    public void testAuthenticationPass() {
        Mockito.when((Object)this.mockAuthzClient.obtainAccessToken("username", "password")).thenReturn((Object)new AccessTokenResponse());
        this.authComponent.authenticateImpl("username", "password".toCharArray());
        IdentityServiceAuthenticationComponentTest.assertEquals((String)"User has not been set as expected.", (String)"username", (String)this.authenticationContext.getCurrentUserName());
    }

    @Test(expected=AuthenticationException.class)
    public void testFallthroughWhenAuthzClientIsNull() {
        this.authComponent.setAuthenticatorAuthzClient(null);
        this.authComponent.authenticateImpl("username", "password".toCharArray());
    }

    @Test
    public void testSettingAllowGuestUser() {
        this.authComponent.setAllowGuestLogin(true);
        IdentityServiceAuthenticationComponentTest.assertTrue((boolean)this.authComponent.guestUserAuthenticationAllowed());
        this.authComponent.setAllowGuestLogin(false);
        IdentityServiceAuthenticationComponentTest.assertFalse((boolean)this.authComponent.guestUserAuthenticationAllowed());
    }
}

