/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.rule.BaseRuleTest;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CyclicChildRelationshipException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleType;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.test.annotation.Commit;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class RuleServiceImplTest
extends BaseRuleTest {
    private String ASSOC_NAME_RULES_PREFIX = "rules";
    private RegexQNamePattern ASSOC_NAME_RULES_REGEX = new RegexQNamePattern("http://www.alfresco.org/model/rule/1.0", "^" + this.ASSOC_NAME_RULES_PREFIX + ".*");
    MutableAuthenticationService authenticationService;
    PermissionService permissionService;
    SearchService searchService;
    NamespaceService namespaceService;
    FileFolderService fileFolderService;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.searchService = (SearchService)this.applicationContext.getBean("SearchService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("NamespaceService");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("FileFolderService");
    }

    @Test
    public void testGetRuleType() {
        List ruleTypes = this.ruleService.getRuleTypes();
        RuleServiceImplTest.assertNotNull((Object)ruleTypes);
        for (RuleType type : ruleTypes) {
            System.out.println(type.getDisplayLabel());
        }
    }

    @Test
    public void testAddRule() {
        Rule newRule = this.createTestRule();
        RuleServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(this.nodeRef, RuleModel.ASPECT_RULES));
        this.ruleService.saveRule(this.nodeRef, newRule);
        RuleServiceImplTest.assertNotNull((Object)newRule.getNodeRef());
        RuleServiceImplTest.assertNotNull((Object)this.ruleService.getOwningNodeRef(newRule));
        RuleServiceImplTest.assertEquals((Object)this.nodeRef, (Object)this.ruleService.getOwningNodeRef(newRule));
        RuleServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(this.nodeRef, RuleModel.ASPECT_RULES));
        Rule savedRule = this.ruleService.getRule(newRule.getNodeRef());
        RuleServiceImplTest.assertNotNull((Object)savedRule);
        RuleServiceImplTest.assertFalse((boolean)savedRule.isAppliedToChildren());
        savedRule.applyToChildren(true);
        this.ruleService.saveRule(this.nodeRef, savedRule);
        Rule savedRule2 = this.ruleService.getRule(savedRule.getNodeRef());
        RuleServiceImplTest.assertNotNull((Object)savedRule2);
        RuleServiceImplTest.assertTrue((boolean)savedRule2.isAppliedToChildren());
    }

    @Test
    public void testRemoveRule() {
        this.ruleService.removeAllRules(this.nodeRef);
        List rules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)rules);
        RuleServiceImplTest.assertEquals((int)0, (int)rules.size());
        RuleServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(this.nodeRef, RuleModel.ASPECT_RULES));
        Rule newRule = this.createTestRule();
        this.ruleService.saveRule(this.nodeRef, newRule);
        rules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)rules);
        RuleServiceImplTest.assertEquals((int)1, (int)rules.size());
        RuleServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(this.nodeRef, RuleModel.ASPECT_RULES));
        this.ruleService.removeRule(this.nodeRef, newRule);
        rules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)rules);
        RuleServiceImplTest.assertEquals((int)0, (int)rules.size());
        RuleServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(this.nodeRef, RuleModel.ASPECT_RULES));
        Rule newRule2 = this.createTestRule();
        this.ruleService.saveRule(this.nodeRef, newRule2);
        Rule newRule3 = this.createTestRule();
        this.ruleService.saveRule(this.nodeRef, newRule3);
        rules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)rules);
        RuleServiceImplTest.assertEquals((int)2, (int)rules.size());
        RuleServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(this.nodeRef, RuleModel.ASPECT_RULES));
        this.ruleService.removeRule(this.nodeRef, newRule3);
        rules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)rules);
        RuleServiceImplTest.assertEquals((int)1, (int)rules.size());
        RuleServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(this.nodeRef, RuleModel.ASPECT_RULES));
        this.ruleService.removeRule(this.nodeRef, newRule2);
        rules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)rules);
        RuleServiceImplTest.assertEquals((int)0, (int)rules.size());
        RuleServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(this.nodeRef, RuleModel.ASPECT_RULES));
    }

    @Test
    public void testRemoveAllRules() {
        this.ruleService.removeAllRules(this.nodeRef);
        List rules1 = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)rules1);
        RuleServiceImplTest.assertEquals((int)0, (int)rules1.size());
        Rule newRule = this.createTestRule();
        this.ruleService.saveRule(this.nodeRef, newRule);
        Rule newRule2 = this.createTestRule();
        this.ruleService.saveRule(this.nodeRef, newRule2);
        List rules2 = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)rules2);
        RuleServiceImplTest.assertEquals((int)2, (int)rules2.size());
        RuleServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(this.nodeRef, RuleModel.ASPECT_RULES));
        this.ruleService.removeAllRules(this.nodeRef);
        List rules3 = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)rules3);
        RuleServiceImplTest.assertEquals((int)0, (int)rules3.size());
        RuleServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(this.nodeRef, RuleModel.ASPECT_RULES));
    }

    @Test
    public void testGetRules() {
        List noRules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)noRules);
        RuleServiceImplTest.assertEquals((int)0, (int)noRules.size());
        List noRulesAfterCache = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)noRulesAfterCache);
        RuleServiceImplTest.assertEquals((int)0, (int)noRulesAfterCache.size());
        this.testAddRule();
        List rules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull((Object)rules);
        RuleServiceImplTest.assertEquals((int)1, (int)rules.size());
        Rule rule = (Rule)rules.get(0);
        RuleServiceImplTest.assertEquals((String)"title", (String)rule.getTitle());
        RuleServiceImplTest.assertEquals((String)"description", (String)rule.getDescription());
        RuleServiceImplTest.assertNotNull((Object)this.nodeService.getProperty(rule.getNodeRef(), ContentModel.PROP_CREATED));
        RuleServiceImplTest.assertNotNull((Object)this.nodeService.getProperty(rule.getNodeRef(), ContentModel.PROP_CREATOR));
        Action action = rule.getAction();
        RuleServiceImplTest.assertNotNull((Object)action);
        List conditions = action.getActionConditions();
        RuleServiceImplTest.assertNotNull((Object)conditions);
        RuleServiceImplTest.assertEquals((int)1, (int)conditions.size());
    }

    @Test
    public void testGetRulesOrder() {
        int index = 0;
        while (index < 10) {
            Rule newRule = this.createTestRule(true, Integer.toString(index));
            this.ruleService.saveRule(this.nodeRef, newRule);
            ++index;
        }
        List rules = this.ruleService.getRules(this.nodeRef);
        int index2 = 0;
        for (Rule rule : rules) {
            RuleServiceImplTest.assertEquals((String)Integer.toString(index2), (String)rule.getTitle());
            ++index2;
        }
        NodeRef level1 = this.createNewNode(this.nodeRef);
        int index22 = 10;
        while (index22 < 20) {
            Rule newRule = this.createTestRule(true, Integer.toString(index22));
            this.ruleService.saveRule(level1, newRule);
            ++index22;
        }
        List rules2 = this.ruleService.getRules(level1);
        int index23 = 0;
        for (Rule rule : rules2) {
            RuleServiceImplTest.assertEquals((String)Integer.toString(index23), (String)rule.getTitle());
            ++index23;
        }
        NodeRef level2 = this.createNewNode(level1);
        int index3 = 20;
        while (index3 < 30) {
            Rule newRule = this.createTestRule(true, Integer.toString(index3));
            this.ruleService.saveRule(level2, newRule);
            ++index3;
        }
        List rules3 = this.ruleService.getRules(level2);
        int index32 = 0;
        for (Rule rule : rules3) {
            RuleServiceImplTest.assertEquals((String)Integer.toString(index32), (String)rule.getTitle());
            ++index32;
        }
        Rule rule1 = (Rule)rules3.get(2);
        rule1.setDescription("This has been changed");
        this.ruleService.saveRule(this.nodeRef, rule1);
        Rule rule2 = (Rule)rules3.get(12);
        rule2.setDescription("This has been changed");
        this.ruleService.saveRule(level1, rule2);
        Rule rule3 = (Rule)rules3.get(22);
        rule3.setDescription("This has been changed");
        this.ruleService.saveRule(level2, rule3);
        List rules4 = this.ruleService.getRules(level2);
        int index4 = 0;
        for (Rule rule : rules4) {
            RuleServiceImplTest.assertEquals((String)Integer.toString(index4), (String)rule.getTitle());
            ++index4;
        }
        NodeRef ruleFolder = ((RuntimeRuleService)this.ruleService).getSavedRuleFolderAssoc(this.nodeRef).getChildRef();
        if (ruleFolder != null) {
            List ruleChildAssocRefs = this.nodeService.getChildAssocs(ruleFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.ASSOC_NAME_RULES_REGEX);
            System.out.println("Association Nth Sibling values ...");
            for (ChildAssociationRef ruleChildAssocRef : ruleChildAssocRefs) {
                System.out.println(" - Assoc index = " + ruleChildAssocRef.getNthSibling() + ", name = " + this.nodeService.getProperty(ruleChildAssocRef.getChildRef(), ContentModel.PROP_TITLE));
            }
        }
        rules = this.ruleService.getRules(this.nodeRef);
        Rule rule = (Rule)rules.get(3);
        this.ruleService.setRulePosition(this.nodeRef, rule, 1);
        if (ruleFolder != null) {
            List ruleChildAssocRefs = this.nodeService.getChildAssocs(ruleFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.ASSOC_NAME_RULES_REGEX);
            System.out.println("After change of index ...");
            for (ChildAssociationRef ruleChildAssocRef : ruleChildAssocRefs) {
                System.out.println(" - Assoc index = " + ruleChildAssocRef.getNthSibling() + ", name = " + this.nodeService.getProperty(ruleChildAssocRef.getChildRef(), ContentModel.PROP_TITLE));
            }
        }
        ArrayList<NodeRef> ruleNodeRefs = new ArrayList<NodeRef>(rules.size());
        for (Rule tempRule : rules) {
            ruleNodeRefs.add(0, tempRule.getNodeRef());
        }
        Action action = this.actionService.createAction("reorder-rules");
        action.setParameterValue("rules", (Serializable)ruleNodeRefs);
        this.actionService.executeAction(action, this.nodeRef);
        List ruleChildAssocRefs = this.nodeService.getChildAssocs(ruleFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.ASSOC_NAME_RULES_REGEX);
        System.out.println("After execution of action ...");
        for (ChildAssociationRef ruleChildAssocRef : ruleChildAssocRefs) {
            System.out.println(" - Assoc index = " + ruleChildAssocRef.getNthSibling() + ", name = " + this.nodeService.getProperty(ruleChildAssocRef.getChildRef(), ContentModel.PROP_TITLE));
        }
    }

    @Test
    public void testIgnoreInheritedRules() {
        this.ruleService.saveRule(this.nodeRef, this.createTestRule(true, "rule1"));
        this.ruleService.saveRule(this.nodeRef, this.createTestRule(false, "rule2"));
        NodeRef nodeRef1 = this.createNewNode(this.nodeRef);
        this.ruleService.saveRule(nodeRef1, this.createTestRule(true, "rule3"));
        this.ruleService.saveRule(nodeRef1, this.createTestRule(false, "rule4"));
        NodeRef nodeRef2 = this.createNewNode(nodeRef1);
        this.ruleService.saveRule(nodeRef2, this.createTestRule(true, "rule5"));
        this.ruleService.saveRule(nodeRef2, this.createTestRule(false, "rule6"));
        this.nodeService.addAspect(nodeRef1, RuleModel.ASPECT_IGNORE_INHERITED_RULES, null);
        List rules1 = this.ruleService.getRules(nodeRef2);
        RuleServiceImplTest.assertNotNull((Object)rules1);
        RuleServiceImplTest.assertEquals((int)3, (int)rules1.size());
        RuleServiceImplTest.assertEquals((String)"rule3", (String)((Rule)rules1.get(0)).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule5", (String)((Rule)rules1.get(1)).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule6", (String)((Rule)rules1.get(2)).getTitle());
        this.nodeService.addAspect(nodeRef2, RuleModel.ASPECT_IGNORE_INHERITED_RULES, null);
        List rules2 = this.ruleService.getRules(nodeRef2);
        RuleServiceImplTest.assertNotNull((Object)rules2);
        RuleServiceImplTest.assertEquals((int)2, (int)rules2.size());
        RuleServiceImplTest.assertEquals((String)"rule5", (String)((Rule)rules2.get(0)).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule6", (String)((Rule)rules2.get(1)).getTitle());
        this.nodeService.removeAspect(nodeRef1, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        this.nodeService.removeAspect(nodeRef2, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        List rules3 = this.ruleService.getRules(nodeRef2);
        RuleServiceImplTest.assertNotNull((Object)rules3);
        RuleServiceImplTest.assertEquals((int)4, (int)rules3.size());
        RuleServiceImplTest.assertEquals((String)"rule1", (String)((Rule)rules3.get(0)).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule3", (String)((Rule)rules3.get(1)).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule5", (String)((Rule)rules3.get(2)).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule6", (String)((Rule)rules3.get(3)).getTitle());
    }

    @Test
    public void testRulesDisabled() {
        this.testAddRule();
        RuleServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(this.nodeRef));
        this.ruleService.disableRules(this.nodeRef);
        RuleServiceImplTest.assertFalse((boolean)this.ruleService.rulesEnabled(this.nodeRef));
        this.ruleService.enableRules(this.nodeRef);
        RuleServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(this.nodeRef));
    }

    private NodeRef createNewNode(NodeRef parent) {
        return this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTAINER).getChildRef();
    }

    @Test
    public void testRuleServicePermissionsConsumer() {
        this.authenticationService.createAuthentication("conUser", "password".toCharArray());
        this.permissionService.setPermission(this.nodeRef, "conUser", "Consumer", true);
        this.permissionService.setInheritParentPermissions(this.nodeRef, true);
        this.authenticationService.authenticate("conUser", "password".toCharArray());
        Rule rule = this.createTestRule();
        try {
            this.ruleService.saveRule(this.nodeRef, rule);
            RuleServiceImplTest.fail((String)"Consumers cannot create rules.");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testRuleServicePermissionsEditor() {
        this.authenticationService.createAuthentication("editorUser", "password".toCharArray());
        this.permissionService.setPermission(this.nodeRef, "editorUser", "Editor", true);
        this.permissionService.setInheritParentPermissions(this.nodeRef, true);
        this.authenticationService.authenticate("editorUser", "password".toCharArray());
        Rule rule = this.createTestRule();
        try {
            this.ruleService.saveRule(this.nodeRef, rule);
            RuleServiceImplTest.fail((String)"Editors cannot create rules.");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testRuleServicePermissionsCoordinator() {
        this.authenticationService.createAuthentication("coordUser", "password".toCharArray());
        this.permissionService.setPermission(this.nodeRef, "coordUser", "Coordinator", true);
        this.permissionService.setInheritParentPermissions(this.nodeRef, true);
        this.authenticationService.authenticate(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        Rule rule2 = this.createTestRule();
        this.ruleService.saveRule(this.nodeRef, rule2);
        this.authenticationService.clearCurrentSecurityContext();
    }

    @Test
    public void testRuleInheritance() {
        NodeRef rootWithRules = this.createNewNode(this.rootNodeRef);
        Rule rule1 = this.createTestRule();
        this.ruleService.saveRule(rootWithRules, rule1);
        Rule rule2 = this.createTestRule(true);
        this.ruleService.saveRule(rootWithRules, rule2);
        NodeRef nonActionableChild = this.createNewNode(rootWithRules);
        NodeRef childWithRules = this.createNewNode(nonActionableChild);
        Rule rule3 = this.createTestRule();
        this.ruleService.saveRule(childWithRules, rule3);
        Rule rule4 = this.createTestRule(true);
        this.ruleService.saveRule(childWithRules, rule4);
        NodeRef rootWithRules2 = this.createNewNode(this.rootNodeRef);
        this.nodeService.addChild(rootWithRules2, childWithRules, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"));
        Rule rule5 = this.createTestRule();
        this.ruleService.saveRule(rootWithRules2, rule5);
        Rule rule6 = this.createTestRule(true);
        this.ruleService.saveRule(rootWithRules2, rule6);
        List allRules = this.ruleService.getRules(childWithRules);
        RuleServiceImplTest.assertNotNull((Object)allRules);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules.size());
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule6));
        int count = 0;
        for (Rule rule : allRules) {
            NodeRef owningNodeRef = this.ruleService.getOwningNodeRef(rule);
            RuleServiceImplTest.assertNotNull((Object)owningNodeRef);
            if (!owningNodeRef.equals((Object)childWithRules)) continue;
            ++count;
        }
        RuleServiceImplTest.assertEquals((int)2, (int)count);
        List myRules = this.ruleService.getRules(childWithRules, false);
        RuleServiceImplTest.assertNotNull((Object)myRules);
        RuleServiceImplTest.assertEquals((int)2, (int)myRules.size());
        RuleServiceImplTest.assertTrue((boolean)myRules.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)myRules.contains(rule4));
        List allRules2 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull((Object)allRules2);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules2.size());
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule2));
        List myRules2 = this.ruleService.getRules(nonActionableChild, false);
        RuleServiceImplTest.assertNotNull((Object)myRules2);
        RuleServiceImplTest.assertEquals((int)0, (int)myRules2.size());
        List allRules3 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull((Object)allRules3);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules3.size());
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule2));
        List myRules3 = this.ruleService.getRules(rootWithRules, false);
        RuleServiceImplTest.assertNotNull((Object)myRules3);
        RuleServiceImplTest.assertEquals((int)2, (int)myRules3.size());
        RuleServiceImplTest.assertTrue((boolean)myRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)myRules3.contains(rule2));
        List allRules4 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull((Object)allRules4);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules4.size());
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule6));
        List myRules4 = this.ruleService.getRules(rootWithRules2, false);
        RuleServiceImplTest.assertNotNull((Object)myRules4);
        RuleServiceImplTest.assertEquals((int)2, (int)myRules4.size());
        RuleServiceImplTest.assertTrue((boolean)myRules4.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)myRules4.contains(rule6));
        Rule rule7 = this.createTestRule(true);
        this.ruleService.saveRule(rootWithRules, rule7);
        List allRules5 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull((Object)allRules5);
        RuleServiceImplTest.assertEquals((int)5, (int)allRules5.size());
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule6));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule7));
        List allRules6 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull((Object)allRules6);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules6.size());
        RuleServiceImplTest.assertTrue((boolean)allRules6.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules6.contains(rule7));
        List allRules7 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull((Object)allRules7);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules7.size());
        RuleServiceImplTest.assertTrue((boolean)allRules7.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules7.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules7.contains(rule7));
        List allRules8 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull((Object)allRules8);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules8.size());
        RuleServiceImplTest.assertTrue((boolean)allRules8.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules8.contains(rule6));
        this.ruleService.removeRule(rootWithRules, rule7);
        List allRules9 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull((Object)allRules9);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules9.size());
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule6));
        List allRules10 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull((Object)allRules10);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules10.size());
        RuleServiceImplTest.assertTrue((boolean)allRules10.contains(rule2));
        List allRules11 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull((Object)allRules11);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules11.size());
        RuleServiceImplTest.assertTrue((boolean)allRules11.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules11.contains(rule2));
        List allRules12 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull((Object)allRules12);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules12.size());
        RuleServiceImplTest.assertTrue((boolean)allRules12.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules12.contains(rule6));
        this.nodeService.removeChild(rootWithRules2, childWithRules);
        List allRules13 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull((Object)allRules13);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules13.size());
        RuleServiceImplTest.assertTrue((boolean)allRules13.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules13.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules13.contains(rule4));
        List allRules14 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull((Object)allRules14);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules14.size());
        RuleServiceImplTest.assertTrue((boolean)allRules14.contains(rule2));
        List allRules15 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull((Object)allRules15);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules15.size());
        RuleServiceImplTest.assertTrue((boolean)allRules15.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules15.contains(rule2));
        List allRules16 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull((Object)allRules16);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules16.size());
        RuleServiceImplTest.assertTrue((boolean)allRules16.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules16.contains(rule6));
        this.ruleService.disableRules(rootWithRules2);
        try {
            this.nodeService.addChild(rootWithRules2, childWithRules, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"));
        }
        finally {
            this.ruleService.enableRules(rootWithRules2);
        }
        List allRules17 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull((Object)allRules17);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules17.size());
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule6));
        List allRules18 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull((Object)allRules18);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules18.size());
        RuleServiceImplTest.assertTrue((boolean)allRules18.contains(rule2));
        List allRules19 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull((Object)allRules19);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules19.size());
        RuleServiceImplTest.assertTrue((boolean)allRules19.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules19.contains(rule2));
        List allRules20 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull((Object)allRules20);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules20.size());
        RuleServiceImplTest.assertTrue((boolean)allRules20.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules20.contains(rule6));
        this.nodeService.deleteNode(rootWithRules2);
        List allRules21 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull((Object)allRules21);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules21.size());
        RuleServiceImplTest.assertTrue((boolean)allRules21.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules21.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules21.contains(rule4));
        List allRules22 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull((Object)allRules22);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules22.size());
        RuleServiceImplTest.assertTrue((boolean)allRules22.contains(rule2));
        List allRules23 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull((Object)allRules23);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules23.size());
        RuleServiceImplTest.assertTrue((boolean)allRules23.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules23.contains(rule2));
    }

    @Test
    public void testCyclicGraphWithInheritedRules() throws Exception {
        NodeRef nodeRef1 = this.createNewNode(this.rootNodeRef);
        NodeRef nodeRef2 = this.createNewNode(nodeRef1);
        NodeRef nodeRef3 = this.createNewNode(nodeRef2);
        try {
            this.nodeService.addChild(nodeRef3, nodeRef1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}loop"));
            RuleServiceImplTest.fail((String)"Expected detection of cyclic relationship");
        }
        catch (CyclicChildRelationshipException cyclicChildRelationshipException) {}
        Rule rule1 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef1, rule1);
        Rule rule2 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef2, rule2);
        Rule rule3 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef3, rule3);
        List allRules1 = this.ruleService.getRules(nodeRef1, true);
        RuleServiceImplTest.assertNotNull((Object)allRules1);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules1.size());
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule3));
        List allRules2 = this.ruleService.getRules(nodeRef2, true);
        RuleServiceImplTest.assertNotNull((Object)allRules2);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules2.size());
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule3));
        List allRules3 = this.ruleService.getRules(nodeRef3, true);
        RuleServiceImplTest.assertNotNull((Object)allRules3);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules3.size());
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule3));
    }

    @Test
    public void testRuleDuplication() {
        NodeRef nodeRef1 = this.createNewNode(this.rootNodeRef);
        NodeRef nodeRef2 = this.createNewNode(nodeRef1);
        NodeRef nodeRef3 = this.createNewNode(nodeRef2);
        NodeRef nodeRef4 = this.createNewNode(nodeRef1);
        this.nodeService.addChild(nodeRef4, nodeRef3, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}test"));
        Rule rule1 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef1, rule1);
        Rule rule2 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef2, rule2);
        Rule rule3 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef3, rule3);
        Rule rule4 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef4, rule4);
        List allRules1 = this.ruleService.getRules(nodeRef1, true);
        RuleServiceImplTest.assertNotNull((Object)allRules1);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules1.size());
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule1));
        List allRules2 = this.ruleService.getRules(nodeRef2, true);
        RuleServiceImplTest.assertNotNull((Object)allRules2);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules2.size());
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule2));
        List allRules3 = this.ruleService.getRules(nodeRef3, true);
        RuleServiceImplTest.assertNotNull((Object)allRules3);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules3.size());
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule4));
        List allRules4 = this.ruleService.getRules(nodeRef4, true);
        RuleServiceImplTest.assertNotNull((Object)allRules4);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules4.size());
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule4));
    }

    @Test
    public void testCyclicRules() {
    }

    @Commit
    @Test
    public void testCyclicAsyncRules() throws Exception {
        NodeRef nodeRef = this.createNewNode(this.rootNodeRef);
        HashMap<String, String> conditionProps = new HashMap<String, String>();
        conditionProps.put("value", "*.jpg");
        HashMap<String, String> actionProps = new HashMap<String, String>();
        actionProps.put("mime-type", "image/gif");
        actionProps.put("destination-folder", (String)nodeRef);
        actionProps.put("assoc-type", (String)ContentModel.ASSOC_CHILDREN);
        actionProps.put("assoc-name", (String)ContentModel.ASSOC_CHILDREN);
        Rule rule = new Rule();
        rule.setRuleType(this.ruleType.getName());
        rule.setTitle("Convert from *.jpg to *.gif");
        rule.setExecuteAsynchronously(true);
        Action action = this.actionService.createAction("transform-image");
        action.setParameterValues(actionProps);
        ActionCondition actionCondition = this.actionService.createActionCondition("compare-property-value");
        actionCondition.setParameterValues(conditionProps);
        action.addActionCondition(actionCondition);
        rule.setAction(action);
        HashMap<String, String> conditionProps2 = new HashMap<String, String>();
        conditionProps2.put("value", "*.gif");
        HashMap<String, String> actionProps2 = new HashMap<String, String>();
        actionProps2.put("mime-type", "image/jpeg");
        actionProps2.put("destination-folder", (String)nodeRef);
        actionProps2.put("assoc-name", (String)ContentModel.ASSOC_CHILDREN);
        Rule rule2 = new Rule();
        rule2.setRuleType(this.ruleType.getName());
        rule2.setTitle("Convert from *.gif to *.jpg");
        rule2.setExecuteAsynchronously(true);
        Action action2 = this.actionService.createAction("transform-image");
        action2.setParameterValues(actionProps2);
        ActionCondition actionCondition2 = this.actionService.createActionCondition("compare-property-value");
        actionCondition2.setParameterValues(conditionProps2);
        action2.addActionCondition(actionCondition2);
        rule2.setAction(action2);
        this.ruleService.saveRule(nodeRef, rule);
        this.ruleService.saveRule(nodeRef, rule);
        NodeRef contentNode = this.nodeService.createNode(nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.setProperty(contentNode, ContentModel.PROP_NAME, (Serializable)((Object)"myFile.jpg"));
        File file = AbstractContentTransformerTest.loadQuickTestFile("jpg");
        ContentWriter writer = this.contentService.getWriter(contentNode, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("image/jpeg");
        writer.putContent(file);
    }

    @Test
    public void testDeleteSpaceWithExecuteScriptRule() throws Exception {
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() {
                NodeRef storeRootNodeRef = RuleServiceImplTest.this.nodeService.getRootNode(new StoreRef("workspace://SpacesStore"));
                NodeRef companyHomeNodeRef = (NodeRef)RuleServiceImplTest.this.searchService.selectNodes(storeRootNodeRef, "/app:company_home", null, (NamespacePrefixResolver)RuleServiceImplTest.this.namespaceService, false).get(0);
                RuleServiceImplTest.assertNotNull((String)"NodeRef company_home is null", (Object)companyHomeNodeRef);
                QName testFolderName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("ISSUE_ETWOTWO_738_" + System.currentTimeMillis()));
                ChildAssociationRef childAssocRef = RuleServiceImplTest.this.nodeService.createNode(companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, testFolderName, ContentModel.TYPE_FOLDER);
                NodeRef testFolderNodeRef = childAssocRef.getChildRef();
                NodeRef scriptRef = (NodeRef)RuleServiceImplTest.this.searchService.selectNodes(storeRootNodeRef, "/app:company_home/app:dictionary/app:scripts/cm:backup.js.sample", null, (NamespacePrefixResolver)RuleServiceImplTest.this.namespaceService, false).get(0);
                RuleServiceImplTest.assertNotNull((String)"NodeRef script is null", (Object)scriptRef);
                Rule rule = new Rule();
                rule.setRuleType("inbound");
                rule.setTitle("rule title " + System.currentTimeMillis());
                CompositeAction compositeAction = RuleServiceImplTest.this.actionService.createCompositeAction();
                rule.setAction((Action)compositeAction);
                ActionCondition condition = RuleServiceImplTest.this.actionService.createActionCondition("no-condition");
                condition.setParameterValues(new HashMap());
                condition.setInvertCondition(false);
                compositeAction.addActionCondition(condition);
                Action action = RuleServiceImplTest.this.actionService.createAction("script");
                HashMap<String, NodeRef> repoActionParams = new HashMap<String, NodeRef>();
                repoActionParams.put("script-ref", scriptRef);
                action.setParameterValues(repoActionParams);
                compositeAction.addAction(action);
                RuleServiceImplTest.this.ruleService.saveRule(testFolderNodeRef, rule);
                RuleServiceImplTest.this.nodeService.deleteNode(testFolderNodeRef);
                return null;
            }
        }, false, true);
    }

    @Test
    public void testPermissionsForPropagatedRules_ALF_8408() throws Exception {
        NodeRef parentNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef childNodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("childnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.deletePermissions(parentNodeRef);
        this.permissionService.setInheritParentPermissions(parentNodeRef, false);
        String username = "ruleTestUser" + GUID.generate();
        this.authenticationService.createAuthentication(username, "password".toCharArray());
        this.permissionService.deletePermissions(childNodeRef);
        this.permissionService.setInheritParentPermissions(childNodeRef, false);
        this.permissionService.setPermission(childNodeRef, username, "Contributor", true);
        Rule testRule = new Rule();
        testRule.setRuleTypes(Collections.singletonList("inbound"));
        testRule.setTitle("RuleServiceTest" + GUID.generate());
        testRule.setDescription("description");
        testRule.applyToChildren(true);
        Action action = this.actionService.createAction("add-features");
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        testRule.setAction(action);
        this.ruleService.saveRule(parentNodeRef, testRule);
        RuleServiceImplTest.assertNotNull((String)"Rule was not saved", (Object)testRule.getNodeRef());
        this.authenticationService.authenticate(username, "password".toCharArray());
        this.authenticationComponent.setCurrentUser(username);
        List rules = this.ruleService.getRules(childNodeRef, true, (String)testRule.getRuleTypes().get(0));
        RuleServiceImplTest.assertNotNull((String)"No rules found", (Object)rules);
        RuleServiceImplTest.assertTrue((String)"Created rule is not found", (boolean)new HashSet(rules).contains(testRule));
        NodeRef actionedUponNodeRef = this.nodeService.createNode(childNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("actioneduponnode" + GUID.generate())), ContentModel.TYPE_CONTENT).getChildRef();
        if (this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            this.nodeService.removeAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE);
        }
        ((RuntimeRuleService)this.ruleService).executeRule(testRule, actionedUponNodeRef, null);
        RuleServiceImplTest.assertTrue((String)"Rule was not executed", (boolean)this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE));
        if (this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            this.nodeService.removeAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE);
        }
        ((RuntimeRuleService)this.ruleService).addRulePendingExecution(parentNodeRef, actionedUponNodeRef, testRule);
        ((RuntimeRuleService)this.ruleService).executePendingRules();
        RuleServiceImplTest.assertTrue((String)"Pending rule was not executed", (boolean)this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE));
    }

    @Test
    public void testOutboundRuleTriggeredAfterRename1() throws Exception {
        String newName = "newName" + GUID.generate();
        NodeRef folder1NodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef folder2NodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        Rule testRule = new Rule();
        testRule.setRuleTypes(Collections.singletonList("outbound"));
        testRule.setTitle("RuleServiceTest" + GUID.generate());
        testRule.setDescription("description");
        testRule.applyToChildren(true);
        Action action = this.actionService.createAction("copy");
        action.setParameterValue("destination-folder", (Serializable)folder2NodeRef);
        testRule.setAction(action);
        this.ruleService.saveRule(folder1NodeRef, testRule);
        RuleServiceImplTest.assertNotNull((String)"Rule was not saved", (Object)testRule.getNodeRef());
        QName actionedQName = QName.createQName((String)("actioneduponnode" + GUID.generate()));
        NodeRef actionedUponNodeRef = this.nodeService.createNode(folder1NodeRef, ContentModel.ASSOC_CHILDREN, actionedQName, ContentModel.TYPE_CONTENT).getChildRef();
        ContentWriter writer = this.contentService.getWriter(actionedUponNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.putContent("TestContent");
        this.fileFolderService.rename(actionedUponNodeRef, newName);
        List childAssoc = this.nodeService.getChildAssocs(folder2NodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)actionedQName);
        RuleServiceImplTest.assertEquals((String)"The rule should not be triggered and no document should be present.", (int)0, (int)childAssoc.size());
        childAssoc = this.nodeService.getChildAssocs(folder1NodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)newName));
        RuleServiceImplTest.assertEquals((String)"The rule should not be triggered and the document should be in folder1.", (int)1, (int)childAssoc.size());
        this.nodeService.deleteNode(folder1NodeRef);
        this.nodeService.deleteNode(folder2NodeRef);
    }

    @Test
    public void testOutboundRuleTriggeredAfterRename2() throws Exception {
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        String newName = "newName" + GUID.generate();
        NodeRef folder1NodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef folder2NodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        Rule testRule = new Rule();
        testRule.setRuleTypes(Collections.singletonList("outbound"));
        testRule.setTitle("RuleServiceTest" + GUID.generate());
        testRule.setDescription("description");
        testRule.applyToChildren(true);
        Action action = this.actionService.createAction("copy");
        action.setParameterValue("destination-folder", (Serializable)folder2NodeRef);
        testRule.setAction(action);
        this.ruleService.saveRule(folder1NodeRef, testRule);
        RuleServiceImplTest.assertNotNull((String)"Rule was not saved", (Object)testRule.getNodeRef());
        QName actionedQName = QName.createQName((String)("actioneduponnode" + GUID.generate()));
        NodeRef actionedUponNodeRef = this.nodeService.createNode(folder1NodeRef, ContentModel.ASSOC_CHILDREN, actionedQName, ContentModel.TYPE_CONTENT).getChildRef();
        ContentWriter writer = this.contentService.getWriter(actionedUponNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.putContent("TestContent");
        this.nodeService.setProperty(actionedUponNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)newName));
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        List childAssoc = this.nodeService.getChildAssocs(folder2NodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)actionedQName);
        RuleServiceImplTest.assertEquals((String)"The rule should not be triggered and no document should be present.", (int)0, (int)childAssoc.size());
        childAssoc = this.nodeService.getChildAssocs(folder1NodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)actionedQName);
        RuleServiceImplTest.assertEquals((String)"The rule should not be triggered and the document should be in folder1.", (int)1, (int)childAssoc.size());
        RuleServiceImplTest.assertEquals((String)"The node should be renamed.", (Object)newName, (Object)this.nodeService.getProperty(actionedUponNodeRef, ContentModel.PROP_NAME));
        this.nodeService.deleteNode(folder1NodeRef);
        this.nodeService.deleteNode(folder2NodeRef);
        txn.commit();
    }

    @Test
    public void testRuleExecutionWhenSecurityContextIsEmpty() throws Exception {
        NodeRef parentNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        RuleServiceImplTest.assertNotNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        Rule testRule = new Rule();
        testRule.setRuleTypes(Collections.singletonList("inbound"));
        testRule.setTitle("RuleServiceTest" + GUID.generate());
        testRule.setDescription("description");
        testRule.applyToChildren(true);
        Action action = this.actionService.createAction("add-features");
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        testRule.setAction(action);
        this.ruleService.saveRule(parentNodeRef, testRule);
        RuleServiceImplTest.assertNotNull((String)"Rule was not saved", (Object)testRule.getNodeRef());
        List rules = this.ruleService.getRules(parentNodeRef, true, (String)testRule.getRuleTypes().get(0));
        RuleServiceImplTest.assertNotNull((String)"No rules found", (Object)rules);
        RuleServiceImplTest.assertTrue((String)"Created rule is not found", (boolean)new HashSet(rules).contains(testRule));
        NodeRef actionedUponNodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("actioneduponnode" + GUID.generate())), ContentModel.TYPE_CONTENT).getChildRef();
        if (this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            this.nodeService.removeAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE);
        }
        ((RuntimeRuleService)this.ruleService).addRulePendingExecution(parentNodeRef, actionedUponNodeRef, testRule);
        AuthenticationUtil.clearCurrentSecurityContext();
        RuleServiceImplTest.assertNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        RuleServiceImplTest.assertNull((Object)AuthenticationUtil.getRunAsUser());
        ((RuntimeRuleService)this.ruleService).executePendingRules();
        RuleServiceImplTest.assertTrue((String)"Pending rule was not executed", (boolean)this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE));
    }

    @Test
    public void testOutBoundRuleTriggerForPendingDelete() throws Exception {
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        NodeRef parentFolderNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef folder1NodeRef = this.nodeService.createNode(parentFolderNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef folder2NodeRef = this.nodeService.createNode(parentFolderNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        Rule testRule = new Rule();
        testRule.setRuleTypes(Collections.singletonList("outbound"));
        testRule.setTitle("RuleServiceTest" + GUID.generate());
        testRule.setDescription("description");
        testRule.applyToChildren(true);
        Action action = this.actionService.createAction("copy");
        action.setParameterValue("destination-folder", (Serializable)folder2NodeRef);
        testRule.setAction(action);
        this.ruleService.saveRule(folder1NodeRef, testRule);
        RuleServiceImplTest.assertNotNull((String)"Rule was not saved", (Object)testRule.getNodeRef());
        QName actionedQName = QName.createQName((String)("actioneduponnode" + GUID.generate()));
        NodeRef actionedUponNodeRef = this.nodeService.createNode(folder1NodeRef, ContentModel.ASSOC_CHILDREN, actionedQName, ContentModel.TYPE_CONTENT).getChildRef();
        ContentWriter writer = this.contentService.getWriter(actionedUponNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.putContent("TestContent");
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        try {
            this.nodeService.deleteNode(parentFolderNodeRef);
        }
        catch (Exception e) {
            RuleServiceImplTest.fail((String)("The nodes should be deleted without errors, but exception was thrown: " + e));
        }
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        RuleServiceImplTest.assertFalse((String)"The folder should be deleted.", (boolean)this.nodeService.exists(parentFolderNodeRef));
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        parentFolderNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        folder1NodeRef = this.nodeService.createNode(parentFolderNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        folder2NodeRef = this.nodeService.createNode(parentFolderNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        testRule = new Rule();
        testRule.setRuleTypes(Collections.singletonList("outbound"));
        testRule.setTitle("RuleServiceTest" + GUID.generate());
        testRule.setDescription("description");
        testRule.applyToChildren(true);
        action = this.actionService.createAction("move");
        action.setParameterValue("destination-folder", (Serializable)folder2NodeRef);
        testRule.setAction(action);
        this.ruleService.saveRule(folder1NodeRef, testRule);
        RuleServiceImplTest.assertNotNull((String)"Rule was not saved", (Object)testRule.getNodeRef());
        actionedQName = QName.createQName((String)("actioneduponnode" + GUID.generate()));
        actionedUponNodeRef = this.nodeService.createNode(folder1NodeRef, ContentModel.ASSOC_CHILDREN, actionedQName, ContentModel.TYPE_CONTENT).getChildRef();
        writer = this.contentService.getWriter(actionedUponNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.putContent("TestContent");
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        try {
            this.nodeService.deleteNode(parentFolderNodeRef);
        }
        catch (Exception e) {
            RuleServiceImplTest.fail((String)("The nodes should be deleted without errors, but exception was thrown: " + e));
        }
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        RuleServiceImplTest.assertFalse((String)"The folder should be deleted.", (boolean)this.nodeService.exists(parentFolderNodeRef));
        txn.commit();
    }

    @Test
    public void testRuleTriggerWithTemporaryFiles() throws Exception {
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        NodeRef parentNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        QName actionedQName = QName.createQName((String)("actioneduponnode" + GUID.generate()));
        NodeRef actionedUponNodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CHILDREN, actionedQName, ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.addAspect(actionedUponNodeRef, ContentModel.ASPECT_TEMPORARY, null);
        ContentWriter writer = this.contentService.getWriter(actionedUponNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.putContent("TestContent");
        Rule testRule = new Rule();
        testRule.setRuleTypes(Collections.singletonList("inbound"));
        testRule.setTitle("RuleServiceTest" + GUID.generate());
        testRule.setDescription("description");
        testRule.applyToChildren(true);
        Action action = this.actionService.createAction("add-features");
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        testRule.setAction(action);
        this.ruleService.saveRule(parentNodeRef, testRule);
        RuleServiceImplTest.assertNotNull((String)"Rule was not saved", (Object)testRule.getNodeRef());
        List rules = this.ruleService.getRules(parentNodeRef, true, (String)testRule.getRuleTypes().get(0));
        RuleServiceImplTest.assertNotNull((String)"No rules found", (Object)rules);
        RuleServiceImplTest.assertTrue((String)"Created rule is not found", (boolean)new HashSet(rules).contains(testRule));
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        RuleServiceImplTest.assertTrue((String)"Node has Temporary aspect: ", (boolean)this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_TEMPORARY));
        RuleServiceImplTest.assertFalse((String)"Node with Temporary aspect has versionable aspect: ", (boolean)this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.removeAspect(actionedUponNodeRef, ContentModel.ASPECT_TEMPORARY);
        txn.commit();
        ((RuntimeRuleService)this.ruleService).addRulePendingExecution(parentNodeRef, actionedUponNodeRef, testRule);
        ((RuntimeRuleService)this.ruleService).executePendingRules();
        RuleServiceImplTest.assertTrue((String)"Pending rule was not executed", (boolean)this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE));
        RuleServiceImplTest.assertFalse((String)"Node has temporary aspect", (boolean)this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_TEMPORARY));
        RuleServiceImplTest.assertTrue((String)"Node has versionable aspect", (boolean)this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.deleteNode(actionedUponNodeRef);
        this.nodeService.deleteNode(parentNodeRef);
    }

    @Test
    public void testRemoveAllRulesForInboundAndOutbound() {
        String scriptName = "nothingToDo.js";
        this.createNothingToDoScript(scriptName);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(new StoreRef("workspace://SpacesStore"));
        NodeRef scriptRef = (NodeRef)this.searchService.selectNodes(storeRootNodeRef, "/app:company_home/app:dictionary/app:scripts/cm:" + scriptName, null, (NamespacePrefixResolver)this.namespaceService, false).get(0);
        NodeRef folderForRulesRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("parentnode" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        try {
            try {
                Rule outRule = new Rule();
                outRule.setRuleType("outbound");
                outRule.setTitle("TestOutRule" + GUID.generate());
                outRule.applyToChildren(true);
                outRule.setRuleDisabled(false);
                outRule.setExecuteAsynchronously(false);
                outRule.setAction(this.createScriptAction());
                this.ruleService.saveRule(folderForRulesRef, outRule);
                RuleServiceImplTest.assertNotNull((String)"Rule was not saved", (Object)outRule.getNodeRef());
                Rule inRule = new Rule();
                inRule.setRuleType("inbound");
                inRule.setTitle("TestinRule" + GUID.generate());
                inRule.applyToChildren(false);
                inRule.setExecuteAsynchronously(false);
                inRule.setRuleDisabled(true);
                inRule.setAction(this.createScriptAction());
                this.ruleService.saveRule(folderForRulesRef, inRule);
                RuleServiceImplTest.assertNotNull((String)"Rule was not saved", (Object)inRule.getNodeRef());
                this.ruleService.removeAllRules(folderForRulesRef);
            }
            catch (InvalidNodeRefException invalidNodeRefException) {
                RuleServiceImplTest.fail((String)"Cannot remove rules from folder");
                this.nodeService.deleteNode(folderForRulesRef);
                this.nodeService.deleteNode(scriptRef);
            }
        }
        finally {
            this.nodeService.deleteNode(folderForRulesRef);
            this.nodeService.deleteNode(scriptRef);
        }
    }

    private void createNothingToDoScript(String scriptName) {
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(new StoreRef("workspace://SpacesStore"));
        NodeRef scriptFolderRef = (NodeRef)this.searchService.selectNodes(storeRootNodeRef, "/app:company_home/app:dictionary/app:scripts", null, (NamespacePrefixResolver)this.namespaceService, false).get(0);
        try {
            FileInfo fileInfo = this.fileFolderService.create(scriptFolderRef, scriptName, ContentModel.TYPE_CONTENT);
            ContentWriter writer = this.fileFolderService.getWriter(fileInfo.getNodeRef());
            RuleServiceImplTest.assertNotNull((String)"Writer is null", (Object)writer);
            String content = "function main(){}\nmain();";
            writer.putContent(content);
        }
        catch (FileExistsException fileExistsException) {}
    }

    private Action createScriptAction() {
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(new StoreRef("workspace://SpacesStore"));
        NodeRef scriptRef = (NodeRef)this.searchService.selectNodes(storeRootNodeRef, "/app:company_home/app:dictionary/app:scripts/cm:nothingToDo.js", null, (NamespacePrefixResolver)this.namespaceService, false).get(0);
        RuleServiceImplTest.assertNotNull((String)"NodeRef script is null", (Object)scriptRef);
        CompositeAction compositeAction = this.actionService.createCompositeAction();
        Action action = this.actionService.createAction("script");
        HashMap<String, NodeRef> repoActionParams = new HashMap<String, NodeRef>();
        repoActionParams.put("script-ref", scriptRef);
        action.setParameterValues(repoActionParams);
        compositeAction.addAction(action);
        return compositeAction;
    }
}

