/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event2.EventConsolidator;
import org.alfresco.repo.event2.NodeResourceHelper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class EventConsolidatorUnitTest {
    private NodeResourceHelper nodeResourceHelper = (NodeResourceHelper)Mockito.mock(NodeResourceHelper.class);

    @Test
    public void testGetMappedAspectsBeforeRemovedAndAddedEmpty() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        Set mappedAspectsBefore = eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)0L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectRemoved() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        HashSet<String> removed = new HashSet<String>();
        HashSet added = new HashSet();
        removed.add("cm:contains");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)3L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectAdded() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        HashSet removed = new HashSet();
        HashSet<String> added = new HashSet<String>();
        added.add("cm:auditable");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)1L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectAddedAndRemoved() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        HashSet<String> removed = new HashSet<String>();
        removed.add("cm:contains");
        HashSet<String> added = new HashSet<String>();
        added.add("cm:contains");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)2L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectRemovedAndAdded() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        currentAspects.add("cm:contains");
        HashSet<String> removed = new HashSet<String>();
        removed.add("cm:contains");
        HashSet<String> added = new HashSet<String>();
        added.add("cm:contains");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)0L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectAddedTwiceRemovedOnce() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        currentAspects.add("cm:contains");
        HashSet removed = new HashSet();
        HashSet<String> added = new HashSet<String>();
        added.add("cm:contains");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)2L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_AspectRemovedTwiceAddedOnce() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        currentAspects.add("cm:contains");
        HashSet<String> removed = new HashSet<String>();
        removed.add("cm:contains");
        HashSet<String> added = new HashSet<String>();
        added.add("cm:contains");
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)2L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testGetMappedAspectsBefore_FilteredAspectAdded() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.addAspect(ContentModel.ASPECT_COPIEDFROM);
        HashSet<String> currentAspects = new HashSet<String>();
        currentAspects.add("cm:geographic");
        currentAspects.add("cm:auditable");
        HashSet removed = new HashSet();
        HashSet added = new HashSet();
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsRemoved())).thenReturn(removed);
        Mockito.when((Object)this.nodeResourceHelper.mapToNodeAspects((Collection)eventConsolidator.getAspectsAdded())).thenReturn(added);
        Set mappedAspectsBefore = eventConsolidator.getMappedAspectsBefore(currentAspects);
        Assert.assertEquals((long)0L, (long)mappedAspectsBefore.size());
    }

    @Test
    public void testAddAspect() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)1L, (long)eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)0L, (long)eventConsolidator.getAspectsRemoved().size());
        Assert.assertTrue((boolean)eventConsolidator.getAspectsAdded().contains(ContentModel.ASSOC_CONTAINS));
    }

    @Test
    public void testRemoveAspect() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)0L, (long)eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)1L, (long)eventConsolidator.getAspectsRemoved().size());
        Assert.assertTrue((boolean)eventConsolidator.getAspectsRemoved().contains(ContentModel.ASSOC_CONTAINS));
    }

    @Test
    public void testAddAspectRemoveAspect() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)0L, (long)eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)0L, (long)eventConsolidator.getAspectsRemoved().size());
    }

    @Test
    public void testRemoveAspectAddAspect() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)0L, (long)eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)0L, (long)eventConsolidator.getAspectsRemoved().size());
    }

    @Test
    public void testAddAspectTwiceRemoveAspectOnce() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)1L, (long)eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)0L, (long)eventConsolidator.getAspectsRemoved().size());
        Assert.assertTrue((boolean)eventConsolidator.getAspectsAdded().contains(ContentModel.ASSOC_CONTAINS));
    }

    @Test
    public void testAddAspectOnceRemoveAspectTwice() {
        EventConsolidator eventConsolidator = new EventConsolidator(this.nodeResourceHelper);
        eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        eventConsolidator.addAspect(ContentModel.ASSOC_CONTAINS);
        eventConsolidator.removeAspect(ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)0L, (long)eventConsolidator.getAspectsAdded().size());
        Assert.assertEquals((long)1L, (long)eventConsolidator.getAspectsRemoved().size());
        Assert.assertTrue((boolean)eventConsolidator.getAspectsRemoved().contains(ContentModel.ASSOC_CONTAINS));
    }
}

