/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.CustomModelServiceImplTest;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.download.DownloadService;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.springframework.context.ApplicationContext;

public class CMMDownloadTestUtil {
    private static final Log logger = LogFactory.getLog(CMMDownloadTestUtil.class);
    private static final String SURF_CONFIG_PATH = "./app:company_home/st:sites/cm:surf-config";
    private static final String SHARE_EXTENSIONS_FOLDER = "extensions";
    private static final String SHARE_PERSISTED_EXTENSION_FILE = "default-persisted-extension.xml";
    private static final String MKR = "{MKR}";
    private static final String MODULE = "<extension><modules><module><id>CMM_{MKR}</id><auto-deploy>true</auto-deploy><configurations><config evaluator=\"string-compare\" condition=\"DocumentLibrary\" replace=\"false\"><types><type name=\"cm:content\"><subtype label=\"type1 title\" name=\"testprefix:type1\"/></type></types></config><config evaluator=\"string-compare\" condition=\"FormDefinition\"></config></configurations></module></modules></extension>";
    private RetryingTransactionHelper transactionHelper;
    private ContentService contentService;
    private NodeService nodeService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private DownloadService downloadService;
    private NodeRef extensionsNodeRef;
    private NodeRef sharePersistedExtNodeRef;
    private boolean isExtFolderCreated = false;
    private File originalShareExtFile;

    public CMMDownloadTestUtil(ApplicationContext ctx) {
        this.transactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        this.contentService = (ContentService)ctx.getBean("contentService", ContentService.class);
        this.searchService = (SearchService)ctx.getBean("searchService", SearchService.class);
        this.nodeService = (NodeService)ctx.getBean("nodeService", NodeService.class);
        this.namespaceService = (NamespaceService)ctx.getBean("namespaceService", NamespaceService.class);
        this.downloadService = (DownloadService)ctx.getBean("downloadService", DownloadService.class);
    }

    private NodeRef getRootNode() {
        return this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
    }

    public synchronized void createShareExtModule(final String moduleId) {
        List results = this.searchService.selectNodes(this.getRootNode(), SURF_CONFIG_PATH, null, (NamespacePrefixResolver)this.namespaceService, false, "xpath");
        Assert.assertTrue((results.size() == 1 ? 1 : 0) != 0);
        final NodeRef surfConfigNodeRef = (NodeRef)results.get(0);
        this.extensionsNodeRef = this.nodeService.getChildByName(surfConfigNodeRef, ContentModel.ASSOC_CONTAINS, SHARE_EXTENSIONS_FOLDER);
        if (this.extensionsNodeRef == null) {
            this.extensionsNodeRef = (NodeRef)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                public NodeRef execute() throws Throwable {
                    QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)CMMDownloadTestUtil.SHARE_EXTENSIONS_FOLDER);
                    NodeRef nodeRef = CMMDownloadTestUtil.this.nodeService.createNode(surfConfigNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_FOLDER, Collections.singletonMap(ContentModel.PROP_NAME, CMMDownloadTestUtil.SHARE_EXTENSIONS_FOLDER)).getChildRef();
                    CMMDownloadTestUtil.this.isExtFolderCreated = true;
                    return nodeRef;
                }
            });
            logger.info((Object)"Created 'cm:extensions' folder within the 'app:company_home/st:sites/cm:surf-config'");
        }
        this.sharePersistedExtNodeRef = this.nodeService.getChildByName(this.extensionsNodeRef, ContentModel.ASSOC_CONTAINS, SHARE_PERSISTED_EXTENSION_FILE);
        if (this.sharePersistedExtNodeRef == null) {
            this.sharePersistedExtNodeRef = (NodeRef)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                public NodeRef execute() throws Throwable {
                    QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)CMMDownloadTestUtil.SHARE_PERSISTED_EXTENSION_FILE);
                    return CMMDownloadTestUtil.this.nodeService.createNode(CMMDownloadTestUtil.this.extensionsNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_CONTENT, Collections.singletonMap(ContentModel.PROP_NAME, CMMDownloadTestUtil.SHARE_PERSISTED_EXTENSION_FILE)).getChildRef();
                }
            });
            logger.info((Object)"Created 'cm:default-persisted-extension.xml' file within the 'app:company_home/st:sites/cm:surf-config/cm:extensions'");
        } else if (this.originalShareExtFile == null) {
            this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    ContentReader reader = CMMDownloadTestUtil.this.contentService.getReader(CMMDownloadTestUtil.this.sharePersistedExtNodeRef, ContentModel.PROP_CONTENT);
                    CMMDownloadTestUtil.this.originalShareExtFile = TempFileProvider.createTempFile((String)CustomModelServiceImplTest.class.getName(), (String)".xml");
                    reader.getContent(CMMDownloadTestUtil.this.originalShareExtFile);
                    return null;
                }
            });
        }
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentWriter writer = CMMDownloadTestUtil.this.contentService.getWriter(CMMDownloadTestUtil.this.sharePersistedExtNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/xml");
                writer.setEncoding("UTF-8");
                writer.putContent(CMMDownloadTestUtil.MODULE.replace(CMMDownloadTestUtil.MKR, moduleId));
                return null;
            }
        });
        logger.info((Object)("Added 'CM_" + moduleId + "' module.'"));
    }

    public synchronized void cleanup() {
        if (this.isExtFolderCreated) {
            this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    CMMDownloadTestUtil.this.nodeService.deleteNode(CMMDownloadTestUtil.this.extensionsNodeRef);
                    return null;
                }
            });
            logger.info((Object)"Deleted 'cm:extensions' folder within the 'app:company_home/st:sites/cm:surf-config");
        } else if (this.originalShareExtFile != null) {
            this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    ContentWriter writer = CMMDownloadTestUtil.this.contentService.getWriter(CMMDownloadTestUtil.this.sharePersistedExtNodeRef, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/xml");
                    writer.setEncoding("UTF-8");
                    writer.putContent(CMMDownloadTestUtil.this.originalShareExtFile);
                    return null;
                }
            });
            logger.info((Object)"Reverted default-persisted-extension.xml content.");
        }
        if (this.originalShareExtFile != null) {
            this.originalShareExtFile.delete();
        }
    }

    public Set<String> getDownloadEntries(final NodeRef downloadNode) {
        return (Set)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Set<String>>(){

            public Set<String> execute() throws Throwable {
                TreeSet<String> entryNames = new TreeSet<String>();
                ContentReader reader = CMMDownloadTestUtil.this.contentService.getReader(downloadNode, ContentModel.PROP_CONTENT);
                Throwable throwable = null;
                Object var4_5 = null;
                try (ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(reader.getContentInputStream());){
                    ZipArchiveEntry zipEntry = null;
                    while ((zipEntry = zipInputStream.getNextZipEntry()) != null) {
                        String name = zipEntry.getName();
                        entryNames.add(name);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return entryNames;
            }
        });
    }

    public String getDownloadEntry(Collection<String> entryNames, String entryName) {
        for (String expectedEntry : entryNames) {
            if (!expectedEntry.equals(entryName)) continue;
            return expectedEntry;
        }
        return null;
    }

    public DownloadStatus getDownloadStatus(final NodeRef downloadNode) {
        return (DownloadStatus)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<DownloadStatus>(){

            public DownloadStatus doWork() throws Exception {
                return (DownloadStatus)CMMDownloadTestUtil.this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<DownloadStatus>(){

                    public DownloadStatus execute() throws Throwable {
                        return CMMDownloadTestUtil.this.downloadService.getDownloadStatus(downloadNode);
                    }
                });
            }
        });
    }
}

