/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.cache.CacheStatistics;
import org.alfresco.repo.cache.NoStatsForCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.TransactionStats;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class})
public class CacheTest
extends TestCase {
    private ApplicationContext ctx;
    private ServiceRegistry serviceRegistry;
    private SimpleCache<String, Object> objectCache;
    private SimpleCache<String, TransactionalCache.ValueHolder<Object>> backingCache;
    private SimpleCache<String, TransactionalCache.ValueHolder<Object>> backingCacheNoStats;
    private TransactionalCache<String, Object> transactionalCache;
    private TransactionalCache<String, Object> transactionalCacheNoStats;
    private CacheStatistics cacheStats;
    private static final String NEW_GLOBAL_ONE = "new_global_one";
    private static final String NEW_GLOBAL_TWO = "new_global_two";
    private static final String NEW_GLOBAL_THREE = "new_global_three";
    private static final String UPDATE_TXN_THREE = "updated_txn_three";
    private static final String UPDATE_TXN_FOUR = "updated_txn_four";
    private static final String DEFINITIVE_ONE = "def_one";
    private static final String DEFINITIVE_TWO = "def_two";
    private static final String DEFINITIVE_THREE = "def_three";
    private static final String COMMON_KEY = "A";
    private static final MutableLong VALUE_ONE_A = new MutableLong(1L);
    private static final MutableLong VALUE_ONE_B = new MutableLong(1L);
    private static final MutableLong VALUE_TWO_A = new MutableLong(2L);

    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:cache-test/cache-test-context.xml", ApplicationContextHelper.CONFIG_LOCATIONS[0]});
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            CacheTest.fail((String)"A transaction is still running");
        }
        this.serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.objectCache = (SimpleCache)this.ctx.getBean("objectCache");
        this.backingCache = (SimpleCache)this.ctx.getBean("backingCache");
        this.backingCacheNoStats = (SimpleCache)this.ctx.getBean("backingCacheNoStats");
        this.transactionalCache = (TransactionalCache)this.ctx.getBean("transactionalCache");
        this.transactionalCacheNoStats = (TransactionalCache)this.ctx.getBean("transactionalCacheNoStats");
        this.cacheStats = (CacheStatistics)this.ctx.getBean("cacheStatistics");
        this.backingCache.clear();
        this.backingCacheNoStats.clear();
        this.transactionalCache.setMutable(true);
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCacheNoStats.setMutable(true);
        this.transactionalCacheNoStats.setAllowEqualsChecks(false);
    }

    public void tearDown() {
        this.serviceRegistry = null;
        this.objectCache = null;
        this.backingCache = null;
        this.transactionalCache = null;
        this.backingCacheNoStats = null;
        this.transactionalCacheNoStats = null;
    }

    public void testSetUp() throws Exception {
        CacheTest.assertNotNull((Object)this.serviceRegistry);
        CacheTest.assertNotNull(this.backingCache);
        CacheTest.assertNotNull(this.backingCacheNoStats);
        CacheTest.assertNotNull(this.objectCache);
        CacheTest.assertNotNull(this.transactionalCache);
        CacheTest.assertNotNull(this.transactionalCacheNoStats);
    }

    public void testObjectCache() throws Exception {
        this.objectCache.clear();
        this.objectCache.put((Serializable)((Object)COMMON_KEY), (Object)this);
        Object obj = this.objectCache.get((Serializable)((Object)COMMON_KEY));
        CacheTest.assertTrue((String)"Object not cached properly", (this == obj ? 1 : 0) != 0);
        this.objectCache.put((Serializable)((Object)COMMON_KEY), (Object)"AAA");
        CacheTest.assertEquals((Object)"AAA", (Object)this.objectCache.get((Serializable)((Object)COMMON_KEY)));
        Collection keys = this.objectCache.getKeys();
        CacheTest.assertEquals((String)"Cache didn't return correct number of keys", (int)1, (int)keys.size());
        this.objectCache.remove((Serializable)((Object)COMMON_KEY));
        CacheTest.assertNull((Object)this.objectCache.get((Serializable)((Object)COMMON_KEY)));
    }

    public void testTransactionalCacheNoTxn() throws Exception {
        String key = "B";
        String value = "BBB";
        this.transactionalCache.put((Serializable)((Object)key), (Object)value);
        CacheTest.assertEquals((String)"Backing cache not used for put when no transaction present", (Object)value, (Object)TransactionalCache.getSharedCacheValue(this.backingCache, (Serializable)((Object)key), null));
        this.backingCache.remove((Serializable)((Object)key));
        CacheTest.assertNull((String)"Backing cache not used for removed when no transaction present", (Object)this.transactionalCache.get((Serializable)((Object)key)));
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)key), (Object)value, null);
        this.transactionalCache.remove((Serializable)((Object)key));
        CacheTest.assertNull((String)"Non-transactional remove didn't go to backing cache", (Object)TransactionalCache.getSharedCacheValue(this.backingCache, (Serializable)((Object)key), null));
    }

    public void testRollbackCleanup() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        RetryingTransactionHelper txnHelper = transactionService.getRetryingTransactionHelper();
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)NEW_GLOBAL_ONE), (Object)NEW_GLOBAL_ONE, null);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){
            private int throwCount = 0;

            public Object execute() throws Throwable {
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.NEW_GLOBAL_TWO), (Object)CacheTest.NEW_GLOBAL_TWO);
                CacheTest.this.transactionalCache.remove((Serializable)((Object)CacheTest.NEW_GLOBAL_ONE));
                String key = "B";
                String value = "BBB";
                CacheTest.this.transactionalCache.put((Serializable)((Object)key), (Object)value);
                if (this.throwCount < 5) {
                    ++this.throwCount;
                    throw new SQLException("Dummy");
                }
                throw new Exception("Fail");
            }
        };
        try {
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Exception exception) {}
        CacheTest.assertFalse((String)"Remove not done after rollback", (boolean)this.transactionalCache.contains((Serializable)((Object)NEW_GLOBAL_ONE)));
        CacheTest.assertFalse((String)"Update happened after rollback", (boolean)this.transactionalCache.contains((Serializable)((Object)NEW_GLOBAL_TWO)));
    }

    public void testTransactionalCacheWithSingleTxn() throws Throwable {
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)NEW_GLOBAL_ONE), (Object)NEW_GLOBAL_ONE, null);
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)NEW_GLOBAL_TWO), (Object)NEW_GLOBAL_TWO, null);
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)NEW_GLOBAL_THREE), (Object)NEW_GLOBAL_THREE, null);
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            this.transactionalCache.remove((Serializable)((Object)NEW_GLOBAL_ONE));
            CacheTest.assertFalse((String)"Item was not removed from txn cache", (boolean)this.transactionalCache.contains((Serializable)((Object)NEW_GLOBAL_ONE)));
            CacheTest.assertNull((String)"Get didn't return null", (Object)this.transactionalCache.get((Serializable)((Object)NEW_GLOBAL_ONE)));
            CacheTest.assertTrue((String)"Item was removed from backing cache", (boolean)this.backingCache.contains((Serializable)((Object)NEW_GLOBAL_ONE)));
            CacheTest.assertEquals((String)"Item not read from backing cache", (Object)NEW_GLOBAL_TWO, (Object)this.transactionalCache.get((Serializable)((Object)NEW_GLOBAL_TWO)));
            TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)NEW_GLOBAL_TWO), (Object)"new_global_two-updated", null);
            CacheTest.assertEquals((String)"Read-committed not preserved", (Object)NEW_GLOBAL_TWO, (Object)this.transactionalCache.get((Serializable)((Object)NEW_GLOBAL_TWO)));
            this.transactionalCache.put((Serializable)((Object)UPDATE_TXN_THREE), (Object)"XXX");
            CacheTest.assertEquals((String)"Item not updated in txn cache", (Object)"XXX", (Object)this.transactionalCache.get((Serializable)((Object)UPDATE_TXN_THREE)));
            CacheTest.assertFalse((String)"Item was put into backing cache", (boolean)this.backingCache.contains((Serializable)((Object)UPDATE_TXN_THREE)));
            Collection transactionalKeys = this.transactionalCache.getKeys();
            CacheTest.assertFalse((String)"Transactionally removed item found in keys", (boolean)transactionalKeys.contains(NEW_GLOBAL_ONE));
            CacheTest.assertTrue((String)"Transactionally added item not found in keys", (boolean)transactionalKeys.contains(UPDATE_TXN_THREE));
            PostCommitCacheReader listenerReader = new PostCommitCacheReader((SimpleCache)this.transactionalCache, UPDATE_TXN_THREE);
            AlfrescoTransactionSupport.bindListener((TransactionListener)listenerReader);
            PostCommitCacheWriter listenerWriter = new PostCommitCacheWriter((SimpleCache)this.transactionalCache, UPDATE_TXN_FOUR, "FOUR");
            AlfrescoTransactionSupport.bindListener((TransactionListener)listenerWriter);
            txn.commit();
            if (listenerReader.e != null) {
                throw listenerReader.e;
            }
            if (listenerWriter.e != null) {
                throw listenerWriter.e;
            }
            CacheTest.assertFalse((String)"Item was not removed from backing cache", (boolean)this.backingCache.contains((Serializable)((Object)NEW_GLOBAL_ONE)));
            CacheTest.assertNull((String)"Item could still be fetched from backing cache", (Object)TransactionalCache.getSharedCacheValue(this.backingCache, (Serializable)((Object)NEW_GLOBAL_ONE), null));
            CacheTest.assertEquals((String)"Item not updated in backing cache", (Object)"XXX", (Object)TransactionalCache.getSharedCacheValue(this.backingCache, (Serializable)((Object)UPDATE_TXN_THREE), null));
            CacheTest.assertEquals((String)"Transactional cache must serve post-commit get requests", (Object)"XXX", (Object)this.transactionalCache.get((Serializable)((Object)UPDATE_TXN_THREE)));
        }
        catch (Throwable e) {
            if (txn.getStatus() == 0) {
                txn.rollback();
            }
            throw e;
        }
    }

    public void testTransactionalCacheDisableSharedCaches() throws Throwable {
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)NEW_GLOBAL_ONE), (Object)NEW_GLOBAL_ONE, null);
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)NEW_GLOBAL_TWO), (Object)NEW_GLOBAL_TWO, null);
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)NEW_GLOBAL_THREE), (Object)NEW_GLOBAL_THREE, null);
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            this.transactionalCache.setDisableSharedCacheReadForTransaction(true);
            CacheTest.assertNull((String)"Read of mutable shared cache MUST NOT use backing cache", (Object)this.transactionalCache.get((Serializable)((Object)NEW_GLOBAL_ONE)));
            CacheTest.assertNull((String)"Value should not be in any cache", (Object)this.transactionalCache.get((Serializable)((Object)UPDATE_TXN_THREE)));
            this.transactionalCache.put((Serializable)((Object)NEW_GLOBAL_TWO), (Object)"An update");
            this.transactionalCache.put((Serializable)((Object)UPDATE_TXN_THREE), (Object)UPDATE_TXN_THREE);
            CacheTest.assertNull((String)"Read of mutable shared cache MUST NOT use backing cache", (Object)this.transactionalCache.get((Serializable)((Object)NEW_GLOBAL_ONE)));
            CacheTest.assertEquals((String)"Value should be in transactional cache", (Object)"An update", (Object)this.transactionalCache.get((Serializable)((Object)NEW_GLOBAL_TWO)));
            CacheTest.assertEquals((String)"Value should be in transactional cache", (Object)UPDATE_TXN_THREE, (Object)this.transactionalCache.get((Serializable)((Object)UPDATE_TXN_THREE)));
            txn.commit();
            CacheTest.assertEquals((String)"Out-of-txn read must return shared value", (Object)NEW_GLOBAL_ONE, (Object)this.transactionalCache.get((Serializable)((Object)NEW_GLOBAL_ONE)));
            CacheTest.assertNull((String)"Value should be removed from shared cache", (Object)this.transactionalCache.get((Serializable)((Object)NEW_GLOBAL_TWO)));
            CacheTest.assertEquals((String)"New values must be written to shared cache", (Object)UPDATE_TXN_THREE, (Object)this.transactionalCache.get((Serializable)((Object)UPDATE_TXN_THREE)));
        }
        catch (Throwable e) {
            if (txn.getStatus() == 0) {
                txn.rollback();
            }
            throw e;
        }
    }

    public long runPerformanceTestOnCache(SimpleCache<String, Object> cache, int objectCount) {
        int i = 0;
        while (i < objectCount) {
            String key = Integer.toString(i);
            Integer value = new Integer(i);
            cache.put((Serializable)((Object)key), (Object)value);
            ++i;
        }
        long start = System.nanoTime();
        int i2 = 0;
        while (i2 < objectCount) {
            String key = Integer.toString(i2);
            cache.remove((Serializable)((Object)key));
            key = Integer.toString(i2 + objectCount);
            Integer value = new Integer(i2 + objectCount);
            cache.put((Serializable)((Object)key), (Object)value);
            ++i2;
        }
        long stop = System.nanoTime();
        return stop - start;
    }

    public void testPerformance() throws Exception {
        int i = 0;
        while (i < 6) {
            int count = (int)Math.pow(10.0, i);
            long timePlain = this.runPerformanceTestOnCache(this.objectCache, count);
            TransactionService transactionService = this.serviceRegistry.getTransactionService();
            UserTransaction txn = transactionService.getUserTransaction();
            txn.begin();
            long timeTxn = this.runPerformanceTestOnCache((SimpleCache<String, Object>)this.transactionalCache, count);
            long commitStart = System.nanoTime();
            txn.commit();
            long commitEnd = System.nanoTime();
            long commitTime = commitEnd - commitStart;
            System.out.println("Cache performance test: \n   count: " + count + "\n" + "   direct: " + timePlain / (long)count + " ns\\count \n" + "   transaction: " + (timeTxn += commitTime) / (long)count + " ns\\count");
            ++i;
        }
    }

    public void testInitializationPerformance() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        long start = System.nanoTime();
        int count = 10000;
        int i = 0;
        while (i < count) {
            UserTransaction txn = transactionService.getUserTransaction();
            try {
                txn.begin();
                this.transactionalCache.contains((Serializable)((Object)COMMON_KEY));
            }
            finally {
                try {
                    txn.rollback();
                }
                catch (Throwable ee) {
                    ee.printStackTrace();
                }
            }
            ++i;
        }
        long end = System.nanoTime();
        System.out.println("Cache initialization performance test: \n   count:       " + count + "\n" + "   transaction: " + (end - start) / (long)count + " ns\\count");
    }

    public static void main(String ... args) {
        try {
            try {
                CacheTest test = new CacheTest();
                test.setUp();
                System.out.println("Press any key to run initialization test ...");
                System.in.read();
                test.testInitializationPerformance();
                System.out.println("Press any key to run performance test ...");
                System.in.read();
                test.testPerformance();
                System.out.println("Press any key to shutdown ...");
                System.in.read();
                test.tearDown();
            }
            catch (Throwable e) {
                e.printStackTrace();
                ApplicationContextHelper.closeApplicationContext();
            }
        }
        finally {
            ApplicationContextHelper.closeApplicationContext();
        }
    }

    public void testNullValue() throws Throwable {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        txn.begin();
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)COMMON_KEY), null, null);
        this.transactionalCache.put((Serializable)((Object)COMMON_KEY), (Object)"AAA");
        try {
            txn.commit();
        }
        catch (Throwable e) {
            try {
                txn.rollback();
            }
            catch (Throwable throwable) {}
            throw e;
        }
    }

    public void testMaxSizeOverrun() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            Integer startValue = new Integer(-1);
            String startKey = ((Object)startValue).toString();
            this.transactionalCache.put((Serializable)((Object)startKey), (Object)startValue);
            CacheTest.assertEquals((String)"The start value isn't correct", (Object)startValue, (Object)this.transactionalCache.get((Serializable)((Object)startKey)));
            int i = 0;
            while (i < 205000) {
                Integer value = i;
                String key = ((Object)value).toString();
                this.transactionalCache.put((Serializable)((Object)key), (Object)value);
                ++i;
            }
            Object checkStartValue = this.transactionalCache.get((Serializable)((Object)startKey));
            CacheTest.assertNull((String)"The start value didn't drop out of the cache", (Object)checkStartValue);
            txn.commit();
        }
        catch (Throwable throwable) {
            try {
                txn.rollback();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            txn.rollback();
        }
        catch (Throwable throwable) {}
    }

    private void executeAndCheck(RetryingTransactionHelper.RetryingTransactionCallback<Object> callback, boolean readOnly, String key, Object expectedValue, boolean mustContainKey) throws Throwable {
        if (expectedValue != null && !mustContainKey) {
            throw new IllegalArgumentException("Why have a value when the key should not be there?");
        }
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction(readOnly);
        try {
            txn.begin();
            callback.execute();
            txn.commit();
        }
        catch (Throwable throwable) {
            try {
                txn.rollback();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            txn.rollback();
        }
        catch (Throwable throwable) {}
        Object actualValue = TransactionalCache.getSharedCacheValue(this.backingCache, (Serializable)((Object)key), null);
        CacheTest.assertEquals((String)"Backing cache value was not correct", (Object)expectedValue, (Object)actualValue);
        CacheTest.assertEquals((String)"Backing cache contains(key): ", (boolean)mustContainKey, (boolean)this.backingCache.contains((Serializable)((Object)key)));
        this.backingCache.clear();
    }

    public void testValueLockingInTxn() throws Exception {
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)DEFINITIVE_TWO), (Object)"initial_two", null);
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)DEFINITIVE_THREE), (Object)"initial_three", null);
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            CacheTest.assertEquals(null, (Object)this.transactionalCache.get((Serializable)((Object)DEFINITIVE_ONE)));
            this.transactionalCache.put((Serializable)((Object)DEFINITIVE_ONE), (Object)DEFINITIVE_ONE);
            CacheTest.assertFalse((String)"Key should not be locked, yet.", (boolean)this.transactionalCache.isValueLocked((Serializable)((Object)DEFINITIVE_ONE)));
            this.transactionalCache.lockValue((Serializable)((Object)DEFINITIVE_ONE));
            CacheTest.assertTrue((String)"Key should be locked.", (boolean)this.transactionalCache.isValueLocked((Serializable)((Object)DEFINITIVE_ONE)));
            this.transactionalCache.put((Serializable)((Object)DEFINITIVE_ONE), (Object)"update_one");
            CacheTest.assertEquals((String)"Update values should be locked.", (Object)DEFINITIVE_ONE, (Object)this.transactionalCache.get((Serializable)((Object)DEFINITIVE_ONE)));
            CacheTest.assertEquals((Object)"initial_two", (Object)this.transactionalCache.get((Serializable)((Object)DEFINITIVE_TWO)));
            this.transactionalCache.put((Serializable)((Object)DEFINITIVE_TWO), (Object)DEFINITIVE_TWO);
            CacheTest.assertFalse((String)"Key should not be locked, yet.", (boolean)this.transactionalCache.isValueLocked((Serializable)((Object)DEFINITIVE_TWO)));
            this.transactionalCache.lockValue((Serializable)((Object)DEFINITIVE_TWO));
            CacheTest.assertTrue((String)"Key should be locked.", (boolean)this.transactionalCache.isValueLocked((Serializable)((Object)DEFINITIVE_TWO)));
            this.transactionalCache.put((Serializable)((Object)DEFINITIVE_TWO), (Object)"update_two");
            CacheTest.assertEquals((String)"Update values should be locked.", (Object)DEFINITIVE_TWO, (Object)this.transactionalCache.get((Serializable)((Object)DEFINITIVE_TWO)));
            this.transactionalCache.remove((Serializable)((Object)DEFINITIVE_TWO));
            CacheTest.assertEquals((String)"Update values should be locked.", (Object)DEFINITIVE_TWO, (Object)this.transactionalCache.get((Serializable)((Object)DEFINITIVE_TWO)));
            CacheTest.assertEquals((Object)"initial_three", (Object)this.transactionalCache.get((Serializable)((Object)DEFINITIVE_THREE)));
            this.transactionalCache.remove((Serializable)((Object)DEFINITIVE_THREE));
            CacheTest.assertFalse((String)"Key should not be locked, yet.", (boolean)this.transactionalCache.isValueLocked((Serializable)((Object)DEFINITIVE_THREE)));
            this.transactionalCache.lockValue((Serializable)((Object)DEFINITIVE_THREE));
            CacheTest.assertTrue((String)"Key should be locked.", (boolean)this.transactionalCache.isValueLocked((Serializable)((Object)DEFINITIVE_THREE)));
            this.transactionalCache.put((Serializable)((Object)DEFINITIVE_THREE), (Object)"add_three");
            CacheTest.assertEquals((String)"Removal should be locked.", null, (Object)this.transactionalCache.get((Serializable)((Object)DEFINITIVE_THREE)));
            txn.commit();
            CacheTest.assertEquals((String)"Definitive change not written through.", (Object)DEFINITIVE_ONE, (Object)TransactionalCache.getSharedCacheValue(this.backingCache, (Serializable)((Object)DEFINITIVE_ONE), null));
            CacheTest.assertEquals((String)"Definitive change not written through.", (Object)DEFINITIVE_TWO, (Object)TransactionalCache.getSharedCacheValue(this.backingCache, (Serializable)((Object)DEFINITIVE_TWO), null));
            CacheTest.assertEquals((String)"Definitive change not written through.", null, (Object)TransactionalCache.getSharedCacheValue(this.backingCache, (Serializable)((Object)DEFINITIVE_THREE), null));
        }
        catch (Throwable throwable) {
            try {
                txn.rollback();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            txn.rollback();
        }
        catch (Throwable throwable) {}
    }

    public void testConcurrentAddAgainstAdd() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B, null);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
    }

    public void testConcurrentAddAgainstAddSame() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A, null);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A, true);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A, true);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A, true);
    }

    public void testConcurrentAddAgainstAddNull() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), null, null);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, true);
        this.executeAndCheck(callback, true, COMMON_KEY, null, true);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, true);
        this.executeAndCheck(callback, true, COMMON_KEY, null, true);
    }

    public void testConcurrentAddAgainstClear() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                CacheTest.this.backingCache.clear();
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A, true);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A, true);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A, true);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A, true);
    }

    public void testConcurrentUpdateAgainstUpdate() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A, null);
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B);
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_TWO_A, null);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_TWO_A, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_TWO_A, true);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_TWO_A, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_TWO_A, true);
    }

    public void testConcurrentUpdateAgainstUpdateNull() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A, null);
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B);
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), null, null);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, true);
        this.executeAndCheck(callback, true, COMMON_KEY, null, true);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, true);
        this.executeAndCheck(callback, true, COMMON_KEY, null, true);
    }

    public void testConcurrentUpdateNullAgainstUpdate() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A, null);
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.COMMON_KEY), null);
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B, null);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
    }

    public void testConcurrentUpdateNullAgainstUpdateNull() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A, null);
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.COMMON_KEY), null);
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), null, null);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, true);
        this.executeAndCheck(callback, true, COMMON_KEY, null, true);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, true);
        this.executeAndCheck(callback, true, COMMON_KEY, null, true);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, true);
        this.executeAndCheck(callback, true, COMMON_KEY, null, true);
    }

    public void testConcurrentUpdateAgainstRemove() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A, null);
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B);
                CacheTest.this.backingCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
    }

    public void testConcurrentUpdateAgainstClear() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A, null);
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B);
                CacheTest.this.backingCache.clear();
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
    }

    public void testConcurrentRemoveAgainstUpdate_NoPreExisting() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                CacheTest.this.backingCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                CacheTest.this.transactionalCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B, null);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
    }

    public void testConcurrentAddAgainstAdd_NoPreExisting() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                CacheTest.this.backingCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                CacheTest.this.transactionalCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B, null);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B, true);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B, true);
    }

    public void testConcurrentRemoveAgainstUpdate_PreExisting() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A, null);
                CacheTest.this.transactionalCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B, null);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
    }

    public void testConcurrentRemoveAgainstRemove() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A, null);
                CacheTest.this.transactionalCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                CacheTest.this.backingCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
    }

    public void testConcurrentRemoveAgainstClear() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                TransactionalCache.putSharedCacheValue((SimpleCache)CacheTest.this.backingCache, (Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A, null);
                CacheTest.this.transactionalCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                CacheTest.this.backingCache.clear();
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null, false);
        this.executeAndCheck(callback, true, COMMON_KEY, null, false);
    }

    public void testTransactionalCacheStatsOnCommit() throws Throwable {
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)"stats-test1"), (Object)"v", null);
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)"stats-test2"), (Object)"v", null);
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)"stats-test3"), (Object)"v", null);
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        long hitsAtStart = this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_HIT);
        long missesAtStart = this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_MISS);
        long putsAtStart = this.cacheStats.count("transactionalCache", TransactionStats.OpType.PUT);
        long removesAtStart = this.cacheStats.count("transactionalCache", TransactionStats.OpType.REMOVE);
        long clearsAtStart = this.cacheStats.count("transactionalCache", TransactionStats.OpType.CLEAR);
        try {
            txn.begin();
            this.transactionalCache.put((Serializable)((Object)"stats-test4"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test5"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test6"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test7"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test8"), (Object)"v");
            this.transactionalCache.get((Serializable)((Object)"stats-test3"));
            this.transactionalCache.get((Serializable)((Object)"stats-test2"));
            this.transactionalCache.get((Serializable)((Object)"stats-test1"));
            this.transactionalCache.get((Serializable)((Object)"stats-test2"));
            this.transactionalCache.get((Serializable)((Object)"stats-test1"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss1"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss2"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss3"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss4"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss2"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss3"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test1"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test2"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test3"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test9"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test10"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test11"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test12"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test13"));
            CacheTest.assertEquals((long)hitsAtStart, (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_HIT));
            CacheTest.assertEquals((long)missesAtStart, (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_MISS));
            CacheTest.assertEquals((long)putsAtStart, (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.PUT));
            CacheTest.assertEquals((long)removesAtStart, (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.REMOVE));
            CacheTest.assertEquals((long)clearsAtStart, (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.CLEAR));
            txn.commit();
            CacheTest.assertEquals((long)(removesAtStart + 16L), (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.REMOVE));
            CacheTest.assertEquals((long)(hitsAtStart + 3L), (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_HIT));
            CacheTest.assertEquals((long)(missesAtStart + 4L), (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_MISS));
            CacheTest.assertEquals((long)(putsAtStart + 5L), (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.PUT));
            CacheTest.assertEquals((long)(clearsAtStart + 0L), (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.CLEAR));
        }
        catch (Throwable e) {
            if (txn.getStatus() == 0) {
                txn.rollback();
            }
            throw e;
        }
    }

    public void testTransactionalCacheStatsDisabled() throws Throwable {
        TransactionStats.OpType opType;
        TransactionalCache.putSharedCacheValue(this.backingCacheNoStats, (Serializable)((Object)"stats-test1"), (Object)"v", null);
        TransactionalCache.putSharedCacheValue(this.backingCacheNoStats, (Serializable)((Object)"stats-test2"), (Object)"v", null);
        TransactionalCache.putSharedCacheValue(this.backingCacheNoStats, (Serializable)((Object)"stats-test3"), (Object)"v", null);
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        TransactionStats.OpType[] opTypeArray = TransactionStats.OpType.values();
        int n = opTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            opType = opTypeArray[n2];
            try {
                this.cacheStats.count("transactionalCacheNoStats", opType);
                CacheTest.fail((String)"Expected NoStatsForCache error.");
            }
            catch (NoStatsForCache noStatsForCache) {}
            ++n2;
        }
        try {
            txn.begin();
            this.transactionalCacheNoStats.put((Serializable)((Object)"stats-test4"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test5"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test6"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test7"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test8"), (Object)"v");
            this.transactionalCache.get((Serializable)((Object)"stats-test3"));
            this.transactionalCache.get((Serializable)((Object)"stats-test2"));
            this.transactionalCache.get((Serializable)((Object)"stats-test1"));
            this.transactionalCache.get((Serializable)((Object)"stats-test2"));
            this.transactionalCache.get((Serializable)((Object)"stats-test1"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss1"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss2"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss3"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss4"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss2"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss3"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test1"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test2"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test3"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test9"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test10"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test11"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test12"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test13"));
            opTypeArray = TransactionStats.OpType.values();
            n = opTypeArray.length;
            n2 = 0;
            while (n2 < n) {
                opType = opTypeArray[n2];
                try {
                    this.cacheStats.count("transactionalCacheNoStats", opType);
                    CacheTest.fail((String)"Expected NoStatsForCache error.");
                }
                catch (NoStatsForCache noStatsForCache) {}
                ++n2;
            }
            txn.commit();
            opTypeArray = TransactionStats.OpType.values();
            n = opTypeArray.length;
            n2 = 0;
            while (n2 < n) {
                opType = opTypeArray[n2];
                try {
                    this.cacheStats.count("transactionalCacheNoStats", opType);
                    CacheTest.fail((String)"Expected NoStatsForCache error.");
                }
                catch (NoStatsForCache noStatsForCache) {}
                ++n2;
            }
        }
        catch (Throwable e) {
            if (txn.getStatus() == 0) {
                txn.rollback();
            }
            throw e;
        }
    }

    public void testTransactionalCacheStatsForClears() throws Throwable {
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)"stats-test1"), (Object)"v", null);
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)"stats-test2"), (Object)"v", null);
        TransactionalCache.putSharedCacheValue(this.backingCache, (Serializable)((Object)"stats-test3"), (Object)"v", null);
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        long hitsAtStart = this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_HIT);
        long missesAtStart = this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_MISS);
        long putsAtStart = this.cacheStats.count("transactionalCache", TransactionStats.OpType.PUT);
        long removesAtStart = this.cacheStats.count("transactionalCache", TransactionStats.OpType.REMOVE);
        long clearsAtStart = this.cacheStats.count("transactionalCache", TransactionStats.OpType.CLEAR);
        try {
            txn.begin();
            this.transactionalCache.put((Serializable)((Object)"stats-test4"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test5"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test6"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test7"), (Object)"v");
            this.transactionalCache.put((Serializable)((Object)"stats-test8"), (Object)"v");
            this.transactionalCache.get((Serializable)((Object)"stats-test3"));
            this.transactionalCache.get((Serializable)((Object)"stats-test2"));
            this.transactionalCache.get((Serializable)((Object)"stats-test1"));
            this.transactionalCache.get((Serializable)((Object)"stats-test2"));
            this.transactionalCache.get((Serializable)((Object)"stats-test1"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss1"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss2"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss3"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss4"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss2"));
            this.transactionalCache.get((Serializable)((Object)"stats-miss3"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test1"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test2"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test3"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test9"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test10"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test11"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test12"));
            this.transactionalCache.remove((Serializable)((Object)"stats-test13"));
            this.transactionalCache.clear();
            this.transactionalCache.clear();
            CacheTest.assertEquals((long)hitsAtStart, (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_HIT));
            CacheTest.assertEquals((long)missesAtStart, (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_MISS));
            CacheTest.assertEquals((long)putsAtStart, (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.PUT));
            CacheTest.assertEquals((long)removesAtStart, (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.REMOVE));
            CacheTest.assertEquals((long)clearsAtStart, (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.CLEAR));
            txn.commit();
            CacheTest.assertEquals((long)(clearsAtStart + 2L), (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.CLEAR));
            CacheTest.assertEquals((long)(removesAtStart + 0L), (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.REMOVE));
            CacheTest.assertEquals((long)(putsAtStart + 0L), (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.PUT));
            CacheTest.assertEquals((long)(hitsAtStart + 3L), (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_HIT));
            CacheTest.assertEquals((long)(missesAtStart + 4L), (long)this.cacheStats.count("transactionalCache", TransactionStats.OpType.GET_MISS));
        }
        catch (Throwable e) {
            if (txn.getStatus() == 0) {
                txn.rollback();
            }
            throw e;
        }
    }

    private class PostCommitCacheReader
    extends TransactionListenerAdapter {
        private final SimpleCache<String, Object> transactionalCache;
        private final String key;
        private Throwable e;

        private PostCommitCacheReader(SimpleCache<String, Object> transactionalCache, String key) {
            this.transactionalCache = transactionalCache;
            this.key = key;
        }

        public void afterCommit() {
            try {
                this.transactionalCache.get((Serializable)((Object)this.key));
            }
            catch (Throwable e) {
                this.e = e;
                return;
            }
        }
    }

    private class PostCommitCacheWriter
    extends TransactionListenerAdapter {
        private final SimpleCache<String, Object> transactionalCache;
        private final String key;
        private final Object value;
        private Throwable e;

        private PostCommitCacheWriter(SimpleCache<String, Object> transactionalCache, String key, Object value) {
            this.transactionalCache = transactionalCache;
            this.key = key;
            this.value = value;
        }

        public void afterCommit() {
            try {
                this.transactionalCache.put((Serializable)((Object)this.key), this.value);
                this.transactionalCache.remove((Serializable)((Object)this.key));
                this.transactionalCache.clear();
            }
            catch (Throwable e) {
                this.e = e;
                return;
            }
        }
    }
}

