/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.UserAuditFilter;
import org.alfresco.repo.audit.model.AuditModelRegistryImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ResourceUtils;

public class UserAuditFilterTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuditModelRegistryImpl auditModelRegistry;
    private AuditComponent auditComponent;
    private ServiceRegistry serviceRegistry;
    private TransactionService transactionService;

    public void setUp() throws Exception {
        this.auditModelRegistry = (AuditModelRegistryImpl)ctx.getBean("auditModel.modelRegistry");
        this.auditComponent = (AuditComponent)ctx.getBean("auditComponent");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = this.serviceRegistry.getTransactionService();
        URL testModelUrl = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test.xml");
        this.auditModelRegistry.registerModel(testModelUrl);
        this.auditModelRegistry.loadAuditModels();
    }

    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        this.auditModelRegistry.destroy();
    }

    public void testUserFilter() {
        HashMap<Boolean, String> userArr = new HashMap<Boolean, String>();
        userArr.put(false, "user1");
        userArr.put(true, "user2");
        userArr.put(true, "bob");
        UserAuditFilter userAuditFilter = new UserAuditFilter();
        userAuditFilter.setUserFilterPattern("~user1;user2;.*");
        userAuditFilter.afterPropertiesSet();
        this.auditComponent.setUserAuditFilter(userAuditFilter);
        RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>>(){

            public Map<String, Serializable> execute() throws Throwable {
                HashMap<String, Object> values = new HashMap<String, Object>(13);
                values.put("/3.1/4.1", new Long(41L));
                values.put("/3.1/4.2", "42");
                values.put("/3.1/4.3", new Date());
                values.put("/3.1/4.4", "");
                values.put("/3.1/4.5", null);
                return UserAuditFilterTest.this.auditComponent.recordAuditValues("/test/one.one/two.one", values);
            }
        };
        AuthenticationUtil.RunAsWork<Map<String, Serializable>> testRunAs = new AuthenticationUtil.RunAsWork<Map<String, Serializable>>((RetryingTransactionHelper.RetryingTransactionCallback)testCallback){
            private final /* synthetic */ RetryingTransactionHelper.RetryingTransactionCallback val$testCallback;
            {
                this.val$testCallback = retryingTransactionCallback;
            }

            public Map<String, Serializable> doWork() throws Exception {
                return (Map)UserAuditFilterTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(this.val$testCallback);
            }
        };
        Set userSet = userArr.entrySet();
        for (Map.Entry entry : userSet) {
            Map result = (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)testRunAs, (String)((String)entry.getValue()));
            UserAuditFilterTest.assertEquals((boolean)((Boolean)entry.getKey()), (!result.isEmpty() ? 1 : 0) != 0);
        }
    }

    public void testUserFilterParseRedirectProperty() {
        UserAuditFilter userAuditFilter = new UserAuditFilter();
        userAuditFilter.setUserFilterPattern("~user1;${audit.test.user};.*");
        try {
            userAuditFilter.afterPropertiesSet();
            UserAuditFilterTest.fail((String)"UserAuditFilter shouldn't parse property with redirect '$'");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
    }
}

