/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.CompositePasswordEncoder;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authentication.RepositoryAuthenticatedUser;
import org.alfresco.repo.tenant.TenantDisabledException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;

public class RepositoryAuthenticationDao
implements MutableAuthenticationDao,
InitializingBean,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private static final StoreRef STOREREF_USERS = new StoreRef("user", "alfrescoUserStore");
    private static Log logger = LogFactory.getLog(RepositoryAuthenticationDao.class);
    protected AuthorityService authorityService;
    protected NodeService nodeService;
    protected TenantService tenantService;
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected PolicyComponent policyComponent;
    private TransactionService transactionService;
    protected CompositePasswordEncoder compositePasswordEncoder;
    private SimpleCache<String, NodeRef> singletonCache;
    private final String KEY_USERFOLDER_NODEREF = "key.userfolder.noderef";
    private SimpleCache<String, CacheEntry> authenticationCache;

    public void setNamespaceService(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setSingletonCache(SimpleCache<String, NodeRef> singletonCache) {
        this.singletonCache = singletonCache;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAuthenticationCache(SimpleCache<String, CacheEntry> authenticationCache) {
        this.authenticationCache = authenticationCache;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setCompositePasswordEncoder(CompositePasswordEncoder compositePasswordEncoder) {
        this.compositePasswordEncoder = compositePasswordEncoder;
    }

    public void afterPropertiesSet() throws Exception {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_USER, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_USER, (Behaviour)new JavaBehaviour(this, "onUpdateUserProperties"));
    }

    public UserDetails loadUserByUsername(String incomingUserName) throws UsernameNotFoundException, DataAccessException {
        CacheEntry userEntry = this.getUserEntryOrNull(incomingUserName);
        if (userEntry == null) {
            throw new UsernameNotFoundException("Could not find user by userName: " + AuthenticationUtil.maskUsername((String)incomingUserName));
        }
        UserDetails userDetails = userEntry.userDetails;
        if (userEntry.credentialExpiryDate == null || userEntry.credentialExpiryDate.getTime() >= System.currentTimeMillis()) {
            return userDetails;
        }
        if (userDetails instanceof RepositoryAuthenticatedUser) {
            RepositoryAuthenticatedUser repoUser = (RepositoryAuthenticatedUser)userDetails;
            return new RepositoryAuthenticatedUser(userDetails.getUsername(), userDetails.getPassword(), userDetails.isEnabled(), userDetails.isAccountNonExpired(), false, userDetails.isAccountNonLocked(), userDetails.getAuthorities(), repoUser.getHashIndicator(), repoUser.getSalt());
        }
        throw new AlfrescoRuntimeException("Unable to retrieve a compatible UserDetails object (requires RepositoryAuthenticatedUser)");
    }

    public NodeRef getUserOrNull(String caseSensitiveSearchUserName) {
        CacheEntry userEntry = this.getUserEntryOrNull(caseSensitiveSearchUserName);
        return userEntry == null ? null : userEntry.nodeRef;
    }

    private CacheEntry getUserEntryOrNull(String caseSensitiveSearchUserName) {
        try {
            return this.getUserEntryOrNullImpl(caseSensitiveSearchUserName);
        }
        catch (InvalidStoreRefException invalidStoreRefException) {
            return null;
        }
    }

    private CacheEntry getUserEntryOrNullImpl(String caseSensitiveSearchUserName) {
        if (caseSensitiveSearchUserName == null || caseSensitiveSearchUserName.length() == 0) {
            return null;
        }
        class SearchUserNameCallback
        implements RetryingTransactionHelper.RetryingTransactionCallback<CacheEntry> {
            private final /* synthetic */ String val$caseSensitiveSearchUserName;

            SearchUserNameCallback(String string) {
                this.val$caseSensitiveSearchUserName = string;
            }

            @Override
            public CacheEntry execute() throws Throwable {
                CacheEntry cacheEntry = (CacheEntry)RepositoryAuthenticationDao.this.authenticationCache.get((Serializable)((Object)this.val$caseSensitiveSearchUserName));
                if (cacheEntry != null && !RepositoryAuthenticationDao.this.nodeService.exists(cacheEntry.nodeRef)) {
                    logger.warn((Object)("Detected state cache entry for '" + this.val$caseSensitiveSearchUserName + "'. Node does not exist: " + cacheEntry));
                    RepositoryAuthenticationDao.this.removeAuthenticationFromCache(this.val$caseSensitiveSearchUserName);
                    cacheEntry = null;
                }
                if (cacheEntry != null) {
                    return cacheEntry;
                }
                List results = RepositoryAuthenticationDao.this.nodeService.getChildAssocs(RepositoryAuthenticationDao.this.getUserFolderLocation(this.val$caseSensitiveSearchUserName), (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)this.val$caseSensitiveSearchUserName));
                if (!results.isEmpty()) {
                    NodeRef userRef = RepositoryAuthenticationDao.this.tenantService.getName(((ChildAssociationRef)results.get(0)).getChildRef());
                    Map properties = RepositoryAuthenticationDao.this.nodeService.getProperties(userRef);
                    Pair<List<String>, String> hashPassword = RepositoryAuthenticationDao.determinePasswordHash(properties);
                    String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, properties.get(ContentModel.PROP_USER_USERNAME));
                    Serializable salt = (Serializable)properties.get(ContentModel.PROP_SALT);
                    GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
                    boolean isAdminAuthority = RepositoryAuthenticationDao.this.authorityService.isAdminAuthority(userName);
                    Date credentialsExpiryDate = RepositoryAuthenticationDao.this.getCredentialsExpiryDate(userName, properties, isAdminAuthority);
                    boolean credentialsHaveNotExpired = credentialsExpiryDate == null || credentialsExpiryDate.getTime() >= System.currentTimeMillis();
                    RepositoryAuthenticatedUser ud = new RepositoryAuthenticatedUser(userName, (String)hashPassword.getSecond(), RepositoryAuthenticationDao.this.getEnabled(userName, properties, isAdminAuthority), !RepositoryAuthenticationDao.this.getHasExpired(userName, properties, isAdminAuthority), credentialsHaveNotExpired, !RepositoryAuthenticationDao.this.getLocked(userName, properties, isAdminAuthority), gas, (List)hashPassword.getFirst(), salt);
                    cacheEntry = new CacheEntry(userRef, (UserDetails)ud, credentialsExpiryDate);
                    RepositoryAuthenticationDao.this.authenticationCache.put((Serializable)((Object)this.val$caseSensitiveSearchUserName), (Object)cacheEntry);
                }
                return cacheEntry;
            }
        }
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(new SearchUserNameCallback(caseSensitiveSearchUserName), true);
    }

    public static Pair<List<String>, String> determinePasswordHash(Map<QName, Serializable> properties) {
        List hashIndicator = (List)((Object)properties.get(ContentModel.PROP_HASH_INDICATOR));
        if (hashIndicator != null && hashIndicator.size() > 0) {
            return new Pair((Object)hashIndicator, (Object)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_PASSWORD_HASH))));
        }
        String passHash = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_PASSWORD_SHA256));
        if (passHash != null) {
            return new Pair(CompositePasswordEncoder.SHA256, (Object)passHash);
        }
        passHash = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_PASSWORD));
        if (passHash != null) {
            return new Pair(CompositePasswordEncoder.MD4, (Object)passHash);
        }
        throw new AlfrescoRuntimeException("Unable to find a password for user '" + AuthenticationUtil.maskUsername((String)((String)((Object)properties.get(ContentModel.PROP_USER_USERNAME)))) + "', please check your repository authentication settings.");
    }

    @Override
    public void createUser(String caseSensitiveUserName, char[] rawPassword) throws AuthenticationException {
        this.createUser(caseSensitiveUserName, null, rawPassword);
    }

    @Override
    public void createUser(String caseSensitiveUserName, String hashedPassword, char[] rawPassword) throws AuthenticationException {
        boolean emptyPassword;
        this.tenantService.checkDomainUser(caseSensitiveUserName);
        NodeRef userRef = this.getUserOrNull(caseSensitiveUserName);
        if (userRef != null) {
            throw new AuthenticationException("User already exists: " + AuthenticationUtil.maskUsername((String)caseSensitiveUserName));
        }
        NodeRef typesNode = this.getUserFolderLocation(caseSensitiveUserName);
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        properties.put(ContentModel.PROP_USER_USERNAME, caseSensitiveUserName);
        String salt = GUID.generate();
        properties.put(ContentModel.PROP_SALT, salt);
        boolean bl = emptyPassword = rawPassword != null ? "".equals(new String(rawPassword)) : true;
        if (emptyPassword) {
            rawPassword = UUID.randomUUID().toString().toCharArray();
        }
        if (hashedPassword == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Hashing raw password to " + this.compositePasswordEncoder.getPreferredEncoding() + " for " + AuthenticationUtil.maskUsername((String)caseSensitiveUserName)));
            }
            hashedPassword = this.compositePasswordEncoder.encodePreferred(new String(rawPassword), salt);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("Using hashed password for  " + AuthenticationUtil.maskUsername((String)caseSensitiveUserName)));
        }
        properties.put(ContentModel.PROP_PASSWORD_HASH, hashedPassword);
        properties.put(ContentModel.PROP_HASH_INDICATOR, (Serializable)((Object)Arrays.asList(this.compositePasswordEncoder.getPreferredEncoding())));
        properties.put(ContentModel.PROP_ACCOUNT_EXPIRES, false);
        properties.put(ContentModel.PROP_CREDENTIALS_EXPIRE, false);
        properties.put(ContentModel.PROP_ENABLED, !emptyPassword);
        properties.put(ContentModel.PROP_ACCOUNT_LOCKED, false);
        this.nodeService.createNode(typesNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)caseSensitiveUserName), ContentModel.TYPE_USER, properties);
    }

    private NodeRef getUserFolderLocation(String caseSensitiveUserName) {
        NodeRef userNodeRef;
        String userDomain = null;
        try {
            userDomain = this.tenantService.getUserDomain(caseSensitiveUserName);
        }
        catch (TenantDisabledException tenantDisabledException) {}
        if (userDomain == null) {
            userDomain = "";
        }
        if ((userNodeRef = (NodeRef)this.singletonCache.get((Serializable)((Object)(String.valueOf(userDomain) + "key.userfolder.noderef")))) == null) {
            QName qnameAssocSystem = QName.createQName((String)"sys", (String)"system", (NamespacePrefixResolver)this.namespacePrefixResolver);
            QName qnameAssocUsers = QName.createQName((String)"sys", (String)"people", (NamespacePrefixResolver)this.namespacePrefixResolver);
            StoreRef userStoreRef = null;
            userStoreRef = TenantUtil.isCurrentDomainDefault() ? this.tenantService.getName(caseSensitiveUserName, new StoreRef(STOREREF_USERS.getProtocol(), STOREREF_USERS.getIdentifier())) : new StoreRef(STOREREF_USERS.getProtocol(), STOREREF_USERS.getIdentifier());
            NodeRef rootNode = this.nodeService.getRootNode(userStoreRef);
            List results = this.nodeService.getChildAssocs(rootNode, RegexQNamePattern.MATCH_ALL, (QNamePattern)qnameAssocSystem);
            NodeRef sysNodeRef = null;
            if (results.size() == 0) {
                throw new AlfrescoRuntimeException("Required authority system folder path not found: " + qnameAssocSystem);
            }
            sysNodeRef = ((ChildAssociationRef)results.get(0)).getChildRef();
            if ((results = this.nodeService.getChildAssocs(sysNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)qnameAssocUsers)).size() == 0) {
                throw new AlfrescoRuntimeException("Required user folder path not found: " + qnameAssocUsers);
            }
            userNodeRef = this.tenantService.getName(((ChildAssociationRef)results.get(0)).getChildRef());
            this.singletonCache.put((Serializable)((Object)(String.valueOf(this.tenantService.getUserDomain(caseSensitiveUserName)) + "key.userfolder.noderef")), (Object)userNodeRef);
        }
        return userNodeRef;
    }

    @Override
    public void updateUser(String userName, char[] rawPassword) throws AuthenticationException {
        NodeRef userRef = this.getUserOrNull(userName);
        if (userRef == null) {
            throw new AuthenticationException("User name does not exist: " + AuthenticationUtil.maskUsername((String)userName));
        }
        Map properties = this.nodeService.getProperties(userRef);
        String salt = GUID.generate();
        properties.remove(ContentModel.PROP_SALT);
        properties.put(ContentModel.PROP_SALT, salt);
        properties.put(ContentModel.PROP_PASSWORD_HASH, this.compositePasswordEncoder.encodePreferred(new String(rawPassword), salt));
        properties.put(ContentModel.PROP_HASH_INDICATOR, this.compositePasswordEncoder.getPreferredEncoding());
        properties.remove(ContentModel.PROP_PASSWORD);
        properties.remove(ContentModel.PROP_PASSWORD_SHA256);
        this.nodeService.setProperties(userRef, properties);
    }

    @Override
    public void deleteUser(String userName) throws AuthenticationException {
        NodeRef userRef = this.getUserOrNull(userName);
        if (userRef == null) {
            throw new AuthenticationException("User name does not exist: " + AuthenticationUtil.maskUsername((String)userName));
        }
        this.nodeService.deleteNode(userRef);
    }

    public Object getSalt(UserDetails userDetails) {
        return null;
    }

    @Override
    public boolean userExists(String userName) {
        return this.getUserOrNull(userName) != null;
    }

    protected Map<QName, Serializable> getUserProperties(String userName) {
        NodeRef userNodeRef = this.getUserOrNull(userName);
        if (userNodeRef == null) {
            return null;
        }
        return this.nodeService.getProperties(userNodeRef);
    }

    @Override
    public boolean getAccountExpires(String userName) {
        if (this.authorityService.isAdminAuthority(userName)) {
            return false;
        }
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return false;
        }
        Serializable ser = this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    @Override
    public Date getAccountExpiryDate(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES))) {
            return (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRY_DATE));
        }
        return null;
    }

    @Override
    public boolean getAccountHasExpired(String userName) {
        return this.getHasExpired(userName, null, null);
    }

    protected boolean getHasExpired(String userName, Map<QName, Serializable> properties, Boolean isAdminAuthority) {
        if (isAdminAuthority == null) {
            isAdminAuthority = this.authorityService.isAdminAuthority(userName);
        }
        if (isAdminAuthority.booleanValue()) {
            return false;
        }
        if (properties == null) {
            properties = this.getUserProperties(userName);
        }
        if (properties == null) {
            return false;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)properties.get(ContentModel.PROP_ACCOUNT_EXPIRES))) {
            Date date = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)properties.get(ContentModel.PROP_ACCOUNT_EXPIRY_DATE));
            if (date == null) {
                return false;
            }
            return date.getTime() < System.currentTimeMillis();
        }
        return false;
    }

    @Override
    public boolean getLocked(String userName) {
        return this.getLocked(userName, null, null);
    }

    @Override
    public boolean getAccountlocked(String userName) {
        return this.getLocked(userName, null, null);
    }

    protected boolean getLocked(String userName, Map<QName, Serializable> properties, Boolean isAdminAuthority) {
        if (isAdminAuthority == null) {
            isAdminAuthority = this.authorityService.isAdminAuthority(userName);
        }
        if (isAdminAuthority.booleanValue()) {
            return false;
        }
        if (properties == null) {
            properties = this.getUserProperties(userName);
        }
        if (properties == null) {
            return false;
        }
        Serializable ser = properties.get(ContentModel.PROP_ACCOUNT_LOCKED);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    @Override
    public boolean getCredentialsExpire(String userName) {
        return this.getCredentialsExpire(userName, null);
    }

    protected boolean getCredentialsExpire(String userName, Map<QName, Serializable> properties) {
        if (this.authorityService.isAdminAuthority(userName)) {
            return false;
        }
        if (properties == null) {
            properties = this.getUserProperties(userName);
        }
        if (properties == null) {
            return false;
        }
        Serializable ser = properties.get(ContentModel.PROP_CREDENTIALS_EXPIRE);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    @Override
    public Date getCredentialsExpiryDate(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE))) {
            return (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRY_DATE));
        }
        return null;
    }

    @Override
    public boolean getCredentialsHaveExpired(String userName) {
        return !this.loadUserByUsername(userName).isCredentialsNonExpired();
    }

    protected boolean getCredentialsHaveExpired(String userName, Map<QName, Serializable> properties, Boolean isAdminAuthority) {
        Date credentialsExpiryDate = this.getCredentialsExpiryDate(userName, properties, isAdminAuthority);
        boolean credentialsHaveNotExpired = credentialsExpiryDate == null || credentialsExpiryDate.getTime() >= System.currentTimeMillis();
        return !credentialsHaveNotExpired;
    }

    private Date getCredentialsExpiryDate(String userName, Map<QName, Serializable> properties, Boolean isAdminAuthority) {
        if (isAdminAuthority == null) {
            isAdminAuthority = this.authorityService.isAdminAuthority(userName);
        }
        if (isAdminAuthority.booleanValue()) {
            return null;
        }
        if (properties == null) {
            properties = this.getUserProperties(userName);
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)properties.get(ContentModel.PROP_CREDENTIALS_EXPIRE))) {
            return (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)properties.get(ContentModel.PROP_CREDENTIALS_EXPIRY_DATE));
        }
        return null;
    }

    @Override
    public boolean getEnabled(String userName) {
        return this.getEnabled(userName, null, null);
    }

    protected boolean getEnabled(String userName, Map<QName, Serializable> properties, Boolean isAdminAuthority) {
        if (isAdminAuthority == null) {
            isAdminAuthority = this.authorityService.isAdminAuthority(userName);
        }
        if (isAdminAuthority.booleanValue()) {
            return true;
        }
        if (properties == null) {
            properties = this.getUserProperties(userName);
        }
        if (properties == null) {
            return false;
        }
        Serializable ser = properties.get(ContentModel.PROP_ENABLED);
        if (ser == null) {
            return true;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    @Override
    public void setAccountExpires(String userName, boolean expires) {
        NodeRef userNode = this.getUserOrNull(userName);
        this.validateUserNode(userName, userNode);
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES, (Serializable)Boolean.valueOf(expires));
    }

    @Override
    public void setAccountExpiryDate(String userName, Date expiryDate) {
        NodeRef userNode = this.getUserOrNull(userName);
        this.validateUserNode(userName, userNode);
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRY_DATE, (Serializable)expiryDate);
    }

    @Override
    public void setCredentialsExpire(String userName, boolean expires) {
        NodeRef userNode = this.getUserOrNull(userName);
        this.validateUserNode(userName, userNode);
        this.nodeService.setProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE, (Serializable)Boolean.valueOf(expires));
    }

    @Override
    public void setCredentialsExpiryDate(String userName, Date exipryDate) {
        NodeRef userNode = this.getUserOrNull(userName);
        this.validateUserNode(userName, userNode);
        this.nodeService.setProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRY_DATE, (Serializable)exipryDate);
    }

    @Override
    public void setEnabled(String userName, boolean enabled) {
        if (!enabled && this.authorityService.isAdminAuthority(userName)) {
            return;
        }
        NodeRef userNode = this.getUserOrNull(userName);
        this.validateUserNode(userName, userNode);
        this.nodeService.setProperty(userNode, ContentModel.PROP_ENABLED, (Serializable)Boolean.valueOf(enabled));
    }

    @Override
    public void setLocked(String userName, boolean locked) {
        NodeRef userNode = this.getUserOrNull(userName);
        this.validateUserNode(userName, userNode);
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_LOCKED, (Serializable)Boolean.valueOf(locked));
    }

    private void validateUserNode(String userName, NodeRef userNode) {
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + AuthenticationUtil.maskUsername((String)userName));
        }
    }

    @Override
    public String getMD4HashedPassword(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        Map properties = this.nodeService.getProperties(userNode);
        List hashIndicator = (List)properties.get(ContentModel.PROP_HASH_INDICATOR);
        if (hashIndicator != null && hashIndicator.size() == 1 && CompositePasswordEncoder.MD4.equals(hashIndicator)) {
            return (String)DefaultTypeConverter.INSTANCE.convert(String.class, properties.get(ContentModel.PROP_PASSWORD_HASH));
        }
        String passHash = (String)DefaultTypeConverter.INSTANCE.convert(String.class, properties.get(ContentModel.PROP_PASSWORD));
        if (passHash != null) {
            return passHash;
        }
        logger.error((Object)("Request made of MD4 hash for " + AuthenticationUtil.maskUsername((String)userName) + " but unable to find it."));
        return null;
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        NodeRef userNode;
        String uidBefore = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)before.get(ContentModel.PROP_USERNAME));
        String uidAfter = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)after.get(ContentModel.PROP_USERNAME));
        if (uidBefore != null && !EqualsHelper.nullSafeEquals((Object)uidBefore, (Object)uidAfter) && (userNode = this.getUserOrNull(uidBefore)) != null) {
            this.nodeService.setProperty(userNode, ContentModel.PROP_USER_USERNAME, (Serializable)((Object)uidAfter));
            this.nodeService.moveNode(userNode, this.nodeService.getPrimaryParent(userNode).getParentRef(), ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)uidAfter));
            this.removeAuthenticationFromCache(uidBefore);
        }
        this.removeAuthenticationFromCache(uidAfter);
    }

    public void onUpdateUserProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        String uidBefore = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)before.get(ContentModel.PROP_USER_USERNAME));
        if (uidBefore != null) {
            this.removeAuthenticationFromCache(uidBefore);
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        String userName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USER_USERNAME));
        if (userName != null) {
            this.removeAuthenticationFromCache(userName);
        }
    }

    private void removeAuthenticationFromCache(String key) {
        this.authenticationCache.remove((Serializable)((Object)key));
        if (this.authenticationCache instanceof TransactionalCache) {
            TransactionalCache authenticationCacheTxn = (TransactionalCache)this.authenticationCache;
            authenticationCacheTxn.lockValue(key);
        }
    }

    static class CacheEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public NodeRef nodeRef;
        public UserDetails userDetails;
        public Date credentialExpiryDate;

        public CacheEntry(NodeRef nodeRef, UserDetails userDetails, Date credentialExpiryDate) {
            this.nodeRef = nodeRef;
            this.userDetails = userDetails;
            this.credentialExpiryDate = credentialExpiryDate;
        }

        public String toString() {
            return "CacheEntry [nodeRef=" + this.nodeRef + ", userDetails=" + this.userDetails + "]";
        }
    }
}

