/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.repo.search.SearchEngineResultSet;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.impl.solr.SolrJSONResultSetRow;
import org.alfresco.repo.search.impl.solr.SolrJSONResultSetRowIterator;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.GenericBucket;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.GenericFacetResponse;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.ListMetric;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.Metric;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.PercentileMetric;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.RangeResultMapper;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.SimpleMetric;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.RangeParameters;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SpellCheckResult;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SolrJSONResultSet
implements SearchEngineResultSet {
    private static final Log logger = LogFactory.getLog(SolrJSONResultSet.class);
    private NodeService nodeService;
    private ArrayList<Pair<Long, Float>> page;
    private ArrayList<NodeRef> refs;
    private ResultSetMetaData rsmd;
    private Long status;
    private Long queryTime;
    private Long numberFound;
    private Long start;
    private Float maxScore;
    private SimpleResultSetMetaData resultSetMetaData;
    private HashMap<String, List<Pair<String, Integer>>> fieldFacets = new HashMap(1);
    private Map<String, Integer> facetQueries = new HashMap<String, Integer>();
    private Map<NodeRef, List<Pair<String, List<String>>>> highlighting = new HashMap<NodeRef, List<Pair<String, List<String>>>>();
    private Map<String, List<Pair<String, Integer>>> facetIntervals = new HashMap<String, List<Pair<String, Integer>>>(1);
    private Map<String, List<Map<String, String>>> facetRanges = new HashMap<String, List<Map<String, String>>>();
    private List<GenericFacetResponse> pivotFacets = new ArrayList<GenericFacetResponse>();
    private Map<String, Set<Metric>> stats = new HashMap<String, Set<Metric>>();
    private NodeDAO nodeDao;
    private long lastIndexedTxId;
    private SpellCheckResult spellCheckResult;
    private boolean processedDenies;

    public SolrJSONResultSet(JSONObject json, SearchParameters searchParameters, NodeService nodeService, NodeDAO nodeDao, LimitBy limitBy, int maxResults) {
        this.nodeService = nodeService;
        this.nodeDao = nodeDao;
        try {
            JSONObject spellCheckJson;
            JSONObject responseHeader = json.getJSONObject("responseHeader");
            this.status = responseHeader.getLong("status");
            this.queryTime = responseHeader.getLong("QTime");
            JSONObject response = json.getJSONObject("response");
            this.numberFound = response.getLong("numFound");
            this.start = response.getLong("start");
            Double d = response.getDouble("maxScore");
            this.maxScore = Float.valueOf(d.floatValue());
            if (json.has("lastIndexedTx")) {
                this.lastIndexedTxId = json.getLong("lastIndexedTx");
            }
            if (json.has("processedDenies")) {
                this.processedDenies = json.getBoolean("processedDenies");
            }
            JSONArray docs = response.getJSONArray("docs");
            int numDocs = docs.length();
            ArrayList<Long> rawDbids = new ArrayList<Long>(numDocs);
            ArrayList<Float> rawScores = new ArrayList<Float>(numDocs);
            int i = 0;
            while (i < numDocs) {
                Float score;
                Long dbid;
                JSONObject doc = docs.getJSONObject(i);
                JSONArray dbids = doc.optJSONArray("DBID");
                if (dbids != null) {
                    dbid = dbids.getLong(0);
                    score = Float.valueOf((float)doc.getDouble("score"));
                    rawDbids.add(dbid);
                    rawScores.add(score);
                } else {
                    dbid = doc.optLong("DBID");
                    if (dbid != null) {
                        score = Float.valueOf((float)doc.getDouble("score"));
                        rawDbids.add(dbid);
                        rawScores.add(score);
                    } else {
                        throw new QueryParserException("No DBID found for doc ...");
                    }
                }
                ++i;
            }
            if (searchParameters.isBulkFetchEnabled()) {
                nodeDao.cacheNodesById(rawDbids);
            }
            this.page = new ArrayList(numDocs);
            this.refs = new ArrayList(numDocs);
            HashMap<Long, NodeRef> dbIdNodeRefs = new HashMap<Long, NodeRef>(numDocs);
            int i2 = 0;
            while (i2 < numDocs) {
                Long dbid = rawDbids.get(i2);
                NodeRef nodeRef = nodeService.getNodeRef(dbid);
                if (nodeRef != null) {
                    this.page.add((Pair<Long, Float>)new Pair((Object)dbid, (Object)((Float)rawScores.get(i2))));
                    this.refs.add(nodeRef);
                    dbIdNodeRefs.put(dbid, nodeRef);
                }
                ++i2;
            }
            if (json.has("highlighting")) {
                JSONObject highObj = json.getJSONObject("highlighting");
                Iterator it = highObj.keys();
                while (it.hasNext()) {
                    Long nodeKey = null;
                    String aKey = (String)it.next();
                    JSONObject high = highObj.getJSONObject(aKey);
                    ArrayList<Pair> highFields = new ArrayList<Pair>(high.length());
                    Iterator hit = high.keys();
                    while (hit.hasNext()) {
                        String highKey = (String)hit.next();
                        if ("DBID".equals(highKey)) {
                            nodeKey = high.getLong("DBID");
                            continue;
                        }
                        JSONArray highVal = high.getJSONArray(highKey);
                        ArrayList<String> highValues = new ArrayList<String>(highVal.length());
                        int i3 = 0;
                        int length = highVal.length();
                        while (i3 < length) {
                            highValues.add(highVal.getString(i3));
                            ++i3;
                        }
                        Pair highPair = new Pair((Object)highKey, highValues);
                        highFields.add(highPair);
                    }
                    NodeRef nodefRef = (NodeRef)dbIdNodeRefs.get(nodeKey);
                    if (nodefRef == null || highFields.isEmpty()) continue;
                    this.highlighting.put(nodefRef, highFields);
                }
            }
            if (json.has("facet_counts")) {
                String fieldName;
                Iterator it;
                JSONObject facet_counts = json.getJSONObject("facet_counts");
                if (facet_counts.has("facet_queries")) {
                    JSONObject facet_queries = facet_counts.getJSONObject("facet_queries");
                    it = facet_queries.keys();
                    while (it.hasNext()) {
                        String fq = (String)it.next();
                        Integer count = facet_queries.getInt(fq);
                        this.facetQueries.put(fq, count);
                    }
                }
                if (facet_counts.has("facet_fields")) {
                    JSONObject facet_fields = facet_counts.getJSONObject("facet_fields");
                    it = facet_fields.keys();
                    while (it.hasNext()) {
                        fieldName = (String)it.next();
                        JSONArray facets = facet_fields.getJSONArray(fieldName);
                        int facetArraySize = facets.length();
                        ArrayList<Pair> facetValues = new ArrayList<Pair>(facetArraySize / 2);
                        int i4 = 0;
                        while (i4 < facetArraySize) {
                            String facetEntryName = "Null";
                            if (!facets.isNull(i4)) {
                                facetEntryName = facets.getString(i4);
                            }
                            Integer facetEntryCount = facets.getInt(i4 + 1);
                            Pair pair = new Pair((Object)facetEntryName, (Object)facetEntryCount);
                            facetValues.add(pair);
                            i4 += 2;
                        }
                        this.fieldFacets.put(fieldName, facetValues);
                    }
                }
                if (facet_counts.has("facet_intervals")) {
                    JSONObject facet_intervals = facet_counts.getJSONObject("facet_intervals");
                    it = facet_intervals.keys();
                    while (it.hasNext()) {
                        fieldName = (String)it.next();
                        JSONObject intervals = facet_intervals.getJSONObject(fieldName);
                        ArrayList<Pair> intervalValues = new ArrayList<Pair>(intervals.length());
                        Iterator itk = intervals.keys();
                        while (itk.hasNext()) {
                            String key = (String)itk.next();
                            Integer count = intervals.getInt(key);
                            intervalValues.add(new Pair((Object)key, (Object)count));
                        }
                        this.facetIntervals.put(fieldName, intervalValues);
                    }
                }
                if (facet_counts.has("facet_pivot")) {
                    JSONObject facet_pivot = facet_counts.getJSONObject("facet_pivot");
                    it = facet_pivot.keys();
                    while (it.hasNext()) {
                        String pivotName = (String)it.next();
                        this.pivotFacets.addAll(this.buildPivot(facet_pivot, pivotName, searchParameters.getRanges()));
                    }
                }
                if (facet_counts.has("facet_ranges")) {
                    JSONObject facet_ranges = facet_counts.getJSONObject("facet_ranges");
                    it = facet_ranges.keys();
                    while (it.hasNext()) {
                        fieldName = (String)it.next();
                        String end = "";
                        try {
                            end = facet_ranges.getJSONObject(fieldName).getString("end");
                        }
                        catch (JSONException jSONException) {
                            end = String.valueOf(facet_ranges.getJSONObject(fieldName).getInt("end"));
                        }
                        JSONArray rangeCollection = facet_ranges.getJSONObject(fieldName).getJSONArray("counts");
                        ArrayList buckets2 = new ArrayList();
                        int i5 = 0;
                        while (i5 < rangeCollection.length()) {
                            String position;
                            String string = position = i5 == 0 ? "head" : "body";
                            if (i5 + 2 == rangeCollection.length()) {
                                position = "tail";
                            }
                            HashMap<String, String> rangeMap = new HashMap<String, String>(3);
                            String rangeFrom = rangeCollection.getString(i5);
                            String facetRangeCount = String.valueOf(rangeCollection.getInt(i5 + 1));
                            String rangeTo = i5 + 2 < rangeCollection.length() ? rangeCollection.getString(i5 + 2) : end;
                            String label = String.valueOf(rangeFrom) + " - " + rangeTo;
                            rangeMap.put("label", label);
                            rangeMap.put("count", facetRangeCount);
                            rangeMap.put("start", rangeFrom);
                            rangeMap.put("end", rangeTo);
                            rangeMap.put("bucketPosition", position);
                            buckets2.add(rangeMap);
                            i5 += 2;
                        }
                        this.facetRanges.put(fieldName, buckets2);
                    }
                    Map<String, List<Map<String, String>>> builtRanges = this.buildRanges(facet_ranges);
                    builtRanges.forEach((pKey, buckets) -> this.facetRanges.put((String)pKey, (List<Map<String, String>>)buckets));
                }
            }
            if (json.has("stats")) {
                JSONObject statsObj = json.getJSONObject("stats");
                Map<String, Map<String, Object>> builtStats = this.buildStats(statsObj);
                builtStats.forEach((pKey, pVal) -> this.stats.put((String)pKey, this.getMetrics((Map<String, Object>)pVal)));
            }
            if ((spellCheckJson = (JSONObject)json.opt("spellcheck")) != null) {
                ArrayList<String> list = new ArrayList<String>(3);
                String flag = "";
                boolean searchedFor = false;
                if (spellCheckJson.has("searchInsteadFor")) {
                    flag = "searchInsteadFor";
                    searchedFor = true;
                    list.add(spellCheckJson.getString(flag));
                } else if (spellCheckJson.has("didYouMean")) {
                    flag = "didYouMean";
                    JSONArray suggestions = spellCheckJson.getJSONArray(flag);
                    int i6 = 0;
                    int lenght = suggestions.length();
                    while (i6 < lenght) {
                        list.add(suggestions.getString(i6));
                        ++i6;
                    }
                }
                this.spellCheckResult = new SpellCheckResult(flag, list, searchedFor);
            } else {
                this.spellCheckResult = new SpellCheckResult(null, null, false);
            }
        }
        catch (JSONException e) {
            logger.info((Object)e.getMessage());
        }
        this.resultSetMetaData = new SimpleResultSetMetaData(maxResults > 0 && this.numberFound < (long)maxResults ? LimitBy.UNLIMITED : limitBy, PermissionEvaluationMode.EAGER, searchParameters);
    }

    protected Map<String, List<Map<String, String>>> buildRanges(JSONObject facet_ranges) throws JSONException {
        HashMap<String, List<Map<String, String>>> ranges = new HashMap<String, List<Map<String, String>>>();
        Iterator it = facet_ranges.keys();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            String end = "";
            try {
                end = facet_ranges.getJSONObject(fieldName).getString("end");
            }
            catch (JSONException jSONException) {
                end = String.valueOf(facet_ranges.getJSONObject(fieldName).getInt("end"));
            }
            JSONArray rangeCollection = facet_ranges.getJSONObject(fieldName).getJSONArray("counts");
            ArrayList buckets = new ArrayList();
            int i = 0;
            while (i < rangeCollection.length()) {
                String position;
                String string = position = i == 0 ? "head" : "body";
                if (i + 2 == rangeCollection.length()) {
                    position = "tail";
                }
                HashMap<String, String> rangeMap = new HashMap<String, String>(3);
                String rangeFrom = rangeCollection.getString(i);
                int facetRangeCount = rangeCollection.getInt(i + 1);
                String rangeTo = i + 2 < rangeCollection.length() ? rangeCollection.getString(i + 2) : end;
                String label = String.valueOf(rangeFrom) + " - " + rangeTo;
                rangeMap.put("label", label);
                rangeMap.put("count", String.valueOf(facetRangeCount));
                rangeMap.put("start", rangeFrom);
                rangeMap.put("end", rangeTo);
                rangeMap.put("bucketPosition", position);
                buckets.add(rangeMap);
                i += 2;
            }
            ranges.put(fieldName, buckets);
        }
        return ranges;
    }

    protected Map<String, Map<String, Object>> buildStats(JSONObject statsObj) throws JSONException {
        if (statsObj.has("stats_fields")) {
            HashMap<String, Map<String, Object>> statsMap = new HashMap<String, Map<String, Object>>();
            JSONObject statsFields = statsObj.getJSONObject("stats_fields");
            Iterator itk = statsFields.keys();
            while (itk.hasNext()) {
                String fieldName = (String)itk.next();
                JSONObject theStats = statsFields.getJSONObject(fieldName);
                HashMap<String, Object> fieldStats = new HashMap<String, Object>(statsFields.length());
                Iterator it = theStats.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    Object val = theStats.get(key);
                    if ("count".equals(key)) {
                        key = Metric.METRIC_TYPE.countValues.toString();
                    }
                    fieldStats.put(key, val);
                }
                statsMap.put(fieldName, fieldStats);
            }
            return statsMap;
        }
        return Collections.emptyMap();
    }

    protected List<GenericFacetResponse> buildPivot(JSONObject facet_pivot, String pivotName, List<RangeParameters> rangeParameters) throws JSONException {
        if (!facet_pivot.has(pivotName)) {
            return Collections.emptyList();
        }
        JSONArray pivots = facet_pivot.getJSONArray(pivotName);
        HashMap pivotBuckets = new HashMap(pivots.length());
        ArrayList<GenericFacetResponse> facetResponses = new ArrayList<GenericFacetResponse>();
        int i = 0;
        while (i < pivots.length()) {
            JSONObject piv = pivots.getJSONObject(i);
            HashSet<Metric> metrics = new HashSet<Metric>(1);
            ArrayList<GenericFacetResponse> nested = new ArrayList<GenericFacetResponse>();
            String field = piv.getString("field");
            String value = piv.getString("value");
            if (piv.has("stats")) {
                JSONObject stats = piv.getJSONObject("stats");
                Map<String, Map<String, Object>> pivotStats = this.buildStats(stats);
                pivotStats.forEach((pKey, pVal) -> metrics.addAll(this.getMetrics((Map<String, Object>)pVal)));
            }
            Integer count = piv.getInt("count");
            metrics.add(new SimpleMetric(Metric.METRIC_TYPE.count, count));
            nested.addAll(this.buildPivot(piv, "pivot", rangeParameters));
            if (piv.has("ranges")) {
                JSONObject ranges = piv.getJSONObject("ranges");
                Map<String, List<Map<String, String>>> builtRanges = this.buildRanges(ranges);
                List<GenericFacetResponse> rangefacets = RangeResultMapper.getGenericFacetsForRanges(builtRanges, rangeParameters);
                nested.addAll(rangefacets);
            }
            GenericBucket buck = new GenericBucket(value, String.valueOf(field) + ":\"" + value + "\"", null, metrics, nested);
            List<GenericBucket> listBucks = pivotBuckets.containsKey(field) ? (List)pivotBuckets.get(field) : new ArrayList();
            listBucks.add(buck);
            pivotBuckets.put(field, listBucks);
            ++i;
        }
        for (Map.Entry entry : pivotBuckets.entrySet()) {
            facetResponses.add(new GenericFacetResponse(GenericFacetResponse.FACET_TYPE.pivot, (String)entry.getKey(), (List)entry.getValue()));
        }
        if (!facetResponses.isEmpty()) {
            return facetResponses;
        }
        return Collections.emptyList();
    }

    protected Set<Metric> getMetrics(Map<String, Object> metrics) {
        if (metrics != null && !metrics.isEmpty()) {
            return metrics.entrySet().stream().map(aStat -> {
                Metric.METRIC_TYPE metricType = Metric.METRIC_TYPE.valueOf((String)aStat.getKey());
                Object val = aStat.getValue();
                if (JSONObject.NULL.equals(val)) {
                    return null;
                }
                switch (metricType) {
                    case distinctValues: {
                        return new ListMetric(metricType, val);
                    }
                    case percentiles: {
                        return new PercentileMetric(metricType, val);
                    }
                    case facets: {
                        return null;
                    }
                    case mean: {
                        if (!"NaN".equals(String.valueOf(val))) break;
                        return null;
                    }
                }
                return new SimpleMetric(metricType, val);
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void close() {
    }

    public boolean getBulkFetch() {
        return true;
    }

    public int getBulkFetchSize() {
        return Integer.MAX_VALUE;
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        ChildAssociationRef primaryParentAssoc = this.nodeService.getPrimaryParent(this.getNodeRef(n));
        if (primaryParentAssoc != null) {
            return primaryParentAssoc;
        }
        return null;
    }

    public List<ChildAssociationRef> getChildAssocRefs() {
        ArrayList<ChildAssociationRef> refs = new ArrayList<ChildAssociationRef>(this.page.size());
        int i = 0;
        while (i < this.page.size()) {
            refs.add(this.getChildAssocRef(i));
            ++i;
        }
        return refs;
    }

    public NodeRef getNodeRef(int n) {
        return this.refs.get(n);
    }

    public List<NodeRef> getNodeRefs() {
        return Collections.unmodifiableList(this.refs);
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public ResultSetRow getRow(int i) {
        return new SolrJSONResultSetRow(this, i);
    }

    public float getScore(int n) {
        return ((Float)this.page.get(n).getSecond()).floatValue();
    }

    public int getStart() {
        return this.start.intValue();
    }

    public boolean hasMore() {
        return this.numberFound > this.start + (long)this.page.size();
    }

    public int length() {
        return this.page.size();
    }

    public boolean setBulkFetch(boolean bulkFetch) {
        return bulkFetch;
    }

    public int setBulkFetchSize(int bulkFetchSize) {
        return bulkFetchSize;
    }

    public Iterator<ResultSetRow> iterator() {
        return new SolrJSONResultSetRowIterator(this);
    }

    @Override
    public Long getQueryTime() {
        return this.queryTime;
    }

    @Override
    public long getNumberFound() {
        return this.numberFound;
    }

    public List<Pair<String, Integer>> getFieldFacet(String field) {
        List<Pair<String, Integer>> answer = this.fieldFacets.get(field);
        if (answer != null) {
            return answer;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, List<Pair<String, Integer>>> getFieldFacets() {
        return Collections.unmodifiableMap(this.fieldFacets);
    }

    @Override
    public Map<String, List<Pair<String, Integer>>> getFacetIntervals() {
        return Collections.unmodifiableMap(this.facetIntervals);
    }

    @Override
    public List<GenericFacetResponse> getPivotFacets() {
        return this.pivotFacets;
    }

    @Override
    public Map<String, Set<Metric>> getStats() {
        return Collections.unmodifiableMap(this.stats);
    }

    @Override
    public long getLastIndexedTxId() {
        return this.lastIndexedTxId;
    }

    public Map<String, Integer> getFacetQueries() {
        return Collections.unmodifiableMap(this.facetQueries);
    }

    public Map<NodeRef, List<Pair<String, List<String>>>> getHighlighting() {
        return Collections.unmodifiableMap(this.highlighting);
    }

    public SpellCheckResult getSpellCheckResult() {
        return this.spellCheckResult;
    }

    @Override
    public boolean getProcessedDenies() {
        return this.processedDenies;
    }

    @Override
    public Map<String, List<Map<String, String>>> getFacetRanges() {
        return this.facetRanges;
    }
}

