/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.acegisecurity.AuthenticationException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.processor.ProcessorExtension;
import org.alfresco.repo.jscript.AlfrescoContextFactory;
import org.alfresco.repo.jscript.AlfrescoScriptContext;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.jscript.NativeMap;
import org.alfresco.repo.jscript.SandboxNativeJavaObject;
import org.alfresco.repo.jscript.Scopeable;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ScriptableHashMap;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.processor.BaseProcessor;
import org.alfresco.scripts.ScriptException;
import org.alfresco.scripts.ScriptResourceHelper;
import org.alfresco.scripts.ScriptResourceLoader;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptProcessor;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.FileCopyUtils;

public class RhinoScriptProcessor
extends BaseProcessor
implements ScriptProcessor,
ScriptResourceLoader,
InitializingBean {
    private static final Log logger = LogFactory.getLog(RhinoScriptProcessor.class);
    private static final Log callLogger = LogFactory.getLog((String)(String.valueOf(RhinoScriptProcessor.class.getName()) + ".calls"));
    private static final String PATH_CLASSPATH = "classpath:";
    private static final WrapFactory wrapFactory = new RhinoWrapFactory();
    private static final SandboxWrapFactory sandboxFactory = new SandboxWrapFactory();
    private final ValueConverter valueConverter = new ValueConverter();
    private StoreRef storeRef;
    private String storePath;
    private Scriptable secureScope;
    private Scriptable nonSecureScope;
    private boolean compile = true;
    private boolean shareSealedScopes = true;
    private final Map<String, Script> scriptCache = new ConcurrentHashMap<String, Script>(256);
    private int optimizationLevel = -1;
    private int maxScriptExecutionSeconds = -1;
    private int maxStackDepth = -1;
    private long maxMemoryUsedInBytes = -1L;
    private int observerInstructionCount = 100;
    public static AlfrescoContextFactory contextFactory;

    public void setStoreUrl(String storeRef) {
        this.storeRef = new StoreRef(storeRef);
    }

    public void setStorePath(String storePath) {
        this.storePath = storePath;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
    }

    public void setShareSealedScopes(boolean shareSealedScopes) {
        this.shareSealedScopes = shareSealedScopes;
    }

    public void setOptimizationLevel(int optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public void setMaxScriptExecutionSeconds(int maxScriptExecutionSeconds) {
        this.maxScriptExecutionSeconds = maxScriptExecutionSeconds;
    }

    public void setMaxStackDepth(int maxStackDepth) {
        this.maxStackDepth = maxStackDepth;
    }

    public void setMaxMemoryUsedInBytes(long maxMemoryUsedInBytes) {
        this.maxMemoryUsedInBytes = maxMemoryUsedInBytes;
    }

    public void setObserverInstructionCount(int observerInstructionCount) {
        this.observerInstructionCount = observerInstructionCount;
    }

    @Override
    public void reset() {
        this.scriptCache.clear();
    }

    @Override
    public Object execute(ScriptLocation location, Map<String, Object> model) {
        try {
            Script script = null;
            String path = location.getPath();
            if (this.compile && location.isCachable()) {
                script = this.scriptCache.get(path);
            }
            if (script == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resolving and compiling script path: " + path));
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FileCopyUtils.copy((InputStream)location.getInputStream(), (OutputStream)os);
                byte[] bytes = os.toByteArray();
                String source = new String(bytes, "UTF-8");
                source = this.resolveScriptImports(new String(bytes));
                Context cx = Context.enter();
                try {
                    script = cx.compileString(source, location.toString(), 1, null);
                    if (this.compile && location.isCachable()) {
                        this.scriptCache.put(path, script);
                    }
                }
                finally {
                    Context.exit();
                }
            }
            String debugScriptName = null;
            if (callLogger.isDebugEnabled()) {
                int i = path.lastIndexOf(47);
                debugScriptName = i != -1 ? path.substring(i + 1) : path;
            }
            return this.executeScriptImpl(script, model, location.isSecure(), debugScriptName);
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + location.toString() + "': " + err.getMessage(), err);
        }
    }

    @Override
    public Object execute(String location, Map<String, Object> model) {
        return this.execute(new ClasspathScriptLocation(location), model);
    }

    @Override
    public Object execute(NodeRef nodeRef, QName contentProp, Map<String, Object> model) {
        try {
            Script script;
            ContentReader cr;
            if (!this.services.getNodeService().exists(nodeRef)) {
                throw new AlfrescoRuntimeException("Script Node does not exist: " + nodeRef);
            }
            if (contentProp == null) {
                contentProp = ContentModel.PROP_CONTENT;
            }
            if ((cr = this.services.getContentService().getReader(nodeRef, contentProp)) == null || !cr.exists()) {
                throw new AlfrescoRuntimeException("Script Node content not found: " + nodeRef);
            }
            Context cx = Context.enter();
            try {
                script = cx.compileString(this.resolveScriptImports(cr.getContentString()), nodeRef.toString(), 1, null);
            }
            finally {
                Context.exit();
            }
            return this.executeScriptImpl(script, model, false, nodeRef.toString());
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + nodeRef.toString() + "': " + err.getMessage(), err);
        }
    }

    @Override
    public Object executeString(String source, Map<String, Object> model) {
        try {
            Script script;
            Context cx = Context.enter();
            try {
                script = cx.compileString(this.resolveScriptImports(source), "AlfrescoJS", 1, null);
            }
            finally {
                Context.exit();
            }
            return this.executeScriptImpl(script, model, true, "string script");
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute supplied script: " + err.getMessage(), err);
        }
    }

    private String resolveScriptImports(String script) {
        return ScriptResourceHelper.resolveScriptImports((String)script, (ScriptResourceLoader)this, (Log)logger);
    }

    public String loadScriptResource(String resource) {
        NodeRef scriptRef;
        String result = null;
        if (resource.startsWith(PATH_CLASSPATH)) {
            try {
                String scriptClasspath = resource.substring(PATH_CLASSPATH.length());
                URL scriptResource = this.getClass().getClassLoader().getResource(scriptClasspath);
                if (scriptResource == null && scriptClasspath.startsWith("/")) {
                    scriptResource = this.getClass().getClassLoader().getResource(scriptClasspath.substring(1));
                }
                if (scriptResource == null) {
                    throw new AlfrescoRuntimeException("Unable to locate included script classpath resource: " + resource);
                }
                InputStream stream = scriptResource.openStream();
                if (stream == null) {
                    throw new AlfrescoRuntimeException("Unable to load included script classpath resource: " + resource);
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FileCopyUtils.copy((InputStream)stream, (OutputStream)os);
                byte[] bytes = os.toByteArray();
                result = new String(bytes, "UTF-8");
            }
            catch (IOException iOException) {
                throw new AlfrescoRuntimeException("Unable to load included script classpath resource: " + resource);
            }
        }
        if (resource.startsWith("/")) {
            NodeRef rootNodeRef = this.services.getNodeService().getRootNode(this.storeRef);
            List nodes = this.services.getSearchService().selectNodes(rootNodeRef, this.storePath, null, (NamespacePrefixResolver)this.services.getNamespaceService(), false);
            if (nodes.size() == 0) {
                throw new AlfrescoRuntimeException("Unable to find store path: " + this.storePath);
            }
            StringTokenizer tokenizer = new StringTokenizer(resource, "/");
            ArrayList<String> elements = new ArrayList<String>(6);
            if (tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
            }
            while (tokenizer.hasMoreTokens()) {
                elements.add(tokenizer.nextToken());
            }
            try {
                FileInfo fileInfo = this.services.getFileFolderService().resolveNamePath((NodeRef)nodes.get(0), elements);
                scriptRef = fileInfo.getNodeRef();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new AlfrescoRuntimeException("Unable to load included script repository resource: " + resource);
            }
        } else {
            scriptRef = new NodeRef(resource);
        }
        try {
            ContentReader cr = this.services.getContentService().getReader(scriptRef, ContentModel.PROP_CONTENT);
            if (cr == null || !cr.exists()) {
                throw new AlfrescoRuntimeException("Included Script Node content not found: " + resource);
            }
            result = cr.getContentString();
        }
        catch (ContentIOException contentIOException) {
            throw new AlfrescoRuntimeException("Unable to load included script repository resource: " + resource);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object executeScriptImpl(Script script, Map<String, Object> model, boolean secure, String debugScriptName) throws AlfrescoRuntimeException {
        Object object;
        long startTime;
        block20: {
            Scriptable scope = null;
            startTime = 0L;
            if (callLogger.isDebugEnabled()) {
                callLogger.debug((Object)(String.valueOf(debugScriptName) + " Start"));
                startTime = System.nanoTime();
            }
            model = this.convertToRhinoModel(model);
            Context cx = Context.enter();
            try {
                cx.setWrapFactory((WrapFactory)(secure ? wrapFactory : sandboxFactory));
                this.enableLimits(cx, secure);
                if (this.shareSealedScopes) {
                    Scriptable sharedScope = secure ? this.nonSecureScope : this.secureScope;
                    scope = cx.newObject(sharedScope);
                    scope.setPrototype(sharedScope);
                    scope.setParentScope(null);
                } else {
                    scope = this.initScope(cx, secure, false);
                }
                if (model == null) {
                    model = new HashMap<String, Object>();
                }
                for (ProcessorExtension ex : this.processorExtensions.values()) {
                    model.put(ex.getExtensionName(), ex);
                }
                for (String key : model.keySet()) {
                    try {
                        Object obj = model.get(key);
                        if (obj instanceof Scopeable) {
                            ((Scopeable)obj).setScope(scope);
                        }
                        Object jsObject = Context.javaToJS((Object)obj, (Scriptable)scope);
                        ScriptableObject.putProperty((Scriptable)scope, (String)key, (Object)jsObject);
                    }
                    catch (AuthenticationException e) {
                        logger.info((Object)("Unable to add " + key + " to root scope: "), (Throwable)e);
                    }
                }
                Object result = script.exec(cx, scope);
                object = this.valueConverter.convertValueForJava(result);
                if (secure) break block20;
                this.unsetScope(model, scope);
            }
            catch (WrappedException w) {
                try {
                    Throwable err;
                    if (callLogger.isDebugEnabled()) {
                        callLogger.debug((Object)(String.valueOf(debugScriptName) + " Exception"), (Throwable)w);
                    }
                    if ((err = w.getWrappedException()) instanceof RuntimeException) {
                        throw (RuntimeException)err;
                    }
                    throw new AlfrescoRuntimeException(err.getMessage(), err);
                    catch (Throwable err2) {
                        if (callLogger.isDebugEnabled()) {
                            callLogger.debug((Object)(String.valueOf(debugScriptName) + " Exception"), err2);
                        }
                        throw new AlfrescoRuntimeException(err2.getMessage(), err2);
                    }
                }
                catch (Throwable throwable) {
                    if (!secure) {
                        this.unsetScope(model, scope);
                    }
                    Context.exit();
                    if (callLogger.isDebugEnabled()) {
                        long endTime = System.nanoTime();
                        callLogger.debug((Object)(String.valueOf(debugScriptName) + " End " + (endTime - startTime) / 1000000L + " ms"));
                    }
                    throw throwable;
                }
            }
        }
        Context.exit();
        if (callLogger.isDebugEnabled()) {
            long endTime = System.nanoTime();
            callLogger.debug((Object)(String.valueOf(debugScriptName) + " End " + (endTime - startTime) / 1000000L + " ms"));
        }
        return object;
    }

    private Map<String, Object> convertToRhinoModel(Map<String, Object> model) {
        HashMap<String, Object> newModel = null;
        if (model != null) {
            newModel = new HashMap<String, Object>(model.size());
            for (Map.Entry<String, Object> entry : model.entrySet()) {
                if (entry.getValue() instanceof NodeRef) {
                    newModel.put(entry.getKey(), new ScriptNode((NodeRef)entry.getValue(), this.services));
                    continue;
                }
                newModel.put(entry.getKey(), entry.getValue());
            }
        } else {
            newModel = new HashMap(1, 1.0f);
        }
        return newModel;
    }

    public void afterPropertiesSet() throws Exception {
        this.initContextFactory();
        Context cx = Context.enter();
        try {
            cx.setWrapFactory(wrapFactory);
            this.secureScope = this.initScope(cx, false, true);
        }
        finally {
            Context.exit();
        }
        cx = Context.enter();
        try {
            cx.setWrapFactory((WrapFactory)sandboxFactory);
            this.nonSecureScope = this.initScope(cx, true, true);
        }
        finally {
            Context.exit();
        }
    }

    protected Scriptable initScope(Context cx, boolean secure, boolean sealed) {
        Object scope = secure ? new ImporterTopLevel(cx, sealed) : cx.initSafeStandardObjects(null, sealed);
        return scope;
    }

    private void unsetScope(Map<String, Object> model, Scriptable scope) {
        Object[] ids;
        if (scope != null && (ids = scope.getIds()) != null) {
            Object[] objectArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Object id = objectArray[n2];
                try {
                    this.deleteProperty(scope, id.toString());
                }
                catch (Exception e) {
                    logger.info((Object)("Unable to delete id: " + id), (Throwable)e);
                }
                ++n2;
            }
        }
        if (model != null) {
            for (String key : model.keySet()) {
                try {
                    this.deleteProperty(scope, key);
                    Object obj = model.get(key);
                    if (!(obj instanceof Scopeable)) continue;
                    ((Scopeable)obj).setScope(null);
                }
                catch (Exception e) {
                    logger.info((Object)("Unable to unset model object " + key + " : "), (Throwable)e);
                }
            }
        }
    }

    private void deleteProperty(Scriptable scope, String name) {
        if (scope != null && name != null) {
            if (!ScriptableObject.deleteProperty((Scriptable)scope, (String)name)) {
                ScriptableObject.putProperty((Scriptable)scope, (String)name, null);
            }
            scope.delete(name);
        }
    }

    private synchronized void initContextFactory() {
        if (contextFactory == null) {
            contextFactory = new AlfrescoContextFactory();
            contextFactory.setOptimizationLevel(this.optimizationLevel);
            if (this.maxScriptExecutionSeconds > 0) {
                contextFactory.setMaxScriptExecutionSeconds(this.maxScriptExecutionSeconds);
            }
            if (this.maxMemoryUsedInBytes > 0L) {
                contextFactory.setMaxMemoryUsedInBytes(this.maxMemoryUsedInBytes);
            }
            if (this.maxStackDepth > 0) {
                contextFactory.setMaxStackDepth(this.maxStackDepth);
            }
            if (this.maxScriptExecutionSeconds > 0 || this.maxMemoryUsedInBytes > 0L) {
                contextFactory.setObserveInstructionCount(this.observerInstructionCount);
            }
            ContextFactory.initGlobal((ContextFactory)contextFactory);
        }
    }

    private void enableLimits(Context cx, boolean secure) {
        if (cx != null && cx instanceof AlfrescoScriptContext) {
            ((AlfrescoScriptContext)cx).setLimitsEnabled(!secure);
        }
    }

    private static class RhinoWrapFactory
    extends WrapFactory {
        private RhinoWrapFactory() {
        }

        protected Scriptable wrapBasicJavaObject(Context cx, Scriptable scope, Object javaObject, Class<?> staticType) {
            return super.wrapAsJavaObject(cx, scope, javaObject, staticType);
        }

        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class<?> staticType) {
            if (javaObject instanceof Map && !(javaObject instanceof ScriptableHashMap)) {
                return new NativeMap(scope, (Map)javaObject);
            }
            return this.wrapBasicJavaObject(cx, scope, javaObject, staticType);
        }

        /* synthetic */ RhinoWrapFactory(RhinoWrapFactory rhinoWrapFactory, RhinoWrapFactory rhinoWrapFactory2) {
            this();
        }
    }

    private static class SandboxWrapFactory
    extends RhinoWrapFactory {
        private SandboxWrapFactory() {
            super(null, null);
        }

        @Override
        protected Scriptable wrapBasicJavaObject(Context cx, Scriptable scope, Object javaObject, Class<?> staticType) {
            return new SandboxNativeJavaObject(scope, javaObject, staticType);
        }
    }
}

