/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.site;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.invitation.site.InviteSender;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.UrlUtil;
import org.apache.commons.lang3.StringUtils;

public class InviteModeratedSender
extends InviteSender {
    private static final String DATA_DICTIONARY_XPATH_PREFIX = "app:";
    public static final String WF_PACKAGE = "wf_package";
    public static final String SHARE_PENDING_INVITES_LINK = "{0}/page/site/{1}/pending-invites";
    public static final String WORKSPACE_PENDING_INVITES_LINK = "{0}/#/{1}/members/libraries";
    private static final List<String> INVITE_MODERATED_EXPECTED_PROPERTIES = Arrays.asList("imwf_inviteeUserName", "imwf_inviteeRole", "imwf_resourceName", "bpm_groupAssignee", "imwf_resourceType");

    public InviteModeratedSender(ServiceRegistry services, Repository repository, MessageService messageService) {
        super(services, repository, messageService);
    }

    @Override
    public void sendMail(String emailTemplatePath, String emailSubjectKey, Map<String, String> properties) {
        this.checkProperties(properties);
        NodeRef invitee = this.personService.getPerson(properties.get("imwf_inviteeUserName"));
        Action mail = this.actionService.createAction("mail");
        mail.setParameterValue("from", (Serializable)((Object)((String)((Object)this.nodeService.getProperty(invitee, ContentModel.PROP_EMAIL)))));
        mail.setParameterValue("to_many", (Serializable)((Object)properties.get("bpm_groupAssignee")));
        mail.setParameterValue("subject", (Serializable)((Object)emailSubjectKey));
        mail.setParameterValue("subjectParams", (Serializable)new Object[]{this.getSiteName(properties)});
        mail.setParameterValue("template", this.getEmailTemplate(emailTemplatePath));
        mail.setParameterValue("template_model", (Serializable)((Object)this.buildMailTextModel(properties)));
        mail.setParameterValue("ignore_send_failure", Boolean.valueOf(true));
        this.actionService.executeAction(mail, new NodeRef(properties.get(WF_PACKAGE)));
    }

    private Serializable getEmailTemplate(String emailTemplatePath) {
        return emailTemplatePath.startsWith(DATA_DICTIONARY_XPATH_PREFIX) ? this.getEmailTemplateNodeRef(emailTemplatePath) : emailTemplatePath;
    }

    @Override
    protected Map<String, Serializable> buildMailTextModel(Map<String, String> properties) {
        NodeRef invitee = this.personService.getPerson(properties.get("imwf_inviteeUserName"));
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("companyhome", (Serializable)this.repository.getCompanyHome());
        model.put("userhome", (Serializable)this.repository.getUserHome(this.repository.getPerson()));
        model.put("productName", (Serializable)((Object)ModelUtil.getProductName(this.repoAdminService)));
        PersonService.PersonInfo inviteePerson = this.personService.getPerson(invitee);
        model.put("inviteeName", (Serializable)((Object)StringUtils.join((Object[])new String[]{inviteePerson.getFirstName(), inviteePerson.getLastName()}, (String)" ")));
        model.put("siteName", (Serializable)((Object)this.getSiteName(properties)));
        model.put("sharePendingInvitesLink", (Serializable)((Object)StringUtils.stripStart((String)this.getPendingInvitesLink(properties), (String)"/")));
        model.put("workspacePendingInvitesLink", (Serializable)((Object)StringUtils.stripStart((String)this.getWorkSpaceInvitesLink(properties), (String)"/")));
        model.put("template_assets_url", (Serializable)((Object)this.getTemplateAssetsLink(properties)));
        return model;
    }

    protected String getPendingInvitesLink(Map<String, String> properties) {
        return MessageFormat.format(SHARE_PENDING_INVITES_LINK, TenantUtil.getCurrentDomain(), properties.get("imwf_resourceName"));
    }

    protected String getWorkSpaceInvitesLink(Map<String, String> properties) {
        String path = properties.get("imwf_workspaceUrl");
        boolean hasValidBaseUrl = path != null && !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{path}) && path.length() > 1;
        String workspaceUrl = String.valueOf(this.sysAdminParams.getAlfrescoProtocol()) + "://" + this.sysAdminParams.getAlfrescoHost() + ":" + this.sysAdminParams.getAlfrescoPort() + (hasValidBaseUrl ? "/" + path.trim() : "");
        return MessageFormat.format(WORKSPACE_PENDING_INVITES_LINK, workspaceUrl, properties.get("imwf_resourceName"));
    }

    protected String getTemplateAssetsLink(Map<String, String> properties) {
        if (properties.get("imwf_templateAssetsUrl") != null) {
            return UrlUtil.replaceAlfrescoUrlPlaceholder(properties.get("imwf_templateAssetsUrl"), this.sysAdminParams);
        }
        return UrlUtil.getAlfrescoUrl(this.sysAdminParams);
    }

    @Override
    public List<String> getRequiredProperties() {
        return INVITE_MODERATED_EXPECTED_PROPERTIES;
    }

    @Override
    protected String getWorkflowPropForSiteName() {
        return "imwf_resourceName";
    }
}

