/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.event.v1.model.ChildAssociationResource;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.PeerAssociationResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event2.ChildAssociationEventConsolidator;
import org.alfresco.repo.event2.ChildAssociationEventSupportedPolicies;
import org.alfresco.repo.event2.EventConsolidator;
import org.alfresco.repo.event2.EventGeneratorQueue;
import org.alfresco.repo.event2.EventInfo;
import org.alfresco.repo.event2.EventSupportedPolicies;
import org.alfresco.repo.event2.NodeResourceHelper;
import org.alfresco.repo.event2.PeerAssociationEventConsolidator;
import org.alfresco.repo.event2.PeerAssociationEventSupportedPolicies;
import org.alfresco.repo.event2.filter.ChildAssociationTypeFilter;
import org.alfresco.repo.event2.filter.EventFilterRegistry;
import org.alfresco.repo.event2.filter.EventUserFilter;
import org.alfresco.repo.event2.filter.NodeTypeFilter;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class EventGenerator
extends AbstractLifecycleBean
implements InitializingBean,
EventSupportedPolicies,
ChildAssociationEventSupportedPolicies,
PeerAssociationEventSupportedPolicies {
    private static final Log LOGGER = LogFactory.getLog(EventGenerator.class);
    protected PolicyComponent policyComponent;
    protected NodeService nodeService;
    private NamespaceService namespaceService;
    protected DictionaryService dictionaryService;
    private DescriptorService descriptorService;
    private EventFilterRegistry eventFilterRegistry;
    private TransactionService transactionService;
    private PersonService personService;
    protected NodeResourceHelper nodeResourceHelper;
    protected NodeDAO nodeDAO;
    private EventGeneratorQueue eventGeneratorQueue;
    private NodeTypeFilter nodeTypeFilter;
    private ChildAssociationTypeFilter childAssociationTypeFilter;
    private EventUserFilter userFilter;
    protected final EventTransactionListener transactionListener = new EventTransactionListener();

    public void afterPropertiesSet() {
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"descriptorService", (Object)this.descriptorService);
        PropertyCheck.mandatory((Object)this, (String)"eventFilterRegistry", (Object)this.eventFilterRegistry);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"nodeResourceHelper", (Object)this.nodeResourceHelper);
        PropertyCheck.mandatory((Object)this, (String)"nodeDAO", (Object)this.nodeDAO);
        PropertyCheck.mandatory((Object)this, (String)"eventGeneratorQueue", (Object)this.eventGeneratorQueue);
        this.nodeTypeFilter = this.eventFilterRegistry.getNodeTypeFilter();
        this.childAssociationTypeFilter = this.eventFilterRegistry.getChildAssociationTypeFilter();
        this.userFilter = this.eventFilterRegistry.getEventUserFilter();
    }

    private void bindBehaviours() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnSetNodeTypePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onSetNodeType"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnRemoveAspectPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onMoveNode"));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation"));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.BeforeDeleteChildAssociationPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "beforeDeleteChildAssociation"));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateAssociationPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onCreateAssociation"));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.BeforeDeleteAssociationPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "beforeDeleteAssociation"));
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setEventFilterRegistry(EventFilterRegistry eventFilterRegistry) {
        this.eventFilterRegistry = eventFilterRegistry;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeResourceHelper(NodeResourceHelper nodeResourceHelper) {
        this.nodeResourceHelper = nodeResourceHelper;
    }

    public void setEventGeneratorQueue(EventGeneratorQueue eventGeneratorQueue) {
        this.eventGeneratorQueue = eventGeneratorQueue;
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        this.getEventConsolidator(childAssocRef.getChildRef()).onCreateNode(childAssocRef);
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        this.getEventConsolidator(newChildAssocRef.getChildRef()).onMoveNode(oldChildAssocRef, newChildAssocRef);
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        this.getEventConsolidator(nodeRef).onUpdateProperties(nodeRef, before, after);
    }

    @Override
    public void onSetNodeType(NodeRef nodeRef, QName before, QName after) {
        this.getEventConsolidator(nodeRef).onSetNodeType(nodeRef, before, after);
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.getEventConsolidator(nodeRef).beforeDeleteNode(nodeRef);
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.getEventConsolidator(nodeRef).onAddAspect(nodeRef, aspectTypeQName);
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.getEventConsolidator(nodeRef).onRemoveAspect(nodeRef, aspectTypeQName);
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssociationRef, boolean isNewNode) {
        this.getEventConsolidator(childAssociationRef).onCreateChildAssociation(childAssociationRef, isNewNode);
    }

    @Override
    public void beforeDeleteChildAssociation(ChildAssociationRef childAssociationRef) {
        this.getEventConsolidator(childAssociationRef).beforeDeleteChildAssociation(childAssociationRef);
    }

    @Override
    public void onCreateAssociation(AssociationRef associationRef) {
        this.getEventConsolidator(associationRef).onCreateAssociation(associationRef);
    }

    @Override
    public void beforeDeleteAssociation(AssociationRef associationRef) {
        this.getEventConsolidator(associationRef).beforeDeleteAssociation(associationRef);
    }

    protected EventConsolidator createEventConsolidator() {
        return new EventConsolidator(this.nodeResourceHelper);
    }

    protected ChildAssociationEventConsolidator createChildAssociationEventConsolidator(ChildAssociationRef childAssociationRef) {
        return new ChildAssociationEventConsolidator(childAssociationRef, this.nodeResourceHelper);
    }

    protected PeerAssociationEventConsolidator createPeerAssociationEventConsolidator(AssociationRef peerAssociationRef) {
        return new PeerAssociationEventConsolidator(peerAssociationRef, this.nodeResourceHelper);
    }

    protected EventConsolidator getEventConsolidator(NodeRef nodeRef) {
        EventConsolidator eventConsolidator;
        Consolidators consolidators = this.getTxnConsolidators((Object)this.transactionListener);
        Map<NodeRef, EventConsolidator> nodeEvents = consolidators.getNodes();
        if (nodeEvents.isEmpty()) {
            AlfrescoTransactionSupport.bindListener((TransactionListener)this.transactionListener);
        }
        if ((eventConsolidator = nodeEvents.get(nodeRef)) == null) {
            eventConsolidator = this.createEventConsolidator();
            nodeEvents.put(nodeRef, eventConsolidator);
        }
        return eventConsolidator;
    }

    protected Consolidators getTxnConsolidators(Object resourceKey) {
        Consolidators consolidators = (Consolidators)AlfrescoTransactionSupport.getResource((Object)resourceKey);
        if (consolidators == null) {
            consolidators = new Consolidators();
            AlfrescoTransactionSupport.bindResource((Object)resourceKey, (Object)consolidators);
        }
        return consolidators;
    }

    private ChildAssociationEventConsolidator getEventConsolidator(ChildAssociationRef childAssociationRef) {
        ChildAssociationEventConsolidator eventConsolidator;
        Consolidators consolidators = this.getTxnConsolidators((Object)this.transactionListener);
        Map<ChildAssociationRef, ChildAssociationEventConsolidator> assocEvents = consolidators.getChildAssocs();
        if (assocEvents.isEmpty()) {
            AlfrescoTransactionSupport.bindListener((TransactionListener)this.transactionListener);
        }
        if ((eventConsolidator = assocEvents.get(childAssociationRef)) == null) {
            eventConsolidator = this.createChildAssociationEventConsolidator(childAssociationRef);
            assocEvents.put(childAssociationRef, eventConsolidator);
        }
        return eventConsolidator;
    }

    private PeerAssociationEventConsolidator getEventConsolidator(AssociationRef peerAssociationRef) {
        PeerAssociationEventConsolidator eventConsolidator;
        Consolidators consolidators = this.getTxnConsolidators((Object)this.transactionListener);
        Map<AssociationRef, PeerAssociationEventConsolidator> assocEvents = consolidators.getPeerAssocs();
        if (assocEvents.isEmpty()) {
            AlfrescoTransactionSupport.bindListener((TransactionListener)this.transactionListener);
        }
        if ((eventConsolidator = assocEvents.get(peerAssociationRef)) == null) {
            eventConsolidator = this.createPeerAssociationEventConsolidator(peerAssociationRef);
            assocEvents.put(peerAssociationRef, eventConsolidator);
        }
        return eventConsolidator;
    }

    private boolean isFiltered(QName nodeType, String user) {
        return this.nodeTypeFilter.isExcluded(nodeType) || this.userFilter.isExcluded(user);
    }

    private boolean isFilteredChildAssociation(QName childAssocType, String user) {
        return this.childAssociationTypeFilter.isExcluded(childAssocType) || this.userFilter.isExcluded(user);
    }

    protected EventInfo getEventInfo(String user) {
        return new EventInfo().setTimestamp(this.getCurrentTransactionTimestamp()).setId(UUID.randomUUID().toString()).setTxnId(AlfrescoTransactionSupport.getTransactionId()).setPrincipal(user).setSource(URI.create("/" + this.descriptorService.getCurrentRepositoryDescriptor().getId()));
    }

    private ZonedDateTime getCurrentTransactionTimestamp() {
        Long currentTransactionCommitTime = this.nodeDAO.getCurrentTransactionCommitTime();
        Instant commitTimeMs = Instant.ofEpochMilli(currentTransactionCommitTime);
        return ZonedDateTime.ofInstant(commitTimeMs, ZoneOffset.UTC);
    }

    protected void onBootstrap(ApplicationEvent applicationEvent) {
        this.bindBehaviours();
    }

    protected void onShutdown(ApplicationEvent applicationEvent) {
    }

    protected static class Consolidators {
        private Map<NodeRef, EventConsolidator> nodes;
        private Map<ChildAssociationRef, ChildAssociationEventConsolidator> childAssocs;
        private Map<AssociationRef, PeerAssociationEventConsolidator> peerAssocs;

        protected Consolidators() {
        }

        public Map<NodeRef, EventConsolidator> getNodes() {
            if (this.nodes == null) {
                this.nodes = new LinkedHashMap<NodeRef, EventConsolidator>(29);
            }
            return this.nodes;
        }

        public Map<ChildAssociationRef, ChildAssociationEventConsolidator> getChildAssocs() {
            if (this.childAssocs == null) {
                this.childAssocs = new LinkedHashMap<ChildAssociationRef, ChildAssociationEventConsolidator>(29);
            }
            return this.childAssocs;
        }

        public Map<AssociationRef, PeerAssociationEventConsolidator> getPeerAssocs() {
            if (this.peerAssocs == null) {
                this.peerAssocs = new LinkedHashMap<AssociationRef, PeerAssociationEventConsolidator>(29);
            }
            return this.peerAssocs;
        }
    }

    protected class EventTransactionListener
    extends TransactionListenerAdapter {
        protected EventTransactionListener() {
        }

        public void afterCommit() {
            if (this.isTransactionCommitted()) {
                try {
                    Policy eventConsolidator;
                    Consolidators consolidators = EventGenerator.this.getTxnConsolidators((Object)this);
                    for (Map.Entry<NodeRef, EventConsolidator> entry : consolidators.getNodes().entrySet()) {
                        eventConsolidator = entry.getValue();
                        this.sendEvent(entry.getKey(), (EventConsolidator)eventConsolidator);
                    }
                    for (Map.Entry<Object, Policy> entry : consolidators.getChildAssocs().entrySet()) {
                        eventConsolidator = (ChildAssociationEventConsolidator)entry.getValue();
                        this.sendEvent((ChildAssociationRef)entry.getKey(), (ChildAssociationEventConsolidator)eventConsolidator);
                    }
                    for (Map.Entry<Object, Policy> entry : consolidators.getPeerAssocs().entrySet()) {
                        eventConsolidator = (PeerAssociationEventConsolidator)entry.getValue();
                        this.sendEvent((AssociationRef)entry.getKey(), (PeerAssociationEventConsolidator)eventConsolidator);
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Unexpected error while sending repository events", (Throwable)e);
                }
            }
        }

        protected void sendEvent(NodeRef nodeRef, EventConsolidator consolidator) {
            EventInfo eventInfo = EventGenerator.this.getEventInfo(AuthenticationUtil.getFullyAuthenticatedUser());
            EventGenerator.this.eventGeneratorQueue.accept(() -> this.createEvent(nodeRef, consolidator, eventInfo));
        }

        protected boolean isTransactionCommitted() {
            return EventGenerator.this.nodeDAO.getCurrentTransactionCommitTime() != null;
        }

        private RepoEvent<?> createEvent(NodeRef nodeRef, EventConsolidator consolidator, EventInfo eventInfo) {
            String user = eventInfo.getPrincipal();
            if (consolidator.isTemporaryNode()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Ignoring temporary node: " + nodeRef));
                }
                return null;
            }
            RepoEvent<DataAttributes<NodeResource>> event = consolidator.getRepoEvent(eventInfo);
            QName nodeType = consolidator.getNodeType();
            if (EventGenerator.this.isFiltered(nodeType, user)) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("EventFilter - Excluding node: '" + nodeRef + "' of type: '" + (nodeType == null ? "Unknown' " : nodeType.toPrefixString()) + "' created by: " + user));
                }
                return null;
            }
            if (event.getType().equals(EventType.NODE_UPDATED.getType()) && consolidator.isResourceBeforeAllFieldsNull()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Ignoring node updated event as no fields have been updated: " + nodeRef));
                }
                return null;
            }
            this.logEvent(event, consolidator.getEventTypes());
            return event;
        }

        protected void sendEvent(ChildAssociationRef childAssociationRef, ChildAssociationEventConsolidator consolidator) {
            EventInfo eventInfo = EventGenerator.this.getEventInfo(AuthenticationUtil.getFullyAuthenticatedUser());
            EventGenerator.this.eventGeneratorQueue.accept(() -> this.createEvent(eventInfo, childAssociationRef, consolidator));
        }

        private RepoEvent<?> createEvent(EventInfo eventInfo, ChildAssociationRef childAssociationRef, ChildAssociationEventConsolidator consolidator) {
            String user = eventInfo.getPrincipal();
            if (consolidator.isTemporaryChildAssociation()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Ignoring temporary child association: " + childAssociationRef));
                }
                return null;
            }
            RepoEvent<DataAttributes<ChildAssociationResource>> event = consolidator.getRepoEvent(eventInfo);
            QName childAssocType = consolidator.getChildAssocType();
            if (EventGenerator.this.isFilteredChildAssociation(childAssocType, user)) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("EventFilter - Excluding child association: '" + childAssociationRef + "' of type: '" + (childAssocType == null ? "Unknown' " : childAssocType.toPrefixString()) + "' created by: " + user));
                }
                return null;
            }
            if (childAssociationRef.isPrimary()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("EventFilter - Excluding primary child association: '" + childAssociationRef + "' of type: '" + (childAssocType == null ? "Unknown' " : childAssocType.toPrefixString()) + "' created by: " + user));
                }
                return null;
            }
            this.logEvent(event, consolidator.getEventTypes());
            return event;
        }

        protected void sendEvent(AssociationRef peerAssociationRef, PeerAssociationEventConsolidator consolidator) {
            EventInfo eventInfo = EventGenerator.this.getEventInfo(AuthenticationUtil.getFullyAuthenticatedUser());
            EventGenerator.this.eventGeneratorQueue.accept(() -> this.createEvent(eventInfo, peerAssociationRef, consolidator));
        }

        private RepoEvent<?> createEvent(EventInfo eventInfo, AssociationRef peerAssociationRef, PeerAssociationEventConsolidator consolidator) {
            if (consolidator.isTemporaryPeerAssociation()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Ignoring temporary peer association: " + peerAssociationRef));
                }
                return null;
            }
            RepoEvent<DataAttributes<PeerAssociationResource>> event = consolidator.getRepoEvent(eventInfo);
            this.logEvent(event, consolidator.getEventTypes());
            return event;
        }

        private void logEvent(RepoEvent<?> event, Deque<EventType> listOfEvents) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("List of Events:" + listOfEvents));
                LOGGER.trace((Object)("Sending event:" + event));
            }
        }
    }
}

