/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.alfresco.repo.content.transform.AbstractLocalTransform;
import org.alfresco.repo.content.transform.LocalFailoverTransform;
import org.alfresco.repo.content.transform.LocalPassThroughTransform;
import org.alfresco.repo.content.transform.LocalPipelineTransform;
import org.alfresco.repo.content.transform.LocalTransform;
import org.alfresco.repo.content.transform.LocalTransformImpl;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.transform.client.model.config.CoreFunction;
import org.alfresco.transform.client.model.config.TransformOption;
import org.alfresco.transform.client.model.config.TransformOptionGroup;
import org.alfresco.transform.client.model.config.TransformStep;
import org.alfresco.transform.client.model.config.Transformer;
import org.alfresco.transform.client.registry.CombinedConfig;
import org.alfresco.transform.client.registry.TransformServiceRegistryImpl;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class LocalTransformServiceRegistry
extends TransformServiceRegistryImpl
implements InitializingBean {
    private static final Log log = LogFactory.getLog(LocalTransformServiceRegistry.class);
    public static final String LOCAL_TRANSFORMER = "localTransform.";
    public static final String URL = ".url";
    static final String STRICT_MIMETYPE_CHECK_WHITELIST_MIMETYPES = "transformer.strict.mimetype.check.whitelist.mimetypes";
    private String pipelineConfigDir;
    private Properties properties;
    private MimetypeService mimetypeService;
    private TransformerDebug transformerDebug;
    private boolean strictMimeTypeCheck;
    private Map<String, Set<String>> strictMimetypeExceptions;
    private boolean retryTransformOnDifferentMimeType;

    public void setPipelineConfigDir(String pipelineConfigDir) {
        this.pipelineConfigDir = pipelineConfigDir;
    }

    public String getPipelineConfigDir() {
        return this.pipelineConfigDir;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    public void setStrictMimeTypeCheck(boolean strictMimeTypeCheck) {
        this.strictMimeTypeCheck = strictMimeTypeCheck;
    }

    public void setRetryTransformOnDifferentMimeType(boolean retryTransformOnDifferentMimeType) {
        this.retryTransformOnDifferentMimeType = retryTransformOnDifferentMimeType;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)((Object)this), (String)"mimetypeService", (Object)this.mimetypeService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"properties", (Object)this.properties);
        PropertyCheck.mandatory((Object)((Object)this), (String)"transformerDebug", (Object)this.transformerDebug);
        this.strictMimetypeExceptions = this.getStrictMimetypeExceptions();
        super.afterPropertiesSet();
    }

    @Override
    public boolean readConfig() throws IOException {
        CombinedConfig combinedConfig = new CombinedConfig(this.getLog(), this);
        List<String> urls = this.getTEngineUrlsSortedByName();
        boolean successReadingConfig = combinedConfig.addRemoteConfig(urls, "T-Engine");
        successReadingConfig &= combinedConfig.addLocalConfig("alfresco/transforms");
        if (this.pipelineConfigDir != null && !this.pipelineConfigDir.isBlank()) {
            successReadingConfig &= combinedConfig.addLocalConfig(this.pipelineConfigDir);
        }
        combinedConfig.addPassThroughTransformer(this.mimetypeService, this);
        combinedConfig.register(this);
        return successReadingConfig;
    }

    @Override
    public LocalData getData() {
        return (LocalData)super.getData();
    }

    @Override
    public TransformServiceRegistryImpl.Data createData() {
        return new LocalData();
    }

    protected void register(Transformer transformer, Map<String, Set<TransformOption>> transformOptions, String baseUrl, String readFrom) {
        try {
            AbstractLocalTransform localTransform;
            boolean isFailover;
            String name = transformer.getTransformerName();
            LocalData data = this.getData();
            Map localTransforms = data.localTransforms;
            Set<TransformOption> transformsTransformOptions = LocalTransformServiceRegistry.lookupTransformOptions(transformer.getTransformOptions(), transformOptions, readFrom, this::logError);
            List pipeline = transformer.getTransformerPipeline();
            List failover = transformer.getTransformerFailover();
            boolean isPipeline = pipeline != null && !pipeline.isEmpty();
            boolean bl = isFailover = failover != null && !failover.isEmpty();
            if (name.equals("PassThrough")) {
                localTransform = new LocalPassThroughTransform(name, this.transformerDebug, this.mimetypeService, this.strictMimeTypeCheck, this.strictMimetypeExceptions, this.retryTransformOnDifferentMimeType, transformsTransformOptions, this);
            } else if (!isPipeline && !isFailover) {
                int startupRetryPeriodSeconds = this.getStartupRetryPeriodSeconds(name);
                localTransform = new LocalTransformImpl(name, this.transformerDebug, this.mimetypeService, this.strictMimeTypeCheck, this.strictMimetypeExceptions, this.retryTransformOnDifferentMimeType, transformsTransformOptions, this, baseUrl, startupRetryPeriodSeconds);
            } else if (isPipeline) {
                int transformerCount = pipeline.size();
                if (transformerCount <= 1) {
                    throw new IllegalArgumentException("Local pipeline transformer " + name + " must have more than one intermediate transformer defined." + " Read from " + readFrom);
                }
                localTransform = new LocalPipelineTransform(name, this.transformerDebug, this.mimetypeService, this.strictMimeTypeCheck, this.strictMimetypeExceptions, this.retryTransformOnDifferentMimeType, transformsTransformOptions, this);
                int i = 0;
                while (i < transformerCount) {
                    TransformStep intermediateTransformerStep = (TransformStep)pipeline.get(i);
                    String intermediateTransformerName = intermediateTransformerStep.getTransformerName();
                    LocalTransform intermediateTransformer = (LocalTransform)localTransforms.get(intermediateTransformerName);
                    if (intermediateTransformer == null) {
                        throw new IllegalArgumentException("Local pipeline transformer " + name + " specified an intermediate transformer " + intermediateTransformerName + " that has not been defined." + " Read from " + readFrom);
                    }
                    String targetMimetype = intermediateTransformerStep.getTargetMediaType();
                    if (i == transformerCount - 1) {
                        if (targetMimetype != null) {
                            throw new IllegalArgumentException("Local pipeline transformer " + name + " must not specify targetMimetype for the final intermediate transformer, " + "as this is defined via the supportedSourceAndTargetList." + " Read from " + readFrom);
                        }
                    } else if (targetMimetype == null) {
                        throw new IllegalArgumentException("Local pipeline transformer " + name + " must specify " + "targetMimetype for all intermediate transformers except for the final one." + " Read from " + readFrom);
                    }
                    ((LocalPipelineTransform)localTransform).addIntermediateTransformer(intermediateTransformer, targetMimetype);
                    ++i;
                }
            } else {
                int transformerCount = failover.size();
                if (transformerCount <= 1) {
                    throw new IllegalArgumentException("Local failover transformer " + name + " must have more than one transformer defined." + " Read from " + readFrom);
                }
                localTransform = new LocalFailoverTransform(name, this.transformerDebug, this.mimetypeService, this.strictMimeTypeCheck, this.strictMimetypeExceptions, this.retryTransformOnDifferentMimeType, transformsTransformOptions, this);
                for (String transformerStepName : failover) {
                    LocalTransform stepTransformer = (LocalTransform)localTransforms.get(transformerStepName);
                    if (stepTransformer == null) {
                        throw new IllegalArgumentException("Local failover transformer " + name + " specified an intermediate transformer " + transformerStepName + " that has not been defined." + " Read from " + readFrom);
                    }
                    ((LocalFailoverTransform)localTransform).addStepTransformer(stepTransformer);
                }
            }
            localTransforms.put(name, localTransform);
            super.register(transformer, transformOptions, baseUrl, readFrom);
        }
        catch (IllegalArgumentException e) {
            String msg = e.getMessage();
            this.getLog().error((Object)msg);
        }
    }

    private static Set<TransformOption> lookupTransformOptions(Set<String> transformOptionNames, Map<String, Set<TransformOption>> transformOptions, String readFrom, Consumer<String> logError) {
        if (transformOptionNames == null) {
            return Collections.emptySet();
        }
        HashSet<TransformOption> options = new HashSet<TransformOption>();
        for (String name : transformOptionNames) {
            Set<TransformOption> oneSetOfTransformOptions = transformOptions.get(name);
            if (oneSetOfTransformOptions == null) {
                logError.accept("transformOptions in " + readFrom + " with the name " + name + " does not exist. Ignored");
                continue;
            }
            options.add((TransformOption)new TransformOptionGroup(false, oneSetOfTransformOptions));
        }
        return options.size() == 1 ? ((TransformOptionGroup)options.iterator().next()).getTransformOptions() : options;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    List<String> getTEngineUrlsSortedByName() {
        return this.getKeySet().stream().filter(key -> key instanceof String).filter(key -> key.startsWith(LOCAL_TRANSFORMER) && key.endsWith(URL)).sorted().map(key -> this.getProperty((String)key, null)).filter(url -> url instanceof String).map(url -> url.trim()).filter(url -> !url.isEmpty()).collect(Collectors.toList());
    }

    private int getStartupRetryPeriodSeconds(String name) {
        int startupRetryPeriodSeconds;
        String startupRetryPeriodSecondsName = LOCAL_TRANSFORMER + name + ".startupRetryPeriodSeconds";
        String property = this.getProperty(startupRetryPeriodSecondsName, "60");
        try {
            startupRetryPeriodSeconds = Integer.parseInt(property);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Local transformer property " + startupRetryPeriodSecondsName + " should be an integer");
        }
        return startupRetryPeriodSeconds;
    }

    private Map<String, Set<String>> getStrictMimetypeExceptions() {
        HashMap<String, Set<String>> strictMimetypeExceptions = new HashMap<String, Set<String>>();
        String whitelist = this.getProperty(STRICT_MIMETYPE_CHECK_WHITELIST_MIMETYPES, "").trim();
        if (!whitelist.isEmpty()) {
            String[] mimetypes = whitelist.split(";");
            if (mimetypes.length % 2 != 0) {
                this.getLog().error((Object)"transformer.strict.mimetype.check.whitelist.mimetypes should have an even number of mimetypes as a ; separated list.");
            } else {
                Set<String> detectedMimetypes = null;
                String[] stringArray = mimetypes;
                int n = mimetypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String mimetype = stringArray[n2];
                    if ((mimetype = mimetype.trim()).isEmpty()) {
                        this.getLog().error((Object)"transformer.strict.mimetype.check.whitelist.mimetypes contains a blank mimetype.");
                    }
                    if (detectedMimetypes == null) {
                        detectedMimetypes = (Set)strictMimetypeExceptions.get(mimetype);
                        if (detectedMimetypes == null) {
                            detectedMimetypes = new HashSet<String>();
                            strictMimetypeExceptions.put(mimetype, detectedMimetypes);
                        }
                    } else {
                        detectedMimetypes.add(mimetype);
                        detectedMimetypes = null;
                    }
                    ++n2;
                }
            }
        }
        return strictMimetypeExceptions;
    }

    private Set<String> getKeySet() {
        Set<Object> systemKeys = System.getProperties().keySet();
        Set<Object> alfrescoGlobalKeys = this.properties.keySet();
        HashSet<String> keys = new HashSet<String>(systemKeys.size() + alfrescoGlobalKeys.size());
        this.addStrings(keys, systemKeys);
        this.addStrings(keys, alfrescoGlobalKeys);
        return keys;
    }

    private void addStrings(Set<String> setOfStrings, Set<Object> objects) {
        objects.forEach(object -> {
            if (object instanceof String) {
                setOfStrings.add((String)object);
            }
        });
    }

    protected String getProperty(String name, String defaultValue) {
        String value = this.properties.getProperty(name);
        if ((value == null || value.isEmpty()) && (value = System.getProperty(name)) != null && value.isEmpty()) {
            value = null;
        }
        return value == null ? defaultValue : value;
    }

    @Override
    public long findMaxSize(String sourceMimetype, String targetMimetype, Map<String, String> options, String renditionName) {
        if (this.getFirstTime()) {
            this.setFirstTime(false);
            this.transformerDebug.debug("Local transforms " + (Object)((Object)this.getData()) + " are " + (this.enabled ? "enabled" : "disabled"));
        }
        return super.findMaxSize(sourceMimetype, targetMimetype, options, renditionName);
    }

    public LocalTransform getLocalTransform(String sourceMimetype, long sourceSizeInBytes, String targetMimetype, Map<String, String> actualOptions, String renditionName) {
        if (!this.enabled) {
            return null;
        }
        LocalTransform localTransform = null;
        String name = this.findTransformerName(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, renditionName);
        if (name != null) {
            LocalData data = this.getData();
            Map localTransforms = data.localTransforms;
            localTransform = (LocalTransform)localTransforms.get(name);
        }
        return localTransform;
    }

    public boolean isSupported(CoreFunction function, LocalTransform transform) {
        return this.isSupported(function, transform.getName());
    }

    public class LocalData
    extends TransformServiceRegistryImpl.Data {
        private Map<String, LocalTransform> localTransforms = new HashMap<String, LocalTransform>();
    }
}

