/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractLocalTransform;
import org.alfresco.repo.content.transform.LocalTransform;
import org.alfresco.repo.content.transform.LocalTransformServiceRegistry;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.transform.client.model.config.TransformOption;
import org.alfresco.util.TempFileProvider;

public class LocalPipelineTransform
extends AbstractLocalTransform {
    private final List<IntermediateTransformer> transformers = new ArrayList<IntermediateTransformer>();

    public LocalPipelineTransform(String name, TransformerDebug transformerDebug, MimetypeService mimetypeService, boolean strictMimeTypeCheck, Map<String, Set<String>> strictMimetypeExceptions, boolean retryTransformOnDifferentMimeType, Set<TransformOption> transformsTransformOptions, LocalTransformServiceRegistry localTransformServiceRegistry) {
        super(name, transformerDebug, mimetypeService, strictMimeTypeCheck, strictMimetypeExceptions, retryTransformOnDifferentMimeType, transformsTransformOptions, localTransformServiceRegistry);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public void addIntermediateTransformer(LocalTransform intermediateTransformer, String targetMimetype) {
        IntermediateTransformer transformer = new IntermediateTransformer();
        transformer.intermediateTransformer = intermediateTransformer;
        transformer.targetMimetype = targetMimetype;
        this.transformers.add(transformer);
    }

    public LocalTransform getIntermediateTransformer(int i) {
        return i >= this.transformers.size() ? null : this.transformers.get((int)i).intermediateTransformer;
    }

    @Override
    protected void transformImpl(ContentReader reader, ContentWriter writer, Map<String, String> transformOptions, String sourceMimetype, String targetMimetype, String sourceExtension, String targetExtension, String renditionName, NodeRef sourceNodeRef) {
        ContentReader currentReader = reader;
        int lastI = this.transformers.size() - 1;
        int i = 0;
        while (i <= lastI) {
            ContentWriter currentWriter;
            IntermediateTransformer transformer = this.transformers.get(i);
            if (i == lastI) {
                currentWriter = writer;
            } else {
                String sourceExt = this.mimetypeService.getExtension(currentReader.getMimetype());
                String targetExt = this.mimetypeService.getExtension(transformer.targetMimetype);
                File tempFile = TempFileProvider.createTempFile((String)("LocalPipelineTransformer_intermediate_" + sourceExt + "_"), (String)("." + targetExt));
                currentWriter = new FileContentWriter(tempFile);
                currentWriter.setMimetype(transformer.targetMimetype);
            }
            transformer.intermediateTransformer.transform(currentReader, currentWriter, transformOptions, renditionName, sourceNodeRef);
            this.removeDirectAccessUrlAfterFirstTransform(transformOptions);
            if (i == 0) {
                sourceNodeRef = null;
            }
            if (i < lastI) {
                currentReader = currentWriter.getReader();
            }
            ++i;
        }
    }

    private void removeDirectAccessUrlAfterFirstTransform(Map<String, String> transformOptions) {
        transformOptions.remove("directAccessUrl");
    }

    private class IntermediateTransformer {
        LocalTransform intermediateTransformer;
        String targetMimetype;

        private IntermediateTransformer() {
        }
    }
}

