/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class Log4JHierarchyInit
implements ApplicationContextAware {
    private static Log logger = LogFactory.getLog(Log4JHierarchyInit.class);
    private List<String> extraLog4jUrls;
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public Log4JHierarchyInit() {
        this.extraLog4jUrls = new ArrayList<String>();
    }

    public void setExtraLog4jUrls(List<String> urls) {
        for (String url : urls) {
            this.extraLog4jUrls.add(url);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.resolver = applicationContext;
    }

    public void init() {
        this.importLogSettings();
    }

    private void importLogSettings() {
        block5: {
            try {
                Properties mainProperties = new Properties();
                Class<?> clazz = Class.forName("org.apache.log4j.PropertyConfigurator");
                Method method = clazz.getMethod("configure", Properties.class);
                for (String url : this.extraLog4jUrls) {
                    this.importLogSettings(url, mainProperties);
                }
                method.invoke(null, mainProperties);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("Unable to find method 'configure' on class 'org.apache.log4j.PropertyConfigurator'");
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)("Failed to add extra Logger configuration: \n   Error: " + t.getMessage()), t);
            }
        }
    }

    private void importLogSettings(String springUrl, Properties mainProperties) {
        Resource[] resources = null;
        try {
            resources = this.resolver.getResources(springUrl);
        }
        catch (Exception exception) {
            logger.warn((Object)("Failed to find additional Logger configuration: " + springUrl));
        }
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Resource resource = resourceArray[n2];
                try {
                    InputStream inputStream = resource.getInputStream();
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    mainProperties.putAll((Map<?, ?>)properties);
                }
                catch (Throwable e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)("Failed to add extra Logger configuration: \n   URL:   " + springUrl + "\n" + "   Error: " + e.getMessage()), e);
                }
            }
            ++n2;
        }
    }
}

