/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionTest;
import org.alfresco.repo.security.permissions.impl.RequiredPermission;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.junit.experimental.categories.Category;

@Category(value={OwnJVMTestsCategory.class})
public class PermissionModelTest
extends AbstractPermissionTest {
    public void testWoof() {
        QName typeQname = this.nodeService.getType(this.rootNodeRef);
        Set aspectQNames = this.nodeService.getAspects(this.rootNodeRef);
        PermissionReference ref = this.permissionModelDAO.getPermissionReference(null, "CheckOut");
        Set answer = this.permissionModelDAO.getRequiredPermissions(ref, typeQname, aspectQNames, RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)1, (int)answer.size());
    }

    public void testIncludePermissionGroups() {
        Set grantees = this.permissionModelDAO.getGranteePermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"Consumer"));
        PermissionModelTest.assertEquals((int)8, (int)grantees.size());
    }

    public void testIncludePermissionGroups2() {
        Set grantees = this.permissionModelDAO.getGranteePermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"Contributor"));
        PermissionModelTest.assertEquals((int)16, (int)grantees.size());
    }

    public void testIncludePermissionGroups3() {
        Set grantees = this.permissionModelDAO.getGranteePermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"Editor"));
        PermissionModelTest.assertEquals((int)19, (int)grantees.size());
    }

    public void testIncludePermissionGroups4() {
        Set grantees = this.permissionModelDAO.getGranteePermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"Collaborator"));
        PermissionModelTest.assertEquals((int)26, (int)grantees.size());
    }

    public void testIncludePermissionGroups5() {
        Set grantees = this.permissionModelDAO.getGranteePermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"Coordinator"));
        PermissionModelTest.assertEquals((int)69, (int)grantees.size());
    }

    public void testIncludePermissionGroups6() {
        Set grantees = this.permissionModelDAO.getGranteePermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"RecordAdministrator"));
        PermissionModelTest.assertEquals((int)19, (int)grantees.size());
    }

    public void testGetGrantingPermissions() {
        Set granters = this.permissionModelDAO.getGrantingPermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"ReadProperties"));
        PermissionModelTest.assertEquals((int)14, (int)granters.size());
        granters = this.permissionModelDAO.getGrantingPermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"_ReadProperties"));
        PermissionModelTest.assertEquals((int)15, (int)granters.size());
    }

    public void testGlobalPermissions() {
        Set globalPermissions = this.permissionModelDAO.getGlobalPermissionEntries();
        PermissionModelTest.assertEquals((int)5, (int)globalPermissions.size());
    }

    public void testRequiredPermissions() {
        Set required = this.permissionModelDAO.getRequiredPermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"Read"), QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.emptySet(), RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)3, (int)required.size());
        required = this.permissionModelDAO.getRequiredPermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"ReadContent"), QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.emptySet(), RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)1, (int)required.size());
        required = this.permissionModelDAO.getRequiredPermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"_ReadContent"), QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.emptySet(), RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)0, (int)required.size());
        required = this.permissionModelDAO.getRequiredPermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"Coordinator"), QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.emptySet(), RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)17, (int)required.size());
        required = this.permissionModelDAO.getRequiredPermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"FullControl"), QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.emptySet(), RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)17, (int)required.size());
    }

    public void testMultiThreadedAccess() {
        Thread runner = null;
        int i = 0;
        while (i < 20) {
            runner = new Nester("Concurrent-" + i, runner);
            ++i;
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void testNulls() {
        this.permissionModelDAO.getRequiredPermissions(null, QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.emptySet(), RequiredPermission.On.NODE);
        this.permissionModelDAO.getRequiredPermissions((PermissionReference)SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), (String)"Read"), null, Collections.emptySet(), RequiredPermission.On.NODE);
        this.permissionModelDAO.getRequiredPermissions(null, null, Collections.emptySet(), RequiredPermission.On.NODE);
        this.permissionModelDAO.getGranteePermissions(null);
        this.permissionModelDAO.getGlobalPermissionEntries().contains(null);
    }

    class Nester
    extends Thread {
        Thread waiter;

        Nester(String name, Thread waiter) {
            super(name);
            this.setDaemon(true);
            this.waiter = waiter;
        }

        @Override
        public void run() {
            block9: {
                PermissionModelTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                if (this.waiter != null) {
                    this.waiter.start();
                }
                try {
                    try {
                        System.out.println("Start " + this.getName());
                        RetryingTransactionHelper.RetryingTransactionCallback<Void> queryPermissionModel = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                Random random = new Random();
                                Set toTest = PermissionModelTest.this.permissionModelDAO.getAllPermissions(QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)PermissionModelTest.this.namespacePrefixResolver));
                                int i = 0;
                                while (i < 10000) {
                                    for (PermissionReference pr : toTest) {
                                        if (!(random.nextFloat() < 0.5f)) continue;
                                        PermissionModelTest.this.permissionModelDAO.getRequiredPermissions(pr, QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)PermissionModelTest.this.namespacePrefixResolver), Collections.emptySet(), RequiredPermission.On.NODE);
                                    }
                                    ++i;
                                }
                                return null;
                            }
                        };
                        PermissionModelTest.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)queryPermissionModel);
                        System.out.println("End " + this.getName());
                    }
                    catch (Exception e) {
                        System.out.println("End " + this.getName() + " with error " + e.getMessage());
                        e.printStackTrace();
                        PermissionModelTest.this.authenticationComponent.clearCurrentSecurityContext();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    PermissionModelTest.this.authenticationComponent.clearCurrentSecurityContext();
                    throw throwable;
                }
                PermissionModelTest.this.authenticationComponent.clearCurrentSecurityContext();
            }
            if (this.waiter != null) {
                try {
                    this.waiter.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

