/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forum;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.forum.CommentService;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CommentsTest {
    private static final ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    public static final String USER_ONE_NAME = "userone";
    public static final String USER_TWO_NAME = "usertwo";
    public static final String USER_THREE_NAME = "userthree";
    public static final AlfrescoPerson TEST_USER1 = new AlfrescoPerson(APP_CONTEXT_INIT, "userone");
    @ClassRule
    public static RuleChain STATIC_RULE_CHAIN = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)TEST_USER1);
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(TEST_USER1);
    public TemporaryNodes testNodes = new TemporaryNodes(APP_CONTEXT_INIT);
    public TemporarySites testSites = new TemporarySites(APP_CONTEXT_INIT);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.runAsRule).around((TestRule)this.testSites).around((TestRule)this.testNodes);
    private static BehaviourFilter behaviourFilter;
    private static ContentService contentService;
    private static NodeService nodeService;
    private static Repository repositoryHelper;
    private static SiteService siteService;
    private static RetryingTransactionHelper transactionHelper;
    private static AuthenticationComponent authenticationComponent;
    private static CommentService commentService;
    private static MutableAuthenticationService authenticationService;
    private static PersonService personService;
    private static ActivityPostDAO postDAO;
    private static PermissionServiceImpl permissionServiceImpl;
    private static ModelDAO permissionModelDAO;
    private static LockService lockService;
    private static NodeRef COMPANY_HOME;
    private SiteInfo testSite;
    private NodeRef testFolder;
    private List<NodeRef> testDocs;

    @BeforeClass
    public static void initBasicServices() throws Exception {
        behaviourFilter = (BehaviourFilter)APP_CONTEXT_INIT.getApplicationContext().getBean("policyBehaviourFilter");
        contentService = (ContentService)APP_CONTEXT_INIT.getApplicationContext().getBean("ContentService");
        nodeService = (NodeService)APP_CONTEXT_INIT.getApplicationContext().getBean("NodeService");
        repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        siteService = (SiteService)APP_CONTEXT_INIT.getApplicationContext().getBean("SiteService");
        transactionHelper = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper");
        authenticationComponent = (AuthenticationComponent)APP_CONTEXT_INIT.getApplicationContext().getBean("authenticationComponent");
        commentService = (CommentService)APP_CONTEXT_INIT.getApplicationContext().getBean("commentService");
        authenticationService = (MutableAuthenticationService)APP_CONTEXT_INIT.getApplicationContext().getBean("AuthenticationService");
        personService = (PersonService)APP_CONTEXT_INIT.getApplicationContext().getBean("PersonService");
        postDAO = (ActivityPostDAO)APP_CONTEXT_INIT.getApplicationContext().getBean("postDAO");
        permissionServiceImpl = (PermissionServiceImpl)APP_CONTEXT_INIT.getApplicationContext().getBean("permissionServiceImpl");
        permissionModelDAO = (ModelDAO)APP_CONTEXT_INIT.getApplicationContext().getBean("permissionsModelDAO");
        lockService = (LockService)APP_CONTEXT_INIT.getApplicationContext().getBean("lockService");
        COMPANY_HOME = repositoryHelper.getCompanyHome();
    }

    @Before
    public void createSomeContentForCommentingOn() throws Exception {
        this.testSite = this.testSites.createSite("sitePreset", "testSite", "test site title", "test site description", SiteVisibility.PUBLIC, USER_ONE_NAME);
        NodeRef doclib = siteService.getContainer(this.testSite.getShortName(), "documentLibrary");
        this.testFolder = this.testNodes.createFolder(doclib, "testFolder", TEST_USER1.getUsername());
        this.testDocs = new ArrayList<NodeRef>(3);
        int i = 0;
        while (i < 3) {
            NodeRef testNode = this.testNodes.createQuickFile("text/plain", this.testFolder, "testDocInFolder_" + GUID.generate() + "_" + i, TEST_USER1.getUsername());
            this.testDocs.add(testNode);
            ++i;
        }
    }

    @Test
    public void testMNT11667() throws Exception {
        try {
            transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
                    CommentsTest.this.createUser(CommentsTest.USER_TWO_NAME);
                    Assert.assertTrue((boolean)siteService.hasSite(CommentsTest.this.testSite.getShortName()));
                    authenticationComponent.setCurrentUser(CommentsTest.USER_ONE_NAME);
                    siteService.setMembership(CommentsTest.this.testSite.getShortName(), CommentsTest.USER_TWO_NAME, "SiteCollaborator");
                    Assert.assertEquals((Object)"SiteManager", (Object)siteService.getMembersRole(CommentsTest.this.testSite.getShortName(), CommentsTest.USER_ONE_NAME));
                    Assert.assertEquals((Object)"SiteCollaborator", (Object)siteService.getMembersRole(CommentsTest.this.testSite.getShortName(), CommentsTest.USER_TWO_NAME));
                    NodeRef doclib = siteService.getContainer(CommentsTest.this.testSite.getShortName(), "documentLibrary");
                    NodeRef testNode = CommentsTest.this.testNodes.createQuickFile("text/plain", doclib, "testDoc", CommentsTest.USER_ONE_NAME);
                    Assert.assertTrue((boolean)nodeService.exists(testNode));
                    permissionServiceImpl.setInheritParentPermissions(testNode, false);
                    permissionServiceImpl.setPermission(testNode, CommentsTest.USER_ONE_NAME, "All", true);
                    NodeRef comment = commentService.createComment(testNode, "This is the comment title", "This is a Web Script comment", true);
                    Assert.assertTrue((boolean)nodeService.exists(comment));
                    ActivityPostEntity params = new ActivityPostEntity();
                    params.setStatus(ActivityPostEntity.STATUS.PENDING.toString());
                    List activityPostList = postDAO.selectPosts(params, -1);
                    String activityNodeRef = null;
                    for (ActivityPostEntity activityPostEntry : activityPostList) {
                        if (!"comments".equals(activityPostEntry.getAppTool())) continue;
                        String activityData = activityPostEntry.getActivityData();
                        JSONObject json = new JSONObject(activityData);
                        activityNodeRef = (String)json.get("nodeRef");
                    }
                    Assert.assertFalse((activityNodeRef == null ? 1 : 0) != 0);
                    NodeRef nodeRef = new NodeRef(activityNodeRef);
                    Assert.assertTrue((permissionServiceImpl.hasPermission(nodeRef, CommentsTest.this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
                    Assert.assertTrue((permissionServiceImpl.hasPermission(nodeRef, CommentsTest.this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
                    Assert.assertTrue((permissionServiceImpl.hasPermission(nodeRef, CommentsTest.this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
                    authenticationComponent.setCurrentUser(CommentsTest.USER_TWO_NAME);
                    Assert.assertTrue((permissionServiceImpl.hasPermission(nodeRef, CommentsTest.this.getPermission("Read")) == AccessStatus.DENIED ? 1 : 0) != 0);
                    Assert.assertTrue((permissionServiceImpl.hasPermission(nodeRef, CommentsTest.this.getPermission("Write")) == AccessStatus.DENIED ? 1 : 0) != 0);
                    Assert.assertTrue((permissionServiceImpl.hasPermission(nodeRef, CommentsTest.this.getPermission("Delete")) == AccessStatus.DENIED ? 1 : 0) != 0);
                    return null;
                }
            });
        }
        finally {
            authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
            if (personService.personExists(USER_TWO_NAME)) {
                personService.deletePerson(USER_TWO_NAME);
            }
            if (authenticationService.authenticationExists(USER_TWO_NAME)) {
                authenticationService.deleteAuthentication(USER_TWO_NAME);
            }
        }
    }

    private PermissionReference getPermission(String permission) {
        return permissionModelDAO.getPermissionReference(null, permission);
    }

    private void createUser(String userName) {
        if (!authenticationService.authenticationExists(userName)) {
            authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            personService.createPerson((Map)personProps);
        }
    }

    @Test
    public void commentOnDocsCheckingCommentCountRollup() throws Exception {
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                for (NodeRef nr : CommentsTest.this.testDocs) {
                    CommentsTest.this.assertCommentCountIs(nr, 0);
                }
                HashMap mapDiscussableToComments = new HashMap();
                for (NodeRef nodeRef : CommentsTest.this.testDocs) {
                    ArrayList<NodeRef> comments = new ArrayList<NodeRef>();
                    mapDiscussableToComments.put(nodeRef, comments);
                    comments.add(CommentsTest.this.applyComment(nodeRef, "Test comment 1 " + System.currentTimeMillis()));
                    Thread.sleep(50L);
                    comments.add(CommentsTest.this.applyComment(nodeRef, "Test comment 2 " + System.currentTimeMillis()));
                    Thread.sleep(50L);
                }
                for (NodeRef nodeRef : CommentsTest.this.testDocs) {
                    CommentsTest.this.assertCommentCountIs(nodeRef, 2);
                }
                for (Map.Entry entry : mapDiscussableToComments.entrySet()) {
                    for (NodeRef commentNode : (List)entry.getValue()) {
                        nodeService.deleteNode(commentNode);
                    }
                }
                for (NodeRef nodeRef : CommentsTest.this.testDocs) {
                    CommentsTest.this.assertCommentCountIs(nodeRef, 0);
                }
                return null;
            }
        });
    }

    @Test
    public void testRollupOfPreSwiftNodes() throws Exception {
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertTrue((String)"Not enough test docs for this test case", (CommentsTest.this.testDocs.size() >= 2 ? 1 : 0) != 0);
                NodeRef node1 = (NodeRef)CommentsTest.this.testDocs.get(0);
                NodeRef node2 = (NodeRef)CommentsTest.this.testDocs.get(1);
                behaviourFilter.disableBehaviour(ForumModel.TYPE_POST);
                NodeRef[] nodeRefArray = new NodeRef[]{node1, node2};
                int n = nodeRefArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeRef nr = nodeRefArray[n2];
                    Assert.assertFalse((String)"Test node had comments rollup aspect.", (boolean)nodeService.hasAspect(nr, ForumModel.ASPECT_COMMENTS_ROLLUP));
                    ++n2;
                }
                NodeRef commentOnNode1 = CommentsTest.this.applyComment(node1, "Hello", true);
                CommentsTest.this.applyComment(node1, "Bonjour", true);
                CommentsTest.this.applyComment(node2, "Hola", true);
                CommentsTest.this.applyComment(node2, "Bout ye?", true);
                NodeRef[] nodeRefArray2 = new NodeRef[]{node1, node2};
                int n3 = nodeRefArray2.length;
                n = 0;
                while (n < n3) {
                    NodeRef nr = nodeRefArray2[n];
                    Assert.assertFalse((String)"Test node had comments rollup aspect.", (boolean)nodeService.hasAspect(nr, ForumModel.ASPECT_COMMENTS_ROLLUP));
                    ++n;
                }
                behaviourFilter.enableBehaviour(ForumModel.TYPE_POST);
                CommentsTest.this.applyComment(node2, "hello again");
                nodeService.deleteNode(commentOnNode1);
                CommentsTest.this.assertCommentCountIs(node2, 3);
                CommentsTest.this.assertCommentCountIs(node1, 1);
                return null;
            }
        });
    }

    @Test
    public void testAddingCommentOnLockedNode() {
        String user = authenticationComponent.getCurrentUserName();
        final NodeRef testDoc = this.testDocs.get(0);
        try {
            block9: {
                block8: {
                    transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Throwable {
                            authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
                            CommentsTest.this.createUser(CommentsTest.USER_TWO_NAME);
                            CommentsTest.this.createUser(CommentsTest.USER_THREE_NAME);
                            siteService.setMembership(CommentsTest.this.testSite.getShortName(), CommentsTest.USER_TWO_NAME, "SiteManager");
                            siteService.setMembership(CommentsTest.this.testSite.getShortName(), CommentsTest.USER_THREE_NAME, "SiteManager");
                            return null;
                        }
                    });
                    authenticationComponent.setCurrentUser(USER_ONE_NAME);
                    transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Throwable {
                            CommentsTest.this.applyComment(testDoc, "Hello 1");
                            CommentsTest.this.applyComment(testDoc, "Hello 2");
                            return null;
                        }
                    });
                    authenticationComponent.setCurrentUser(USER_TWO_NAME);
                    transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Throwable {
                            lockService.lock(testDoc, LockType.WRITE_LOCK, 3600, Lifetime.PERSISTENT, "someInfo");
                            return null;
                        }
                    });
                    authenticationComponent.setCurrentUser(USER_THREE_NAME);
                    try {
                        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                CommentsTest.this.applyComment(testDoc, "Hello 3");
                                return null;
                            }
                        });
                        Assert.fail((String)"NodeLockedException not thrown");
                    }
                    catch (NodeLockedException nodeLockedException) {
                    }
                    catch (ContentIOException cioe) {
                        if (cioe.getCause() instanceof NodeLockedException) break block8;
                        throw cioe;
                    }
                }
                authenticationComponent.setCurrentUser(USER_ONE_NAME);
                try {
                    transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Throwable {
                            CommentsTest.this.applyComment(testDoc, "Hello 3");
                            return null;
                        }
                    });
                    Assert.fail((String)"NodeLockedException not thrown");
                }
                catch (NodeLockedException nodeLockedException) {
                }
                catch (ContentIOException cioe) {
                    if (cioe.getCause() instanceof NodeLockedException) break block9;
                    throw cioe;
                }
            }
            authenticationComponent.setCurrentUser(USER_TWO_NAME);
            transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    CommentsTest.this.applyComment(testDoc, "Hello 3");
                    return null;
                }
            });
            this.assertCommentCountIs(testDoc, 3);
        }
        catch (Throwable throwable) {
            authenticationComponent.setCurrentUser(USER_ONE_NAME);
            transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(testDoc){
                private final /* synthetic */ NodeRef val$testDoc;
                {
                    this.val$testDoc = nodeRef;
                }

                public Void execute() throws Throwable {
                    lockService.unlock(this.val$testDoc);
                    return null;
                }
            });
            authenticationComponent.setCurrentUser(user);
            throw throwable;
        }
        authenticationComponent.setCurrentUser(USER_ONE_NAME);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new /* invalid duplicate definition of identical inner class */);
        authenticationComponent.setCurrentUser(user);
    }

    @Test
    public void testTriggerCommentRecount() throws Exception {
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef testDoc = (NodeRef)CommentsTest.this.testDocs.get(0);
                CommentsTest.this.applyComment(testDoc, "Hello 1");
                CommentsTest.this.applyComment(testDoc, "Hello 2");
                CommentsTest.this.applyComment(testDoc, "Hello 3");
                CommentsTest.this.assertCommentCountIs(testDoc, 3);
                nodeService.setProperty(testDoc, ForumModel.PROP_COMMENT_COUNT, (Serializable)Integer.valueOf(42));
                CommentsTest.this.assertCommentCountIs(testDoc, 42);
                nodeService.setProperty(testDoc, ForumModel.PROP_COMMENT_COUNT, (Serializable)Integer.valueOf(-1));
                CommentsTest.this.assertCommentCountIs(testDoc, 3);
                return null;
            }
        });
    }

    private void assertCommentCountIs(NodeRef discussableNode, int expectedCount) {
        Serializable commentCount = nodeService.getProperty(discussableNode, ForumModel.PROP_COMMENT_COUNT);
        if (expectedCount == 0) {
            Assert.assertTrue((String)"Uncommented node should have EITHER no commentsRollup aspect OR commentCount of zero.", (!nodeService.hasAspect(discussableNode, ForumModel.ASPECT_COMMENTS_ROLLUP) || commentCount != null && commentCount.equals(new Integer(0)) ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"Commented node should have discussable aspect.", (boolean)nodeService.hasAspect(discussableNode, ForumModel.ASPECT_COMMENTS_ROLLUP));
            Assert.assertEquals((String)"Wrong comment count", (Object)expectedCount, (Object)commentCount);
        }
    }

    private NodeRef applyComment(NodeRef nr, String comment) {
        return this.applyComment(nr, comment, false);
    }

    private NodeRef applyComment(NodeRef nr, String comment, boolean suppressRollups) {
        if (!nodeService.hasAspect(nr, ForumModel.ASPECT_DISCUSSABLE)) {
            nodeService.addAspect(nr, ForumModel.ASPECT_DISCUSSABLE, null);
        }
        if (!nodeService.hasAspect(nr, ForumModel.ASPECT_COMMENTS_ROLLUP) && !suppressRollups) {
            nodeService.addAspect(nr, ForumModel.ASPECT_COMMENTS_ROLLUP, null);
        }
        NodeRef forumNode = ((ChildAssociationRef)nodeService.getChildAssocs(nr, (QNamePattern)ForumModel.ASSOC_DISCUSSION, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussion")).get(0)).getChildRef();
        List existingTopics = nodeService.getChildAssocs(forumNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments"));
        NodeRef topicNode = null;
        topicNode = existingTopics.isEmpty() ? nodeService.createNode(forumNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments"), ForumModel.TYPE_TOPIC).getChildRef() : ((ChildAssociationRef)existingTopics.get(0)).getChildRef();
        NodeRef postNode = nodeService.createNode(topicNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)("comment" + System.currentTimeMillis())), ForumModel.TYPE_POST).getChildRef();
        ContentWriter writer = contentService.getWriter(postNode, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(comment);
        return postNode;
    }
}

