/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.scheduled.CronScheduledQueryBasedTemplateActionDefinition;
import org.alfresco.repo.action.scheduled.FreeMarkerWithLuceneExtensionsModelFactory;
import org.alfresco.repo.action.scheduled.SimpleTemplateActionDefinition;
import org.alfresco.repo.action.scheduled.TemplateActionDefinition;
import org.alfresco.repo.action.scheduled.TemplateActionModelFactory;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.quartz.Scheduler;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class, RedundantTests.class})
public class CronScheduledQueryBasedTemplateActionDefinitionTest
extends TestCase {
    private static final int AMOUNT_OF_DAYS_BEFORE = -4;
    private static final int TEST_DOCUMENTS_AMOUNT = 5;
    private static final String SCRIPT_TEST_ACTION_NAME = "scriptTestActionName-" + System.currentTimeMillis();
    private static final String SCHEDULER_QUERY_LANGUAGE = "lucene";
    private static final String SCHEDULER_CRON_EXPRESSION = "0 50 * * * ?";
    private static final String SCHEDULER_COMPENSATING_ACTION_MODE = "IGNORE";
    private static final String SCHEDULER_TRANSACTION_MODE = "UNTIL_FIRST_FAILURE";
    private static final String SCHEDULER_JOB_NAME = "jobTestName-" + System.currentTimeMillis();
    private static final String SCHEDULER_JOB_GROUP = "jobTestGroup-" + System.currentTimeMillis();
    private static final String SCHEDULER_TRIGGER_NAME = "triggerTestName-" + System.currentTimeMillis();
    private static final String SCHEDULER_TRIGGER_GROUP = "triggerTestGroup-" + System.currentTimeMillis();
    private static final String SCHEDULER_FACTORY_BEAN_NAME = "schedulerFactory";
    private static final String POLICY_BEHAVIOUR_FILTER_BEAN_NAME = "policyBehaviourFilter";
    private static final String ROOT_TEST_FOLDER_NAME_TEMPLATE = "RootTestFolder-%d";
    private static final String TEST_DOCUMENT_NAME_TEMPLATE = "TestDocument-%d-%d.txt";
    private static final String FRESH_TEST_DOCUMENT_NAME_TEMPLATE = "FreshTestDocument-%d-%d.txt";
    private static final String YESTERDAY_TEST_DOCUMENT_NAME_TEMPLATE = "YesterdayTestDocument-%d-%d.txt";
    private static final String MNT_11598_QUERY_TEMPLATE = "@cm\\:created:\\$\\{luceneDateRange(\"%s\", \"-P10Y\")\\}";
    private static final String TEST_FOLDER_NAME = String.format("RootTestFolder-%d", System.currentTimeMillis());
    private ApplicationContext applicationContext;
    private ServiceRegistry registry;
    private UserTransaction transaction;
    private NodeRef rootTestFolder;
    private List<FileInfo> freshNodes = new LinkedList<FileInfo>();
    private List<FileInfo> yesterdayNodes = new LinkedList<FileInfo>();
    private CronScheduledQueryBasedTemplateActionDefinition scheduler;
    private StoreRef storeRef = new StoreRef("workspace", "SpacesStore");

    @Before
    public void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        this.registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.initializeScheduler();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.transaction = this.registry.getTransactionService().getUserTransaction(false);
        this.transaction.begin();
        this.createTestContent();
    }

    private void initializeScheduler() {
        Scheduler factory = (Scheduler)this.applicationContext.getBean(SCHEDULER_FACTORY_BEAN_NAME);
        FreeMarkerWithLuceneExtensionsModelFactory templateActionModelFactory = new FreeMarkerWithLuceneExtensionsModelFactory();
        templateActionModelFactory.setServiceRegistry(this.registry);
        SimpleTemplateActionDefinition templateActionDefinition = new SimpleTemplateActionDefinition();
        templateActionDefinition.setApplicationContext(this.applicationContext);
        templateActionDefinition.setActionService(this.registry.getActionService());
        templateActionDefinition.setTemplateService(this.registry.getTemplateService());
        templateActionDefinition.setDictionaryService(this.registry.getDictionaryService());
        templateActionDefinition.setTemplateActionModelFactory((TemplateActionModelFactory)templateActionModelFactory);
        templateActionDefinition.setActionName(SCRIPT_TEST_ACTION_NAME);
        this.scheduler = new CronScheduledQueryBasedTemplateActionDefinition();
        this.scheduler.setScheduler(factory);
        this.scheduler.setTransactionService(this.registry.getTransactionService());
        this.scheduler.setActionService(this.registry.getActionService());
        this.scheduler.setSearchService(this.registry.getSearchService());
        this.scheduler.setTemplateService(this.registry.getTemplateService());
        this.scheduler.setRunAsUser(AuthenticationUtil.getSystemUserName());
        this.scheduler.setTemplateActionDefinition((TemplateActionDefinition)templateActionDefinition);
        this.scheduler.setTemplateActionModelFactory((TemplateActionModelFactory)templateActionModelFactory);
        this.scheduler.setStores(Collections.singletonList(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.toString()));
        this.scheduler.setQueryLanguage(SCHEDULER_QUERY_LANGUAGE);
        this.scheduler.setCronExpression(SCHEDULER_CRON_EXPRESSION);
        this.scheduler.setCompensatingActionMode(SCHEDULER_COMPENSATING_ACTION_MODE);
        this.scheduler.setTransactionMode(SCHEDULER_TRANSACTION_MODE);
        this.scheduler.setJobName(SCHEDULER_JOB_NAME);
        this.scheduler.setJobGroup(SCHEDULER_JOB_GROUP);
        this.scheduler.setTriggerName(SCHEDULER_TRIGGER_NAME);
        this.scheduler.setTriggerGroup(SCHEDULER_TRIGGER_GROUP);
    }

    private void createTestContent() throws Exception {
        FileFolderService fileFolderService = this.registry.getFileFolderService();
        NodeRef companyHomeNodeRef = this.registry.getNodeLocatorService().getNode("companyhome", null, null);
        this.rootTestFolder = fileFolderService.create(companyHomeNodeRef, TEST_FOLDER_NAME, ContentModel.TYPE_FOLDER).getNodeRef();
        int i = 0;
        while (i < 5) {
            String freshDocName = String.format(FRESH_TEST_DOCUMENT_NAME_TEMPLATE, i, System.currentTimeMillis());
            FileInfo fileInfo = fileFolderService.create(this.rootTestFolder, freshDocName, ContentModel.TYPE_CONTENT);
            this.freshNodes.add(fileInfo);
            ++i;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(6, -4);
        Date yesterdayTime = calendar.getTime();
        NodeService nodeService = this.registry.getNodeService();
        BehaviourFilter policyBehaviourFilter = (BehaviourFilter)this.applicationContext.getBean(POLICY_BEHAVIOUR_FILTER_BEAN_NAME);
        policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        try {
            int i2 = 0;
            while (i2 < 5) {
                String yesterdayDocName = String.format(YESTERDAY_TEST_DOCUMENT_NAME_TEMPLATE, i2, System.currentTimeMillis());
                FileInfo fileInfo = fileFolderService.create(this.rootTestFolder, yesterdayDocName, ContentModel.TYPE_CONTENT);
                nodeService.setProperty(fileInfo.getNodeRef(), ContentModel.PROP_CREATED, (Serializable)yesterdayTime);
                this.yesterdayNodes.add(fileInfo);
                ++i2;
            }
        }
        finally {
            policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
        }
        this.checkNodes(this.freshNodes);
        this.checkNodes(this.yesterdayNodes);
    }

    private void checkNodes(List<FileInfo> nodes) throws Exception {
        SearchService searchService = this.registry.getSearchService();
        boolean notFound = false;
        int i = 1;
        while (i <= 40) {
            notFound = false;
            for (FileInfo fileInfo : nodes) {
                ResultSet resultSet = searchService.query(this.storeRef, SCHEDULER_QUERY_LANGUAGE, "PATH:\"/app:company_home//cm:" + TEST_FOLDER_NAME + "//cm:" + fileInfo.getName() + "\"");
                if (resultSet.length() != 0) continue;
                notFound = true;
                break;
            }
            if (!notFound) break;
            Thread.sleep(500L);
            ++i;
        }
        CronScheduledQueryBasedTemplateActionDefinitionTest.assertFalse((String)"The content was not created or indexed correctly.", (boolean)notFound);
    }

    @After
    public void tearDown() throws Exception {
        this.scheduler.getScheduler().unscheduleJob(this.scheduler.getTrigger().getKey());
        if (4 != this.transaction.getStatus()) {
            this.transaction.rollback();
        }
        this.freshNodes.clear();
        this.yesterdayNodes.clear();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void testQueryTemplateFunctionsUnescapingMnt11598() throws Exception {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(6, -2);
        String isoDate = ISO8601DateFormat.format((Date)calendar.getTime());
        String queryTemplate = String.format(MNT_11598_QUERY_TEMPLATE, isoDate);
        this.scheduler.setQueryTemplate(queryTemplate);
        HashSet actualNodes = new HashSet(this.scheduler.getNodes());
        CronScheduledQueryBasedTemplateActionDefinitionTest.assertNotNull((String)"Result set must not be null!", actualNodes);
        CronScheduledQueryBasedTemplateActionDefinitionTest.assertFalse((String)"Result set must not be empty!", (boolean)actualNodes.isEmpty());
        CronScheduledQueryBasedTemplateActionDefinitionTest.assertTrue((String)"Result set must contain at least 5 nodes!", (actualNodes.size() >= this.yesterdayNodes.size() ? 1 : 0) != 0);
        for (FileInfo fileInfo : this.freshNodes) {
            CronScheduledQueryBasedTemplateActionDefinitionTest.assertFalse((String)"No one of the nodes created \"today\" is expected in result set!", (boolean)actualNodes.contains(fileInfo.getNodeRef()));
        }
        for (FileInfo fileInfo : this.yesterdayNodes) {
            CronScheduledQueryBasedTemplateActionDefinitionTest.assertTrue((String)"One of the nodes created \"yesteday\" is missing in result set!", (boolean)actualNodes.contains(fileInfo.getNodeRef()));
        }
    }
}

