/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.directurl.DirectAccessUrlDisabledException;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.rest.api.DirectAccessUrlHelper;
import org.alfresco.rest.api.model.DirectAccessUrlRequest;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.api.model.VersionOptions;
import org.alfresco.rest.api.nodes.AbstractNodeRelation;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceBinaryAction;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="versions", entityResource=NodesEntityResource.class, title="Node Versions")
public class NodeVersionsRelation
extends AbstractNodeRelation
implements RelationshipResourceAction.Read<Node>,
RelationshipResourceAction.ReadById<Node>,
RelationshipResourceBinaryAction.Read,
RelationshipResourceAction.Delete,
InitializingBean {
    protected VersionService versionService;
    protected BehaviourFilter behaviourFilter;
    private DirectAccessUrlHelper directAccessUrlHelper;

    public void setDirectAccessUrlHelper(DirectAccessUrlHelper directAccessUrlHelper) {
        this.directAccessUrlHelper = directAccessUrlHelper;
    }

    @Override
    public void afterPropertiesSet() {
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.sr);
        ParameterCheck.mandatory((String)"nodes", (Object)this.nodes);
        this.versionService = this.sr.getVersionService();
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    @Override
    @WebApiDescription(title="Return version history as a paged list of version node infos")
    public CollectionWithPagingInfo<Node> readAll(String nodeId, Parameters parameters) {
        int maxItems;
        Paging paging;
        int skipCount;
        NodeRef nodeRef = this.nodes.validateOrLookupNode(nodeId);
        Optional optionalVersionHistory = this.versionService.getVersionHistory(nodeRef, skipCount = (paging = parameters.getPaging()).getSkipCount(), maxItems = paging.getMaxItems());
        if (optionalVersionHistory.isEmpty()) {
            return this.listPage(Collections.emptyList(), paging);
        }
        VersionHistory versionHistory = (VersionHistory)optionalVersionHistory.orElseThrow();
        List<String> includeParam = parameters.getInclude();
        HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>(10);
        Collection versions = versionHistory.getAllVersions();
        ArrayList<Node> page = new ArrayList<Node>(versions.size());
        for (Version v : versions) {
            Node node = this.nodes.getFolderOrDocument(v.getFrozenStateNodeRef(), null, null, includeParam, mapUserInfo);
            this.mapVersionInfo(v, node);
            page.add(node);
        }
        int totalCount = versionHistory.getTotalVersionsCount();
        boolean hasMoreItems = skipCount + page.size() < totalCount;
        return CollectionWithPagingInfo.asPaged(paging, page, hasMoreItems, totalCount);
    }

    private void mapVersionInfo(Version v, Node aNode) {
        this.mapVersionInfo(v, aNode, new NodeRef("", "", v.getVersionLabel()));
    }

    public void mapVersionInfo(Version v, Node aNode, NodeRef nodeRef) {
        aNode.setNodeRef(nodeRef);
        aNode.setVersionComment(v.getDescription());
        Map<String, Object> props = aNode.getProperties();
        if (props != null) {
            props.put("cm:versionType", v.getVersionProperty("versionType"));
        }
        aNode.setParentId(null);
        aNode.setCreated(null);
        aNode.setCreatedByUser(null);
    }

    @Override
    @WebApiDescription(title="Get version node info", description="Return metadata for a specific version node")
    public Node readById(String nodeId, String versionId, Parameters parameters) {
        Version version = this.findVersion(nodeId, versionId);
        if (version != null) {
            Node node = this.nodes.getFolderOrDocumentFullInfo(version.getFrozenStateNodeRef(), null, null, parameters, null);
            this.mapVersionInfo(version, node);
            return node;
        }
        throw new EntityNotFoundException(nodeId + "-" + versionId);
    }

    @Override
    @WebApiDescription(title="Download version content", description="Download version content")
    @BinaryProperties(value={"content"})
    public BinaryResource readProperty(String nodeId, String versionId, Parameters parameters) {
        Version version = this.findVersion(nodeId, versionId);
        if (version != null) {
            NodeRef versionNodeRef = version.getFrozenStateNodeRef();
            return this.nodes.getContent(versionNodeRef, parameters, true);
        }
        throw new EntityNotFoundException(nodeId + "-" + versionId);
    }

    @Operation(value="revert")
    @WebApiDescription(title="Revert Version", description="Reverts (ie. promotes) specified version to become a new, most recent, version", successStatus=200)
    public Node revertById(String nodeId, String versionId, VersionOptions versionOptions, Parameters parameters, WithResponse withResponse) {
        Version version = this.findVersion(nodeId, versionId);
        if (version != null) {
            CheckOutCheckInService cociService = this.sr.getCheckOutCheckInService();
            NodeRef nodeRef = version.getVersionedNodeRef();
            String versionComment = versionOptions.getComment();
            VersionType versionType = VersionType.MINOR;
            Boolean versionMajor = versionOptions.getMajorVersion();
            if (versionMajor != null && versionMajor.booleanValue()) {
                versionType = VersionType.MAJOR;
            }
            HashMap<String, Object> versionProperties = new HashMap<String, Object>(2);
            versionProperties.put("versionType", versionType);
            if (versionComment != null) {
                versionProperties.put("description", versionComment);
            }
            if (this.sr.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
                nodeRef = cociService.cancelCheckout(nodeRef);
            }
            this.versionService.revert(nodeRef, version, false);
            NodeRef wcNodeRef = cociService.checkout(nodeRef);
            cociService.checkin(wcNodeRef, versionProperties);
            version = this.versionService.getVersionHistory(nodeRef).getHeadVersion();
            Node node = this.nodes.getFolderOrDocumentFullInfo(version.getFrozenStateNodeRef(), null, null, parameters, null);
            this.mapVersionInfo(version, node);
            return node;
        }
        throw new EntityNotFoundException(nodeId + "-" + versionId);
    }

    @Override
    @WebApiDescription(title="Delete version")
    public void delete(String nodeId, String versionId, Parameters parameters) {
        Version version = this.findVersion(nodeId, versionId);
        NodeRef nodeRef = version.getVersionedNodeRef();
        if (this.sr.getPermissionService().hasPermission(nodeRef, "Delete") != AccessStatus.ALLOWED) {
            throw new PermissionDeniedException("Cannot delete version");
        }
        this.versionService.deleteVersion(nodeRef, version);
        Map props = this.sr.getNodeService().getProperties(nodeRef);
        if (props.get(ContentModel.PROP_VERSION_LABEL) == null) {
            throw new IntegrityException("Cannot delete last version (did you mean to disable versioning instead ?) [" + nodeId + "," + versionId + "]", null);
        }
    }

    public Version findVersion(String nodeId, String versionLabelId) {
        NodeRef nodeRef = this.nodes.validateOrLookupNode(nodeId);
        VersionHistory vh = this.versionService.getVersionHistory(nodeRef);
        if (vh != null) {
            return vh.getVersion(versionLabelId);
        }
        return null;
    }

    @Operation(value="request-direct-access-url")
    @WebApiParam(name="directAccessUrlRequest", title="Request direct access url", description="Options for direct access url request", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Request content url", description="Generates a direct access URL.", successStatus=200)
    public DirectAccessUrl requestContentDirectUrl(String nodeId, String versionId, DirectAccessUrlRequest directAccessUrlRequest, Parameters parameters, WithResponse withResponse) {
        boolean attachment = this.directAccessUrlHelper.getAttachment(directAccessUrlRequest);
        Long validFor = this.directAccessUrlHelper.getDefaultExpiryTimeInSec();
        String fileName = this.directAccessUrlHelper.getFileName(directAccessUrlRequest);
        Version version = this.findVersion(nodeId, versionId);
        if (version != null) {
            DirectAccessUrl directAccessUrl;
            NodeRef versionNodeRef = version.getFrozenStateNodeRef();
            try {
                directAccessUrl = this.nodes.requestContentDirectUrl(versionNodeRef, attachment, validFor, fileName);
            }
            catch (DirectAccessUrlDisabledException ex) {
                throw new DisabledServiceException(ex.getMessage());
            }
            return directAccessUrl;
        }
        throw new EntityNotFoundException(nodeId + "-" + versionId);
    }
}

