/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.core.exceptions;

import java.util.Map;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.ErrorResponse;
import org.alfresco.rest.framework.core.exceptions.ExceptionResolver;

public class SimpleMappingExceptionResolver
implements ExceptionResolver<Exception> {
    private Map<String, Integer> exceptionMappings;

    @Override
    public ErrorResponse resolveException(Exception ex) {
        ErrorResponse response = null;
        if (this.exceptionMappings != null) {
            response = this.findMatchingException(this.exceptionMappings, ex);
        }
        return response;
    }

    private ErrorResponse findMatchingException(Map<String, Integer> exceptionMappings, Exception ex) {
        Integer statusCode = this.matchException(ex.getClass());
        if (statusCode != null) {
            return this.makeErrorResponse(ex, statusCode);
        }
        return null;
    }

    private Integer matchException(Class<? extends Exception> ex) {
        Integer statusCode = this.exceptionMappings.get(ex.getName());
        if (statusCode == null && !ex.isAssignableFrom(Exception.class)) {
            statusCode = this.matchException(ex.getSuperclass());
        }
        return statusCode;
    }

    private ErrorResponse makeErrorResponse(Exception ex, Integer statusCode) {
        if (ex instanceof ApiException) {
            ApiException apEx = (ApiException)((Object)ex);
            return new ErrorResponse(apEx.getMsgId(), statusCode, ex.getLocalizedMessage(), ex.getStackTrace(), apEx.getAdditionalState());
        }
        return new ErrorResponse("framework.exception.ApiDefault", statusCode, ex.getLocalizedMessage(), ex.getStackTrace(), null);
    }

    public void setExceptionMappings(Map<String, Integer> exceptionMappings) {
        this.exceptionMappings = exceptionMappings;
    }
}

